<?php
/**
 * Classe nmApplicationGridFilterBuilderSettings.
 *
 * Classe para manipulacao de filtro de uma consulta.
 *
 * @package     Classes
 * @subpackage  Interface
 * @creation    2003/11/29
 * @copyright   NetMake Solucoes em Informatica
 * @author      Luis Humberto Roman <romanlh@netmake.com.br>
 *
 * $Id: nmApplicationGridFilterDynamicSettings.class.php,v 1.2 2011-07-18 23:41:43 diogo Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

/* Classes ancestrais */
nm_load_class('interface', 'Application');

/* Definicao da classe */
class nmApplicationGridFilterBuilderSettings extends nmApplication
{
    /* ----- Construtor e Destrutor ------------------------------------ */

    /**
     * Construtor da classe.
     *
     * Inicializa objeto.
     *
     * @access  public
     */
    function __construct()
    {
        $this->SetTable('tab_apl');
        $this->SetCodField('Cod_Apl');
        $this->SetFields(array('filter_builder_settings' =>
                               array(
                                     'dynamic_filter_show_enabled',
                                     'dynamic_filter_show_desc',
                                     'dynamic_search_modal',
                                     'filterbuilder_highlight_result',
                                    )
                              )
                        );
    }
}

?>