<?php
/**
 * Classe nmPageEditFreeCSS.
 *
 * Página para edição de pedaços de código do usuário.
 *
 * @package     Classes
 * @subpackage  Page
 * @creation    2018/11/19
 * @copyright   NetMake Solucoes em Informatica
 * @author      Henrique Cézar de Barros <h.barros@netmake.com.br>
 *
 * $Id: nmPageEditFreeCSS.class.php,v 1.0 2018-11-19 15:58:42 henrique Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

/* Classes ancestrais */
nm_load_class('page', 'Page');

/* Definicao da classe */
class nmPageEditFreeCSS extends nmPage
{
    var $handler;

    function __construct()
    {
        nm_load_class('interface', 'FreeCSS');
        nm_load_class('editor', 'Editor');

        $this->handler = new nmFreeCSS();
        $this->editor = new nmEditor('', '', 'css');

	    $this->setDocType("XHTML 1.0 Transitional");
        $this->SetBody('nmPage');
        $this->SetMargin(0);
	    $this->LoadLang('Top2');
        $this->SetPage('editfreecss');
        $this->CheckLogin();
        $this->SetPageSubtitle('');
        $this->SetScroll('auto');
    }

    function DisplayContent()
    {
	    global $nm_template;

	    $display = 'body_edit_free_css';

	  	$nm_template->SetVar('files_list', $this->handler->getTemplateList());

	  	$this->editor->setName('code');
        $this->editor->setCode('');
        $this->editor->setMode('css');
        $this->editor->setModeString('css');
        $this->editor->setPermissions([
            'precodes' => false,
            'fullscreen' => false,
            'initial_size' => false,
            'resize' => false,
            'help' => false,
        ]);
	  	$nm_template->SetVar('editor_body', $this->editor->execute());

		$this->showPageDesenv('free_css');
        $dest = nm_verify_doc_url($this->getManual('free_css', NM_HELP_MENU_TOOLS));
		$nm_template->SetVar('link_manual', $dest);

	    $nm_template->Display($display);
    }


    function PageJavascript()
    {
	    global $nm_config, $obj_lic;

        $file_list = $this->handler->getTemplateList();
        $img_path = $nm_config['url_img_toolbar'];
        $has_92 = ($nm_config['has_93']) ? 'true' : 'false';
        $em_desenv = ($nm_config['em_desenv']) ? 'true' : 'false';
        $separator = $this->handler::NM_SEPARATOR;
        $lang_invalid_file_name = str_replace("'", '\\\'', nm_get_text_lang("['help_case_err_file_invalido']", 'HelpCaseLista'));
        $lang_file_name_already_exists = str_replace("'", '\\\'', nm_get_text_lang("['already_exists']", 'HelpCaseLista'));

        $override = <<<JS
        function savePageHK(e, h) {
            var btn = $('button#save');
            if (btn.is(':visible')) {
                return btn.click();
            }
        }
JS;
        $this->overrideHotkeyAction('app_save', $override);

        $str_js =  $this->editor->getJsCode();
        $str_js .= <<<JS
        
        $(document).on('DOMContentLoaded.snippets', function(){
            if (!{$has_92}) {
                nmFrmScaseRunFunc('noPermission');
            }
            $('#template-settings select#filescope').dropdown({
                forceSelection: true
            });
            $('select#editor_select_theme').dropdown({
                forceSelection: true
            });
            $('#templates-list-grid .accordion').accordion();
            $('#_form_tab_block').remove();
            $('.toolbar_editor').css({
                'height': '40px',
                'background-color': '#eee',
                'text-align': 'left',
            });
            $('.toolbar_editor > td > div').css({
                'padding': '0 10px',
                'display': 'flex',
                'flex-direction': 'row',
                'justify-items': 'center',
                'align-items': 'center',
                'height': '100%',
            });
            $('.toolbar_editor > td > div > img:last-of-type').after('<span style="flex-grow: 1"></span>');
        });

        function updateScopeInput(value) {
            $('#template-settings select#filescope').closest('.ui.dropdown').dropdown('set selected', value);
            if (value == 'scriptcase' && !{$em_desenv}) {
                $('#template-settings select#filescope').closest('.ui.dropdown').dropdown('set text', 'ScriptCase');
            }
        }

        function updateFilenameInput(value) {
            $('#template-settings input#filename').val(value);
        }

        function updateOldfileInput(value) {
            $('#template-settings input#oldfile').val(value);
        }
    
        function openEditor(context, filename, oldfile, viewOnly) {
            
            if (!{$has_92}) {
                return nmFrmScaseRunFunc('noPermission');
            }
            $('#keybindings-actions #save').attr('disabled', false).show();
            $('#filescope').closest('.ui.dropdown').removeClass('disabled');
            $('#filename').attr('disabled', false);
            $('#filescope').closest('.input-group').css('display', 'flex');
            $('#keybindings-container').find('select, input, button, .ui.dropdown').not('#hidden-field, .sc_icheck').attr('disabled', false).removeClass('disabled');
            openLoading(function () {
                var editor = $('.CodeMirror')[0].CodeMirror;
                
                if (context && filename) {
                    contextfix = context;
                    if (context == 'scriptcase' && !{$em_desenv} && !viewOnly){
                        contextfix = 'sys';
                    }
                    updateScopeInput(contextfix);
                    if (oldfile) {
                        updateOldfileInput(oldfile);
                        updateFilenameInput(filename);
                    } else if (viewOnly) {
                        updateOldfileInput('');
                        updateFilenameInput(filename);
                        $('#editor_container').hide();
                        $('#code_view_container').show();
                    } else {
                        updateOldfileInput('');
                        updateFilenameInput(filename + '_copy');
                    }
                    loadTemplateData(context, filename, function (data) {
                        var code = JSON.parse(data.file_data).code;
                        var hl = JSON.parse(data.file_data).hl;
                        
                        $('#code_view_container').html(hl);
                        
                        var br = $('#code_view_container').find('br').first();
                        var brp = br.parent();
                        var brh = br[0].outerHTML;
                        var fline = brp.html().split(brh);
                        
                        fline.splice(0, 1);
                        fline = fline.join();
                        brp.html(fline);
                        brp.prepend(brh);
                        
                        var c = 1;
                        $('#code_view_container').find('br').each(function() {
                            $(this).after('<span class="line-num"><span>' + c + '</span>|</span>');
                            c++;
                        });
                        if (viewOnly) {
                            $('#keybindings-actions #save').attr('disabled', true).hide();
                            $('#filescope').closest('.ui.dropdown').addClass('disabled');
                            $('#filename').attr('disabled', true);
                        }
                        $('#loading-keys').transition({
                            animation  : 'fade',
                            queue: false,
                            onComplete: function() {
                                $('#keybindings-container').transition({
                                    animation  : 'fade up',
                                    queue: false
                                }); 
                                $('#keybindings-actions').transition({
                                    animation  : 'fade up',
                                    queue: false,
                                    onComplete: function () {
                                        editor.setSize('', '');
                                        editor.getDoc().setValue(code);
                                        editor.refresh();
                                    }
                                });
                            }
                        });
                    });
                } else {
                    updateScopeInput('sys');
                    updateFilenameInput('');
                    updateOldfileInput('');
                    $('#loading-keys').transition({
                        animation  : 'fade',
                        queue: false,
                        onComplete: function() {
                            $('#keybindings-container').transition({
                                animation  : 'fade up',
                                queue: false
                            }); 
                            $('#keybindings-actions').transition({
                                animation  : 'fade up',
                                queue: false,
                                onComplete: function () {
                                    editor.setSize('', '');
                                    editor.refresh();
                                }
                            });
                        }
                    });
                }
            });
        }
    
        function openLoading(callback) {
            if (!{$has_92}) {
                return nmFrmScaseRunFunc('noPermission');
            }
            $('#keybindings-templates').transition({
                animation: 'fade up',
                queue: false,
                onComplete: function() {
                    $('#loading-keys').transition({
                        animation  : 'fade',
                        queue: false,
                        onComplete: function() {
                            callback();
                        }
                    });
                }
            });
        }
    
        function closeLoading() {
            $('#loading-keys').transition({
                animation: 'fade',
                queue: false,
                onComplete: function() {
                    $('#keybindings-templates').transition({
                        animation  : 'fade up',
                        queue: false
                    });
                }
            });
        }
        
        function clearEditor() {
            var editor = $('.CodeMirror')[0].CodeMirror;
            
            editor.getDoc().setValue('');
            editor.refresh();
            
            $('#template-settings input#filename').val('');
            $('#template-settings input#oldfile').val('');
            $('#template-settings select#filescope').dropdown('set selected', 'sys');
            $('#code_view_container').html('');
            $('#editor_container').show();
            $('#code_view_container').hide();
            clearErrors();
        }
        
        function clearErrors() {
            $('.input-group').find('.error-message').remove();
            $('.ui.input').removeClass('error');
        }
        
        function closeEditor() {
            clearEditor();
            $('#keybindings-actions').transition({
                animation  : 'fade up',
                queue: false
            });
            $('#keybindings-container').transition({
                animation: 'fade up',
                queue: false,
                onComplete: function() {
                    $('#keybindings-templates').transition({
                        animation  : 'fade up',
                        queue: false
                    });
                }
            });
        }
            
            
            
            
        function openWrapper(obj) {
            $('.hotkeys-list-wrapper').not($(obj).next()).stop().slideUp(function(){ $(this).css('height', 'auto'); });
            $('.hotkey-list-section').not(obj).removeClass('open');
            
            $(obj).next().stop().slideToggle(function(){ $(this).css('height', 'auto'); });
            $(obj).toggleClass('open');
            $("html, body").animate({ scrollTop: '150px' }, "fast")
        }

        function removeKeyset(obj) {
            $(obj).closest('.hotkey-segment').remove();
            markDefault(false);
        }
		
		function deleteTemplate(scope, filename) {
            openLoading(function () {
                $.ajax({
                    type: "POST",
                    url: '../iface/ajax_function.php',
                    data: {
                        call: 'eraseFreeCSSFile',
                        data: {
                            'filename': filename,
                            'scope': scope
                        }
                    },
                    complete: function (a, b) {
                        if (a.responseJSON && a.responseJSON.data) {
                            updateTemplateList(a.responseJSON.data, closeLoading, closeLoading);
                        } else {
                            nmFrmScaseRunFunc('errorMessage');
                        }
                    },
                    dataType: 'json'
                });
            });
		}
		
		function loadTemplateData(scope, filename, callback) {
            $.ajax({
                type: "POST",
                url: '../iface/ajax_function.php',
                data: {
                    call: 'getFreeCSSFileData',
                    data: {
                        'filename': filename,
                        'scope': scope
                    }
                },
                complete: function (a, b) {
                    if (a.responseJSON && a.responseJSON.data) {
                        callback(a.responseJSON.data);
                    } else {
                        nmFrmScaseRunFunc('errorMessage');
                    }
                },
                dataType: 'json'
            });
		}
		
		function updateTemplateList(data, callback, callback_fail) {
            if (!callback) {
                callback = function () {};
            }
            if (!callback_fail) {
                callback_fail = function () {};
            }
            if (data.template_data) {
                $('#templates-list-grid .accordion').html(data.template_data);
                callback();
            } else {
                nmFrmScaseRunFunc('errorMessage');
                callback_fail();
            }
		}
		
		function saveData() {
            if (!{$has_92}) {
                return nmFrmScaseRunFunc('noPermission');
            }
            var separator = '{$separator}';
            var savebutton = $('button#save');
            var filename = $('#template-settings input#filename')[0];
            var oldfile = $('#template-settings input#oldfile')[0];
            var scope = $('#template-settings select#filescope')[0];
            var filename_val = $(filename).val().trim().replace(/[\W+]/g, '_');
            var scope_val = $(scope).closest('.ui.dropdown').dropdown('get value').trim();
            var oldfile_val = $(oldfile).val().trim();
            var has_oldfile = (oldfile_val.trim() !== '' && oldfile_val.trim() !== undefined);
            
            $(filename).closest('.input-group').find('.error-message').remove();
            $(filename).closest('.ui.input').removeClass('error');
            try {
                if (filename_val.trim() === '') {
                    $(filename).closest('.ui.input').addClass('error');
                    $(filename).closest('.input-group').append('<span class="error-message">{$lang_invalid_file_name}</span>');
                    $("html, body").animate({ scrollTop: 0 }, "slow");
                    return false;
                } else if ($('#templates-list-grid #scope-group-' + scope_val).has('#file-name-' + filename_val).length > 0) {
                    if (!has_oldfile || !(oldfile_val.split(separator)[1].trim() === filename_val.trim() && oldfile_val.split(separator)[0].trim() === scope_val.trim())) {
                        $(filename).closest('.ui.input').addClass('error');
                        $(filename).closest('.input-group').append('<span class="error-message">{$lang_file_name_already_exists}</span>');
                        $("html, body").animate({ scrollTop: 0 }, "slow");
                        return false;
                    }
                }
            } catch (e) {
                console.log(e);
                $(filename).closest('.ui.input').addClass('error');
                $(filename).closest('.input-group').append('<span class="error-message">{$lang_invalid_file_name}</span>');
                $("html, body").animate({ scrollTop: 0 }, "slow");
                return false;
            }
            data = translateData();
            if (!savebutton.hasClass('loading')) {
                savebutton.addClass('loading');
                sendData(data);
            }
            
        }
		
		function translateData() {
            var editor = $('.CodeMirror')[0].CodeMirror;
            return {
                'code': editor.getValue()
            }
		}
		
		function sendData(data) {
            if (!{$has_92}) {
                return nmFrmScaseRunFunc('noPermission');
            }
            $('input#hidden-field').val(JSON.stringify(data));
            $.ajax({
                type: "POST",
                url: '../iface/ajax_function.php',
                data: {
                    call: 'saveFreeCSSFile',
                    data: {
                        'filedata': data,
                        'filename': $('#template-settings input#filename').val().trim().replace(/[\W+]/g, '_'),
                        'oldfile': $('#template-settings input#oldfile').val().trim(),
                        'scope': $('#template-settings select#filescope').closest('.ui.dropdown').dropdown('get value')
                    }
                },
                complete: function (a, b) {
                    var savebutton = $('button#save');
                    savebutton.removeClass('loading');
                    if (a.responseJSON && a.responseJSON.data) {
                        updateTemplateList(a.responseJSON.data, closeEditor);
                    } else {
                        nmFrmScaseRunFunc('errorMessage');
                    }
                },
                dataType: 'json'
            });
		}
	
JS;

        $this->AddJavascript($str_js);
    }

    function PageJs()
    {
		$this->AddJs('devel', 'window.js?v=9.1');
        $this->AddJs('third', 'jquery_plugin/malsup-blockui/jquery.blockUI.js');
        $this->AddJs('third', 'semantic-ui/semantic.min.js');
        $this->AddJs('thirddevel', 'CodeMirror/lib/codemirror.js?v4');
        $js = $this->editor->getJs();
        foreach($js as $j)
        {
            $this->AddJs('thirddevel', $j);
        }
    }

    function PageStyle() { }

    function PageStyleCss()
    {
    	$this->AddStyleCssAfterScCss('third', 'semantic-ui/semantic.min.css');
        $this->AddStyleCss('third', 'font-awesome/css/all.css');
        $this->AddStyleCss('sc_css', 'editcodesnippets.css');
        $this->AddStyleCss('thirddevel', 'CodeMirror/lib/codemirror.css?v4');
        $css = $this->editor->getCss();
        foreach($css as $c)
        {
            $this->AddStyleCss('thirddevel', $c);
        }
    }
}

?>