<?php
/* Classes ancestrais */
nm_load_class('xmlparser', 'XmlparserIni');

/* Definicao da classe */
class nmXmlparserIniButton extends nmXmlparserIni
{
    /**
     * Construtor da classe.
     *
     * Seta o elemento raiz do XML.
     *
     * @access  public
     */
    function __construct()
    {
        $this->SetRoot('button');
        $this->SetFile('button');

		$this->str_id = "IniButton";
		$this->StartDefault();
    } // nmXmlparserIniButton

    function HandleExceptions($v_arr_unserialize, $v_arr_default = array())
    {
    	return $v_arr_unserialize;
    } // HandleExceptions

    function Load()
    {
        $this->CheckExtension();
        $str_data = '';
        if (is_file($this->GetFilename($this->GetExtension())))
        {
            $str_data = file_get_contents($this->GetFilename($this->GetExtension()));
        }

        $arr_btns_origin = $this->getTag('button');
        
        $this->Handle($str_data);

        if(!empty($str_data))
        {
            $arr_btns_client = $this->getTag('button');

            if(isset($arr_btns_client['list']) && isset($arr_btns_origin['list']) && count($arr_btns_origin['list']) != count($arr_btns_client['list']))
            {
                $hasChanged = false;
                foreach($arr_btns_origin['list'] as $_btn=>$_arr)
                {
                    if(!isset($arr_btns_client['list'][$_btn]))
                    {
                        $arr_btns_client['list'][$_btn] = $_arr;
                        $hasChanged = true;
                    }
                }
                if($hasChanged)
                {
                    $this->setTag('button', $arr_btns_client);
                }
            }
        }
    } // Load
}

?>