
const menuJSON_url = {};
const panelTheme = document.getElementById('themes-panel');
const panelNotification = document.getElementById("notification-panel");
var loadTimeout = null;
var notif_update_lock = false;

function markAllAsRead() {
    const markAllAsRead_btn = document.getElementById("markAllAsRead-btn");
    markAllAsRead_btn.addEventListener("click", (ev) => {
        ev.stopImmediatePropagation();
        const notificationItems = document.querySelectorAll(".notification-item");
        notificationItems.forEach((item) => {
            item.setAttribute("data-read", "true");
        });
        markAllAsReadAjax();
        // countNotifications();
    });
}
function countNotifications() {
    if (notif_update_lock) return true;
    const notificationDot = document.getElementById("notification-dot");
    const notificationNumber = document.getElementById("notification-number");
    const notificationItems = document.querySelectorAll(".notification-item[data-read=false]");
    $.ajax({
        type: "POST",
        url: '',
        data: {
            ajax_notif_request: 'count',
            script_case_init: '1'
        },
        complete: function (a, b) {
            if (a.responseJSON && (typeof a.responseJSON.msg === typeof '' || typeof a.responseJSON.msg === typeof 1)) {
                var counterCap = parseInt(a.responseJSON.msg);
                if (counterCap > 0) {
                    $(notificationDot).show();
                    $(notificationNumber).closest('.unread-counter').show();
                } else {
                    $(notificationDot).hide();
                    $(notificationNumber).closest('.unread-counter').hide();
                }
                if ( counterCap >= 100 ) {
                    counterCap = '99+';
                }
                notificationNumber.textContent = counterCap;
            } else {
                ajaxError(a);
            }
        },
        dataType: 'json'
    });
}
function notificationClose() {
    const notificationsClose = document.querySelectorAll(".notification-close");
    const notificationsConfirmBlock = document.querySelectorAll(".confirm-exclude");
    const notificationsOKConfirm = document.querySelectorAll(".confirm-exclude .ok-confirm");
    const notificationsCancelConfirm = document.querySelectorAll(".confirm-exclude .cancel-confirm");
    notificationsConfirmBlock.forEach((item) => {
        item.addEventListener("click", (ev) => {
            ev.stopImmediatePropagation();
        });
    });
    notificationsOKConfirm.forEach((item) => {
        item.addEventListener("click", (ev) => {
            ev.stopImmediatePropagation();
            deleteNotif($(item).closest('.notification-item').attr('id'));
            $(item).closest('.notification-item').remove();
            countNotifications();
            notif_update_lock = false;
        });
    });
    notificationsCancelConfirm.forEach((item) => {
        item.addEventListener("click", (ev) => {
            ev.stopImmediatePropagation();
            $(item).closest('.confirm-exclude').removeClass('open-confirm');
            notif_update_lock = false;
        });
    });
    notificationsClose.forEach((item) => {
        item.addEventListener("click", (ev) => {
            ev.stopImmediatePropagation();
            notif_update_lock = true;
            $('.confirm-exclude').removeClass('open-confirm');
            $(item).closest('.notification-item').find('.confirm-exclude').addClass('open-confirm');
        });
    });
}

function startAppTab(initApp) {

    if (typeof openInTab == 'function') {
        openInTab(apl_default, 'init_tab', '', '', '<i class="mb_icon fas fa-house"></i>', '_self', true);
    } else {
        if($("#nav_list a[tab-name='init_tab']").length)
        {
            $("#nav_list a[tab-name='init_tab']").click();
        }

        $('#app-frames').find('iframe').addClass('loading');
        if (loadTimeout) {
            clearTimeout(loadTimeout);
        }
        loadTimeout = setTimeout(function () {
            $('#app-frames iframe').removeClass('loading');
        }, 10000);
        $('.nm_frame_app').attr('src', apl_default);
    }
}
function layoutControl(offsetX) {
    const thresholdX = offsetX ? offsetX : 16;
    const menubar_vertical = document.querySelector('.ae-menubar.menubar[aria-orientation="vertical"]');
    const toolbar = document.querySelector('.ae-menubar.toolbar');
    const switch_menu_pos_button = document.getElementById('switch-menu-position');
    const sc_main_content = document.getElementById('sc-main-content');
    const checkRTL = document.querySelector('html').getAttribute('dir') == "RTL";

    sc_main_content.parentElement.style.height = '100%';

    if(checkRTL) {
        if(window.getComputedStyle(menubar_vertical).left !== 'auto') {
            menubar_vertical.style.right = '0';
            menubar_vertical.style.left = 'auto';
        }
    }

    const layout = () => {
        if(checkRTL) {
            sc_main_content.style.paddingRight = menubar_vertical.offsetWidth + 'px';

            if(toolbar) {
                setTimeout(() => {
                    toolbar.style.width = sc_main_content.offsetWidth - menubar_vertical.offsetWidth - thresholdX - 16 + 'px';
                }, 251)
            }

        } else {
            sc_main_content.style.paddingLeft = menubar_vertical.offsetWidth + 'px';
        }
    }

    // init
    layout();

    // click
    switch_menu_pos_button.addEventListener('click', () => {
        setTimeout(layout, 350);
    });
}
function getCookieMenu(cname) {
    let name = cname + "=";
    let ca = document.cookie.split(';');
    for(let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return false;
}
function pickTheme(themeName) {
    var themeButton = $('[data-theme="'+themeName+'"]');
    if (themeButton.length > 0) {
        $('[data-themeapply]').closest('li.theme-name.button ').removeClass('active');
        themeButton.closest('li.theme-name.button ').addClass('active');
        document.querySelectorAll('[data-aetheme]').forEach(menubar => {
            menubar.setAttribute('data-aetheme', themeName);
        });
        document.cookie = "menuTheme=" + themeName;
    }
    // $('ul.context-menu-list.context-menu-root').attr('data-aetheme', button.getAttribute('data-theme'));
    // $('#app-frames').attr('data-aetheme', button.getAttribute('data-theme'));
}
function themeApply() {
    var cookieTheme = getCookieMenu('menuTheme');
    if (cookieTheme && panelTheme.querySelectorAll('[data-theme="'+cookieTheme+'"]')[0]) {
        pickTheme(cookieTheme);
    }
    panelTheme.querySelectorAll('[data-themeapply]').forEach(button => {
        button.addEventListener('click', () => {
            pickTheme(button.getAttribute('data-theme'))
        });
    });
}

function loadJSON(url) {
    fetch(url)
        .then(response => {
            if (!response.ok) {
                throw new Error(`Erro na solicitação ${response.status}`)
            }

            return response.json();
        })
        .then(data => {
            //console.log(data);
        })
        .catch(error => {
            console.error('Erro ao carregar o arquivo JSON:', error);
        })
}


function updateNavMenu() {
    var vert = document.querySelector('.ae-menubar.menubar').getAttribute('aria-orientation') == 'vertical';
    if (vert) {
        layoutControl(4);
    }
    document.getElementById('nav_list').innerHTML = renderItems(items_data, vert);
    if (document.getElementById('nav_mobile')) {
        document.getElementById('nav_mobile').innerHTML = renderItems(items_data, true);
    }
    if (document.querySelector('#list_megamenu')) {
        document.querySelector('#list_megamenu').innerHTML = renderMegaBox(items_data);
    }
    if ($('#user_menu_list')[0]) {
        if (user_menu_data.length > 0) {
            $('#user_menu_list')[0].innerHTML = renderItems(user_menu_data, true);
        } else {
            $('#user_menu_list').closest('.section.actions.ae-menubar-accordion').remove();
            $('.user-info').addClass('inactive').off('click');
            $('.user-menu').remove();
        }
    }
    $('.ae-menubar.menubar[aria-orientation="vertical"] a,.ae-menubar.menubar[aria-orientation="vertical"] a span').on('click.closeVertMenu', function() {
        $('.ae-menubar.menubar[aria-orientation="vertical"]').removeClass('expanded-mob');
    });
    if (typeof loadMegamenus == 'function') {
        loadMegamenus();
        $('.close-megamenu-flex').on('click', function () {
            var mega_container = $(this).closest('.dropdown');
            mega_container.removeClass('show');
            if ($('[aria-controls="'+mega_container.id+'"]').length > 0) {
                $('[aria-controls="' + mega_container.id + '"]').setAttribute('aria-expanded', 'false');
            }
        });
    }
}
function renderUserImage(arr_items, is_vert) {
    var el = $('.user_image');
    if (el.length > 0) {
        var src = el.attr('src');
        if (src.trim() == '') {
            el.replaceWith('<i class="mb_icon fa-solid fa-user" aria-hidden="true"></i>');
        }
    }
}
function renderLogo() {
    var el_list = $('.logo img');
    el_list.each(function(i, el) {
        var src = $(el).attr('src');
        if (src.trim() != '') {
            $(el).css('visibility', 'visible');
        }
    });
}
function renderMenuUser(arr_items){
    var ret_html = '';
    arr_items.forEach(function (item) {
        var has_icon = item.icon_check == 'S';
        var icon = item.icon_fa;
        var label = item.label;
        var url = item.link;
        var id = item.id;
        var target = item.target;

        ret_html += '<li class="wrapper" role="none">'+"\n";
        ret_html += "<a href=\"" + url + "\" tab-name=\""+ id + "\" tab-title=\""+ label + "\" target=\""+ target + "\" role=\"menuitem\" aria-haspopup=\"false\" aria-expanded=\"false\" data-active=\"false\">"+"\n";

        if (has_icon) {
            ret_html += '   <i class="mb_icon ' + icon + '" aria-hidden="true"> </i>'+"\n";
        }
        if(label != '') {
            ret_html += '       <span class="label">' + label + '</span>' + "\n";
        }
        ret_html += '</a>'+"\n";
        ret_html += '</li>'+"\n";
    });
    return ret_html;
}
function getTarget(target_name) {
    var ret = 'nm_frame_app';
    try {
        var targets = targets_list;
        if (targets[target_name] !== undefined) {
            ret = targets[target_name];
        }
    } catch (e) {
        ret = 'nm_frame_app';
    }
    return ret
}
function renderMegaBoxColumn(arr_items) {
    var ret_html = "" ;
    arr_items.forEach(function (item) {
        var has_icon = item.icon_check == 'S';
        var icon = item.icon_fa;
        var disabled = (item.disabled == 'Y') ? 'disabled="disabled"' : '';
        var label = item.label;
        var hint = item.hint;
        var url = item.link;
        var id = item.id;
        var link_target = item.link_target;
        var fav_check = item.fav_check;
        var children = Object.values(item.itens);
        var has_popup = 'true';

        try {
            link_target = getTarget(link_target);
            if (link_target == '_self' && url == '#' && (!children || !children.length)) {
                url = 'javascript: window.close();';
            }
        } catch (e) {
            link_target = 'nm_frame_app';
        }


        if (!children || !children.length) {
            ret_html += '<li class="wrapper" ' + disabled + ' role="none">'+"\n";
                has_popup = 'false';
                ret_html += "<a class=\"border_botto_m\" role='menuitem' href=\"" + url + "\" tab-name=\""+ id + "\" title=\"" + hint + "\" tab-title=\""+ label + "\" target=\""+ link_target + "\" role=\"menuitem\" aria-haspopup=\""+ has_popup + "\" aria-expanded=\"false\" data-active=\"false\">"+"\n";
            if (has_icon) {
                ret_html += '   <i class="mb_icon ' + icon + '" aria-hidden="true"> </i>'+"\n";
            }
            if(label != '') {
                ret_html += '       <span class="label">' + label + '</span>' + "\n";
            }
            ret_html += '</a>'+"\n";
            ret_html += '</li>'+"\n";
        } else {
            ret_html += renderMegaBoxColumn(children);
        }

    });
    return ret_html;
}
function renderMegaBoxItens(arr_items) {
    var ret_html = "" ;
    arr_items.forEach(function (item) {
        var has_icon = item.icon_check == 'S';
        var icon = item.icon_fa;
        var label = item.label;
        var hint = item.hint;
        var id = item.id;
        var children = Object.values(item.itens);


        ret_html += '<ul class="col_md col_lg">'+"\n";
        ret_html += '<li class="wrapper wrapper section_title" role="none">'+"\n";
        ret_html += '<p role="menuitem">'+"\n";
        if (has_icon) {
            ret_html += '   <i class="mb_icon ' + icon + '" aria-hidden="true"> </i>'+"\n";
        }
        if(label != '') {
            ret_html += '       <span class="label">' + label + '</span>' + "\n";
        }
        ret_html += '</p>'+"\n";
        ret_html += '</li>'+"\n";
        ret_html += renderMegaBoxColumn(children)+"\n";
        ret_html += '</ul>'+"\n";
    });
    return ret_html;
}
function renderMegaBox(arr_items) {

    var ret_html = "" ;
    arr_items.forEach(function (item) {
        var mega_check = item.mega_check == 'S';
        var id = item.id;
        var children = Object.values(item.itens);
        if (mega_check) {
            ret_html += "<div id=\"megamenu-" + id + "\" class=\"submenu container dropdown\" role=\"menu\" aria-label=\"Mega menu\">";
            ret_html += "<button class=\"button mob-button close-megamenu-flex\"> <i class=\"fas fa-xmark\"></i> </button>";
            ret_html += "<div class=\"submenu_row\" >";
            ret_html += renderMegaBoxItens(children);
            ret_html += '</div>' + "\n";
            ret_html += '</div>' + "\n";
        }
    });
    return ret_html
}
function renderItems(arr_items, is_vert, level) {
    var ret_html = '';
    if (typeof level == 'undefined') {
        level = 0;
    }
    arr_items.forEach(function (item) {
        var has_icon = item.icon_check == 'S';
        var icon = item.icon_fa;
        var disabled = (item.disabled == 'Y') ? 'disabled="disabled"' : '';
        var label = item.label;
        var hint = item.hint;
        var url = item.link;
        var id = item.id;
        var link_target = item.link_target;
        var fav_check = item.fav_check;
        var mega_check = item.mega_check == 'S' && level == 0;
        var children = Object.values(item.itens);
        var has_popup = 'true';

        try {
            link_target = getTarget(link_target);
            if (link_target == '_self' && url == '#' && (!children || !children.length)) {
                url = 'javascript: window.close();';
            }
        } catch (e) {
            link_target = 'nm_frame_app';
        }

        ret_html += '<li class="wrapper" ' + disabled + ' role="none">'+"\n";
        if (!children || !children.length) {
            has_popup = 'false';
            ret_html += "<a href=\"" + url + "\" tab-name=\""+ id + "\" title=\"" + hint + "\" tab-title=\""+ label + "\" target=\""+ link_target + "\" role=\"menuitem\" aria-haspopup=\""+ has_popup + "\" aria-expanded=\"false\" data-active=\"false\">"+"\n";
        } else {
            if (mega_check) {
                ret_html += '   <span role="menuitem" aria-haspopup="' + has_popup + '" aria-expanded="false" data-axis="' + ((is_vert) ? 'vertical' : 'horizontal') + '" data-megamenu="link" aria-controls="megamenu-' + id + '" data-active="false">' + "\n";
            } else {
                ret_html += '   <span role="menuitem" aria-haspopup="' + has_popup + '" aria-expanded="false" aria-controls="submenu-' + id + '" data-active="false">' + "\n";
            }
        }
        if (has_icon) {
            ret_html += '   <i class="mb_icon ' + icon + '" aria-hidden="true"> </i>'+"\n";
        }
        if(label != '') {
            ret_html += '       <span class="label">' + label + '</span>' + "\n";
        }
        if (mega_check) {
            ret_html += '   </span>' + "\n";
        } else {
            if (!children || !children.length) {
            } else {
                if (is_vert) {
                    ret_html += '   </span>' + "\n";
                }
            }
            if (children && children.length > 0) {
                if (is_vert) {
                    ret_html += '<div class="wrapper">' + "\n";
                }
                ret_html += '   <ul class="submenu" id="submenu-' + id + '" role="menu" aria-label="' + label + '" aria-hidden="true">' + "\n";
                ret_html += renderItems(children, is_vert, level + 1);
                ret_html += '   </ul>' + "\n";
                if (is_vert) {
                    ret_html += '</div>' + "\n";
                }
            } else {
                ret_html += '</a>' + "\n";
            }
            if (!children || !children.length) {
            } else {
                if (!is_vert) {
                    ret_html += '   </span>' + "\n";
                }
            }
        }
        ret_html += '</li>'+"\n";
    });
    return ret_html;
}

function hideTBButton(panel_name) {
    $('[aria-controls="'+panel_name+'-panel"]').hide();
}
function showTBButton(panel_name) {
    $('[aria-controls="'+panel_name+'-panel"]').show();
}

function finishLoadingTab(tabName) {
    var frame_el = $('#' + tabName + ' iframe');
    var tab_el = $('#id_tab_' + tabName);
    if ($('#id_tab_' + tabName + ' a').is('.active')) {
        bodyColorUpdate(frame_el[0].parentNode);
    }
    tab_el.removeClass('loading');
    frame_el.removeClass('loading');
}
function setLoadingTab(tabName) {
    var frame_el = $('#' + tabName + ' iframe');
    var tab_el = $('#id_tab_' + tabName);
    tab_el.addClass('loading');
    if (typeof use_load != 'undefined' && use_load) {
        frame_el.addClass('loading');
    }
}

function bodyColorUpdate(el_wrap) {
    try {
        var iFrameEl = $(el_wrap).find('iframe')[0];
        var bgcolor = '#efefef';
        var iframeDoc = iFrameEl.contentDocument || iFrameEl.contentWindow.document;
        bgcolor = iFrameEl.contentWindow.getComputedStyle(iframeDoc.body).backgroundColor;
        $('body').css('background-color', bgcolor);
    } catch (e) {
        console.log(e);
    }
}
function tryRenderCalendarFix(el_wrap) {
    try {
        var iFrameEl = $(el_wrap).find('iframe')[0];
        var iframeDoc = iFrameEl.contentWindow;
        if ( iframeDoc.scMainCalendar ) {
            iframeDoc.scMainCalendar.render();
        }
    } catch (e) {
        console.log(e);
    }
}

function activateItem(id) {
    var vert = document.querySelector('.ae-menubar.menubar').getAttribute('aria-orientation') == 'vertical';
    var activeItem =  $('[tab-name="' + id + '"]');
    $('[role="menuitem"]').attr('data-active', 'false');
    activeItem.attr('data-active', 'true');
    if (vert) {
        activeItem.parents('.wrapper').find(' > [role="menuitem"]').attr('data-active', 'true');
    } else {
        activeItem.parents('[role="menuitem"]').attr('data-active', 'true');
    }
}
function handleLinks(e) {
    if ($('a[tab-name="' + e + '"]').attr('target') == '_self' && ($('a[tab-name="' + e + '"]').attr('href') == '#' || $('a[tab-name="' + e + '"]').attr('href') == '')) {
        window.close();
        return false;
    }
    if ($('a[tab-name="' + e + '"]').attr('href') == '#' || $('a[tab-name="' + e + '"]').attr('href') == '') {
        event.preventDefault();
        event.stopPropagation();
        return false;
    }
    // $('body').removeAttr("style");
    activateItem(e);
    if (typeof use_load != 'undefined' && use_load) {
        $('#app-frames').find('iframe').addClass('loading');
    }
    // if (!$('#app-frames').find('iframe').hasClass('loading')) {
    //     bodyColorUpdate($('#app-frames'));
    // }
    if (typeof use_load != 'undefined' && use_load) {
        if (loadTimeout) {
            clearTimeout(loadTimeout);
        }
        loadTimeout = setTimeout(function() {
            $('#app-frames iframe').removeClass('loading');
        }, 10000);
    }

    $('.ae-menubar.menubar[aria-orientation="vertical"]').removeClass('expanded-mob');
    $('.submenu.container.dropdown').removeClass('show');
    if ($('.menu-mobile-control').attr('aria-pressed') === 'true') {
        $('.menu-mobile-control').click();
    }
}
function flattenItems(arr_items) {

    return arr_items.reduce((acc, x) => {
        acc = acc.concat(x);
        if (typeof x.itens == typeof {}) {
            acc = acc.concat(flattenItems(Object.values(x.itens)));
            // x.itens = [];
        }
        return acc;
    }, []);


}

var SCMenubar;
window.addEventListener('load', () => {

    // Inicialização da aplicação de temas
    //-------------------------------------
    if (panelTheme) {
        themeApply();
    }
    if (panelNotification) {
        markAllAsRead();
        countNotifications();
        notificationClose();
    }

    // Sistema de busca do menu
    //-------------------------------------

    renderUserImage();
    renderLogo();
    // Controle de layout
    //---------------------------------
    /**
     * @param {number} offsetX - deslocamento entre a toolbar e a menubar vertical
     */
    updateNavMenu();
    if (typeof startCrumbs == 'function') {
        startCrumbs();
    }
    if (typeof searchInit == 'function') {
        searchInit();
    }
    if (typeof startTabs == 'function') {
        startTabs();
    } else {
        $('#app-frames iframe').on('load', function () {
            bodyColorUpdate($('#app-frames')); $('#app-frames iframe').removeClass('loading');
        });
        $('a[tab-name], a[tab-name] > span').on('click', function (e) {
            var el = $(this).closest('a[tab-name]');
            if (el.attr('target') == 'nm_frame_app') {
                handleLinks(el.attr('tab-name'));
            }
        });
    }
    // Inicialização do menu
    //-------------------------------------
    SCMenubar = new Menubar({
        animation: {
            show: true,
            name: 'slide-left'
        }
    });

    document.addEventListener('panel-oppened', function(e) {
        if (e.detail.panel.id == 'search-panel') {
            $('#main-search').focus();
        }
        $('#' + e.detail.panel.id).after('<div class="panel-backdrop-overlay"></div>');
        $('.panel-backdrop-overlay').off('click');
        $('.panel-backdrop-overlay').on('click', function () {
            SCMenubar.closePanel();
        });
    });
    document.addEventListener('panel-closed', function(e) {
        $('.panel-backdrop-overlay').remove();
        $('#main-search').val('');
        $('#search-result .result-links').html('');
        notif_update_lock = false;
        $('.confirm-exclude').removeClass('open-confirm');
    });

    $('.button.expand-button').on('click', function () {
        $('.ae-menubar.menubar[aria-orientation="vertical"]').addClass('expanded-mob');
        if (typeof document.menu_expand_func == 'function') {
            document.menu_expand_func();
        }
    });
    $('#close-menu-expand').on('click', function () {
        $('.ae-menubar.menubar[aria-orientation="vertical"]').removeClass('expanded-mob');
    });
    if (apl_default != '') {
        startAppTab('');
    }
    if (!start_expanded) {
        $('#switch-menu-position').click();
    }
    $('err-msg').each(function(i, t) {
        var er_msg = $(t).html();

        Swal.fire({
            title: '',
            html: er_msg,
            confirmButtonText: 'OK'
        });
    });
});

