<?php

/*************************************************************************************************************
 * FUNCOES PARA GERACAO DE METODOS DE RETORNO CODIGO HTML DOS CAMPOS DA APLICACAO
 ************************************************************************************************************/

function geraHtmlCampo($seq)
{
    global $tab_cmp;

    switch ($tab_cmp[$seq]['nmgp_tipo_dado']) {
        case 'RATING':
            return geraHtmlCampo_rating($seq);
        case 'RATINGSMILE':
            return geraHtmlCampo_ratingSmile($seq);
        case 'RATINGSTAR':
            return geraHtmlCampo_ratingStar($seq);
        case 'RATINGTHUMBS':
            return geraHtmlCampo_ratingThumbs($seq);
    }

    return '';
}

function geraHtmlCampo_rating($seq)
{
    global $tab_cmp, $nm_img_icone;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldHtml_{$nmgp_campo}(\$value)
    {
        if (!is_numeric(\$value) || null == \$value) {
            \$value = 0;
        }
        if (\$value >= 0) {
            \$htmlContent = <<<SCEOT

<span style="white-space: nowrap; display: inline-block">

SCEOT;
            for (\$i = 0; \$i < {$tab_cmp[$seq]['rating_amount']}; \$i++) {
                if (\$value >= \$i + 1) {
                    \$starImg = '{$tab_cmp[$seq]['rating_icon']}';
                } elseif ((\$value < \$i + 1) && (\$value > \$i)) {
                    \$starImg = '{$tab_cmp[$seq]['rating_icon_half']}';
                } else {
                    \$starImg = '{$tab_cmp[$seq]['rating_icon_off']}';
                }
                \$htmlContent .= <<<SCEOT
    <img class="sc-rating-item sc-star-edit-{$nmgp_campo} sc-star-edit-{$nmgp_campo}-{\$i}" src="{\$this->NM_raiz_img}{\$this->Ini->path_icones}/{\$starImg}" />

SCEOT;
            }
            \$htmlContent .= <<<SCEOT
</span>

SCEOT;
        } else {
            \$htmlContent = "&nbsp;";
        }

        return \$htmlContent;
    }


EOT;

    $nm_img_icone[] = $tab_cmp[$seq]['rating_icon'];
    $nm_img_icone[] = $tab_cmp[$seq]['rating_icon_off'];
    $nm_img_icone[] = $tab_cmp[$seq]['rating_icon_half'];

    return $phpCode;
}

function geraHtmlCampo_ratingSmile($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldHtml_{$nmgp_campo}(\$value)
    {
        \$selectedItem1 = "{$tab_cmp[$seq]['rating_smile_values'][0]}" == \$value ? " sc-smile-selected-{$nmgp_campo}" : "";
        \$selectedItem2 = "{$tab_cmp[$seq]['rating_smile_values'][1]}" == \$value ? " sc-smile-selected-{$nmgp_campo}" : "";
        \$selectedItem3 = "{$tab_cmp[$seq]['rating_smile_values'][2]}" == \$value ? " sc-smile-selected-{$nmgp_campo}" : "";
        \$selectedItem4 = "{$tab_cmp[$seq]['rating_smile_values'][3]}" == \$value ? " sc-smile-selected-{$nmgp_campo}" : "";
        \$selectedItem5 = "{$tab_cmp[$seq]['rating_smile_values'][4]}" == \$value ? " sc-smile-selected-{$nmgp_campo}" : "";

        \$htmlContent = <<<SCEOT

<span style="white-space: nowrap; display: inline-block">
    <i class="sc-rating-item sc-smile-edit-{$nmgp_campo} sc-smile-edit-{$nmgp_campo}-0 fa{$tab_cmp[$seq]['rating_smile_display']} fa-angry{\$selectedItem1}" style="color: {$tab_cmp[$seq]['rating_smile_colors'][0]}"></i>
    <i class="sc-rating-item sc-smile-edit-{$nmgp_campo} sc-smile-edit-{$nmgp_campo}-1 fa{$tab_cmp[$seq]['rating_smile_display']} fa-frown{\$selectedItem2}" style="color: {$tab_cmp[$seq]['rating_smile_colors'][1]}"></i>
    <i class="sc-rating-item sc-smile-edit-{$nmgp_campo} sc-smile-edit-{$nmgp_campo}-2 fa{$tab_cmp[$seq]['rating_smile_display']} fa-meh{\$selectedItem3}" style="color: {$tab_cmp[$seq]['rating_smile_colors'][2]}"></i>
    <i class="sc-rating-item sc-smile-edit-{$nmgp_campo} sc-smile-edit-{$nmgp_campo}-3 fa{$tab_cmp[$seq]['rating_smile_display']} fa-smile{\$selectedItem4}" style="color: {$tab_cmp[$seq]['rating_smile_colors'][3]}"></i>
    <i class="sc-rating-item sc-smile-edit-{$nmgp_campo} sc-smile-edit-{$nmgp_campo}-4 fa{$tab_cmp[$seq]['rating_smile_display']} fa-laugh-beam{\$selectedItem5}" style="color: {$tab_cmp[$seq]['rating_smile_colors'][4]}"></i>
</span>

SCEOT;

        return \$htmlContent;
    }


EOT;

    return $phpCode;
}

function geraHtmlCampo_ratingStar($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldHtml_{$nmgp_campo}(\$value)
    {
        if (!is_numeric(\$value) || null == \$value) {
            \$value = 0;
        }
        if (\$value >= 0) {
            \$htmlContent = <<<SCEOT

<span style="white-space: nowrap; display: inline-block">

SCEOT;
            for (\$i = 0; \$i < {$tab_cmp[$seq]['rating_amount']}; \$i++) {
                if (\$value >= \$i + 1) {
                    \$starClass = 'fas fa-star';
                } elseif ((\$value < \$i + 1) && (\$value > \$i)) {
                    \$starClass = 'far fa-star-half-stroke';
                } else {
                    \$starClass = 'far fa-star';
                }
                \$htmlContent .= <<<SCEOT
    <i class="sc-rating-item sc-star-edit-{$nmgp_campo} sc-star-edit-{$nmgp_campo}-{\$i} {\$starClass}" style="color: {$tab_cmp[$seq]['rating_star_color']}"></i>

SCEOT;
            }
            \$htmlContent .= <<<SCEOT
</span>

SCEOT;
        } else {
            \$htmlContent = "&nbsp;";
        }

        return \$htmlContent;
    }


EOT;

    return $phpCode;
}

function geraHtmlCampo_ratingThumbs($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldHtml_{$nmgp_campo}(\$value)
    {
        \$selectedItem1 = "{$tab_cmp[$seq]['rating_thumb_values'][0]}" == \$value ? " sc-thumb-selected-{$nmgp_campo}" : "";
        \$selectedItem2 = "{$tab_cmp[$seq]['rating_thumb_values'][1]}" == \$value ? " sc-thumb-selected-{$nmgp_campo}" : "";

        \$htmlContent = <<<SCEOT

<span style="white-space: nowrap; display: inline-block">
    <i class="sc-rating-item sc-thumb-edit-{$nmgp_campo} sc-thumb-edit-{$nmgp_campo}-0 fa{$tab_cmp[$seq]['rating_thumb_display']} fa-thumbs-up{\$selectedItem1}" style="color: {$tab_cmp[$seq]['rating_thumb_colors'][0]}"></i>
    <i class="sc-rating-item sc-thumb-edit-{$nmgp_campo} sc-thumb-edit-{$nmgp_campo}-1 fa{$tab_cmp[$seq]['rating_thumb_display']} fa-thumbs-down{\$selectedItem2}" style="color: {$tab_cmp[$seq]['rating_thumb_colors'][1]}"></i>
</span>

SCEOT;
        return \$htmlContent;
    }


EOT;

    return $phpCode;
}

/*************************************************************************************************************
 * FUNCOES PARA GERACAO DE METODOS DE RETORNO DE CODIGO CSS DOS CAMPOS DA APLICACAO
 ************************************************************************************************************/

function geraCssCampo($seq)
{
    global $tab_cmp;

    switch ($tab_cmp[$seq]['nmgp_tipo_dado']) {
        case 'RATINGSMILE':
            return geraCssCampo_ratingSmile($seq);
        case 'RATINGSTAR':
            return geraCssCampo_ratingStar($seq);
        case 'RATINGTHUMBS':
            return geraCssCampo_ratingThumbs($seq);
    }

    return '';
}

function geraCssCampo_ratingSmile($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];
    if ('s' == $tab_cmp[$seq]['rating_smile_display']) {
        $ratingStroke = <<<EOT

    text-shadow: -1px -1px 0 #000, 1px -1px 0 #000, -1px 1px 0 #000, 1px 1px 0 #000;
EOT;
    } else {
        $ratingStroke = '';
    }

    $phpCode = <<<EOT
    function getFieldCss_{$nmgp_campo}()
    {
        \$cssContent = <<<SCEOT
.sc-smile-edit-{$nmgp_campo} {
    font-size: {$tab_cmp[$seq]['rating_smile_font_size']}px;
    padding: {$tab_cmp[$seq]['rating_smile_padding']};
    opacity: 0.25 !important;$ratingStroke
}
.sc-smile-selected-{$nmgp_campo} {
    opacity: 1 !important;
}
SCEOT;

        return \$cssContent;
    }


EOT;

    return $phpCode;
}

function geraCssCampo_ratingStar($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldCss_{$nmgp_campo}()
    {
        \$cssContent = <<<SCEOT
.sc-star-edit-{$nmgp_campo} {
    font-size: {$tab_cmp[$seq]['rating_star_font_size']}px;
    padding: {$tab_cmp[$seq]['rating_star_padding']};
    opacity: 1 !important;
}
SCEOT;

        return \$cssContent;
    }


EOT;

    return $phpCode;
}

function geraCssCampo_ratingThumbs($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];

    $phpCode = <<<EOT
    function getFieldCss_{$nmgp_campo}()
    {
        \$cssContent = <<<SCEOT
.sc-thumb-edit-{$nmgp_campo} {
    font-size: {$tab_cmp[$seq]['rating_thumb_font_size']}px;
    padding: {$tab_cmp[$seq]['rating_thumb_padding']};
    opacity: 0.25 !important;
}
.sc-thumb-selected-{$nmgp_campo} {
    opacity: 1 !important;
}
SCEOT;

        return \$cssContent;
    }


EOT;

    return $phpCode;
}

/*************************************************************************************************************
 * FUNCOES PARA GERACAO DE METODOS DE RETORNO DE CODIGO JAVASCRIPT DOS CAMPOS DA APLICACAO
 ************************************************************************************************************/

function geraJavascriptCampo($seq)
{
    global $tab_cmp;

    switch ($tab_cmp[$seq]['nmgp_tipo_dado']) {
        case 'RATING':
            return geraJavascriptCampo_rating($seq);
        case 'RATINGSMILE':
            return geraJavascriptCampo_ratingSmile($seq);
        case 'RATINGSTAR':
            return geraJavascriptCampo_ratingStar($seq);
        case 'RATINGTHUMBS':
            return geraJavascriptCampo_ratingThumbs($seq);
    }

    return '';
}

function geraJavascriptCampo_rating($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];
    $ratingHints = $tab_cmp[$seq]['rating_star_hints'];
    $starCount = $tab_cmp[$seq]['rating_amount'];

    $dataCount = count($ratingHints);
    if ($dataCount < $starCount) {
        for ($i = $dataCount; $i < $starCount; $i++) {
            $ratingHints[] = '';
        }
    } elseif ($dataCount > $starCount) {
        $dif = $dataCount - $starCount;
        while ($dif > 0) {
            array_pop($ratingHints);
            $dif--;
        }
    }

    $phpCode = <<<EOT
    function getFieldJavascript_{$nmgp_campo}()
    {
        \$jsContent = <<<SCEOT
function scAddTippy_{$nmgp_campo}() {

EOT;
    foreach ($ratingHints as $i => $ratingHintString) {
        $ratingHintString = trataVariaveisHint($ratingHintString);

        $phpCode .= <<<EOT
    if ("" != "{$ratingHintString}") {
        \$(".sc-star-edit-{$nmgp_campo}-{$i}").each(function() {
            if (!$(this).parent().parent().hasClass("sc-rating-breakdown-trigger")) {
                tippy(this, {
                    content: "{$ratingHintString}",
                    offset: [0, 15],
                    theme: "light",
                });
            }
        });
    }

EOT;
    }
    $phpCode .= <<<EOT
}

SCEOT;

        return \$jsContent;
    }


EOT;

    return $phpCode;
}

function geraJavascriptCampo_ratingSmile($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];
    $ratingHints = $tab_cmp[$seq]['rating_smile_hints'];

    $phpCode = <<<EOT
    function getFieldJavascript_{$nmgp_campo}()
    {
        \$jsContent = <<<SCEOT
function scAddTippy_{$nmgp_campo}() {

EOT;
    foreach ($ratingHints as $i => $ratingHintString) {
        $ratingHintString = trataVariaveisHint($ratingHintString);

        $phpCode .= <<<EOT
    if ("" != "{$ratingHintString}") {
        \$(".sc-smile-edit-{$nmgp_campo}-{$i}").each(function() {
            if (!$(this).parent().parent().hasClass("sc-rating-breakdown-trigger")) {
                tippy(this, {
                    content: "{$ratingHintString}",
                    offset: [0, 15],
                    theme: "light",
                });
            }
        });
    }

EOT;
    }
    $phpCode .= <<<EOT
}

SCEOT;

        return \$jsContent;
    }


EOT;

    return $phpCode;
}

function geraJavascriptCampo_ratingStar($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];
    $ratingHints = $tab_cmp[$seq]['rating_star_hints'];
    $starCount = $tab_cmp[$seq]['rating_amount'];

    $dataCount = count($ratingHints);
    if ($dataCount < $starCount) {
        for ($i = $dataCount; $i < $starCount; $i++) {
            $ratingHints[] = '';
        }
    } elseif ($dataCount > $starCount) {
        $dif = $dataCount - $starCount;
        while ($dif > 0) {
            array_pop($ratingHints);
            $dif--;
        }
    }

    $phpCode = <<<EOT
    function getFieldJavascript_{$nmgp_campo}()
    {
        \$jsContent = <<<SCEOT
function scAddTippy_{$nmgp_campo}() {

EOT;
    foreach ($ratingHints as $i => $ratingHintString) {
        $ratingHintString = trataVariaveisHint($ratingHintString);

        $phpCode .= <<<EOT
    if ("" != "{$ratingHintString}") {
        \$(".sc-star-edit-{$nmgp_campo}-{$i}").each(function() {
            if (!$(this).parent().parent().hasClass("sc-rating-breakdown-trigger")) {
                tippy(this, {
                    content: "{$ratingHintString}",
                    offset: [0, 15],
                    theme: "light",
                });
            }
        });
    }

EOT;
    }
    $phpCode .= <<<EOT
}

SCEOT;

        return \$jsContent;
    }


EOT;

    return $phpCode;
}

function geraJavascriptCampo_ratingThumbs($seq)
{
    global $tab_cmp;

    $nmgp_campo = $tab_cmp[$seq]['nmgp_campo'];
    $ratingHints = $tab_cmp[$seq]['rating_thumb_hints'];

    $phpCode = <<<EOT
    function getFieldJavascript_{$nmgp_campo}()
    {
        \$jsContent = <<<SCEOT
function scAddTippy_{$nmgp_campo}() {

EOT;
    foreach ($ratingHints as $i => $ratingHintString) {
        $ratingHintString = trataVariaveisHint($ratingHintString);

        $phpCode .= <<<EOT
    if ("" != "{$ratingHintString}") {
        \$(".sc-thumb-edit-{$nmgp_campo}-{$i}").each(function() {
            if (!$(this).parent().parent().hasClass("sc-rating-breakdown-trigger")) {
                tippy(this, {
                    content: "{$ratingHintString}",
                    offset: [0, 15],
                    theme: "light",
                });
            }
        });
    }

EOT;
    }
    $phpCode .= <<<EOT
}

SCEOT;

        return \$jsContent;
    }


EOT;

    return $phpCode;
}

/*************************************************************************************************************
 * FUNCOES AUXILIARES
 ************************************************************************************************************/

function trataVariaveisHint($hint)
{
    global $tbapl_idioma, $apl_charset, $tbapl_atributos;

    sc_preg_match_local($hint, $matches, $tbapl_idioma, $apl_charset);
    if (!empty($matches[0])) {
        $matches = $matches[0];
        foreach ($matches as $match) {
            $variableName = substr($match, 1, strlen($match) - 2);
            if (in_array($variableName, $tbapl_atributos)) {
                $replace = "{\$_SESSION['$nome_aplicacao']['" . $variableName . "']}";
                $hint = str_replace($match, $replace, $hint);
            }
            elseif (substr($variableName, 0, 5) == "lang_") {
                $replace = "{\$this->Ini->Nm_lang['" . $variableName . "']}";
                $hint = str_replace($match, $replace, $hint);
            }
        }
    }

    sc_preg_match_global($hint, $matches, $tbapl_idioma, $apl_charset);
    if (!empty($matches[0])) {
        $matches = $matches[0];
        foreach ($matches as $match) {
            $replace = "{\$_SESSION['" . substr($match, 1, strlen($match) - 2) . "']}";
            $hint = str_replace($match, $replace, $hint);
        }
    }

    return $hint;
}
