<?php

/*
 * List folders from a project looking for duplicated folders. If empty, delete it.
 * */
if ($num_versao_atual < 9120023 || empty($num_versao_atual))
{
    $previous_error = set_error_handler("nm_faz_nada");
    nm_load_class('interface', 'Group');
    nm_load_class('interface', 'Application');

    $obj_grp = new nmGroup();
    $obj_app = new nmApplication();

    $arr_groups = $obj_grp->getGroupList();

    beginTrans();
    $arr_groups = $obj_grp->ListData();
    foreach($arr_groups as $arr_group)
    {
        $obj_grp->LoadData($arr_group['Cod_Prj']);
        $arr_folders = $obj_grp->GetData('Folders');

        $arr_list = $obj_app->RetListApp($arr_group['Cod_Prj'], 0, false, array(), true, array(), false);

        $bol_changed = false;
        testeDuplicatedDir($arr_folders['root'], $arr_folders['root'], "", $arr_folders, $arr_list, $bol_changed);

        if($bol_changed)
        {
            $obj_grp->SetData('Folders', $arr_folders);
            $obj_grp->AtuData($arr_group['Cod_Prj']);
        }
    }
    CommitTrans();
    set_error_handler($previous_error);
    $return = true;
}

function testeDuplicatedDir($arr, $arr_base, $_path, &$arr_completo, $arr_apl, &$bol_changed)
{
    foreach($arr as $_folder => $_folders)
    {
        findPathInFolder($_folder, $arr_base, "", $_path . "/" . $_folder, $arr_completo, $arr_apl, $bol_changed);

        if(is_array($_folders) && !empty($_folders))
        {
            testeDuplicatedDir($_folders, $arr_base, $_path . "/" . $_folder, $arr_completo, $arr_apl, $bol_changed);
        }
    }
}

function findPathInFolder($_find, $arr_base, $_path, $_path_origem, &$arr_completo, $arr_apl, &$bol_changed)
{
    foreach($arr_base as $_folder => $_folders)
    {
        if($_find == $_folder && $_path . "/" . $_folder != $_path_origem)
        {
            apagaDirVazio("root" . $_path . "/" . $_folder, $arr_completo, $arr_apl, $bol_changed);
        }
        if(is_array($_folders) && !empty($_folders))
        {
            findPathInFolder($_find, $_folders, $_path . "/" . $_folder, $_path_origem, $arr_completo, $arr_apl, $bol_changed);
        }
    }
}

function apagaDirVazio($dir, &$arr_completo, $arr_apl, &$bol_changed)
{
    $found = false;
    foreach($arr_apl as $_folder => $_apls)
    {
        if (stripos($_folder, $dir) !== false) {
            $found = true;
        }
    }

    if(!$found)
    {
        $_arr_dir = explode("/", $dir);
        $_str_dir = "['" . implode("']['", $_arr_dir) . "']";
        eval("unset(\$arr_completo". $_str_dir .");");

        $bol_changed = true;
    }
}