-- $Id: samples_mysql.sql,v 1.1.1.1 2011-05-12 20:31:11 diogo Exp $
DROP TABLE IF EXISTS `adm_categorias`;
CREATE TABLE `adm_categorias` (`CategoriaID` int(11) NOT NULL default '0', `NomeCategoria` varchar(15) NOT NULL default '', `Descricao` varchar(255) default NULL, `Foto` varchar(128) default NULL, PRIMARY KEY  (`CategoriaID`)) TYPE=MyISAM;
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (1, 'Bebidas', 'Refrigerantes, Cafes, Chas, Cervejas e Bebidas Alcoolicas', 'bebidas.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (2, 'Condimentos', 'Condimentos, Temperos e Pastas', 'condimentos.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (3, 'Confeitaria', 'Sobremesas, Doces e Tortas', 'sobremesas.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (4, 'Laticinios', 'Queijos', 'queijos.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (5, 'Graos e Cereais', 'Paes, Biscoitos e Cereais', 'paes.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (6, 'Pratos Prontos', 'Comida Preparada', 'comida pronta.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (7, 'Produtos Indust', 'Conservas, Frutas secas', 'frutas secas.jpg');
INSERT INTO `adm_categorias` (`CategoriaID`, `NomeCategoria`, `Descricao`, `Foto`) VALUES (8, 'Frutos do Mar', 'Algas e Peixes', 'peixes.jpg');
DROP TABLE IF EXISTS `adm_clientes`;
CREATE TABLE `adm_clientes` (`ClienteId` varchar(5) NOT NULL default '', `NomeCliente` varchar(40) NOT NULL default '', `NomeContato` varchar(30) default NULL, `CargoContato` varchar(30) default NULL, `Tpcli` char(1) default NULL, `CIC_CNPJ` varchar(14) default NULL, `DataNasc` date default NULL, `Endereco` varchar(60) default NULL, `Bairro` varchar(15) default NULL, `Cidade` varchar(15) default NULL, `Estado` char(2) default NULL, `Cep` varchar(8) default NULL, `Pais` varchar(15) default NULL, `Fone` varchar(24) default NULL, `Fax` varchar(24) default NULL, `LimiteCred` decimal(16,4) default NULL, `CartaoTipo` char(1) default NULL, `CartaoNumero` varchar(20) default NULL, `Notas` varchar(255) default NULL, PRIMARY KEY  (`ClienteId`)) TYPE=MyISAM;
INSERT INTO `adm_clientes` VALUES ('ALFKI', 'Antonio Camargo Alcoforado', 'Jose Velozo Barbosa', 'Rep Vendas', 'F', '39903222491', '1980-01-10 00:00:00', 'AVENIDA BEIRA RIO', 'Bultrins', 'Olinda', 'PE', '50610100', 'BR', '88132230033', '', '2100.0000', '0', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('ANATR', 'Ana Rainha da Culinaria', 'Ana Porfirio', 'Proprietario', 'J', '87163234000138', '1970-11-13 00:00:00', 'URIEL PAES BARRETO', 'Varadouro', 'Olinda', 'PE', '50710500', 'BR', '11-222321123', '', '2400.0000', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('ANTON', 'Antonio Moreno Bebidas', 'Antonio Moreno', 'Proprietario', 'J', '00634398000118', '1970-11-13 00:00:00', 'R. Vasco da Gama, 424', 'Espinheiro', 'Fortaleza', 'CE', '50710500', 'BR', '011-222321123', '', '7514.3500', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('AROUT', 'Arquimedes Alimentacao', 'Timoteo Brito', 'Rep Vendas', 'J', '19877269449', '1970-11-13 00:00:00', 'R. Taquaritinga, 48 B', 'Madalena', 'Recife', 'PE', '50710500', 'BR', '081-222321123', NULL, '3805.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BERGS', 'Bernadete Refeioes', 'Cristiane  Alencar', 'Administrador', 'J', '24218539000180', '1970-11-13 00:00:00', 'R. Surubim, 117', 'Janga', 'Paulista', 'PE', '50710500', 'BR', '081-222321123', NULL, '7965.1500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BLAUS', 'Belo Delicatessen', 'Helena Gusmao', 'Rep Vendas', 'J', '00199843000169', '1970-11-13 00:00:00', 'R. Sta Maria Goreth, 226', 'Espinheiro', 'Fortaleza', 'CE', '50710500', 'BR', '011-222321123', NULL, '3239.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BLONP', 'Belarmino pais e filhos', 'Frederico Cardoso', 'Ger Vendas', 'J', '24214702000136', '1970-11-13 00:00:00', 'R. Senador Soares Meireles, 123', 'Espinheiro', 'Rio de Janeiro', 'RJ', '50710500', 'BR', '021-222721123', NULL, '9087.2500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BOLID', 'Barto Comidas', 'Marcos Soares', 'Proprietario', 'J', '62538202000815', '1970-11-13 00:00:00', 'R. Senador Milton Campos, 176', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '5297.1000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BONAP', 'Bom Apetite', 'Lourival Almeida', 'Proprietario', 'J', '00963007000109', '1970-11-13 00:00:00', 'R. Sao Vicente, 340', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '4847.7500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BOTTM', 'Barcelos Mercado', 'Marilia Gabriela', 'Ger Contabil', 'J', '40881674000167', '1970-11-13 00:00:00', 'R. Bela Vista, 51', 'Espinheiro', 'So Luis', 'MA', '50710500', 'BR', '011-222321123', NULL, '3604.7500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('BSBEV', 'Beto Bebidas', 'Vitoria Guimaraes', 'Rep Vendas', 'J', '01394917000180', '1970-11-13 00:00:00', 'R. Santa Isabel, 223 ap.202', 'Bairro Novo', 'Olinda', 'PE', '50710500', 'BR', '222321123', NULL, '6089.9000', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('CACTU', 'Cactus Comidas', 'Petrucio Souza Junior', 'Agente de Vendas', 'J', '09268517003156', '1970-11-13 00:00:00', 'R. Rosa da Fonseca, 93/304', 'Espinheiro', 'Macap', 'AP', '50710500', 'BR', '011-222321123', NULL, '2814.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('CENTC', 'Centro Meridional', 'Francisco Gomes', 'Ger Vendas', 'J', '02429317000335', '1970-11-13 00:00:00', 'R. Rodrigues Sete, 80', 'Espinheiro', 'Fortaleza', 'CE', '50710500', 'BR', '32321123', NULL, '2100.8000', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('CHOPS', 'Chop-suey Chines', 'Yang Wang', 'Proprietario', 'J', '01231008000121', '1970-11-13 00:00:00', 'R. REDENTOR, 45', 'Espinheiro', 'Fortaleza', 'CE', '50710500', 'BR', '011-222321123', NULL, '2885.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('COMMI', 'Comrcio Mineiro', 'Pedro Afonso', 'Associado de Vendas', 'J', '02000869000161', '1970-11-13 00:00:00', 'R. Alfredo Gama, 14', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '3810.7500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('CONSH', 'Consolidados Bom Apetite', 'Elizandra Batista', 'Rep Vendas', 'J', '02838461000163', '1970-11-13 00:00:00', 'R. Raimundo Freixeira, 163', 'Marinha Farinha', 'Paulista', 'PE', '50710500', 'BR', '081-222321123', NULL, '2719.1000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('DRACD', 'Dracula Delicatessen', 'Waldetario Silva', 'Administrador', 'J', '00360163000185', '1970-11-13 00:00:00', 'R. Prof. Alvaro Lima, 50', 'Espinheiro', 'Manaus', 'AM', '50710500', 'BR', '011-222321123', NULL, '3763.2100', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('DUMON', 'O Mundo Inteiro', 'Janaina da Paixao', 'Proprietario', 'J', '35329382000186', '1970-11-13 00:00:00', 'R. Pedro Allain, 125 Casa.34', 'Espinheiro', 'Aracaju', 'SE', '50710500', 'BR', '011-222321123', NULL, '2615.9000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('EASTC', 'Estacao do Oriente', 'Ana Clara', 'Agente de Vendas', 'J', '41035627000165', '1970-11-13 00:00:00', 'R. Paula Batista, 165', 'Espinheiro', 'Recife', 'PE', '50710500', 'BR', '081-222321123', NULL, '5033.1600', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('ERNSH', 'Encontro Certo', 'Roberto Meira Silva', 'Ger Vendas', 'J', '00048785003279', '1970-11-13 00:00:00', 'R. Padre Lemos, 644/sala 01', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '3229.7300', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FAMIA', 'Familia Juliano', 'Aria Cruz', 'Assistente de Vendas', 'J', '02441423000172', '1970-11-13 00:00:00', 'R. Conde de Iraja, 432/801', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '4437.7000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FISSA', 'FISSA Fabrica Inter', 'Diogenes Padilha', 'Ger Contabil', 'J', '01244800000110', '1970-11-13 00:00:00', 'R. Oscar Pinto, 142', 'Espinheiro', 'Campina Grande', 'PB', '50710500', 'BR', '33453278', NULL, '2135.0500', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('FOLIG', 'Forte e Alimentado', 'Marcos Ribeiro Couto', 'Assistente Agente Vendas', 'J', '96479258000191', '1970-11-13 00:00:00', 'R. Olimpio Tauares , 97', 'Espinheiro', 'Sao Paulo', 'SP', '50710500', 'BR', '011-222321123', NULL, '2666.9000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FOLKO', 'Festa Popular', 'Maria Limeira Souza', 'Proprietario', 'J', '01895380000132', '1970-11-13 00:00:00', 'R. Nova Friburgo, 594', 'Espinheiro', 'Recife', 'PE', '50710500', 'BR', '081-222321123', NULL, '3551.7000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FRANK', 'Frazo Comidas', 'Pedro Fernandes', 'Gerente Comercializacao', 'J', '11015708000132', '1970-11-13 00:00:00', 'R. Nova Descoberta,84', 'Espinheiro', 'Anaplis', 'GO', '50710500', 'BR', '011-222321123', NULL, '9719.5600', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FRANR', 'Frances Restaurante', 'Catarina Belarmino', 'Gerente Comercializacao', 'J', '09794389000169', '1970-11-13 00:00:00', 'R. Motta Junior, 31', 'Espinheiro', 'Aracaju', 'SE', '50710500', 'BR', '011-222321123', NULL, '3172.1600', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FRANS', 'Francinete S.p.a', 'Paulo Assuncao', 'Rep Vendas', 'J', '00370147003270', '1970-11-13 00:00:00', 'R. manoel apolinario, 102', 'Espinheiro', 'Macei', 'AL', '50710500', 'BR', '082-222361723', NULL, '2545.7000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('FURIB', 'Feijo Frutos do Mar', 'Leonel Rodrigues', 'Ger Vendas', 'J', '10582062000102', '1970-11-13 00:00:00', 'R. mandacaru, 512, casa, 02', 'Espinheiro', 'Sao Paulo', 'SP', '50710500', 'BR', '011-222321123', NULL, '7149.6000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('GALED', 'Galera do Gastronomo', 'Eduardo Savoia', 'Gerente Comercializacao', 'J', '10970887000102', '1970-11-13 00:00:00', 'R. Major Nereu  Guerra, 131', 'Espinheiro', 'Porto Velho', 'RO', '50710500', 'BR', '011-222321123', NULL, '2836.7000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('GODOS', 'Gordo Cozinha Tipica', 'Jos Pedro Freire', 'Ger Vendas', 'J', '35457951000179', '1970-11-13 00:00:00', 'R. Major Afonso Leal, 81/02', 'Espinheiro', 'Terezina', 'PI', '50710500', 'BR', '011-222321123', NULL, '2829.0500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('GOURL', 'Gourmet Lanchonetes', 'Andr Fonseca', 'Associado de Vendas', 'J', '37655784000104', '1970-11-13 00:00:00', 'R. Melquizedeque de Lima, 105', 'Espinheiro', 'Campo Grande', 'MS', '50710500', 'BR', '011-222321123', NULL, '8700.9300', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('GREAL', 'Grandes Lagos Alimentos', 'Herval Carvalho Pimentel', 'Gerente Comercializacao', 'J', '09989120002262', '1970-11-13 00:00:00', 'AV. pedro allaim, 125 ,casa, 17', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '9709.5800', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('GROSR', 'Geralda - Restaurante', 'Manuel Pereira', 'Proprietario', 'J', '53026472002557', '1970-11-13 00:00:00', 'R. Antonio de Castro, 133', 'Espinheiro', 'Vitria', 'ES', '50710500', 'BR', '011-222321123', NULL, '2488.7000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('HANAR', 'Havai Carnes', 'Mario Pontes Costa', 'Ger Contabil', 'J', '00216435000178', '1970-11-13 00:00:00', 'Av. Dr. Eurico Chaves, 661', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '5099.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('HILAA', 'Hilda - Abastecimentos', 'Carlos Herculano Pinto', 'Rep Vendas', 'J', '02497415000148', '1970-11-13 00:00:00', 'R. jose Bonifacio, 232', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '4610.0800', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('HUNGC', 'Hugo Lobo Importacao', 'Yasmim Lamartine', 'Rep Vendas', 'J', '02813146000181', '1970-11-13 00:00:00', 'AV. Otacilo Azevedo, 2397', 'Espinheiro', 'Manaus', 'AM', '50710500', 'BR', '011-222321123', NULL, '3063.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('HUNGO', 'Helena Coruja Noturna', 'Patricia Pilar dos Santos', 'Associado de Vendas', 'J', '15102288019100', '1970-11-13 00:00:00', 'R. Antonio Prado, 30', 'Espinheiro', 'Palmas', 'TO', '50710500', 'BR', '011-222321123', NULL, '7311.1400', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('ISLAT', 'Israel Comercio', 'Helena Bastos da Rocha', 'Gerente Comercializacao', 'J', '61156410019482', '1970-11-13 00:00:00', 'R. Abel de Sa B. Cavalcante, 101', 'Espinheiro', 'Campina Grande', 'PB', '50710500', 'BR', '083-33453278', NULL, '6146.3000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('KOENE', 'Katia Comidas em Geral', 'Paulo Canudos', 'Associado de Vendas', 'J', '69970143000122', '1970-11-13 00:00:00', 'R. Luiz Cezario de Melo, 237', 'Espinheiro', 'Campina Grande', 'PB', '50710500', 'BR', '083-33453278', NULL, '2744.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LACOR', 'Lago Sao Sebastiao', 'Daniel Travassos', 'Rep Vendas', 'J', '02336993000100', '1970-11-13 00:00:00', 'R. Largo Casa Amarela, 136', 'Espinheiro', 'So Luis', 'MA', '50710500', 'BR', '011-222321123', NULL, '2992.0500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LAMAI', 'Lagoa da Asia', 'Anita Rosemberg', 'Ger Vendas', 'J', '70089412000125', '1970-11-13 00:00:00', 'R. Iguatama, 189', 'Espinheiro', 'Aracaju', 'SE', '50710500', 'BR', '011-222321123', NULL, '2498.8900', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LAUGB', 'Lourival  Vinhos & CIA', 'Yoshi Tamandare', 'Assistente Comercializacao', 'J', '08697211000137', '1970-11-13 00:00:00', 'R. barao de granito, 54', 'Espinheiro', 'Macap', 'AP', '50710500', 'BR', '011-222321123', NULL, '2522.5000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LAZYK', 'Lazer Lojas Associadas', 'Joao Sabara Peixoto', 'Gerente Comercializacao', 'J', '24130072000111', '1970-11-13 00:00:00', 'Av. Felicino Dourado, 98', 'Espinheiro', 'Macap', 'AP', '50710500', 'BR', '011-222321123', NULL, '2357.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LEHMS', 'Leticia Comercio Ltda', 'Renato Messia Porto', 'Rep Vendas', 'J', '00355855000135', '1970-11-13 00:00:00', 'R. Ibia, 97', 'Espinheiro', 'Porto Alegre', 'RS', '50710500', 'BR', '011-222321123', NULL, '2278.2700', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LETSS', 'Ligao Parada Obrigatoria', 'Jaime Carvalho', 'Proprietario', 'J', '01209307000160', '1970-11-13 00:00:00', 'R. Bacuri, 158', 'Espinheiro', 'Rio Branco', 'AC', '50710500', 'BR', '011-222321123', NULL, '3488.9200', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LILAS', 'LILA-Supermercado', 'Carlos Gomes Silva', 'Ger Contabil', 'J', '11869070000105', '1970-11-13 00:00:00', 'R. 22 de outubro, 67', 'Espinheiro', 'Curitiba', 'PR', '50710500', 'BR', '011-222321123', NULL, '7821.7600', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LINOD', 'Lindolfo - Delicatessen', 'Felipe Alcantara', 'Proprietario', 'J', '09596636000112', '1970-11-13 00:00:00', 'AV. Rui Barbosa, 1672', 'Espinheiro', 'Campo Grande', 'MS', '50710500', 'BR', '011-222321123', NULL, '7886.4500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('LONEP', 'Lamartine Restaurante', 'Francisco Ricardo', 'Ger Vendas', 'J', '00530052000170', '1970-11-13 00:00:00', 'R. Uriel Paes Barreto,25', 'Espinheiro', 'Florianopolis', 'SC', '50710500', 'BR', '011-222321123', NULL, '4258.6000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('MAGAA', 'Magazine Alimentar Ltda', 'Geraldo Ribeiro', 'Gerente Comercializacao', 'J', '00736194000198', '1970-11-13 00:00:00', 'R. Heraclito Cavalcante, 165', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '7602.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('MAISD', 'Maravilhas do Amazonas', 'Catarina da Silva', 'Agente de Vendas', 'J', '70188859000151', '1970-11-13 00:00:00', 'R. Heitor Maia, 85', 'Espinheiro', 'So Luis', 'MA', '50710500', 'BR', '011-222321123', NULL, '2660.0200', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('MEREP', 'Mercia Paladar', 'Joesil Fonseca', 'Assistente Comercializacao', 'J', '35716166000193', '1970-11-13 00:00:00', 'Av. Malaco, 503', 'Espinheiro', 'Florianopolis', 'SC', '50710500', 'BR', '011-222321123', NULL, '3202.0500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('MORGK', 'Miramar Comercio Ltda', 'Alexandre Fagundes', 'Assistente Comercializacao', 'J', '35526946000170', '1970-11-13 00:00:00', 'R. Guimaraes  Peixoto,  405', 'Espinheiro', 'Porto Alegre', 'RS', '50710500', 'BR', '011-222321123', NULL, '5042.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('NORTS', 'Norte/Sul Ltda', 'Savio Caravelas', 'Associado de Vendas', 'J', '01283410000150', '1970-11-13 00:00:00', 'R. General Meira Barreto, 63', 'Espinheiro', 'Recife', 'PE', '50710500', 'BR', '081-222321123', NULL, '2649.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('OCEAN', 'Ocano Atlntico Ltda.', 'Isaura Fonseca Carneiro', 'Agente de Vendas', 'J', '01699694000160', '1970-11-13 00:00:00', 'R. Ferreira Lopes, 414', 'Espinheiro', 'Macap', 'AP', '50710500', 'BR', '011-222321123', NULL, '3460.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('OLDWO', 'Olinda - Delicatessen', 'Rene Filipe Peixoto', 'Rep Vendas', 'J', '09943754000150', '1970-11-13 00:00:00', 'R. Bento de Loyola, 161', 'Espinheiro', 'Natal', 'RN', '50710500', 'BR', '011-222321123', NULL, '6323.5500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('OTTIK', 'Otilia Alimento em Geral', 'Henriqueta Pedrosa', 'Proprietario', 'J', '02443601000102', '1970-11-13 00:00:00', 'R. Evaristo da Veiga, 106', 'Espinheiro', 'Caxias', 'RS', '50710500', 'BR', '011-222321123', NULL, '3155.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('PARIS', 'Paris Especialidades', 'Maria Beltrao', 'Proprietario', 'J', '10669331000172', '1970-11-13 00:00:00', 'R. Eng. Oscar Ferreira, 338', 'Espinheiro', 'Curitiba', 'PR', '50710500', 'BR', '32230033', NULL, '2000.0000', 'M', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('PERIC', 'Pericles Comidas classicas', 'Gilberto Felinto Coelho', 'Rep Vendas', 'J', '02017120000127', '1970-11-13 00:00:00', 'R. Dr. Jose Ribeiro Campos, 45', 'Espinheiro', 'Aracati', 'CE', '50710500', 'BR', '011-222321123', NULL, '4242.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('PICCO', 'Pivete Vendas em Geral', 'George Petronio', 'Ger Vendas', 'J', '02140902000159', '1970-11-13 00:00:00', 'R. Dr. Carlos Mavignier, 104', 'Espinheiro', 'Belo Horizonte', 'MG', '50710500', 'BR', '011-222321123', NULL, '7258.3000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('PRINI', 'Princesa Isabel Vinhos', 'Isabel de Castro', 'Rep Vendas', 'J', '01716476000196', '1970-11-13 00:00:00', 'R. Dr. Antonio de Castro, 160', 'Espinheiro', 'So Carlos', 'SP', '50710500', 'BR', '011-222321123', NULL, '5316.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('QUEDE', 'Que Delcia', 'Bernardo Batista', 'Ger Contabil', 'J', '11484193000110', '1970-11-13 00:00:00', 'AV. Cons.Ribas, 162', 'Espinheiro', 'Coxixola', 'PB', '50710500', 'BR', '083-33453278', NULL, '6972.1800', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('QUEEN', 'Quero Mais Cozinha', 'Lcia Carvalho', 'Assistente Comercializacao', 'J', '03116281000130', '1970-11-13 00:00:00', 'R. Conde de Iraja,  520', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '2222.5000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('QUICK', 'Que Bacana Comercio', 'Herculano Costa', 'Ger Contabil', 'J', '11523602000140', '1970-11-13 00:00:00', 'R. Dona Rosa da Fonseca, 109/02', 'Espinheiro', 'Caxias', 'RS', '50710500', 'BR', '011-222321123', NULL, '7477.4400', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('RANCH', 'Rancho grande', 'Sergio Gazola', 'Rep Vendas', 'J', '02022866000129', '1970-11-13 00:00:00', 'R. Dona Ana Xavier, 60 Lj 05', 'Espinheiro', 'Macap', 'AP', '50710500', 'BR', '011-222321123', NULL, '2844.1000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('RATTC', 'Rato e Gato Comestiveis', 'Paula Saudanha', 'Assistente Representante Venda', 'J', '01744963000162', '1970-11-13 00:00:00', 'Av. Ver. Otacilio de Azevedo, 1581', 'Espinheiro', 'Belo Horizonte', 'MG', '50710500', 'BR', '011-222321123', NULL, '2243.4100', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('REGGC', 'Regina Comercio Ltda', 'Mauricio Matos Souto', 'Associado de Vendas', 'J', '00517504000183', '1970-11-13 00:00:00', 'R. Dom Mauricio, 275', 'Espinheiro', 'Anaplis', 'GO', '50710500', 'BR', '011-222321123', NULL, '7553.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('RICAR', 'Ricardo Adocicados', 'Janete Limeira', 'Assistente Agente Vendas', 'J', '00394429001344', '1970-11-13 00:00:00', 'AV. 17 de Agosto, 892', 'Espinheiro', 'Coxixola', 'PB', '50710500', 'BR', '083-33453278', NULL, '2923.1000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('RICSU', 'Rivaldo Supermercados S/A', 'Mizael Antonio Souza', 'Ger Vendas', 'J', '01007520000199', '1970-11-13 00:00:00', 'R. Des. Fonseca Galvao, 110', 'Casa Caiada', 'Olinda', 'PE', '50710500', 'BR', '081-222321123', NULL, '2031.9500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('ROMEY', 'Romero & Tomaz', 'Alexandra Carmelita', 'Ger Contabil', 'J', '37977691000430', '1970-11-13 00:00:00', 'R. Deputado Mario Monteiro, 52/04', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '2467.2900', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SANTG', 'Santa Fe Comidas', 'Jonas Bartolomeu', 'Proprietario', 'J', '10230480001960', '1970-11-13 00:00:00', 'R. de Santa Izabel, 239', 'Espinheiro', 'Salvador', 'BA', '50710500', 'BR', '011-222321123', NULL, '5735.1500', '', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('SAVEA', 'Salvador Mercado', 'Jose Pavarotti', 'Rep Vendas', 'J', '10773372000104', '1970-11-13 00:00:00', 'R. Alfredo Gama, 14', 'Espinheiro', 'Arapiraca', 'AL', '50710500', 'BR', '082-222361723', NULL, '5663.7900', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SEVES', 'Sete Oceanos Importao', 'Helena Beltrao', 'Ger Vendas', 'J', '02818743000107', '1970-11-13 00:00:00', 'R. das Neves, 390', 'Espinheiro', 'Recife', 'PE', '50710500', 'BR', '081-222321123', NULL, '7170.1500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SIMOB', 'Simao Comidas Ltda', 'Josue Pimentel', 'Proprietario', 'J', '11567039001000', '1970-11-13 00:00:00', 'R. da Harmonia  480/403', 'Espinheiro', 'Anaplis', 'GO', '50710500', 'BR', '011-222321123', NULL, '8136.3500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SPECD', 'Sabores do Mundo', 'Damiao Petrucio Amorim', 'Gerente Comercializacao', 'J', '02111102000100', '1970-11-13 00:00:00', 'R. D. Ana Xavier, 60 lj.9/10', 'Espinheiro', 'Curitiba', 'PR', '50710500', 'BR', '011-222321123', NULL, '2423.3500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SPLIR', 'Sao Paulo Bebidas', 'Armando Bastos', 'Ger Vendas', 'J', '12882650000197', '1970-11-13 00:00:00', 'R. Maroquinha Ramos, 607', 'Espinheiro', 'Porto Alegre', 'RS', '50710500', 'BR', '011-222321123', NULL, '2487.8500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('SUPRD', 'Super Delicias Ltda', 'Pascoal Camargo', 'Ger Contabil', 'J', '02080072000111', '1970-11-13 00:00:00', 'R. Costa Lima, 49', 'Espinheiro', 'Belm', 'PA', '50710500', 'BR', '011-222321123', NULL, '5703.2500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('THEBI', 'Tonico do Queijo Ltda', 'Lizandra Galindo', 'Gerente Comercializacao', 'J', '01908121000107', '1970-11-13 00:00:00', 'AV. Norte, 6622', 'Espinheiro', 'Florianopolis', 'SC', '50710500', 'BR', '011-222321123', NULL, '3361.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('THECR', 'Tinoco Atacados em Geral', 'Leonardo Camargo', 'Assistente Comercializacao', 'J', '12790622000140', '1970-11-13 00:00:00', 'R.  Bento de Loyola, 88', 'Espinheiro', 'Salvador', 'BA', '50710500', 'BR', '011-222321123', NULL, '2947.2400', '', '5390778580350260', '');
INSERT INTO `adm_clientes` VALUES ('TOMSP', 'Toni Especiarias', 'Karina Joseli', 'Gerente Comercializacao', 'J', '12806295000177', '1970-11-13 00:00:00', 'R. Conselheiro Ribas, 106', 'Espinheiro', 'Florianopolis', 'SC', '50710500', 'BR', '011-222321123', NULL, '4952.7500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('TORTU', 'Tartaruga Restaurante', 'Miguel Angel Paolino', 'Proprietario', 'J', '77917680001290', '1970-11-13 00:00:00', 'R. Conselheiro Nabuco, 151', 'Espinheiro', 'Aracati', 'CE', '50710500', 'BR', '011-222321123', NULL, '2042.5900', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('TRADH', 'Tradio Hipermercados', 'Anabela Domingos', 'Rep Vendas', 'J', '41114422000175', '1970-11-13 00:00:00', 'Av. Beira Rio, 1059/202', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '7309.6700', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('TRAIH', 'Tereza Bebidas e Comidas', 'Etelvina do Monte', 'Associado de Vendas', 'J', '24354193000147', '1970-11-13 00:00:00', 'R. Jose de Holanda, 561', 'Espinheiro', 'Campo Grande', 'MS', '50710500', 'BR', '011-222321123', NULL, '2571.2000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('VAFFE', 'Varejao Sto Antonio', 'Paloma Justa', 'Ger Vendas', 'J', '08072175000116', '1970-11-13 00:00:00', 'R. Cons. Peretti, 106', 'Espinheiro', 'Aracaju', 'SE', '50710500', 'BR', '011-222321123', NULL, '6642.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('VICTE', 'Visconde Sabores Mil', 'Maria Savaroni', 'Agente de Vendas', 'J', '00120529000149', '1970-11-13 00:00:00', 'R. Cons Nabuco 151/502', 'Espinheiro', 'Joo Pessoa', 'PB', '50710500', 'BR', '083-33453278', NULL, '9934.8000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('VINET', 'Vinicula Sao Gabriel', 'Paulo Henrique', 'Ger Contabil', 'J', '24215618000137', '1970-11-13 00:00:00', 'R. Ciamarte, 95', 'Espinheiro', 'Campina Grande', 'PB', '50710500', 'BR', '083-33453278', NULL, '2480.0000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WANDK', 'Wando Comida e Satisfao', 'Rita Maia Leite', 'Rep Vendas', 'J', '08283285000127', '1970-11-13 00:00:00', 'R. Cecilia Reis, 45', 'Espinheiro', 'Macei', 'AL', '50710500', 'BR', '082-222361723', NULL, '2881.9900', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WARTH', 'Wilson Comida Diet', 'Persio Andrade', 'Ger Contabil', 'J', '01874331000113', '1970-11-13 00:00:00', 'R. Carlos Mavignier, 274', 'Espinheiro', 'Londrina', 'PR', '50710500', 'BR', '011-222321123', NULL, '6615.1000', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WELLI', 'Wellington Importadora', 'Paula Parente', 'Ger Vendas', 'J', '24135766000141', '1970-11-13 00:00:00', 'R. Belarmino Carneiro, 53', 'Espinheiro', 'Goiana', 'GO', '50710500', 'BR', '011-222321123', NULL, '6479.1500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WHITC', 'Wanderlucia Trevo Mercado', 'Katia Andrade', 'Proprietario', 'J', '70177282000182', '1970-11-13 00:00:00', 'AV. Juarez Tavora, 1230', 'Espinheiro', 'Arapiraca', 'AL', '50710500', 'BR', '082-222361723', NULL, '2301.1400', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WILMK', 'Wilson Especiarias', 'Marcelo Toscano', 'Propietario/Assistente Comerci', 'J', '10952133000111', '1970-11-13 00:00:00', 'R. cabo eptacio lucena, 114', 'Espinheiro', 'Campo Grande', 'MS', '50710500', 'BR', '011-222321123', NULL, '3161.3500', 'M', '5390778580350260', NULL);
INSERT INTO `adm_clientes` VALUES ('WOLZA', 'Wanderson Culinaria', 'Zilda Amorim Souza', 'Proprietario', 'J', '01674293000155', '1970-11-13 00:00:00', 'R. Bonito de Santa, 211', 'Espinheiro', 'So Luis', 'MA', '50710500', 'BR', '011-222321123', NULL, '3531.9500', 'M', '5390778580350260', NULL);
DROP TABLE IF EXISTS `adm_estados`;
CREATE TABLE `adm_estados` (`EstadoID` char(2) NOT NULL default '', `NomeEstado` varchar(20) NOT NULL default '', PRIMARY KEY  (`EstadoID`)) TYPE=MyISAM;
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('AC', 'Acre');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('AL', 'Alagoas');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('AM', 'Amazonas');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('AP', 'Amap');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('BA', 'Bahia');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('CE', 'Cear');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('DF', 'Distrito Federal');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('ES', 'Esprito Santo');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('GO', 'Goias');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('MA', 'Maranho');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('MG', 'Minas Gerais');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('MS', 'Mato Grosso do Sul');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('MT', 'Mato Grosso');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('PA', 'Par');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('PB', 'Paraba');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('PE', 'Pernambuco');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('PI', 'Piau');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('PR', 'Paran');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('RJ', 'Rio de Janeiro');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('RN', 'Rio Grande do Norte');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('RO', 'Rondnia');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('RR', 'Roraima');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('RS', 'Rio  Grande do Sul');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('SC', 'Santa Catarina');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('SE', 'Sergipe');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('SP', 'So Paulo');
INSERT INTO `adm_estados` (`EstadoID`, `NomeEstado`) VALUES ('TO', 'Tocantins');

DROP TABLE IF EXISTS `adm_fornecedores`;
CREATE TABLE `adm_fornecedores` (`FornecedorID` int(11) NOT NULL default '0', `NomeFornecedor` varchar(40) NOT NULL default '', `NomeContato` varchar(30) default NULL, `CargoContato` varchar(30) default NULL, `Endereco` varchar(60) default NULL, `Cidade` varchar(15) default NULL, `Estado` varchar(15) default NULL, `CaixaPostal` varchar(10) default NULL, `Pais` varchar(15) default NULL, `Fone` varchar(24) default NULL, `Fax` varchar(24) default NULL, `HomePage` varchar(255) default NULL, PRIMARY KEY  (`FornecedorID`)) TYPE=MyISAM;

INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (1, 'Exoticos Alimentos e Bebidas', 'Catarina Chaves Borba', 'Gerente de Compras', 'R. Xavantes, 40', 'Recife', 'PE', 'EC1 4SD', 'Brasil', '081-222321123', '081-22233423', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (2, 'Nova Friburgo Animacoes', 'Scheyla Pedrosa Melo', 'Administrador', 'R. Visconde de Taunay, 145', 'Goiana', 'GO', '70117', 'Brasil', '011-222321123', '011-222321123', '#CAJUN.HTM#');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (3, 'Grandes Terras Brasil', 'Regina Magalhaes', 'Representante Vendas', 'R. Vasco da Gama, 424', 'Florianopolis', 'SC', '48104', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (4, 'Recife Negocios Ltda', 'Yasmim Peixoto', 'Gerente Comercializacao', 'R. Taquaritinga, 48 B', 'Salvador', 'BH', '100', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (5, 'Cooperativa de Queijos', 'Antonio Severino Bastos', 'Administrador Exportacao', 'R. Surubim, 117', 'Goiana', 'GO', '33007', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (6, 'Mauricio Alimentos', 'Marcos Olimpio', 'Representante Comercial', 'R. Sta Maria Goreth, 226', 'Curitiba', 'PR', '545', 'Brasil', '011-222321123', '011-222321123', 'http://www.netmake.com.br');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (7, 'Patativa Ltda', 'Israel de Melo', 'Gerente Comercializacao', 'R. Senador Soares Meireles, 123', 'Fortaleza', 'CE', '3058', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (8, 'Especiais Biscoitos Ltda', 'Pedro Wilson Melo', 'Representante Vendas', 'R. Senador Milton Campos, 176', 'Fortaleza', 'CE', 'M14 GSD', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (9, 'Parada Alimentar', 'Luis Faustino de Sa', 'Agente de Vendas', 'R. Sao Vicente, 340', 'Campo Grande', 'MS', 'S-345 67', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (10, 'Refrescos Americanas Ltda', 'Carlos Diaz de Souza', 'Gerente Comercializacao', 'R. Santa Isabel, 223 ap.202', 'Goiana', 'GO', '5442', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (11, 'Helio Especiarias Ltda', 'Pricila da Silva', 'Gerente de Vendas', 'R. Rosa da Fonseca, 93/304', 'Cuiab', 'MT', '10785', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (12, 'Plutao Gastronomia e Mania', 'Mario Bernardo', 'Gerente Comercio Internacional', 'R. Rodrigues Sete, 80', 'Manaus', 'AM', '60439', 'Brasil', '011-222321123', '011-222321123', 'Plutzer (na World Wide Web)#http://www.netmake.com.br');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (13, 'Niteroi Atacado do Alimentos', 'Severino Pereira', 'Coordenador Comercio Exterior', 'R. REDENTOR, 45', 'Boa Vista', 'RR', '27478', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (14, 'Fazenda dos Alimentos', 'Eduardo Rezende', 'Representante Vendas', 'R. Raimundo Freixeira, 163', 'Goiana', 'GO', '48100', 'Brasil', '011-222321123', '011-222321123', '#FORMAGGI.HTM#');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (15, 'Nordesto Alimentos Ltda', 'Bernardo Vilaca', 'Gerente Comercializacao', 'R. Prof. Alvaro Lima, 50', 'Rio Branco', 'AC', '1320', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (16, 'Boa Cerveja Ltda', 'Carlos Severino', 'Rep. Contabilidade Regional', 'R. Pedro Allain, 125 Casa.34', 'Terezina', 'PI', '97101', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (17, 'Savoi Tradicao em Comercio', 'Marcone Bezerra', 'Representante Vendas', 'R. Paula Batista, 165', 'Rio de Janeiro', 'RJ', 'S-123 45', 'Brasil', '021-222721123', '021-289321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (18, 'Austria Sabores Ltda', 'Gracinha Pedrosa', 'Gerente de Vendas', 'R. Padre Lemos, 644/sala 01', 'Curitiba', 'PR', '75004', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (19, 'Natal Frutos do Mar Ltda', 'Roberto Mesquita', 'Agente Contas Atacado', 'R. Oscar Pinto, 142', 'Rio Branco', 'AC', '02134', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (20, 'Leia Comercio', 'Cassandra Mercedes', 'Proprietario', 'R. Olimpio Tauares , 97', 'Terezina', 'PI', '0512', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (21, 'Lamartine Rei da Alimentao', 'Niedson Pereira', 'Gerente de Vendas', 'R. Nova Friburgo, 594', 'Aracaju', 'SE', '2800', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (22, 'Zoraide Atacadao Ltda', 'Dirceu Lamartine', 'Gerente Contabilidade', 'R. Nova Descoberta,84', 'So Luis', 'MA', '9999 ZZ', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (23, 'Karla  Alimentos Congelados', 'Ana Clara da Silva', 'Gerente de Produtos', 'R. Motta Junior, 31', 'Goiana', 'GO', '53120', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (24, 'Grande Parceiro', 'Wilson Borba Pires', 'Representante Vendas', 'R. manoel apolinario, 102', 'Salvador', 'BH', '2042', 'Brasil', '011-222321123', '011-222321123', 'G\'day Mate (on the World Wide Web)#http://www.microsoft.com/accessdev/sampleapps/gdaymate.htm#');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (25, 'Minha Casa', 'Jose Gusmao', 'Gerente Comercializacao', 'R. mandacaru, 512, casa, 02', 'Florianopolis', 'SC', 'H1J 1C3', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (26, 'Pasta Brasilia', 'Garcia Alcoforado', 'Administrador', 'R. Major Nereu  Guerra, 131', 'Belo Horizonte', 'MG', '84100', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (27, 'Crustaceos Saborosos', 'Maria do Carmo', 'Gerente de Vendas', 'R. Major Afonso Leal, 81/02', 'Florianopolis', 'SC', '71300', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (28, 'Gaivota Comidas', 'Eliana Nabuco', 'Representante Vendas', 'R. Luiz Cezario de Melo, 237', 'Goiana', 'GO', '74000', 'Brasil', '011-222321123', '011-222321123', '');
INSERT INTO `adm_fornecedores` (`FornecedorID`, `NomeFornecedor`, `NomeContato`, `CargoContato`, `Endereco`, `Cidade`, `Estado`, `CaixaPostal`, `Pais`, `Fone`, `Fax`, `HomePage`) VALUES (29, 'Forts d\'rables', 'Charles Guimaraes', 'Gerente Contabilidade', 'R. Largo Casa Amarela, 136', 'Rio de Janeiro', 'RJ', 'J2S 7S8', 'Brasil', '021-222721123', '021-289321123', '');

DROP TABLE IF EXISTS `adm_pedido_itens`;
CREATE TABLE `adm_pedido_itens` (`PedidoID` int(11) NOT NULL default '0', `ProdutoID` int(11) NOT NULL default '0', `PrecoUnit` decimal(16,4) NOT NULL default '0.0000', `Quantidade` smallint(6) NOT NULL default '0', `Desconto` decimal(16,2) NOT NULL default '0.00', `Total` decimal(16,2) NOT NULL default '0.00', PRIMARY KEY  (`PedidoID`,`ProdutoID`), KEY `PedidoID` (`PedidoID`), KEY `ProdutoID` (`ProdutoID`)) TYPE=MyISAM;

INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10248, 11, '14.0000', 12, '0.00', '168.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10248, 42, '9.8000', 10, '0.00', '98.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10248, 72, '34.8000', 5, '0.00', '174.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10249, 14, '18.6000', 9, '0.00', '167.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10249, 51, '42.4000', 40, '0.00', '1696.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10250, 41, '7.7000', 10, '0.00', '77.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10250, 51, '42.4000', 35, '0.15', '1483.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10250, 65, '16.8000', 15, '0.15', '251.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10251, 22, '16.8000', 6, '0.05', '100.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10251, 57, '15.6000', 15, '0.05', '233.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10251, 65, '16.8000', 20, '0.00', '336.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10252, 20, '64.8000', 40, '0.05', '2591.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10252, 33, '2.0000', 25, '0.05', '49.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10252, 60, '27.2000', 40, '0.00', '1088.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10253, 31, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10253, 39, '14.4000', 42, '0.00', '604.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10253, 49, '16.0000', 40, '0.00', '640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10254, 24, '3.6000', 15, '0.15', '53.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10254, 55, '19.2000', 21, '0.15', '403.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10254, 74, '8.0000', 21, '0.00', '168.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10255, 2, '15.2000', 20, '0.00', '304.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10255, 16, '13.9000', 35, '0.00', '486.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10255, 36, '15.2000', 25, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10255, 59, '44.0000', 30, '0.00', '1320.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10256, 53, '26.2000', 15, '0.00', '393.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10256, 77, '10.4000', 12, '0.00', '124.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10257, 27, '35.1000', 25, '0.00', '877.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10257, 39, '14.4000', 6, '0.00', '86.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10257, 77, '10.4000', 15, '0.00', '156.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10258, 2, '15.2000', 50, '0.20', '759.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10258, 5, '17.0000', 65, '0.20', '1104.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10258, 32, '25.6000', 6, '0.20', '153.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10259, 21, '8.0000', 10, '0.00', '80.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10259, 37, '20.8000', 1, '0.00', '20.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10260, 41, '7.7000', 16, '0.25', '122.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10260, 57, '15.6000', 50, '0.00', '780.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10260, 62, '39.4000', 15, '0.25', '590.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10260, 70, '12.0000', 21, '0.25', '251.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10261, 21, '8.0000', 20, '0.00', '160.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10261, 35, '14.4000', 20, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10262, 5, '17.0000', 12, '0.20', '203.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10262, 7, '24.0000', 15, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10262, 56, '30.4000', 2, '0.00', '60.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10263, 16, '13.9000', 60, '0.25', '833.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10263, 24, '3.6000', 28, '0.00', '100.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10263, 30, '20.7000', 60, '0.25', '1241.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10263, 74, '8.0000', 36, '0.25', '287.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10264, 2, '15.2000', 35, '0.00', '532.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10264, 41, '7.7000', 25, '0.15', '192.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10265, 17, '31.2000', 30, '0.00', '936.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10265, 70, '12.0000', 20, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10266, 12, '30.4000', 12, '0.05', '364.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10267, 40, '14.7000', 50, '0.00', '735.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10267, 59, '44.0000', 70, '0.15', '3079.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10267, 76, '14.4000', 15, '0.15', '215.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10268, 29, '99.0000', 10, '0.00', '990.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10268, 72, '27.8000', 4, '0.00', '111.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10269, 33, '2.0000', 60, '0.05', '119.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10269, 72, '27.8000', 20, '0.05', '555.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10270, 36, '15.2000', 30, '0.00', '456.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10270, 43, '36.8000', 25, '0.00', '920.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10271, 33, '2.0000', 24, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10272, 20, '64.8000', 6, '0.00', '388.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10272, 31, '10.0000', 40, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10272, 72, '27.8000', 24, '0.00', '667.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10273, 10, '24.8000', 24, '0.05', '595.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10273, 31, '10.0000', 15, '0.05', '149.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10273, 33, '2.0000', 20, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10273, 40, '14.7000', 60, '0.05', '881.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10273, 76, '14.4000', 33, '0.05', '475.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10274, 71, '17.2000', 20, '0.00', '344.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10274, 72, '27.8000', 7, '0.00', '194.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10275, 24, '3.6000', 12, '0.05', '43.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10275, 59, '44.0000', 6, '0.05', '263.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10276, 10, '24.8000', 15, '0.00', '372.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10276, 13, '4.8000', 10, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10277, 28, '36.4000', 20, '0.00', '728.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10277, 62, '39.4000', 12, '0.00', '472.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10278, 44, '15.5000', 16, '0.00', '248.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10278, 59, '44.0000', 15, '0.00', '660.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10278, 63, '35.1000', 8, '0.00', '280.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10278, 73, '12.0000', 25, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10279, 17, '31.2000', 15, '0.25', '467.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10280, 24, '3.6000', 12, '0.00', '43.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10280, 55, '19.2000', 20, '0.00', '384.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10280, 75, '6.2000', 30, '0.00', '186.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10281, 19, '7.3000', 1, '0.00', '7.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10281, 24, '3.6000', 6, '0.00', '21.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10281, 35, '14.4000', 4, '0.00', '57.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10282, 30, '20.7000', 6, '0.00', '124.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10282, 57, '15.6000', 2, '0.00', '31.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10283, 15, '12.4000', 20, '0.00', '248.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10283, 19, '7.3000', 18, '0.00', '131.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10283, 60, '27.2000', 35, '0.00', '952.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10283, 72, '27.8000', 3, '0.00', '83.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10284, 27, '35.1000', 15, '0.25', '526.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10284, 44, '15.5000', 21, '0.00', '325.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10284, 60, '27.2000', 20, '0.25', '543.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10284, 67, '11.2000', 5, '0.25', '55.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10285, 1, '14.4000', 45, '0.20', '647.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10285, 40, '14.7000', 40, '0.20', '587.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10285, 53, '26.2000', 36, '0.20', '943.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10286, 35, '14.4000', 100, '0.00', '1440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10286, 62, '39.4000', 40, '0.00', '1576.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10287, 16, '13.9000', 40, '0.15', '555.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10287, 34, '11.2000', 20, '0.00', '224.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10287, 46, '9.6000', 15, '0.15', '143.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10288, 54, '5.9000', 10, '0.10', '58.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10288, 68, '10.0000', 3, '0.10', '29.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10289, 3, '8.0000', 30, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10289, 64, '26.6000', 9, '0.00', '239.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10290, 5, '17.0000', 20, '0.00', '340.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10290, 29, '99.0000', 15, '0.00', '1485.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10290, 49, '16.0000', 15, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10290, 77, '10.4000', 10, '0.00', '104.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10291, 13, '4.8000', 20, '0.10', '95.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10291, 44, '15.5000', 24, '0.10', '371.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10291, 51, '42.4000', 2, '0.10', '84.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10292, 20, '64.8000', 20, '0.00', '1296.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10293, 18, '50.0000', 12, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10293, 24, '3.6000', 10, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10293, 63, '35.1000', 5, '0.00', '175.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10293, 75, '6.2000', 6, '0.00', '37.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10294, 1, '14.4000', 18, '0.00', '259.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10294, 17, '31.2000', 15, '0.00', '468.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10294, 43, '36.8000', 15, '0.00', '552.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10294, 60, '27.2000', 21, '0.00', '571.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10294, 75, '6.2000', 6, '0.00', '37.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10295, 56, '30.4000', 4, '0.00', '121.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10296, 11, '16.8000', 12, '0.00', '201.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10296, 16, '13.9000', 30, '0.00', '417.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10296, 69, '28.8000', 15, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10297, 39, '14.4000', 60, '0.00', '864.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10297, 72, '27.8000', 20, '0.00', '556.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10298, 2, '15.2000', 40, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10298, 36, '15.2000', 40, '0.25', '607.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10298, 59, '44.0000', 30, '0.25', '1319.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10298, 62, '39.4000', 15, '0.00', '591.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10299, 19, '7.3000', 15, '0.00', '109.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10299, 70, '12.0000', 20, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10300, 66, '13.6000', 30, '0.00', '408.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10300, 68, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10301, 40, '14.7000', 10, '0.00', '147.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10301, 56, '30.4000', 20, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10302, 17, '31.2000', 40, '0.00', '1248.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10302, 28, '36.4000', 28, '0.00', '1019.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10302, 43, '36.8000', 12, '0.00', '441.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10303, 40, '14.7000', 40, '0.10', '587.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10303, 65, '16.8000', 30, '0.10', '503.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10303, 68, '10.0000', 15, '0.10', '149.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10304, 49, '16.0000', 30, '0.00', '480.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10304, 59, '44.0000', 10, '0.00', '440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10304, 71, '17.2000', 2, '0.00', '34.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10305, 18, '50.0000', 25, '0.10', '1249.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10305, 29, '99.0000', 25, '0.10', '2474.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10305, 39, '14.4000', 30, '0.10', '431.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10306, 30, '20.7000', 10, '0.00', '207.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10306, 53, '26.2000', 10, '0.00', '262.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10306, 54, '5.9000', 5, '0.00', '29.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10307, 62, '39.4000', 10, '0.00', '394.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10307, 68, '10.0000', 3, '0.00', '30.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10308, 69, '28.8000', 1, '0.00', '28.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10308, 70, '12.0000', 5, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10309, 4, '17.6000', 20, '0.00', '352.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10309, 6, '20.0000', 30, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10309, 42, '11.2000', 2, '0.00', '22.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10309, 43, '36.8000', 20, '0.00', '736.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10309, 71, '17.2000', 3, '0.00', '51.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10310, 16, '13.9000', 10, '0.00', '139.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10310, 62, '39.4000', 5, '0.00', '197.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10311, 42, '11.2000', 6, '0.00', '67.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10311, 69, '28.8000', 7, '0.00', '201.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10312, 28, '36.4000', 4, '0.00', '145.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10312, 43, '36.8000', 24, '0.00', '883.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10312, 53, '26.2000', 20, '0.00', '524.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10312, 75, '6.2000', 10, '0.00', '62.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10313, 36, '15.2000', 12, '0.00', '182.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10314, 32, '25.6000', 40, '0.10', '1023.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10314, 58, '10.6000', 30, '0.10', '317.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10314, 62, '39.4000', 25, '0.10', '984.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10315, 34, '11.2000', 14, '0.00', '156.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10315, 70, '12.0000', 30, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10316, 41, '7.7000', 10, '0.00', '77.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10316, 62, '39.4000', 70, '0.00', '2758.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10317, 1, '14.4000', 20, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10318, 41, '7.7000', 20, '0.00', '154.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10318, 76, '14.4000', 6, '0.00', '86.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10319, 17, '31.2000', 8, '0.00', '249.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10319, 28, '36.4000', 14, '0.00', '509.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10319, 76, '14.4000', 30, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10320, 71, '17.2000', 30, '0.00', '516.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10321, 35, '14.4000', 10, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10322, 52, '5.6000', 20, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10323, 15, '12.4000', 5, '0.00', '62.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10323, 25, '11.2000', 4, '0.00', '44.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10323, 39, '14.4000', 4, '0.00', '57.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10324, 16, '13.9000', 21, '0.15', '291.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10324, 35, '14.4000', 70, '0.15', '1007.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10324, 46, '9.6000', 30, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10324, 59, '44.0000', 40, '0.15', '1759.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10324, 63, '35.1000', 80, '0.15', '2807.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10325, 6, '20.0000', 6, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10325, 13, '4.8000', 12, '0.00', '57.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10325, 14, '18.6000', 9, '0.00', '167.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10325, 31, '10.0000', 4, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10325, 72, '27.8000', 40, '0.00', '1112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10326, 4, '17.6000', 24, '0.00', '422.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10326, 57, '15.6000', 16, '0.00', '249.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10326, 75, '6.2000', 50, '0.00', '310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10327, 2, '15.2000', 25, '0.20', '379.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10327, 11, '16.8000', 50, '0.20', '839.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10327, 30, '20.7000', 35, '0.20', '724.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10327, 58, '10.6000', 30, '0.20', '317.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10328, 59, '44.0000', 9, '0.00', '396.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10328, 65, '16.8000', 40, '0.00', '672.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10328, 68, '10.0000', 10, '0.00', '100.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10329, 19, '7.3000', 10, '0.05', '72.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10329, 30, '20.7000', 8, '0.05', '165.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10329, 38, '210.8000', 20, '0.05', '4215.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10329, 56, '30.4000', 12, '0.05', '364.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10330, 26, '24.9000', 50, '0.15', '1244.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10330, 72, '27.8000', 25, '0.15', '694.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10331, 54, '5.9000', 15, '0.00', '88.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10332, 18, '50.0000', 40, '0.20', '1999.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10332, 42, '11.2000', 10, '0.20', '111.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10332, 47, '7.6000', 16, '0.20', '121.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10333, 14, '18.6000', 10, '0.00', '186.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10333, 21, '8.0000', 10, '0.10', '79.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10333, 71, '17.2000', 40, '0.10', '687.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10334, 52, '5.6000', 8, '0.00', '44.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10334, 68, '10.0000', 10, '0.00', '100.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10335, 2, '15.2000', 7, '0.20', '106.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10335, 31, '10.0000', 25, '0.20', '249.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10335, 32, '25.6000', 6, '0.20', '153.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10335, 51, '42.4000', 48, '0.20', '2035.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10336, 4, '17.6000', 18, '0.10', '316.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10337, 23, '7.2000', 40, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10337, 26, '24.9000', 24, '0.00', '597.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10337, 36, '15.2000', 20, '0.00', '304.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10337, 37, '20.8000', 28, '0.00', '582.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10337, 72, '27.8000', 25, '0.00', '695.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10338, 17, '31.2000', 20, '0.00', '624.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10338, 30, '20.7000', 15, '0.00', '310.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10339, 4, '17.6000', 10, '0.00', '176.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10339, 17, '31.2000', 70, '0.05', '2183.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10339, 62, '39.4000', 28, '0.00', '1103.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10340, 18, '50.0000', 20, '0.05', '999.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10340, 41, '7.7000', 12, '0.05', '92.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10340, 43, '36.8000', 40, '0.05', '1471.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10341, 33, '2.0000', 8, '0.00', '16.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10341, 59, '44.0000', 9, '0.15', '395.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10342, 2, '15.2000', 24, '0.20', '364.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10342, 31, '10.0000', 56, '0.20', '559.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10342, 36, '15.2000', 40, '0.20', '607.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10342, 55, '19.2000', 40, '0.20', '767.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10343, 64, '26.6000', 50, '0.00', '1330.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10343, 68, '10.0000', 4, '0.05', '39.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10343, 76, '14.4000', 15, '0.00', '216.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10344, 4, '17.6000', 35, '0.00', '616.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10344, 8, '32.0000', 70, '0.25', '2239.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10345, 8, '32.0000', 70, '0.00', '2240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10345, 19, '7.3000', 80, '0.00', '584.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10345, 42, '11.2000', 9, '0.00', '100.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10346, 17, '31.2000', 36, '0.10', '1123.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10346, 56, '30.4000', 20, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10347, 25, '11.2000', 10, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10347, 39, '14.4000', 50, '0.15', '719.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10347, 40, '14.7000', 4, '0.00', '58.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10347, 75, '6.2000', 6, '0.15', '37.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10348, 1, '14.4000', 15, '0.15', '215.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10348, 23, '7.2000', 25, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10349, 54, '5.9000', 24, '0.00', '141.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10350, 50, '13.0000', 15, '0.10', '194.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10350, 69, '28.8000', 18, '0.10', '518.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10351, 38, '210.8000', 20, '0.05', '4215.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10351, 41, '7.7000', 13, '0.00', '100.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10351, 44, '15.5000', 77, '0.05', '1193.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10351, 65, '16.8000', 10, '0.05', '167.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10352, 24, '3.6000', 10, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10352, 54, '5.9000', 20, '0.15', '117.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10353, 11, '16.8000', 12, '0.20', '201.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10353, 38, '210.8000', 50, '0.20', '10539.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10354, 1, '14.4000', 12, '0.00', '172.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10354, 29, '99.0000', 4, '0.00', '396.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10355, 24, '3.6000', 25, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10355, 57, '15.6000', 25, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10356, 31, '10.0000', 30, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10356, 55, '19.2000', 12, '0.00', '230.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10356, 69, '28.8000', 20, '0.00', '576.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10357, 10, '24.8000', 30, '0.20', '743.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10357, 26, '24.9000', 16, '0.00', '398.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10357, 60, '27.2000', 8, '0.20', '217.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10358, 24, '3.6000', 10, '0.05', '35.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10358, 34, '11.2000', 10, '0.05', '111.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10358, 36, '15.2000', 20, '0.05', '303.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10359, 16, '13.9000', 56, '0.05', '778.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10359, 31, '10.0000', 70, '0.05', '699.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10359, 60, '27.2000', 80, '0.05', '2175.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10360, 28, '36.4000', 30, '0.00', '1092.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10360, 29, '99.0000', 35, '0.00', '3465.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10360, 38, '210.8000', 10, '0.00', '2108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10360, 49, '16.0000', 35, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10360, 54, '5.9000', 28, '0.00', '165.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10361, 39, '14.4000', 54, '0.10', '777.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10361, 60, '27.2000', 55, '0.10', '1495.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10362, 25, '11.2000', 50, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10362, 51, '42.4000', 20, '0.00', '848.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10362, 54, '5.9000', 24, '0.00', '141.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10363, 31, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10363, 75, '6.2000', 12, '0.00', '74.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10363, 76, '14.4000', 12, '0.00', '172.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10364, 69, '28.8000', 30, '0.00', '864.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10364, 71, '17.2000', 5, '0.00', '86.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10365, 11, '16.8000', 24, '0.00', '403.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10366, 65, '16.8000', 5, '0.00', '84.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10366, 77, '10.4000', 5, '0.00', '52.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10367, 34, '11.2000', 36, '0.00', '403.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10367, 54, '5.9000', 18, '0.00', '106.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10367, 65, '16.8000', 15, '0.00', '252.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10367, 77, '10.4000', 7, '0.00', '72.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10368, 21, '8.0000', 5, '0.10', '39.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10368, 28, '36.4000', 13, '0.10', '473.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10368, 57, '15.6000', 25, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10368, 64, '26.6000', 35, '0.10', '930.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10369, 29, '99.0000', 20, '0.00', '1980.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10369, 56, '30.4000', 18, '0.25', '546.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10370, 1, '14.4000', 15, '0.15', '215.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10370, 64, '26.6000', 30, '0.00', '798.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10370, 74, '8.0000', 20, '0.15', '159.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10371, 36, '15.2000', 6, '0.20', '91.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10372, 20, '64.8000', 12, '0.25', '777.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10372, 38, '210.8000', 40, '0.25', '8431.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10372, 60, '27.2000', 70, '0.25', '1903.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10372, 72, '27.8000', 42, '0.25', '1167.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10373, 58, '10.6000', 80, '0.20', '847.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10373, 71, '17.2000', 50, '0.20', '859.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10374, 31, '10.0000', 30, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10374, 58, '10.6000', 15, '0.00', '159.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10375, 14, '18.6000', 15, '0.00', '279.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10375, 54, '5.9000', 10, '0.00', '59.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10376, 31, '10.0000', 42, '0.05', '419.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10377, 28, '36.4000', 20, '0.15', '727.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10377, 39, '14.4000', 20, '0.15', '287.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10378, 71, '17.2000', 6, '0.00', '103.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10379, 41, '7.7000', 8, '0.10', '61.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10379, 63, '35.1000', 16, '0.10', '561.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10379, 65, '16.8000', 20, '0.10', '335.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10380, 30, '20.7000', 18, '0.10', '372.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10380, 53, '26.2000', 20, '0.10', '523.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10380, 60, '27.2000', 6, '0.10', '163.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10380, 70, '12.0000', 30, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10381, 74, '8.0000', 14, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10382, 5, '17.0000', 32, '0.00', '544.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10382, 18, '50.0000', 9, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10382, 29, '99.0000', 14, '0.00', '1386.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10382, 33, '2.0000', 60, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10382, 74, '8.0000', 50, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10383, 13, '4.8000', 20, '0.00', '96.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10383, 50, '13.0000', 15, '0.00', '195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10383, 56, '30.4000', 20, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10384, 20, '64.8000', 28, '0.00', '1814.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10384, 60, '27.2000', 15, '0.00', '408.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10385, 7, '24.0000', 10, '0.20', '239.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10385, 60, '27.2000', 20, '0.20', '543.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10385, 68, '10.0000', 8, '0.20', '79.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10386, 24, '3.6000', 15, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10386, 34, '11.2000', 10, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10387, 24, '3.6000', 15, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10387, 28, '36.4000', 6, '0.00', '218.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10387, 59, '44.0000', 12, '0.00', '528.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10387, 71, '17.2000', 15, '0.00', '258.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10388, 45, '7.6000', 15, '0.20', '113.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10388, 52, '5.6000', 20, '0.20', '111.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10388, 53, '26.2000', 40, '0.00', '1048.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10389, 10, '24.8000', 16, '0.00', '396.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10389, 55, '19.2000', 15, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10389, 62, '39.4000', 20, '0.00', '788.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10389, 70, '12.0000', 30, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10390, 31, '10.0000', 60, '0.10', '599.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10390, 35, '14.4000', 40, '0.10', '575.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10390, 46, '9.6000', 45, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10390, 72, '27.8000', 24, '0.10', '667.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10391, 13, '4.8000', 18, '0.00', '86.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10392, 69, '28.8000', 50, '0.00', '1440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10393, 2, '15.2000', 25, '0.25', '379.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10393, 14, '18.6000', 42, '0.25', '780.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10393, 25, '11.2000', 7, '0.25', '78.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10393, 26, '24.9000', 70, '0.25', '1742.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10393, 31, '10.0000', 32, '0.00', '320.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10394, 13, '4.8000', 10, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10394, 62, '39.4000', 10, '0.00', '394.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10395, 46, '9.6000', 28, '0.10', '268.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10395, 53, '26.2000', 70, '0.10', '1833.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10395, 69, '28.8000', 8, '0.00', '230.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10396, 23, '7.2000', 40, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10396, 71, '17.2000', 60, '0.00', '1032.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10396, 72, '27.8000', 21, '0.00', '583.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10397, 21, '8.0000', 10, '0.15', '79.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10397, 51, '42.4000', 18, '0.15', '763.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10398, 35, '14.4000', 30, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10398, 55, '19.2000', 120, '0.10', '2303.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10399, 68, '10.0000', 60, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10399, 71, '17.2000', 30, '0.00', '516.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10399, 76, '14.4000', 35, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10399, 77, '10.4000', 14, '0.00', '145.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10400, 29, '99.0000', 21, '0.00', '2079.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10400, 35, '14.4000', 35, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10400, 49, '16.0000', 30, '0.00', '480.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10401, 30, '20.7000', 18, '0.00', '372.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10401, 56, '30.4000', 70, '0.00', '2128.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10401, 65, '16.8000', 20, '0.00', '336.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10401, 71, '17.2000', 60, '0.00', '1032.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10402, 23, '7.2000', 60, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10402, 63, '35.1000', 65, '0.00', '2281.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10403, 16, '13.9000', 21, '0.15', '291.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10403, 48, '10.2000', 70, '0.15', '713.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10404, 26, '24.9000', 30, '0.05', '746.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10404, 42, '11.2000', 40, '0.05', '447.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10404, 49, '16.0000', 30, '0.05', '479.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10405, 3, '8.0000', 50, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10406, 1, '14.4000', 10, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10406, 21, '8.0000', 30, '0.10', '239.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10406, 28, '36.4000', 42, '0.10', '1528.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10406, 36, '15.2000', 5, '0.10', '75.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10406, 40, '14.7000', 2, '0.10', '29.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10407, 11, '16.8000', 30, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10407, 69, '28.8000', 15, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10407, 71, '17.2000', 15, '0.00', '258.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10408, 37, '20.8000', 10, '0.00', '208.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10408, 54, '5.9000', 6, '0.00', '35.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10408, 62, '39.4000', 35, '0.00', '1379.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10409, 14, '18.6000', 12, '0.00', '223.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10409, 21, '8.0000', 12, '0.00', '96.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10410, 33, '2.0000', 49, '0.00', '98.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10410, 59, '44.0000', 16, '0.00', '704.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10411, 41, '7.7000', 25, '0.20', '192.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10411, 44, '15.5000', 40, '0.20', '619.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10411, 59, '44.0000', 9, '0.20', '395.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10412, 14, '18.6000', 20, '0.10', '371.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10413, 1, '14.4000', 24, '0.00', '345.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10413, 62, '39.4000', 40, '0.00', '1576.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10413, 76, '14.4000', 14, '0.00', '201.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10414, 19, '7.3000', 18, '0.05', '131.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10414, 33, '2.0000', 50, '0.00', '100.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10415, 17, '31.2000', 2, '0.00', '62.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10415, 33, '2.0000', 20, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10416, 19, '7.3000', 20, '0.00', '146.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10416, 53, '26.2000', 10, '0.00', '262.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10416, 57, '15.6000', 20, '0.00', '312.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10417, 38, '210.8000', 50, '0.00', '10540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10417, 46, '9.6000', 2, '0.25', '18.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10417, 68, '10.0000', 36, '0.25', '359.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10417, 77, '10.4000', 35, '0.00', '364.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10418, 2, '15.2000', 60, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10418, 47, '7.6000', 55, '0.00', '418.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10418, 61, '22.8000', 16, '0.00', '364.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10418, 74, '8.0000', 15, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10419, 60, '27.2000', 60, '0.05', '1631.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10419, 69, '28.8000', 20, '0.05', '575.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10420, 9, '77.6000', 20, '0.10', '1551.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10420, 13, '4.8000', 2, '0.10', '9.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10420, 70, '12.0000', 8, '0.10', '95.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10420, 73, '12.0000', 20, '0.10', '239.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10421, 19, '7.3000', 4, '0.15', '29.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10421, 26, '24.9000', 30, '0.00', '747.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10421, 53, '26.2000', 15, '0.15', '392.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10421, 77, '10.4000', 10, '0.15', '103.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10422, 26, '24.9000', 2, '0.00', '49.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10423, 31, '10.0000', 14, '0.00', '140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10423, 59, '44.0000', 20, '0.00', '880.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10424, 35, '14.4000', 60, '0.20', '863.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10424, 38, '210.8000', 49, '0.20', '10329.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10424, 68, '10.0000', 30, '0.20', '299.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10425, 55, '19.2000', 10, '0.25', '191.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10425, 76, '14.4000', 20, '0.25', '287.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10426, 56, '30.4000', 5, '0.00', '152.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10426, 64, '26.6000', 7, '0.00', '186.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10427, 14, '18.6000', 35, '0.00', '651.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10428, 46, '9.6000', 20, '0.00', '192.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10429, 50, '13.0000', 40, '0.00', '520.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10429, 63, '35.1000', 35, '0.25', '1228.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10430, 17, '31.2000', 45, '0.20', '1403.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10430, 21, '8.0000', 50, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10430, 56, '30.4000', 30, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10430, 59, '44.0000', 70, '0.20', '3079.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10431, 17, '31.2000', 50, '0.25', '1559.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10431, 40, '14.7000', 50, '0.25', '734.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10431, 47, '7.6000', 30, '0.25', '227.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10432, 26, '24.9000', 10, '0.00', '249.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10432, 54, '5.9000', 40, '0.00', '236.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10433, 56, '30.4000', 28, '0.00', '851.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10434, 11, '16.8000', 6, '0.00', '100.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10434, 76, '14.4000', 18, '0.15', '259.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10435, 2, '15.2000', 10, '0.00', '152.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10435, 22, '16.8000', 12, '0.00', '201.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10435, 72, '27.8000', 10, '0.00', '278.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10436, 46, '9.6000', 5, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10436, 56, '30.4000', 40, '0.10', '1215.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10436, 64, '26.6000', 30, '0.10', '797.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10436, 75, '6.2000', 24, '0.10', '148.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10437, 53, '26.2000', 15, '0.00', '393.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10438, 19, '7.3000', 15, '0.20', '109.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10438, 34, '11.2000', 20, '0.20', '223.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10438, 57, '15.6000', 15, '0.20', '233.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10439, 12, '30.4000', 15, '0.00', '456.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10439, 16, '13.9000', 16, '0.00', '222.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10439, 64, '26.6000', 6, '0.00', '159.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10439, 74, '8.0000', 30, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10440, 2, '15.2000', 45, '0.15', '683.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10440, 16, '13.9000', 49, '0.15', '680.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10440, 29, '99.0000', 24, '0.15', '2375.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10440, 61, '22.8000', 90, '0.15', '2051.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10441, 27, '35.1000', 50, '0.00', '1755.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10442, 11, '16.8000', 30, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10442, 54, '5.9000', 80, '0.00', '472.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10442, 66, '13.6000', 60, '0.00', '816.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10443, 11, '16.8000', 6, '0.20', '100.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10443, 28, '36.4000', 12, '0.00', '436.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10444, 17, '31.2000', 10, '0.00', '312.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10444, 26, '24.9000', 15, '0.00', '373.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10444, 35, '14.4000', 8, '0.00', '115.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10444, 41, '7.7000', 30, '0.00', '231.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10445, 39, '14.4000', 6, '0.00', '86.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10445, 54, '5.9000', 15, '0.00', '88.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10446, 19, '7.3000', 12, '0.10', '87.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10446, 24, '3.6000', 20, '0.10', '71.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10446, 31, '10.0000', 3, '0.10', '29.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10446, 52, '5.6000', 15, '0.10', '83.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10447, 19, '7.3000', 40, '0.00', '292.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10447, 65, '16.8000', 35, '0.00', '588.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10447, 71, '17.2000', 2, '0.00', '34.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10448, 26, '24.9000', 6, '0.00', '149.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10448, 40, '14.7000', 20, '0.00', '294.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10449, 10, '24.8000', 14, '0.00', '347.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10449, 52, '5.6000', 20, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10449, 62, '39.4000', 35, '0.00', '1379.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10450, 10, '24.8000', 20, '0.20', '495.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10450, 54, '5.9000', 6, '0.20', '35.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10451, 55, '19.2000', 120, '0.10', '2303.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10451, 64, '26.6000', 35, '0.10', '930.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10451, 65, '16.8000', 28, '0.10', '470.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10451, 77, '10.4000', 55, '0.10', '571.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10452, 28, '36.4000', 15, '0.00', '546.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10452, 44, '15.5000', 100, '0.05', '1549.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10453, 48, '10.2000', 15, '0.10', '152.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10453, 70, '12.0000', 25, '0.10', '299.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10454, 16, '13.9000', 20, '0.20', '277.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10454, 33, '2.0000', 20, '0.20', '39.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10454, 46, '9.6000', 10, '0.20', '95.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10455, 39, '14.4000', 20, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10455, 53, '26.2000', 50, '0.00', '1310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10455, 61, '22.8000', 25, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10455, 71, '17.2000', 30, '0.00', '516.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10456, 21, '8.0000', 40, '0.15', '319.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10456, 49, '16.0000', 21, '0.15', '335.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10457, 59, '44.0000', 36, '0.00', '1584.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10458, 26, '24.9000', 30, '0.00', '747.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10458, 28, '36.4000', 30, '0.00', '1092.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10458, 43, '36.8000', 20, '0.00', '736.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10458, 56, '30.4000', 15, '0.00', '456.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10458, 71, '17.2000', 50, '0.00', '860.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10459, 7, '24.0000', 16, '0.05', '383.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10459, 46, '9.6000', 20, '0.05', '191.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10459, 72, '27.8000', 40, '0.00', '1112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10460, 68, '10.0000', 21, '0.25', '209.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10460, 75, '6.2000', 4, '0.25', '24.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10461, 21, '8.0000', 40, '0.25', '319.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10461, 30, '20.7000', 28, '0.25', '579.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10461, 55, '19.2000', 60, '0.25', '1151.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10462, 13, '4.8000', 1, '0.00', '4.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10462, 23, '7.2000', 21, '0.00', '151.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10463, 19, '7.3000', 21, '0.00', '153.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10463, 42, '11.2000', 50, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10464, 4, '17.6000', 16, '0.20', '281.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10464, 43, '36.8000', 3, '0.00', '110.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10464, 56, '30.4000', 30, '0.20', '911.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10464, 60, '27.2000', 20, '0.00', '544.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10465, 24, '3.6000', 25, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10465, 29, '99.0000', 18, '0.10', '1781.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10465, 40, '14.7000', 20, '0.00', '294.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10465, 45, '7.6000', 30, '0.10', '227.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10465, 50, '13.0000', 25, '0.00', '325.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10466, 11, '16.8000', 10, '0.00', '168.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10466, 46, '9.6000', 5, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10467, 24, '3.6000', 28, '0.00', '100.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10467, 25, '11.2000', 12, '0.00', '134.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10468, 30, '20.7000', 8, '0.00', '165.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10468, 43, '36.8000', 15, '0.00', '552.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10469, 2, '15.2000', 40, '0.15', '607.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10469, 16, '13.9000', 35, '0.15', '486.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10469, 44, '15.5000', 2, '0.15', '30.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10470, 18, '50.0000', 30, '0.00', '1500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10470, 23, '7.2000', 15, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10470, 64, '26.6000', 8, '0.00', '212.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10471, 7, '24.0000', 30, '0.00', '720.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10471, 56, '30.4000', 20, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10472, 24, '3.6000', 80, '0.05', '287.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10472, 51, '42.4000', 18, '0.00', '763.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10473, 33, '2.0000', 12, '0.00', '24.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10473, 71, '17.2000', 12, '0.00', '206.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10474, 14, '18.6000', 12, '0.00', '223.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10474, 28, '36.4000', 18, '0.00', '655.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10474, 40, '14.7000', 21, '0.00', '308.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10474, 75, '6.2000', 10, '0.00', '62.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10475, 31, '10.0000', 35, '0.15', '349.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10475, 66, '13.6000', 60, '0.15', '815.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10475, 76, '14.4000', 42, '0.15', '604.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10476, 55, '19.2000', 2, '0.05', '38.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10476, 70, '12.0000', 12, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10477, 1, '14.4000', 15, '0.00', '216.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10477, 21, '8.0000', 21, '0.25', '167.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10477, 39, '14.4000', 20, '0.25', '287.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10478, 10, '24.8000', 20, '0.05', '495.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10479, 38, '210.8000', 30, '0.00', '6324.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10479, 53, '26.2000', 28, '0.00', '733.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10479, 59, '44.0000', 60, '0.00', '2640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10479, 64, '26.6000', 30, '0.00', '798.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10480, 47, '7.6000', 30, '0.00', '228.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10480, 59, '44.0000', 12, '0.00', '528.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10481, 49, '16.0000', 24, '0.00', '384.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10481, 60, '27.2000', 40, '0.00', '1088.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10482, 40, '14.7000', 10, '0.00', '147.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10483, 34, '11.2000', 35, '0.05', '391.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10483, 77, '10.4000', 30, '0.05', '311.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10484, 21, '8.0000', 14, '0.00', '112.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10484, 40, '14.7000', 10, '0.00', '147.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10484, 51, '42.4000', 3, '0.00', '127.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10485, 2, '15.2000', 20, '0.10', '303.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10485, 3, '8.0000', 20, '0.10', '159.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10485, 55, '19.2000', 30, '0.10', '575.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10485, 70, '12.0000', 60, '0.10', '719.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10486, 11, '16.8000', 5, '0.00', '84.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10486, 51, '42.4000', 25, '0.00', '1060.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10486, 74, '8.0000', 16, '0.00', '128.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10487, 19, '7.3000', 5, '0.00', '36.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10487, 26, '24.9000', 30, '0.00', '747.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10487, 54, '5.9000', 24, '0.25', '141.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10488, 59, '44.0000', 30, '0.00', '1320.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10488, 73, '12.0000', 20, '0.20', '239.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10489, 11, '16.8000', 15, '0.25', '251.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10489, 16, '13.9000', 18, '0.00', '250.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10490, 59, '44.0000', 60, '0.00', '2640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10490, 68, '10.0000', 30, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10490, 75, '6.2000', 36, '0.00', '223.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10491, 44, '15.5000', 15, '0.15', '232.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10491, 77, '10.4000', 7, '0.15', '72.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10492, 25, '11.2000', 60, '0.05', '671.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10492, 42, '11.2000', 20, '0.05', '223.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10493, 65, '16.8000', 15, '0.10', '251.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10493, 66, '13.6000', 10, '0.10', '135.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10493, 69, '28.8000', 10, '0.10', '287.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10494, 56, '30.4000', 30, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10495, 23, '7.2000', 10, '0.00', '72.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10495, 41, '7.7000', 20, '0.00', '154.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10495, 77, '10.4000', 5, '0.00', '52.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10496, 31, '10.0000', 20, '0.05', '199.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10497, 56, '30.4000', 14, '0.00', '425.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10497, 72, '27.8000', 25, '0.00', '695.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10497, 77, '10.4000', 25, '0.00', '260.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10498, 24, '4.5000', 14, '0.00', '63.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10498, 40, '18.4000', 5, '0.00', '92.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10498, 42, '14.0000', 30, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10499, 28, '45.6000', 20, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10499, 49, '20.0000', 25, '0.00', '500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10500, 15, '15.5000', 12, '0.05', '185.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10500, 28, '45.6000', 8, '0.05', '364.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10501, 54, '7.4500', 20, '0.00', '149.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10502, 45, '9.5000', 21, '0.00', '199.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10502, 53, '32.8000', 6, '0.00', '196.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10502, 67, '14.0000', 30, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10503, 14, '23.2500', 70, '0.00', '1627.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10503, 65, '21.0500', 20, '0.00', '421.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10504, 2, '19.0000', 12, '0.00', '228.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10504, 21, '10.0000', 12, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10504, 53, '32.8000', 10, '0.00', '328.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10504, 61, '28.5000', 25, '0.00', '712.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10505, 62, '49.3000', 3, '0.00', '147.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10506, 25, '14.0000', 18, '0.10', '251.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10506, 70, '15.0000', 14, '0.10', '209.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10507, 43, '46.0000', 15, '0.15', '689.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10507, 48, '12.7500', 15, '0.15', '191.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10508, 13, '6.0000', 10, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10508, 39, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10509, 28, '45.6000', 3, '0.00', '136.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10510, 29, '123.7900', 36, '0.00', '4456.44');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10510, 75, '7.7500', 36, '0.10', '278.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10511, 4, '22.0000', 50, '0.15', '1099.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10511, 7, '30.0000', 50, '0.15', '1499.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10511, 8, '40.0000', 10, '0.15', '399.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10512, 24, '4.5000', 10, '0.15', '44.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10512, 46, '12.0000', 9, '0.15', '107.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10512, 47, '9.5000', 6, '0.15', '56.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10512, 60, '34.0000', 12, '0.15', '407.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10513, 21, '10.0000', 40, '0.20', '399.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10513, 32, '32.0000', 50, '0.20', '1599.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10513, 61, '28.5000', 15, '0.20', '427.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10514, 20, '81.0000', 39, '0.00', '3159.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10514, 28, '45.6000', 35, '0.00', '1596.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10514, 56, '38.0000', 70, '0.00', '2660.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10514, 65, '21.0500', 39, '0.00', '820.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10514, 75, '7.7500', 50, '0.00', '387.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10515, 9, '97.0000', 16, '0.15', '1551.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10515, 16, '17.4500', 50, '0.00', '872.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10515, 27, '43.9000', 120, '0.00', '5268.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10515, 33, '2.5000', 16, '0.15', '39.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10515, 60, '34.0000', 84, '0.15', '2855.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10516, 18, '62.5000', 25, '0.10', '1562.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10516, 41, '9.6500', 80, '0.10', '771.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10516, 42, '14.0000', 20, '0.00', '280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10517, 52, '7.0000', 6, '0.00', '42.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10517, 59, '55.0000', 4, '0.00', '220.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10517, 70, '15.0000', 6, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10518, 24, '4.5000', 5, '0.00', '22.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10518, 38, '263.5000', 15, '0.00', '3952.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10518, 44, '19.4500', 9, '0.00', '175.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10519, 10, '31.0000', 16, '0.05', '495.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10519, 56, '38.0000', 40, '0.00', '1520.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10519, 60, '34.0000', 10, '0.05', '339.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10520, 24, '4.5000', 8, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10520, 53, '32.8000', 5, '0.00', '164.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10521, 35, '18.0000', 3, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10521, 41, '9.6500', 10, '0.00', '96.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10521, 68, '12.5000', 6, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10522, 1, '18.0000', 40, '0.20', '719.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10522, 8, '40.0000', 24, '0.00', '960.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10522, 30, '25.8900', 20, '0.20', '517.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10522, 40, '18.4000', 25, '0.20', '459.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10523, 17, '39.0000', 25, '0.10', '974.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10523, 20, '81.0000', 15, '0.10', '1214.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10523, 37, '26.0000', 18, '0.10', '467.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10523, 41, '9.6500', 6, '0.10', '57.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10524, 10, '31.0000', 2, '0.00', '62.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10524, 30, '25.8900', 10, '0.00', '258.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10524, 43, '46.0000', 60, '0.00', '2760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10524, 54, '7.4500', 15, '0.00', '111.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10525, 36, '19.0000', 30, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10525, 40, '18.4000', 15, '0.10', '275.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10526, 1, '18.0000', 8, '0.15', '143.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10526, 13, '6.0000', 10, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10526, 56, '38.0000', 30, '0.15', '1139.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10527, 4, '22.0000', 50, '0.10', '1099.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10527, 36, '19.0000', 30, '0.10', '569.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10528, 11, '21.0000', 3, '0.00', '63.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10528, 33, '2.5000', 8, '0.20', '19.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10528, 72, '34.8000', 9, '0.00', '313.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10529, 55, '24.0000', 14, '0.00', '336.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10529, 68, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10529, 69, '36.0000', 10, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10530, 17, '39.0000', 40, '0.00', '1560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10530, 43, '46.0000', 25, '0.00', '1150.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10530, 61, '28.5000', 20, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10530, 76, '18.0000', 50, '0.00', '900.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10531, 59, '55.0000', 2, '0.00', '110.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10532, 30, '25.8900', 15, '0.00', '388.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10532, 66, '17.0000', 24, '0.00', '408.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10533, 4, '22.0000', 50, '0.05', '1099.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10533, 72, '34.8000', 24, '0.00', '835.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10533, 73, '15.0000', 24, '0.05', '359.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10534, 30, '25.8900', 10, '0.00', '258.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10534, 40, '18.4000', 10, '0.20', '183.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10534, 54, '7.4500', 10, '0.20', '74.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10535, 11, '21.0000', 50, '0.10', '1049.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10535, 40, '18.4000', 10, '0.10', '183.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10535, 57, '19.5000', 5, '0.10', '97.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10535, 59, '55.0000', 15, '0.10', '824.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10536, 12, '38.0000', 15, '0.25', '569.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10536, 31, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10536, 33, '2.5000', 30, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10536, 60, '34.0000', 35, '0.25', '1189.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10537, 31, '12.5000', 30, '0.00', '375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10537, 51, '53.0000', 6, '0.00', '318.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10537, 58, '13.2500', 20, '0.00', '265.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10537, 72, '34.8000', 21, '0.00', '730.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10537, 73, '15.0000', 9, '0.00', '135.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10538, 70, '15.0000', 7, '0.00', '105.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10538, 72, '34.8000', 1, '0.00', '34.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10539, 13, '6.0000', 8, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10539, 21, '10.0000', 15, '0.00', '150.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10539, 33, '2.5000', 15, '0.00', '37.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10539, 49, '20.0000', 6, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10540, 3, '10.0000', 60, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10540, 26, '31.2300', 40, '0.00', '1249.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10540, 38, '263.5000', 30, '0.00', '7905.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10540, 68, '12.5000', 35, '0.00', '437.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10541, 24, '4.5000', 35, '0.10', '157.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10541, 38, '263.5000', 4, '0.10', '1053.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10541, 65, '21.0500', 36, '0.10', '757.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10541, 71, '21.5000', 9, '0.10', '193.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10542, 11, '21.0000', 15, '0.05', '314.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10542, 54, '7.4500', 24, '0.05', '178.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10543, 12, '38.0000', 30, '0.15', '1139.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10543, 23, '9.0000', 70, '0.15', '629.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10544, 28, '45.6000', 7, '0.00', '319.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10544, 67, '14.0000', 7, '0.00', '98.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10545, 11, '21.0000', 10, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10546, 7, '30.0000', 10, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10546, 35, '18.0000', 30, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10546, 62, '49.3000', 40, '0.00', '1972.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10547, 32, '32.0000', 24, '0.15', '767.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10547, 36, '19.0000', 60, '0.00', '1140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10548, 34, '14.0000', 10, '0.25', '139.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10548, 41, '9.6500', 14, '0.00', '135.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10549, 31, '12.5000', 55, '0.15', '687.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10549, 45, '9.5000', 100, '0.15', '949.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10549, 51, '53.0000', 48, '0.15', '2543.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10550, 17, '39.0000', 8, '0.10', '311.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10550, 19, '9.2000', 10, '0.00', '92.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10550, 21, '10.0000', 6, '0.10', '59.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10550, 61, '28.5000', 10, '0.10', '284.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10551, 16, '17.4500', 40, '0.15', '697.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10551, 35, '18.0000', 20, '0.15', '359.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10551, 44, '19.4500', 40, '0.00', '778.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10552, 69, '36.0000', 18, '0.00', '648.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10552, 75, '7.7500', 30, '0.00', '232.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10553, 11, '21.0000', 15, '0.00', '315.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10553, 16, '17.4500', 14, '0.00', '244.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10553, 22, '21.0000', 24, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10553, 31, '12.5000', 30, '0.00', '375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10553, 35, '18.0000', 6, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10554, 16, '17.4500', 30, '0.05', '523.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10554, 23, '9.0000', 20, '0.05', '179.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10554, 62, '49.3000', 20, '0.05', '985.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10554, 77, '13.0000', 10, '0.05', '129.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10555, 14, '23.2500', 30, '0.20', '697.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10555, 19, '9.2000', 35, '0.20', '321.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10555, 24, '4.5000', 18, '0.20', '80.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10555, 51, '53.0000', 20, '0.20', '1059.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10555, 56, '38.0000', 40, '0.20', '1519.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10556, 72, '34.8000', 24, '0.00', '835.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10557, 64, '33.2500', 30, '0.00', '997.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10557, 75, '7.7500', 20, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10558, 47, '9.5000', 25, '0.00', '237.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10558, 51, '53.0000', 20, '0.00', '1060.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10558, 52, '7.0000', 30, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10558, 53, '32.8000', 18, '0.00', '590.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10558, 73, '15.0000', 3, '0.00', '45.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10559, 41, '9.6500', 12, '0.05', '115.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10559, 55, '24.0000', 18, '0.05', '431.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10560, 30, '25.8900', 20, '0.00', '517.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10560, 62, '49.3000', 15, '0.25', '739.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10561, 44, '19.4500', 10, '0.00', '194.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10561, 51, '53.0000', 50, '0.00', '2650.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10562, 33, '2.5000', 20, '0.10', '49.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10562, 62, '49.3000', 10, '0.10', '492.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10563, 36, '19.0000', 25, '0.00', '475.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10563, 52, '7.0000', 70, '0.00', '490.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10564, 17, '39.0000', 16, '0.05', '623.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10564, 31, '12.5000', 6, '0.05', '74.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10564, 55, '24.0000', 25, '0.05', '599.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10565, 24, '4.5000', 25, '0.10', '112.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10565, 64, '33.2500', 18, '0.10', '598.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10566, 11, '21.0000', 35, '0.15', '734.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10566, 18, '62.5000', 18, '0.15', '1124.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10566, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10567, 31, '12.5000', 60, '0.20', '749.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10567, 51, '53.0000', 3, '0.00', '159.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10567, 59, '55.0000', 40, '0.20', '2199.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10568, 10, '31.0000', 5, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10569, 31, '12.5000', 35, '0.20', '437.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10569, 76, '18.0000', 30, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10570, 11, '21.0000', 15, '0.05', '314.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10570, 56, '38.0000', 60, '0.05', '2279.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10571, 14, '23.2500', 11, '0.15', '255.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10571, 42, '14.0000', 28, '0.15', '391.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10572, 16, '17.4500', 12, '0.10', '209.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10572, 32, '32.0000', 10, '0.10', '319.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10572, 40, '18.4000', 50, '0.00', '920.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10572, 75, '7.7500', 15, '0.10', '116.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10573, 17, '39.0000', 18, '0.00', '702.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10573, 34, '14.0000', 40, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10573, 53, '32.8000', 25, '0.00', '820.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10574, 33, '2.5000', 14, '0.00', '35.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10574, 40, '18.4000', 2, '0.00', '36.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10574, 62, '49.3000', 10, '0.00', '493.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10574, 64, '33.2500', 6, '0.00', '199.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10575, 59, '55.0000', 12, '0.00', '660.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10575, 63, '43.9000', 6, '0.00', '263.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10575, 72, '34.8000', 30, '0.00', '1044.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10575, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10576, 1, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10576, 31, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10576, 44, '19.4500', 21, '0.00', '408.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10577, 39, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10577, 75, '7.7500', 20, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10577, 77, '13.0000', 18, '0.00', '234.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10578, 35, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10578, 57, '19.5000', 6, '0.00', '117.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10579, 15, '15.5000', 10, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10579, 75, '7.7500', 21, '0.00', '162.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10580, 14, '23.2500', 15, '0.05', '348.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10580, 41, '9.6500', 9, '0.05', '86.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10580, 65, '21.0500', 30, '0.05', '631.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10581, 75, '7.7500', 50, '0.20', '387.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10582, 57, '19.5000', 4, '0.00', '78.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10582, 76, '18.0000', 14, '0.00', '252.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10583, 29, '123.7900', 10, '0.00', '1237.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10583, 60, '34.0000', 24, '0.15', '815.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10583, 69, '36.0000', 10, '0.15', '359.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10584, 31, '12.5000', 50, '0.05', '624.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10585, 47, '9.5000', 15, '0.00', '142.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10586, 52, '7.0000', 4, '0.15', '27.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10587, 26, '31.2300', 6, '0.00', '187.38');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10587, 35, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10587, 77, '13.0000', 20, '0.00', '260.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10588, 18, '62.5000', 40, '0.20', '2499.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10588, 42, '14.0000', 100, '0.20', '1399.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10589, 35, '18.0000', 4, '0.00', '72.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10590, 1, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10590, 77, '13.0000', 60, '0.05', '779.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10591, 3, '10.0000', 14, '0.00', '140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10591, 7, '30.0000', 10, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10591, 54, '7.4500', 50, '0.00', '372.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10592, 15, '15.5000', 25, '0.05', '387.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10592, 26, '31.2300', 5, '0.05', '156.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10593, 20, '81.0000', 21, '0.20', '1700.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10593, 69, '36.0000', 20, '0.20', '719.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10593, 76, '18.0000', 4, '0.20', '71.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10594, 52, '7.0000', 24, '0.00', '168.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10594, 58, '13.2500', 30, '0.00', '397.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10595, 35, '18.0000', 30, '0.25', '539.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10595, 61, '28.5000', 120, '0.25', '3419.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10595, 69, '36.0000', 65, '0.25', '2339.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10596, 56, '38.0000', 5, '0.20', '189.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10596, 63, '43.9000', 24, '0.20', '1053.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10596, 75, '7.7500', 30, '0.20', '232.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10597, 24, '4.5000', 35, '0.20', '157.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10597, 57, '19.5000', 20, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10597, 65, '21.0500', 12, '0.20', '252.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10598, 27, '43.9000', 50, '0.00', '2195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10598, 71, '21.5000', 9, '0.00', '193.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10599, 62, '49.3000', 10, '0.00', '493.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10600, 54, '7.4500', 4, '0.00', '29.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10600, 73, '15.0000', 30, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10601, 13, '6.0000', 60, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10601, 59, '55.0000', 35, '0.00', '1925.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10602, 77, '13.0000', 5, '0.25', '64.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10603, 22, '21.0000', 48, '0.00', '1008.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10603, 49, '20.0000', 25, '0.05', '499.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10604, 48, '12.7500', 6, '0.10', '76.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10604, 76, '18.0000', 10, '0.10', '179.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10605, 16, '17.4500', 30, '0.05', '523.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10605, 59, '55.0000', 20, '0.05', '1099.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10605, 60, '34.0000', 70, '0.05', '2379.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10605, 71, '21.5000', 15, '0.05', '322.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10606, 4, '22.0000', 20, '0.20', '439.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10606, 55, '24.0000', 20, '0.20', '479.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10606, 62, '49.3000', 10, '0.20', '492.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10607, 7, '30.0000', 45, '0.00', '1350.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10607, 17, '39.0000', 100, '0.00', '3900.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10607, 33, '2.5000', 14, '0.00', '35.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10607, 40, '18.4000', 42, '0.00', '772.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10607, 72, '34.8000', 12, '0.00', '417.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10608, 56, '38.0000', 28, '0.00', '1064.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10609, 1, '18.0000', 3, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10609, 10, '31.0000', 10, '0.00', '310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10609, 21, '10.0000', 6, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10610, 36, '19.0000', 21, '0.25', '398.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10611, 1, '18.0000', 6, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10611, 2, '19.0000', 10, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10611, 60, '34.0000', 15, '0.00', '510.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10612, 10, '31.0000', 70, '0.00', '2170.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10612, 36, '19.0000', 55, '0.00', '1045.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10612, 49, '20.0000', 18, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10612, 60, '34.0000', 40, '0.00', '1360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10612, 76, '18.0000', 80, '0.00', '1440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10613, 13, '6.0000', 8, '0.10', '47.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10613, 75, '7.7500', 40, '0.00', '310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10614, 11, '21.0000', 14, '0.00', '294.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10614, 21, '10.0000', 8, '0.00', '80.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10614, 39, '18.0000', 5, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10615, 55, '24.0000', 5, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10616, 38, '263.5000', 15, '0.05', '3952.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10616, 56, '38.0000', 14, '0.00', '532.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10616, 70, '15.0000', 15, '0.05', '224.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10616, 71, '21.5000', 15, '0.05', '322.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10617, 59, '55.0000', 30, '0.15', '1649.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10618, 6, '25.0000', 70, '0.00', '1750.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10618, 56, '38.0000', 20, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10618, 68, '12.5000', 15, '0.00', '187.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10619, 21, '10.0000', 42, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10619, 22, '21.0000', 40, '0.00', '840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10620, 24, '4.5000', 5, '0.00', '22.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10620, 52, '7.0000', 5, '0.00', '35.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10621, 19, '9.2000', 5, '0.00', '46.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10621, 23, '9.0000', 10, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10621, 70, '15.0000', 20, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10621, 71, '21.5000', 15, '0.00', '322.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10622, 2, '19.0000', 20, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10622, 68, '12.5000', 18, '0.20', '224.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10623, 14, '23.2500', 21, '0.00', '488.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10623, 19, '9.2000', 15, '0.10', '137.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10623, 21, '10.0000', 25, '0.10', '249.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10623, 24, '4.5000', 3, '0.00', '13.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10623, 35, '18.0000', 30, '0.10', '539.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10624, 28, '45.6000', 10, '0.00', '456.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10624, 29, '123.7900', 6, '0.00', '742.74');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10624, 44, '19.4500', 10, '0.00', '194.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10625, 14, '23.2500', 3, '0.00', '69.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10625, 42, '14.0000', 5, '0.00', '70.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10625, 60, '34.0000', 10, '0.00', '340.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10626, 53, '32.8000', 12, '0.00', '393.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10626, 60, '34.0000', 20, '0.00', '680.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10626, 71, '21.5000', 20, '0.00', '430.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10627, 62, '49.3000', 15, '0.00', '739.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10627, 73, '15.0000', 35, '0.15', '524.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10628, 1, '18.0000', 25, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10629, 29, '123.7900', 20, '0.00', '2475.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10629, 64, '33.2500', 9, '0.00', '299.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10630, 55, '24.0000', 12, '0.05', '287.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10630, 76, '18.0000', 35, '0.00', '630.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10631, 75, '7.7500', 8, '0.10', '61.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10632, 2, '19.0000', 30, '0.05', '569.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10632, 33, '2.5000', 20, '0.05', '49.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10633, 12, '38.0000', 36, '0.15', '1367.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10633, 13, '6.0000', 13, '0.15', '77.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10633, 26, '31.2300', 35, '0.15', '1092.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10633, 62, '49.3000', 80, '0.15', '3943.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10634, 7, '30.0000', 35, '0.00', '1050.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10634, 18, '62.5000', 50, '0.00', '3125.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10634, 51, '53.0000', 15, '0.00', '795.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10634, 75, '7.7500', 2, '0.00', '15.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10635, 4, '22.0000', 10, '0.10', '219.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10635, 5, '21.3500', 15, '0.10', '320.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10635, 22, '21.0000', 40, '0.00', '840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10636, 4, '22.0000', 25, '0.00', '550.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10636, 58, '13.2500', 6, '0.00', '79.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10637, 11, '21.0000', 10, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10637, 50, '16.2500', 25, '0.05', '406.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10637, 56, '38.0000', 60, '0.05', '2279.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10638, 45, '9.5000', 20, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10638, 65, '21.0500', 21, '0.00', '442.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10638, 72, '34.8000', 60, '0.00', '2088.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10639, 18, '62.5000', 8, '0.00', '500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10640, 69, '36.0000', 20, '0.25', '719.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10640, 70, '15.0000', 15, '0.25', '224.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10641, 2, '19.0000', 50, '0.00', '950.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10641, 40, '18.4000', 60, '0.00', '1104.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10642, 21, '10.0000', 30, '0.20', '299.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10642, 61, '28.5000', 20, '0.20', '569.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10643, 28, '45.6000', 15, '0.25', '683.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10643, 39, '18.0000', 21, '0.25', '377.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10643, 46, '12.0000', 2, '0.25', '23.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10644, 18, '62.5000', 4, '0.10', '249.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10644, 43, '46.0000', 20, '0.00', '920.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10644, 46, '12.0000', 21, '0.10', '251.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10645, 18, '62.5000', 20, '0.00', '1250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10645, 36, '19.0000', 15, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10646, 1, '18.0000', 15, '0.25', '269.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10646, 10, '31.0000', 18, '0.25', '557.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10646, 71, '21.5000', 30, '0.25', '644.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10646, 77, '13.0000', 35, '0.25', '454.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10647, 19, '9.2000', 30, '0.00', '276.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10647, 39, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10648, 22, '21.0000', 15, '0.00', '315.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10648, 24, '4.5000', 15, '0.15', '67.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10649, 28, '45.6000', 20, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10649, 72, '34.8000', 15, '0.00', '522.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10650, 30, '25.8900', 30, '0.00', '776.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10650, 53, '32.8000', 25, '0.05', '819.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10650, 54, '7.4500', 30, '0.00', '223.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10651, 19, '9.2000', 12, '0.25', '110.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10651, 22, '21.0000', 20, '0.25', '419.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10652, 30, '25.8900', 2, '0.25', '51.53');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10652, 42, '14.0000', 20, '0.00', '280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10653, 16, '17.4500', 30, '0.10', '523.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10653, 60, '34.0000', 20, '0.10', '679.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10654, 4, '22.0000', 12, '0.10', '263.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10654, 39, '18.0000', 20, '0.10', '359.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10654, 54, '7.4500', 6, '0.10', '44.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10655, 41, '9.6500', 20, '0.20', '192.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10656, 14, '23.2500', 3, '0.10', '69.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10656, 44, '19.4500', 28, '0.10', '544.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10656, 47, '9.5000', 6, '0.10', '56.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 15, '15.5000', 50, '0.00', '775.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 41, '9.6500', 24, '0.00', '231.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 46, '12.0000', 45, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 47, '9.5000', 10, '0.00', '95.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 56, '38.0000', 45, '0.00', '1710.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10657, 60, '34.0000', 30, '0.00', '1020.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10658, 21, '10.0000', 60, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10658, 40, '18.4000', 70, '0.05', '1287.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10658, 60, '34.0000', 55, '0.05', '1869.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10658, 77, '13.0000', 70, '0.05', '909.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10659, 31, '12.5000', 20, '0.05', '249.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10659, 40, '18.4000', 24, '0.05', '441.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10659, 70, '15.0000', 40, '0.05', '599.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10660, 20, '81.0000', 21, '0.00', '1701.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10661, 39, '18.0000', 3, '0.20', '53.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10661, 58, '13.2500', 49, '0.20', '649.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10662, 68, '12.5000', 10, '0.00', '125.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10663, 40, '18.4000', 30, '0.05', '551.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10663, 42, '14.0000', 30, '0.05', '419.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10663, 51, '53.0000', 20, '0.05', '1059.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10664, 10, '31.0000', 24, '0.15', '743.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10664, 56, '38.0000', 12, '0.15', '455.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10664, 65, '21.0500', 15, '0.15', '315.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10665, 51, '53.0000', 20, '0.00', '1060.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10665, 59, '55.0000', 1, '0.00', '55.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10665, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10666, 29, '123.7900', 36, '0.00', '4456.44');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10666, 65, '21.0500', 10, '0.00', '210.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10667, 69, '36.0000', 45, '0.20', '1619.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10667, 71, '21.5000', 14, '0.20', '300.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10668, 31, '12.5000', 8, '0.10', '99.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10668, 55, '24.0000', 4, '0.10', '95.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10668, 64, '33.2500', 15, '0.10', '498.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10669, 36, '19.0000', 30, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10670, 23, '9.0000', 32, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10670, 46, '12.0000', 60, '0.00', '720.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10670, 67, '14.0000', 25, '0.00', '350.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10670, 73, '15.0000', 50, '0.00', '750.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10670, 75, '7.7500', 25, '0.00', '193.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10671, 16, '17.4500', 10, '0.00', '174.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10671, 62, '49.3000', 10, '0.00', '493.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10671, 65, '21.0500', 12, '0.00', '252.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10672, 38, '263.5000', 15, '0.10', '3952.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10672, 71, '21.5000', 12, '0.00', '258.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10673, 16, '17.4500', 3, '0.00', '52.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10673, 42, '14.0000', 6, '0.00', '84.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10673, 43, '46.0000', 6, '0.00', '276.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10674, 23, '9.0000', 5, '0.00', '45.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10675, 14, '23.2500', 30, '0.00', '697.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10675, 53, '32.8000', 10, '0.00', '328.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10675, 58, '13.2500', 30, '0.00', '397.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10676, 10, '31.0000', 2, '0.00', '62.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10676, 19, '9.2000', 7, '0.00', '64.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10676, 44, '19.4500', 21, '0.00', '408.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10677, 26, '31.2300', 30, '0.15', '936.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10677, 33, '2.5000', 8, '0.15', '19.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10678, 12, '38.0000', 100, '0.00', '3800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10678, 33, '2.5000', 30, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10678, 41, '9.6500', 120, '0.00', '1158.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10678, 54, '7.4500', 30, '0.00', '223.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10679, 59, '55.0000', 12, '0.00', '660.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10680, 16, '17.4500', 50, '0.25', '872.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10680, 31, '12.5000', 20, '0.25', '249.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10680, 42, '14.0000', 40, '0.25', '559.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10681, 19, '9.2000', 30, '0.10', '275.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10681, 21, '10.0000', 12, '0.10', '119.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10681, 64, '33.2500', 28, '0.00', '931.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10682, 33, '2.5000', 30, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10682, 66, '17.0000', 4, '0.00', '68.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10682, 75, '7.7500', 30, '0.00', '232.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10683, 52, '7.0000', 9, '0.00', '63.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10684, 40, '18.4000', 20, '0.00', '368.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10684, 47, '9.5000', 40, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10684, 60, '34.0000', 30, '0.00', '1020.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10685, 10, '31.0000', 20, '0.00', '620.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10685, 41, '9.6500', 4, '0.00', '38.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10685, 47, '9.5000', 15, '0.00', '142.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10686, 17, '39.0000', 30, '0.20', '1169.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10686, 26, '31.2300', 15, '0.00', '468.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10687, 9, '97.0000', 50, '0.25', '4849.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10687, 29, '123.7900', 10, '0.00', '1237.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10687, 36, '19.0000', 6, '0.25', '113.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10688, 10, '31.0000', 18, '0.10', '557.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10688, 28, '45.6000', 60, '0.10', '2735.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10688, 34, '14.0000', 14, '0.00', '196.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10689, 1, '18.0000', 35, '0.25', '629.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10690, 56, '38.0000', 20, '0.25', '759.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10690, 77, '13.0000', 30, '0.25', '389.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10691, 1, '18.0000', 30, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10691, 29, '123.7900', 40, '0.00', '4951.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10691, 43, '46.0000', 40, '0.00', '1840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10691, 44, '19.4500', 24, '0.00', '466.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10691, 62, '49.3000', 48, '0.00', '2366.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10692, 63, '43.9000', 20, '0.00', '878.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10693, 9, '97.0000', 6, '0.00', '582.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10693, 54, '7.4500', 60, '0.15', '446.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10693, 69, '36.0000', 30, '0.15', '1079.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10693, 73, '15.0000', 15, '0.15', '224.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10694, 7, '30.0000', 90, '0.00', '2700.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10694, 59, '55.0000', 25, '0.00', '1375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10694, 70, '15.0000', 50, '0.00', '750.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10695, 8, '40.0000', 10, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10695, 12, '38.0000', 4, '0.00', '152.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10695, 24, '4.5000', 20, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10696, 17, '39.0000', 20, '0.00', '780.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10696, 46, '12.0000', 18, '0.00', '216.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10697, 19, '9.2000', 7, '0.25', '64.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10697, 35, '18.0000', 9, '0.25', '161.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10697, 58, '13.2500', 30, '0.25', '397.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10697, 70, '15.0000', 30, '0.25', '449.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10698, 11, '21.0000', 15, '0.00', '315.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10698, 17, '39.0000', 8, '0.05', '311.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10698, 29, '123.7900', 12, '0.05', '1485.43');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10698, 65, '21.0500', 65, '0.05', '1368.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10698, 70, '15.0000', 8, '0.05', '119.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10699, 47, '9.5000', 12, '0.00', '114.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10700, 1, '18.0000', 5, '0.20', '89.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10700, 34, '14.0000', 12, '0.20', '167.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10700, 68, '12.5000', 40, '0.20', '499.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10700, 71, '21.5000', 60, '0.20', '1289.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10701, 59, '55.0000', 42, '0.15', '2309.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10701, 71, '21.5000', 20, '0.15', '429.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10701, 76, '18.0000', 35, '0.15', '629.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10702, 3, '10.0000', 6, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10702, 76, '18.0000', 15, '0.00', '270.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10703, 2, '19.0000', 5, '0.00', '95.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10703, 59, '55.0000', 35, '0.00', '1925.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10703, 73, '15.0000', 35, '0.00', '525.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10704, 4, '22.0000', 6, '0.00', '132.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10704, 24, '4.5000', 35, '0.00', '157.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10704, 48, '12.7500', 24, '0.00', '306.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10705, 31, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10705, 32, '32.0000', 4, '0.00', '128.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10706, 16, '17.4500', 20, '0.00', '349.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10706, 43, '46.0000', 24, '0.00', '1104.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10706, 59, '55.0000', 8, '0.00', '440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10707, 55, '24.0000', 21, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10707, 57, '19.5000', 40, '0.00', '780.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10707, 70, '15.0000', 28, '0.15', '419.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10708, 5, '21.3500', 4, '0.00', '85.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10708, 36, '19.0000', 5, '0.00', '95.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10709, 8, '40.0000', 40, '0.00', '1600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10709, 51, '53.0000', 28, '0.00', '1484.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10709, 60, '34.0000', 10, '0.00', '340.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10710, 19, '9.2000', 5, '0.00', '46.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10710, 47, '9.5000', 5, '0.00', '47.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10711, 19, '9.2000', 12, '0.00', '110.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10711, 41, '9.6500', 42, '0.00', '405.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10711, 53, '32.8000', 120, '0.00', '3936.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10712, 53, '32.8000', 3, '0.05', '98.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10712, 56, '38.0000', 30, '0.00', '1140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10713, 10, '31.0000', 18, '0.00', '558.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10713, 26, '31.2300', 30, '0.00', '936.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10713, 45, '9.5000', 110, '0.00', '1045.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10713, 46, '12.0000', 24, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10714, 2, '19.0000', 30, '0.25', '569.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10714, 17, '39.0000', 27, '0.25', '1052.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10714, 47, '9.5000', 50, '0.25', '474.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10714, 56, '38.0000', 18, '0.25', '683.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10714, 58, '13.2500', 12, '0.25', '158.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10715, 10, '31.0000', 21, '0.00', '651.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10715, 71, '21.5000', 30, '0.00', '645.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10716, 21, '10.0000', 5, '0.00', '50.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10716, 51, '53.0000', 7, '0.00', '371.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10716, 61, '28.5000', 10, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10717, 21, '10.0000', 32, '0.05', '319.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10717, 54, '7.4500', 15, '0.00', '111.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10717, 69, '36.0000', 25, '0.05', '899.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10718, 12, '38.0000', 36, '0.00', '1368.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10718, 16, '17.4500', 20, '0.00', '349.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10718, 36, '19.0000', 40, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10718, 62, '49.3000', 20, '0.00', '986.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10719, 18, '62.5000', 12, '0.25', '749.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10719, 30, '25.8900', 3, '0.25', '77.42');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10719, 54, '7.4500', 40, '0.25', '297.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10720, 35, '18.0000', 21, '0.00', '378.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10720, 71, '21.5000', 8, '0.00', '172.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10721, 44, '19.4500', 50, '0.05', '972.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10722, 2, '19.0000', 3, '0.00', '57.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10722, 31, '12.5000', 50, '0.00', '625.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10722, 68, '12.5000', 45, '0.00', '562.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10722, 75, '7.7500', 42, '0.00', '325.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10723, 26, '31.2300', 15, '0.00', '468.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10724, 10, '31.0000', 16, '0.00', '496.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10724, 61, '28.5000', 5, '0.00', '142.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10725, 41, '9.6500', 12, '0.00', '115.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10725, 52, '7.0000', 4, '0.00', '28.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10725, 55, '24.0000', 6, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10726, 4, '22.0000', 25, '0.00', '550.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10726, 11, '21.0000', 5, '0.00', '105.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10727, 17, '39.0000', 20, '0.05', '779.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10727, 56, '38.0000', 10, '0.05', '379.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10727, 59, '55.0000', 10, '0.05', '549.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10728, 30, '25.8900', 15, '0.00', '388.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10728, 40, '18.4000', 6, '0.00', '110.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10728, 55, '24.0000', 12, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10728, 60, '34.0000', 15, '0.00', '510.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10729, 1, '18.0000', 50, '0.00', '900.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10729, 21, '10.0000', 30, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10729, 50, '16.2500', 40, '0.00', '650.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10730, 16, '17.4500', 15, '0.05', '261.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10730, 31, '12.5000', 3, '0.05', '37.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10730, 65, '21.0500', 10, '0.05', '210.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10731, 21, '10.0000', 40, '0.05', '399.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10731, 51, '53.0000', 30, '0.05', '1589.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10732, 76, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10733, 14, '23.2500', 16, '0.00', '372.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10733, 28, '45.6000', 20, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10733, 52, '7.0000', 25, '0.00', '175.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10734, 6, '25.0000', 30, '0.00', '750.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10734, 30, '25.8900', 15, '0.00', '388.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10734, 76, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10735, 61, '28.5000', 20, '0.10', '569.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10735, 77, '13.0000', 2, '0.10', '25.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10736, 65, '21.0500', 40, '0.00', '842.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10736, 75, '7.7500', 20, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10737, 13, '6.0000', 4, '0.00', '24.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10737, 41, '9.6500', 12, '0.00', '115.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10738, 16, '17.4500', 3, '0.00', '52.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10739, 36, '19.0000', 6, '0.00', '114.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10739, 52, '7.0000', 18, '0.00', '126.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10740, 28, '45.6000', 5, '0.20', '227.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10740, 35, '18.0000', 35, '0.20', '629.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10740, 45, '9.5000', 40, '0.20', '379.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10740, 56, '38.0000', 14, '0.20', '531.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10741, 2, '19.0000', 15, '0.20', '284.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10742, 3, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10742, 60, '34.0000', 50, '0.00', '1700.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10742, 72, '34.8000', 35, '0.00', '1218.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10743, 46, '12.0000', 28, '0.05', '335.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10744, 40, '18.4000', 50, '0.20', '919.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10745, 18, '62.5000', 24, '0.00', '1500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10745, 44, '19.4500', 16, '0.00', '311.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10745, 59, '55.0000', 45, '0.00', '2475.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10745, 72, '34.8000', 7, '0.00', '243.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10746, 13, '6.0000', 6, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10746, 42, '14.0000', 28, '0.00', '392.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10746, 62, '49.3000', 9, '0.00', '443.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10746, 69, '36.0000', 40, '0.00', '1440.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10747, 31, '12.5000', 8, '0.00', '100.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10747, 41, '9.6500', 35, '0.00', '337.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10747, 63, '43.9000', 9, '0.00', '395.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10747, 69, '36.0000', 30, '0.00', '1080.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10748, 23, '9.0000', 44, '0.00', '396.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10748, 40, '18.4000', 40, '0.00', '736.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10748, 56, '38.0000', 28, '0.00', '1064.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10749, 56, '38.0000', 15, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10749, 59, '55.0000', 6, '0.00', '330.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10749, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10750, 14, '23.2500', 5, '0.15', '116.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10750, 45, '9.5000', 40, '0.15', '379.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10750, 59, '55.0000', 25, '0.15', '1374.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10751, 26, '31.2300', 12, '0.10', '374.66');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10751, 30, '25.8900', 30, '0.00', '776.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10751, 50, '16.2500', 20, '0.10', '324.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10751, 73, '15.0000', 15, '0.00', '225.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10752, 1, '18.0000', 8, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10752, 69, '36.0000', 3, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10753, 45, '9.5000', 4, '0.00', '38.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10753, 74, '10.0000', 5, '0.00', '50.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10754, 40, '18.4000', 3, '0.00', '55.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10755, 47, '9.5000', 30, '0.25', '284.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10755, 56, '38.0000', 30, '0.25', '1139.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10755, 57, '19.5000', 14, '0.25', '272.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10755, 69, '36.0000', 25, '0.25', '899.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10756, 18, '62.5000', 21, '0.20', '1312.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10756, 36, '19.0000', 20, '0.20', '379.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10756, 68, '12.5000', 6, '0.20', '74.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10756, 69, '36.0000', 20, '0.20', '719.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10757, 34, '14.0000', 30, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10757, 59, '55.0000', 7, '0.00', '385.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10757, 62, '49.3000', 30, '0.00', '1479.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10757, 64, '33.2500', 24, '0.00', '798.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10758, 26, '31.2300', 20, '0.00', '624.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10758, 52, '7.0000', 60, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10758, 70, '15.0000', 40, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10759, 32, '32.0000', 10, '0.00', '320.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10760, 25, '14.0000', 12, '0.25', '167.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10760, 27, '43.9000', 40, '0.00', '1756.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10760, 43, '46.0000', 30, '0.25', '1379.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10761, 25, '14.0000', 35, '0.25', '489.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10761, 75, '7.7500', 18, '0.00', '139.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10762, 39, '18.0000', 16, '0.00', '288.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10762, 47, '9.5000', 30, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10762, 51, '53.0000', 28, '0.00', '1484.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10762, 56, '38.0000', 60, '0.00', '2280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10763, 21, '10.0000', 40, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10763, 22, '21.0000', 6, '0.00', '126.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10763, 24, '4.5000', 20, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10764, 3, '10.0000', 20, '0.10', '199.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10764, 39, '18.0000', 130, '0.10', '2339.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10765, 65, '21.0500', 80, '0.10', '1683.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10766, 2, '19.0000', 40, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10766, 7, '30.0000', 35, '0.00', '1050.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10766, 68, '12.5000', 40, '0.00', '500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10767, 42, '14.0000', 2, '0.00', '28.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10768, 22, '21.0000', 4, '0.00', '84.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10768, 31, '12.5000', 50, '0.00', '625.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10768, 60, '34.0000', 15, '0.00', '510.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10768, 71, '21.5000', 12, '0.00', '258.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10769, 41, '9.6500', 30, '0.05', '289.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10769, 52, '7.0000', 15, '0.05', '104.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10769, 61, '28.5000', 20, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10769, 62, '49.3000', 15, '0.00', '739.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10770, 11, '21.0000', 15, '0.25', '314.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10771, 71, '21.5000', 16, '0.00', '344.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10772, 29, '123.7900', 18, '0.00', '2228.22');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10772, 59, '55.0000', 25, '0.00', '1375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10773, 17, '39.0000', 33, '0.00', '1287.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10773, 31, '12.5000', 70, '0.20', '874.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10773, 75, '7.7500', 7, '0.20', '54.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10774, 31, '12.5000', 2, '0.25', '24.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10774, 66, '17.0000', 50, '0.00', '850.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10775, 10, '31.0000', 6, '0.00', '186.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10775, 67, '14.0000', 3, '0.00', '42.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10776, 31, '12.5000', 16, '0.05', '199.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10776, 42, '14.0000', 12, '0.05', '167.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10776, 45, '9.5000', 27, '0.05', '256.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10776, 51, '53.0000', 120, '0.05', '6359.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10777, 42, '14.0000', 20, '0.20', '279.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10778, 41, '9.6500', 10, '0.00', '96.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10779, 16, '17.4500', 20, '0.00', '349.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10779, 62, '49.3000', 20, '0.00', '986.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10780, 70, '15.0000', 35, '0.00', '525.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10780, 77, '13.0000', 15, '0.00', '195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10781, 54, '7.4500', 3, '0.20', '22.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10781, 56, '38.0000', 20, '0.20', '759.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10781, 74, '10.0000', 35, '0.00', '350.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10782, 31, '12.5000', 1, '0.00', '12.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10783, 31, '12.5000', 10, '0.00', '125.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10783, 38, '263.5000', 5, '0.00', '1317.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10784, 36, '19.0000', 30, '0.00', '570.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10784, 39, '18.0000', 2, '0.15', '35.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10784, 72, '34.8000', 30, '0.15', '1043.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10785, 10, '31.0000', 10, '0.00', '310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10785, 75, '7.7500', 10, '0.00', '77.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10786, 8, '40.0000', 30, '0.20', '1199.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10786, 30, '25.8900', 15, '0.20', '388.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10786, 75, '7.7500', 42, '0.20', '325.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10787, 2, '19.0000', 15, '0.05', '284.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10787, 29, '123.7900', 20, '0.05', '2475.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10788, 19, '9.2000', 50, '0.05', '459.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10788, 75, '7.7500', 40, '0.05', '309.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10789, 18, '62.5000', 30, '0.00', '1875.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10789, 35, '18.0000', 15, '0.00', '270.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10789, 63, '43.9000', 30, '0.00', '1317.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10789, 68, '12.5000', 18, '0.00', '225.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10790, 7, '30.0000', 3, '0.15', '89.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10790, 56, '38.0000', 20, '0.15', '759.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10791, 29, '123.7900', 14, '0.05', '1733.01');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10791, 41, '9.6500', 20, '0.05', '192.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10792, 2, '19.0000', 10, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10792, 54, '7.4500', 3, '0.00', '22.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10792, 68, '12.5000', 15, '0.00', '187.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10793, 41, '9.6500', 14, '0.00', '135.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10793, 52, '7.0000', 8, '0.00', '56.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10794, 14, '23.2500', 15, '0.20', '348.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10794, 54, '7.4500', 6, '0.20', '44.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10795, 16, '17.4500', 65, '0.00', '1134.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10795, 17, '39.0000', 35, '0.25', '1364.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10796, 26, '31.2300', 21, '0.20', '655.63');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10796, 44, '19.4500', 10, '0.00', '194.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10796, 64, '33.2500', 35, '0.20', '1163.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10796, 69, '36.0000', 24, '0.20', '863.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10797, 11, '21.0000', 20, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10798, 62, '49.3000', 2, '0.00', '98.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10798, 72, '34.8000', 10, '0.00', '348.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10799, 13, '6.0000', 20, '0.15', '119.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10799, 24, '4.5000', 20, '0.15', '89.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10799, 59, '55.0000', 25, '0.00', '1375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10800, 11, '21.0000', 50, '0.10', '1049.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10800, 51, '53.0000', 10, '0.10', '529.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10800, 54, '7.4500', 7, '0.10', '52.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10801, 17, '39.0000', 40, '0.25', '1559.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10801, 29, '123.7900', 20, '0.25', '2475.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10802, 30, '25.8900', 25, '0.25', '647.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10802, 51, '53.0000', 30, '0.25', '1589.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10802, 55, '24.0000', 60, '0.25', '1439.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10802, 62, '49.3000', 5, '0.25', '246.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10803, 19, '9.2000', 24, '0.05', '220.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10803, 25, '14.0000', 15, '0.05', '209.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10803, 59, '55.0000', 15, '0.05', '824.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10804, 10, '31.0000', 36, '0.00', '1116.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10804, 28, '45.6000', 24, '0.00', '1094.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10804, 49, '20.0000', 4, '0.15', '79.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10805, 34, '14.0000', 10, '0.00', '140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10805, 38, '263.5000', 10, '0.00', '2635.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10806, 2, '19.0000', 20, '0.25', '379.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10806, 65, '21.0500', 2, '0.00', '42.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10806, 74, '10.0000', 15, '0.25', '149.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10807, 40, '18.4000', 1, '0.00', '18.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10808, 56, '38.0000', 20, '0.15', '759.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10808, 76, '18.0000', 50, '0.15', '899.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10809, 52, '7.0000', 20, '0.00', '140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10810, 13, '6.0000', 7, '0.00', '42.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10810, 25, '14.0000', 5, '0.00', '70.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10810, 70, '15.0000', 5, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10811, 19, '9.2000', 15, '0.00', '138.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10811, 23, '9.0000', 18, '0.00', '162.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10811, 40, '18.4000', 30, '0.00', '552.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10812, 31, '12.5000', 16, '0.10', '199.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10812, 72, '34.8000', 40, '0.10', '1391.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10812, 77, '13.0000', 20, '0.00', '260.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10813, 2, '19.0000', 12, '0.20', '227.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10813, 46, '12.0000', 35, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10814, 41, '9.6500', 20, '0.00', '193.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10814, 43, '46.0000', 20, '0.15', '919.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10814, 48, '12.7500', 8, '0.15', '101.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10814, 61, '28.5000', 30, '0.15', '854.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10815, 33, '2.5000', 16, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10816, 38, '263.5000', 30, '0.05', '7904.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10816, 62, '49.3000', 20, '0.05', '985.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10817, 26, '31.2300', 40, '0.15', '1249.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10817, 38, '263.5000', 30, '0.00', '7905.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10817, 40, '18.4000', 60, '0.15', '1103.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10817, 62, '49.3000', 25, '0.15', '1232.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10818, 32, '32.0000', 20, '0.00', '640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10818, 41, '9.6500', 20, '0.00', '193.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10819, 43, '46.0000', 7, '0.00', '322.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10819, 75, '7.7500', 20, '0.00', '155.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10820, 56, '38.0000', 30, '0.00', '1140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10821, 35, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10821, 51, '53.0000', 6, '0.00', '318.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10822, 62, '49.3000', 3, '0.00', '147.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10822, 70, '15.0000', 6, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10823, 11, '21.0000', 20, '0.10', '419.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10823, 57, '19.5000', 15, '0.00', '292.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10823, 59, '55.0000', 40, '0.10', '2199.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10823, 77, '13.0000', 15, '0.10', '194.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10824, 41, '9.6500', 12, '0.00', '115.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10824, 70, '15.0000', 9, '0.00', '135.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10825, 26, '31.2300', 12, '0.00', '374.76');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10825, 53, '32.8000', 20, '0.00', '656.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10826, 31, '12.5000', 35, '0.00', '437.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10826, 57, '19.5000', 15, '0.00', '292.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10827, 10, '31.0000', 15, '0.00', '465.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10827, 39, '18.0000', 21, '0.00', '378.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10828, 20, '81.0000', 5, '0.00', '405.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10828, 38, '263.5000', 2, '0.00', '527.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10829, 2, '19.0000', 10, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10829, 8, '40.0000', 20, '0.00', '800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10829, 13, '6.0000', 10, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10829, 60, '34.0000', 21, '0.00', '714.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10830, 6, '25.0000', 6, '0.00', '150.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10830, 39, '18.0000', 28, '0.00', '504.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10830, 60, '34.0000', 30, '0.00', '1020.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10830, 68, '12.5000', 24, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10831, 19, '9.2000', 2, '0.00', '18.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10831, 35, '18.0000', 8, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10831, 38, '263.5000', 8, '0.00', '2108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10831, 43, '46.0000', 9, '0.00', '414.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10832, 13, '6.0000', 3, '0.20', '17.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10832, 25, '14.0000', 10, '0.20', '139.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10832, 44, '19.4500', 16, '0.20', '311.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10832, 64, '33.2500', 3, '0.00', '99.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10833, 7, '30.0000', 20, '0.10', '599.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10833, 31, '12.5000', 9, '0.10', '112.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10833, 53, '32.8000', 9, '0.10', '295.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10834, 29, '123.7900', 8, '0.05', '990.27');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10834, 30, '25.8900', 20, '0.05', '517.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10835, 59, '55.0000', 15, '0.00', '825.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10835, 77, '13.0000', 2, '0.20', '25.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10836, 22, '21.0000', 52, '0.00', '1092.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10836, 35, '18.0000', 6, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10836, 57, '19.5000', 24, '0.00', '468.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10836, 60, '34.0000', 60, '0.00', '2040.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10836, 64, '33.2500', 30, '0.00', '997.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10837, 13, '6.0000', 6, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10837, 40, '18.4000', 25, '0.00', '460.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10837, 47, '9.5000', 40, '0.25', '379.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10837, 76, '18.0000', 21, '0.25', '377.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10838, 1, '18.0000', 4, '0.25', '71.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10838, 18, '62.5000', 25, '0.25', '1562.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10838, 36, '19.0000', 50, '0.25', '949.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10839, 58, '13.2500', 30, '0.10', '397.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10839, 72, '34.8000', 15, '0.10', '521.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10840, 25, '14.0000', 6, '0.20', '83.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10840, 39, '18.0000', 10, '0.20', '179.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10841, 10, '31.0000', 16, '0.00', '496.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10841, 56, '38.0000', 30, '0.00', '1140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10841, 59, '55.0000', 50, '0.00', '2750.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10841, 77, '13.0000', 15, '0.00', '195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10842, 11, '21.0000', 15, '0.00', '315.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10842, 43, '46.0000', 5, '0.00', '230.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10842, 68, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10842, 70, '15.0000', 12, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10843, 51, '53.0000', 4, '0.25', '211.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10844, 22, '21.0000', 35, '0.00', '735.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10845, 23, '9.0000', 70, '0.10', '629.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10845, 35, '18.0000', 25, '0.10', '449.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10845, 42, '14.0000', 42, '0.10', '587.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10845, 58, '13.2500', 60, '0.10', '794.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10845, 64, '33.2500', 48, '0.00', '1596.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10846, 4, '22.0000', 21, '0.00', '462.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10846, 70, '15.0000', 30, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10846, 74, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 1, '18.0000', 80, '0.20', '1439.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 19, '9.2000', 12, '0.20', '110.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 37, '26.0000', 60, '0.20', '1559.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 45, '9.5000', 36, '0.20', '341.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 60, '34.0000', 45, '0.20', '1529.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10847, 71, '21.5000', 55, '0.20', '1182.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10848, 5, '21.3500', 30, '0.00', '640.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10848, 9, '97.0000', 3, '0.00', '291.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10849, 3, '10.0000', 49, '0.00', '490.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10849, 26, '31.2300', 18, '0.15', '561.99');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10850, 25, '14.0000', 20, '0.15', '279.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10850, 33, '2.5000', 4, '0.15', '9.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10850, 70, '15.0000', 30, '0.15', '449.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10851, 2, '19.0000', 5, '0.05', '94.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10851, 25, '14.0000', 10, '0.05', '139.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10851, 57, '19.5000', 10, '0.05', '194.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10851, 59, '55.0000', 42, '0.05', '2309.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10852, 2, '19.0000', 15, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10852, 17, '39.0000', 6, '0.00', '234.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10852, 62, '49.3000', 50, '0.00', '2465.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10853, 18, '62.5000', 10, '0.00', '625.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10854, 10, '31.0000', 100, '0.15', '3099.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10854, 13, '6.0000', 65, '0.15', '389.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10855, 16, '17.4500', 50, '0.00', '872.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10855, 31, '12.5000', 14, '0.00', '175.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10855, 56, '38.0000', 24, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10855, 65, '21.0500', 15, '0.15', '315.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10856, 2, '19.0000', 20, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10856, 42, '14.0000', 20, '0.00', '280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10857, 3, '10.0000', 30, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10857, 26, '31.2300', 35, '0.25', '1092.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10857, 29, '123.7900', 10, '0.25', '1237.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10858, 7, '30.0000', 5, '0.00', '150.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10858, 27, '43.9000', 10, '0.00', '439.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10858, 70, '15.0000', 4, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10859, 24, '4.5000', 40, '0.25', '179.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10859, 54, '7.4500', 35, '0.25', '260.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10859, 64, '33.2500', 30, '0.25', '997.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10860, 51, '53.0000', 3, '0.00', '159.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10860, 76, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10861, 17, '39.0000', 42, '0.00', '1638.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10861, 18, '62.5000', 20, '0.00', '1250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10861, 21, '10.0000', 40, '0.00', '400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10861, 33, '2.5000', 35, '0.00', '87.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10861, 62, '49.3000', 3, '0.00', '147.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10862, 11, '21.0000', 25, '0.00', '525.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10862, 52, '7.0000', 8, '0.00', '56.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10863, 1, '18.0000', 20, '0.15', '359.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10863, 58, '13.2500', 12, '0.15', '158.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10864, 35, '18.0000', 4, '0.00', '72.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10864, 67, '14.0000', 15, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10865, 38, '263.5000', 60, '0.05', '15809.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10865, 39, '18.0000', 80, '0.05', '1439.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10866, 2, '19.0000', 21, '0.25', '398.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10866, 24, '4.5000', 6, '0.25', '26.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10866, 30, '25.8900', 40, '0.25', '1035.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10867, 53, '32.8000', 3, '0.00', '98.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10868, 26, '31.2300', 20, '0.00', '624.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10868, 35, '18.0000', 30, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10868, 49, '20.0000', 42, '0.10', '839.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10869, 1, '18.0000', 40, '0.00', '720.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10869, 11, '21.0000', 10, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10869, 23, '9.0000', 50, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10869, 68, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10870, 35, '18.0000', 3, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10870, 51, '53.0000', 2, '0.00', '106.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10871, 6, '25.0000', 50, '0.05', '1249.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10871, 16, '17.4500', 12, '0.05', '209.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10871, 17, '39.0000', 16, '0.05', '623.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10872, 55, '24.0000', 10, '0.05', '239.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10872, 62, '49.3000', 20, '0.05', '985.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10872, 64, '33.2500', 15, '0.05', '498.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10872, 65, '21.0500', 21, '0.05', '442.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10873, 21, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10873, 28, '45.6000', 3, '0.00', '136.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10874, 10, '31.0000', 10, '0.00', '310.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10875, 19, '9.2000', 25, '0.00', '230.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10875, 47, '9.5000', 21, '0.10', '199.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10875, 49, '20.0000', 15, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10876, 46, '12.0000', 21, '0.00', '252.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10876, 64, '33.2500', 20, '0.00', '665.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10877, 16, '17.4500', 30, '0.25', '523.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10877, 18, '62.5000', 25, '0.00', '1562.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10878, 20, '81.0000', 20, '0.05', '1619.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10879, 40, '18.4000', 12, '0.00', '220.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10879, 65, '21.0500', 10, '0.00', '210.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10879, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10880, 23, '9.0000', 30, '0.20', '269.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10880, 61, '28.5000', 30, '0.20', '854.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10880, 70, '15.0000', 50, '0.20', '749.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10881, 73, '15.0000', 10, '0.00', '150.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10882, 42, '14.0000', 25, '0.00', '350.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10882, 49, '20.0000', 20, '0.15', '399.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10882, 54, '7.4500', 32, '0.15', '238.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10883, 24, '4.5000', 8, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10884, 21, '10.0000', 40, '0.05', '399.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10884, 56, '38.0000', 21, '0.05', '797.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10884, 65, '21.0500', 12, '0.05', '252.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10885, 2, '19.0000', 20, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10885, 24, '4.5000', 12, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10885, 70, '15.0000', 30, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10885, 77, '13.0000', 25, '0.00', '325.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10886, 10, '31.0000', 70, '0.00', '2170.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10886, 31, '12.5000', 35, '0.00', '437.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10886, 77, '13.0000', 40, '0.00', '520.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10887, 25, '14.0000', 5, '0.00', '70.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10888, 2, '19.0000', 20, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10888, 68, '12.5000', 18, '0.00', '225.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10889, 11, '21.0000', 40, '0.00', '840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10889, 38, '263.5000', 40, '0.00', '10540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10890, 17, '39.0000', 15, '0.00', '585.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10890, 34, '14.0000', 10, '0.00', '140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10890, 41, '9.6500', 14, '0.00', '135.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10891, 30, '25.8900', 15, '0.05', '388.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10892, 59, '55.0000', 40, '0.05', '2199.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10893, 8, '40.0000', 30, '0.00', '1200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10893, 24, '4.5000', 10, '0.00', '45.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10893, 29, '123.7900', 24, '0.00', '2970.96');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10893, 30, '25.8900', 35, '0.00', '906.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10893, 36, '19.0000', 20, '0.00', '380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10894, 13, '6.0000', 28, '0.05', '167.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10894, 69, '36.0000', 50, '0.05', '1799.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10894, 75, '7.7500', 120, '0.05', '929.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10895, 24, '4.5000', 110, '0.00', '495.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10895, 39, '18.0000', 45, '0.00', '810.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10895, 40, '18.4000', 91, '0.00', '1674.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10895, 60, '34.0000', 100, '0.00', '3400.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10896, 45, '9.5000', 15, '0.00', '142.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10896, 56, '38.0000', 16, '0.00', '608.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10897, 29, '123.7900', 80, '0.00', '9903.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10897, 30, '25.8900', 36, '0.00', '932.04');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10898, 13, '6.0000', 5, '0.00', '30.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10899, 39, '18.0000', 8, '0.15', '143.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10900, 70, '15.0000', 3, '0.25', '44.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10901, 41, '9.6500', 30, '0.00', '289.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10901, 71, '21.5000', 30, '0.00', '645.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10902, 55, '24.0000', 30, '0.15', '719.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10902, 62, '49.3000', 6, '0.15', '295.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10903, 13, '6.0000', 40, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10903, 65, '21.0500', 21, '0.00', '442.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10903, 68, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10904, 58, '13.2500', 15, '0.00', '198.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10904, 62, '49.3000', 35, '0.00', '1725.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10905, 1, '18.0000', 20, '0.05', '359.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10906, 61, '28.5000', 15, '0.00', '427.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10907, 75, '7.7500', 14, '0.00', '108.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10908, 7, '30.0000', 20, '0.05', '599.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10908, 52, '7.0000', 14, '0.05', '97.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10909, 7, '30.0000', 12, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10909, 16, '17.4500', 15, '0.00', '261.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10909, 41, '9.6500', 5, '0.00', '48.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10910, 19, '9.2000', 12, '0.00', '110.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10910, 49, '20.0000', 10, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10910, 61, '28.5000', 5, '0.00', '142.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10911, 1, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10911, 17, '39.0000', 12, '0.00', '468.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10911, 67, '14.0000', 15, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10912, 11, '21.0000', 40, '0.25', '839.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10912, 29, '123.7900', 60, '0.25', '7427.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10913, 4, '22.0000', 30, '0.25', '659.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10913, 33, '2.5000', 40, '0.25', '99.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10913, 58, '13.2500', 15, '0.00', '198.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10914, 71, '21.5000', 25, '0.00', '537.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10915, 17, '39.0000', 10, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10915, 33, '2.5000', 30, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10915, 54, '7.4500', 10, '0.00', '74.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10916, 16, '17.4500', 6, '0.00', '104.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10916, 32, '32.0000', 6, '0.00', '192.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10916, 57, '19.5000', 20, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10917, 30, '25.8900', 1, '0.00', '25.89');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10917, 60, '34.0000', 10, '0.00', '340.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10918, 1, '18.0000', 60, '0.25', '1079.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10918, 60, '34.0000', 25, '0.25', '849.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10919, 16, '17.4500', 24, '0.00', '418.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10919, 25, '14.0000', 24, '0.00', '336.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10919, 40, '18.4000', 20, '0.00', '368.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10920, 50, '16.2500', 24, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10921, 35, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10921, 63, '43.9000', 40, '0.00', '1756.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10922, 17, '39.0000', 15, '0.00', '585.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10922, 24, '4.5000', 35, '0.00', '157.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10923, 42, '14.0000', 10, '0.20', '139.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10923, 43, '46.0000', 10, '0.20', '459.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10923, 67, '14.0000', 24, '0.20', '335.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10924, 10, '31.0000', 20, '0.10', '619.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10924, 28, '45.6000', 30, '0.10', '1367.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10924, 75, '7.7500', 6, '0.00', '46.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10925, 36, '19.0000', 25, '0.15', '474.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10925, 52, '7.0000', 12, '0.15', '83.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10926, 11, '21.0000', 2, '0.00', '42.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10926, 13, '6.0000', 10, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10926, 19, '9.2000', 7, '0.00', '64.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10926, 72, '34.8000', 10, '0.00', '348.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10927, 20, '81.0000', 5, '0.00', '405.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10927, 52, '7.0000', 5, '0.00', '35.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10927, 76, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10928, 47, '9.5000', 5, '0.00', '47.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10928, 76, '18.0000', 5, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10929, 21, '10.0000', 60, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10929, 75, '7.7500', 49, '0.00', '379.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10929, 77, '13.0000', 15, '0.00', '195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10930, 21, '10.0000', 36, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10930, 27, '43.9000', 25, '0.00', '1097.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10930, 55, '24.0000', 25, '0.20', '599.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10930, 58, '13.2500', 30, '0.20', '397.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10931, 13, '6.0000', 42, '0.15', '251.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10931, 57, '19.5000', 30, '0.00', '585.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10932, 16, '17.4500', 30, '0.10', '523.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10932, 62, '49.3000', 14, '0.10', '690.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10932, 72, '34.8000', 16, '0.00', '556.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10932, 75, '7.7500', 20, '0.10', '154.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10933, 53, '32.8000', 2, '0.00', '65.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10933, 61, '28.5000', 30, '0.00', '855.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10934, 6, '25.0000', 20, '0.00', '500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10935, 1, '18.0000', 21, '0.00', '378.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10935, 18, '62.5000', 4, '0.25', '249.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10935, 23, '9.0000', 8, '0.25', '71.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10936, 36, '19.0000', 30, '0.20', '569.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10937, 28, '45.6000', 8, '0.00', '364.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10937, 34, '14.0000', 20, '0.00', '280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10938, 13, '6.0000', 20, '0.25', '119.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10938, 43, '46.0000', 24, '0.25', '1103.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10938, 60, '34.0000', 49, '0.25', '1665.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10938, 71, '21.5000', 35, '0.25', '752.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10939, 2, '19.0000', 10, '0.15', '189.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10939, 67, '14.0000', 40, '0.15', '559.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10940, 7, '30.0000', 8, '0.00', '240.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10940, 13, '6.0000', 20, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10941, 31, '12.5000', 44, '0.25', '549.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10941, 62, '49.3000', 30, '0.25', '1478.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10941, 68, '12.5000', 80, '0.25', '999.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10941, 72, '34.8000', 50, '0.00', '1740.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10942, 49, '20.0000', 28, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10943, 13, '6.0000', 15, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10943, 22, '21.0000', 21, '0.00', '441.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10943, 46, '12.0000', 15, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10944, 11, '21.0000', 5, '0.25', '104.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10944, 44, '19.4500', 18, '0.25', '349.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10944, 56, '38.0000', 18, '0.00', '684.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10945, 13, '6.0000', 20, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10945, 31, '12.5000', 10, '0.00', '125.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10946, 10, '31.0000', 25, '0.00', '775.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10946, 24, '4.5000', 25, '0.00', '112.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10946, 77, '13.0000', 40, '0.00', '520.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10947, 59, '55.0000', 4, '0.00', '220.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10948, 50, '16.2500', 9, '0.00', '146.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10948, 51, '53.0000', 40, '0.00', '2120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10948, 55, '24.0000', 4, '0.00', '96.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10949, 6, '25.0000', 12, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10949, 10, '31.0000', 30, '0.00', '930.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10949, 17, '39.0000', 6, '0.00', '234.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10949, 62, '49.3000', 60, '0.00', '2958.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10950, 4, '22.0000', 5, '0.00', '110.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10951, 33, '2.5000', 15, '0.05', '37.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10951, 41, '9.6500', 6, '0.05', '57.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10951, 75, '7.7500', 50, '0.05', '387.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10952, 6, '25.0000', 16, '0.05', '399.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10952, 28, '45.6000', 2, '0.00', '91.20');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10953, 20, '81.0000', 50, '0.05', '4049.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10953, 31, '12.5000', 50, '0.05', '624.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10954, 16, '17.4500', 28, '0.15', '488.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10954, 31, '12.5000', 25, '0.15', '312.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10954, 45, '9.5000', 30, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10954, 60, '34.0000', 24, '0.15', '815.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10955, 75, '7.7500', 12, '0.20', '92.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10956, 21, '10.0000', 12, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10956, 47, '9.5000', 14, '0.00', '133.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10956, 51, '53.0000', 8, '0.00', '424.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10957, 30, '25.8900', 30, '0.00', '776.70');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10957, 35, '18.0000', 40, '0.00', '720.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10957, 64, '33.2500', 8, '0.00', '266.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10958, 5, '21.3500', 20, '0.00', '427.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10958, 7, '30.0000', 6, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10958, 72, '34.8000', 5, '0.00', '174.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10959, 75, '7.7500', 20, '0.15', '154.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10960, 24, '4.5000', 10, '0.25', '44.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10960, 41, '9.6500', 24, '0.00', '231.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10961, 52, '7.0000', 6, '0.05', '41.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10961, 76, '18.0000', 60, '0.00', '1080.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10962, 7, '30.0000', 45, '0.00', '1350.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10962, 13, '6.0000', 77, '0.00', '462.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10962, 53, '32.8000', 20, '0.00', '656.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10962, 69, '36.0000', 9, '0.00', '324.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10962, 76, '18.0000', 44, '0.00', '792.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10963, 60, '34.0000', 2, '0.15', '67.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10964, 18, '62.5000', 6, '0.00', '375.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10964, 38, '263.5000', 5, '0.00', '1317.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10964, 69, '36.0000', 10, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10965, 51, '53.0000', 16, '0.00', '848.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10966, 37, '26.0000', 8, '0.00', '208.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10966, 56, '38.0000', 12, '0.15', '455.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10966, 62, '49.3000', 12, '0.15', '591.45');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10967, 19, '9.2000', 12, '0.00', '110.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10967, 49, '20.0000', 40, '0.00', '800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10968, 12, '38.0000', 30, '0.00', '1140.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10968, 24, '4.5000', 30, '0.00', '135.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10968, 64, '33.2500', 4, '0.00', '133.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10969, 46, '12.0000', 9, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10970, 52, '7.0000', 40, '0.20', '279.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10971, 29, '123.7900', 14, '0.00', '1733.06');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10972, 17, '39.0000', 6, '0.00', '234.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10972, 33, '2.5000', 7, '0.00', '17.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10973, 26, '31.2300', 5, '0.00', '156.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10973, 41, '9.6500', 6, '0.00', '57.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10973, 75, '7.7500', 10, '0.00', '77.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10974, 63, '43.9000', 10, '0.00', '439.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10975, 8, '40.0000', 16, '0.00', '640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10975, 75, '7.7500', 10, '0.00', '77.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10976, 28, '45.6000', 20, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10977, 39, '18.0000', 30, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10977, 47, '9.5000', 30, '0.00', '285.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10977, 51, '53.0000', 10, '0.00', '530.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10977, 63, '43.9000', 20, '0.00', '878.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10978, 8, '40.0000', 20, '0.15', '799.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10978, 21, '10.0000', 40, '0.15', '399.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10978, 40, '18.4000', 10, '0.00', '184.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10978, 44, '19.4500', 6, '0.15', '116.55');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 7, '30.0000', 18, '0.00', '540.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 12, '38.0000', 20, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 24, '4.5000', 80, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 27, '43.9000', 30, '0.00', '1317.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 31, '12.5000', 24, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10979, 63, '43.9000', 35, '0.00', '1536.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10980, 75, '7.7500', 40, '0.20', '309.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10981, 38, '263.5000', 60, '0.00', '15810.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10982, 7, '30.0000', 20, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10982, 43, '46.0000', 9, '0.00', '414.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10983, 13, '6.0000', 84, '0.15', '503.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10983, 57, '19.5000', 15, '0.00', '292.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10984, 16, '17.4500', 55, '0.00', '959.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10984, 24, '4.5000', 20, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10984, 36, '19.0000', 40, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10985, 16, '17.4500', 36, '0.10', '628.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10985, 18, '62.5000', 8, '0.10', '499.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10985, 32, '32.0000', 35, '0.10', '1119.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10986, 11, '21.0000', 30, '0.00', '630.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10986, 20, '81.0000', 15, '0.00', '1215.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10986, 76, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10986, 77, '13.0000', 15, '0.00', '195.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10987, 7, '30.0000', 60, '0.00', '1800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10987, 43, '46.0000', 6, '0.00', '276.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10987, 72, '34.8000', 20, '0.00', '696.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10988, 7, '30.0000', 60, '0.00', '1800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10988, 62, '49.3000', 40, '0.10', '1971.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10989, 6, '25.0000', 40, '0.00', '1000.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10989, 11, '21.0000', 15, '0.00', '315.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10989, 41, '9.6500', 4, '0.00', '38.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10990, 21, '10.0000', 65, '0.00', '650.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10990, 34, '14.0000', 60, '0.15', '839.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10990, 55, '24.0000', 65, '0.15', '1559.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10990, 61, '28.5000', 66, '0.15', '1880.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10991, 2, '19.0000', 50, '0.20', '949.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10991, 70, '15.0000', 20, '0.20', '299.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10991, 76, '18.0000', 90, '0.20', '1619.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10992, 72, '34.8000', 2, '0.00', '69.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10993, 29, '123.7900', 50, '0.25', '6189.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10993, 41, '9.6500', 35, '0.25', '337.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10994, 59, '55.0000', 18, '0.05', '989.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10995, 51, '53.0000', 20, '0.00', '1060.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10995, 60, '34.0000', 4, '0.00', '136.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10996, 42, '14.0000', 40, '0.00', '560.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10997, 32, '32.0000', 50, '0.00', '1600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10997, 46, '12.0000', 20, '0.25', '239.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10997, 52, '7.0000', 20, '0.25', '139.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10998, 24, '4.5000', 12, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10998, 61, '28.5000', 7, '0.00', '199.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10998, 74, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10998, 75, '7.7500', 30, '0.00', '232.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10999, 41, '9.6500', 20, '0.05', '192.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10999, 51, '53.0000', 15, '0.05', '794.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (10999, 77, '13.0000', 21, '0.05', '272.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11000, 4, '22.0000', 25, '0.25', '549.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11000, 24, '4.5000', 30, '0.25', '134.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11000, 77, '13.0000', 30, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11001, 7, '30.0000', 60, '0.00', '1800.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11001, 22, '21.0000', 25, '0.00', '525.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11001, 46, '12.0000', 25, '0.00', '300.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11001, 55, '24.0000', 6, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11002, 13, '6.0000', 56, '0.00', '336.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11002, 35, '18.0000', 15, '0.15', '269.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11002, 42, '14.0000', 24, '0.15', '335.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11002, 55, '24.0000', 40, '0.00', '960.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11003, 1, '18.0000', 4, '0.00', '72.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11003, 40, '18.4000', 10, '0.00', '184.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11003, 52, '7.0000', 10, '0.00', '70.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11004, 26, '31.2300', 6, '0.00', '187.38');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11004, 76, '18.0000', 6, '0.00', '108.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11005, 1, '18.0000', 2, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11005, 59, '55.0000', 10, '0.00', '550.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11006, 1, '18.0000', 8, '0.00', '144.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11006, 29, '123.7900', 2, '0.25', '247.33');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11007, 8, '40.0000', 30, '0.00', '1200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11007, 29, '123.7900', 10, '0.00', '1237.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11007, 42, '14.0000', 14, '0.00', '196.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11008, 28, '45.6000', 70, '0.05', '3191.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11008, 34, '14.0000', 90, '0.05', '1259.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11008, 71, '21.5000', 21, '0.00', '451.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11009, 24, '4.5000', 12, '0.00', '54.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11009, 36, '19.0000', 18, '0.25', '341.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11009, 60, '34.0000', 9, '0.00', '306.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11010, 7, '30.0000', 20, '0.00', '600.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11010, 24, '4.5000', 10, '0.00', '45.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11011, 58, '13.2500', 40, '0.05', '529.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11011, 71, '21.5000', 20, '0.00', '430.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11012, 19, '9.2000', 50, '0.05', '459.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11012, 60, '34.0000', 36, '0.05', '1223.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11012, 71, '21.5000', 60, '0.05', '1289.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11013, 23, '9.0000', 10, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11013, 42, '14.0000', 4, '0.00', '56.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11013, 45, '9.5000', 20, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11013, 68, '12.5000', 2, '0.00', '25.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11014, 41, '9.6500', 28, '0.10', '270.10');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11015, 30, '25.8900', 15, '0.00', '388.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11015, 77, '13.0000', 18, '0.00', '234.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11016, 31, '12.5000', 15, '0.00', '187.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11016, 36, '19.0000', 16, '0.00', '304.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11017, 3, '10.0000', 25, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11017, 59, '55.0000', 110, '0.00', '6050.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11017, 70, '15.0000', 30, '0.00', '450.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11018, 12, '38.0000', 20, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11018, 18, '62.5000', 10, '0.00', '625.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11018, 56, '38.0000', 5, '0.00', '190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11019, 46, '12.0000', 3, '0.00', '36.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11019, 49, '20.0000', 2, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11020, 10, '31.0000', 24, '0.15', '743.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11021, 2, '19.0000', 11, '0.25', '208.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11021, 20, '81.0000', 15, '0.00', '1215.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11021, 26, '31.2300', 63, '0.00', '1967.49');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11021, 51, '53.0000', 44, '0.25', '2331.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11021, 72, '34.8000', 35, '0.00', '1218.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11022, 19, '9.2000', 35, '0.00', '322.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11022, 69, '36.0000', 30, '0.00', '1080.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11023, 7, '30.0000', 4, '0.00', '120.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11023, 43, '46.0000', 30, '0.00', '1380.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11024, 26, '31.2300', 12, '0.00', '374.76');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11024, 33, '2.5000', 30, '0.00', '75.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11024, 65, '21.0500', 21, '0.00', '442.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11024, 71, '21.5000', 50, '0.00', '1075.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11025, 1, '18.0000', 10, '0.10', '179.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11025, 13, '6.0000', 20, '0.10', '119.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11026, 18, '62.5000', 8, '0.00', '500.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11026, 51, '53.0000', 10, '0.00', '530.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11027, 24, '4.5000', 30, '0.25', '134.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11027, 62, '49.3000', 21, '0.25', '1035.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11028, 55, '24.0000', 35, '0.00', '840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11028, 59, '55.0000', 24, '0.00', '1320.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11029, 56, '38.0000', 20, '0.00', '760.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11029, 63, '43.9000', 12, '0.00', '526.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11030, 2, '19.0000', 100, '0.25', '1899.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11030, 5, '21.3500', 70, '0.00', '1494.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11030, 29, '123.7900', 60, '0.25', '7427.15');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11030, 59, '55.0000', 100, '0.25', '5499.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11031, 1, '18.0000', 45, '0.00', '810.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11031, 13, '6.0000', 80, '0.00', '480.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11031, 24, '4.5000', 21, '0.00', '94.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11031, 64, '33.2500', 20, '0.00', '665.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11031, 71, '21.5000', 16, '0.00', '344.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11032, 36, '19.0000', 35, '0.00', '665.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11032, 38, '263.5000', 25, '0.00', '6587.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11032, 59, '55.0000', 30, '0.00', '1650.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11033, 53, '32.8000', 70, '0.10', '2295.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11033, 69, '36.0000', 36, '0.10', '1295.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11034, 21, '10.0000', 15, '0.10', '149.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11034, 44, '19.4500', 12, '0.00', '233.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11034, 61, '28.5000', 6, '0.00', '171.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11035, 1, '18.0000', 10, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11035, 35, '18.0000', 60, '0.00', '1080.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11035, 42, '14.0000', 30, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11035, 54, '7.4500', 10, '0.00', '74.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11036, 13, '6.0000', 7, '0.00', '42.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11036, 59, '55.0000', 30, '0.00', '1650.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11037, 70, '15.0000', 4, '0.00', '60.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11038, 40, '18.4000', 5, '0.20', '91.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11038, 52, '7.0000', 2, '0.00', '14.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11038, 71, '21.5000', 30, '0.00', '645.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11039, 28, '45.6000', 20, '0.00', '912.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11039, 35, '18.0000', 24, '0.00', '432.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11039, 49, '20.0000', 60, '0.00', '1200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11039, 57, '19.5000', 28, '0.00', '546.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11040, 21, '10.0000', 20, '0.00', '200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11041, 2, '19.0000', 30, '0.20', '569.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11041, 63, '43.9000', 30, '0.00', '1317.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11042, 44, '19.4500', 15, '0.00', '291.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11042, 61, '28.5000', 4, '0.00', '114.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11043, 11, '21.0000', 10, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11044, 62, '49.3000', 12, '0.00', '591.60');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11045, 33, '2.5000', 15, '0.00', '37.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11045, 51, '53.0000', 24, '0.00', '1272.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11046, 12, '38.0000', 20, '0.05', '759.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11046, 32, '32.0000', 15, '0.05', '479.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11046, 35, '18.0000', 18, '0.05', '323.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11047, 1, '18.0000', 25, '0.25', '449.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11047, 5, '21.3500', 30, '0.25', '640.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11048, 68, '12.5000', 42, '0.00', '525.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11049, 2, '19.0000', 10, '0.20', '189.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11049, 12, '38.0000', 4, '0.20', '151.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11050, 76, '18.0000', 50, '0.10', '899.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11051, 24, '4.5000', 10, '0.20', '44.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11052, 43, '46.0000', 30, '0.20', '1379.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11052, 61, '28.5000', 10, '0.20', '284.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11053, 18, '62.5000', 35, '0.20', '2187.30');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11053, 32, '32.0000', 20, '0.00', '640.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11053, 64, '33.2500', 25, '0.20', '831.05');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11054, 33, '2.5000', 10, '0.00', '25.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11054, 67, '14.0000', 20, '0.00', '280.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11055, 24, '4.5000', 15, '0.00', '67.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11055, 25, '14.0000', 15, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11055, 51, '53.0000', 20, '0.00', '1060.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11055, 57, '19.5000', 20, '0.00', '390.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11056, 7, '30.0000', 40, '0.00', '1200.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11056, 55, '24.0000', 35, '0.00', '840.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11056, 60, '34.0000', 50, '0.00', '1700.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11057, 70, '15.0000', 3, '0.00', '45.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11058, 21, '10.0000', 3, '0.00', '30.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11058, 60, '34.0000', 21, '0.00', '714.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11058, 61, '28.5000', 4, '0.00', '114.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11059, 13, '6.0000', 30, '0.00', '180.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11059, 17, '39.0000', 12, '0.00', '468.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11059, 60, '34.0000', 35, '0.00', '1190.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11060, 60, '34.0000', 4, '0.00', '136.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11060, 77, '13.0000', 10, '0.00', '130.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11061, 60, '34.0000', 15, '0.00', '510.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11062, 53, '32.8000', 10, '0.20', '327.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11062, 70, '15.0000', 12, '0.20', '179.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11063, 34, '14.0000', 30, '0.00', '420.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11063, 40, '18.4000', 40, '0.10', '735.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11063, 41, '9.6500', 30, '0.10', '289.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11064, 17, '39.0000', 77, '0.10', '3002.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11064, 41, '9.6500', 12, '0.00', '115.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11064, 53, '32.8000', 25, '0.10', '819.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11064, 55, '24.0000', 4, '0.10', '95.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11064, 68, '12.5000', 55, '0.00', '687.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11065, 30, '25.8900', 4, '0.25', '103.31');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11065, 54, '7.4500', 20, '0.25', '148.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11066, 16, '17.4500', 3, '0.00', '52.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11066, 19, '9.2000', 42, '0.00', '386.40');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11066, 34, '14.0000', 35, '0.00', '490.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11067, 41, '9.6500', 9, '0.00', '86.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11068, 28, '45.6000', 8, '0.15', '364.65');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11068, 43, '46.0000', 36, '0.15', '1655.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11068, 77, '13.0000', 28, '0.15', '363.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11069, 39, '18.0000', 20, '0.00', '360.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11070, 1, '18.0000', 40, '0.15', '719.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11070, 2, '19.0000', 20, '0.15', '379.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11070, 16, '17.4500', 30, '0.15', '523.35');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11070, 31, '12.5000', 20, '0.00', '250.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11071, 7, '30.0000', 15, '0.05', '449.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11071, 13, '6.0000', 10, '0.05', '59.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11072, 2, '19.0000', 8, '0.00', '152.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11072, 41, '9.6500', 40, '0.00', '386.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11072, 50, '16.2500', 22, '0.00', '357.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11072, 64, '33.2500', 130, '0.00', '4322.50');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11073, 11, '21.0000', 10, '0.00', '210.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11073, 24, '4.5000', 20, '0.00', '90.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11074, 16, '17.4500', 14, '0.05', '244.25');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11075, 2, '19.0000', 10, '0.15', '189.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11075, 46, '12.0000', 30, '0.15', '359.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11075, 76, '18.0000', 2, '0.15', '35.85');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11076, 6, '25.0000', 20, '0.25', '499.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11076, 14, '23.2500', 20, '0.25', '464.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11076, 19, '9.2000', 10, '0.25', '91.75');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 2, '19.0000', 24, '0.20', '455.80');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 3, '10.0000', 4, '0.00', '40.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 4, '22.0000', 1, '0.00', '22.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 6, '25.0000', 1, '0.02', '24.98');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 7, '30.0000', 1, '0.05', '29.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 8, '40.0000', 2, '0.10', '79.90');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 10, '31.0000', 1, '0.00', '31.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 12, '38.0000', 2, '0.05', '75.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 13, '6.0000', 4, '0.00', '24.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 14, '23.2500', 1, '0.03', '23.22');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 16, '17.4500', 2, '0.03', '34.87');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 20, '81.0000', 1, '0.04', '80.96');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 23, '9.0000', 2, '0.00', '18.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 32, '32.0000', 1, '0.00', '32.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 39, '18.0000', 2, '0.05', '35.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 41, '9.6500', 3, '0.00', '28.95');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 46, '12.0000', 3, '0.02', '35.98');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 52, '7.0000', 2, '0.00', '14.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 55, '24.0000', 2, '0.00', '48.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 60, '34.0000', 2, '0.06', '67.94');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 64, '33.2500', 2, '0.03', '66.47');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 66, '17.0000', 1, '0.00', '17.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 73, '15.0000', 2, '0.01', '29.99');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 75, '7.7500', 4, '0.00', '31.00');
INSERT INTO `adm_pedido_itens` (`PedidoID`, `ProdutoID`, `PrecoUnit`, `Quantidade`, `Desconto`, `Total`) VALUES (11077, 77, '13.0000', 2, '0.00', '26.00');

DROP TABLE IF EXISTS `adm_pedidos`;
CREATE TABLE `adm_pedidos` ( `PedidoID` int(11) NOT NULL default '0', `ClienteId` varchar(5) default NULL, `EmpresaID` int(11) default NULL, `EmpregadoID` int(11) default NULL, `DataPedido` date default NULL, `DataPrevista` date default NULL, `DataEnvio` date default NULL, `EnvioVia` int(11) default NULL, `ValorFrete` decimal(16,4) default NULL, `ValorPedido` decimal(16,2) default NULL, `DestNome` varchar(40) default NULL, `DestEndereco` varchar(60) default NULL, `DestCidade` varchar(15) default NULL, `DestEstado` varchar(15) default NULL, `DestCaixaPostal` varchar(10) default NULL, `DestPais` varchar(15) default NULL, PRIMARY KEY  (`PedidoID`), KEY `ClienteId` (`ClienteId`)) TYPE=MyISAM;

INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10248, 'VINET', 1, 5, '1996-07-04', '1996-08-01', '1996-07-16', 3, '32.3800', '440.00', 'Vinicula Sao Gabriel', 'R. Ciamarte, 95', 'Joo Pessoa', 'PB', '51100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10249, 'TOMSP', 1, 6, '1996-07-05', '1996-08-16', '1996-07-10', 1, '11.6100', '1863.40', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10250, 'HANAR', 1, 4, '1996-07-08', '1996-08-05', '1996-07-12', 2, '65.8300', '1812.70', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10251, 'VICTE', 1, 3, '1996-07-08', '1996-08-05', '1996-07-15', 1, '41.3400', '670.70', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10252, 'SUPRD', 1, 4, '1996-07-09', '1996-08-06', '1996-07-11', 2, '51.3000', '3729.90', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10253, 'HANAR', 1, 3, '1996-07-10', '1996-07-24', '1996-07-16', 2, '58.1700', '1444.80', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10254, 'CHOPS', 1, 5, '1996-07-11', '1996-08-08', '1996-07-23', 2, '22.9800', '624.90', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10255, 'RICSU', 1, 9, '1996-07-12', '1996-08-09', '1996-07-15', 3, '148.3300', '2490.50', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10256, 'WELLI', 1, 3, '1996-07-15', '1996-08-12', '1996-07-17', 2, '13.9700', '517.80', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10257, 'HILAA', 1, 4, '1996-07-16', '1996-08-13', '1996-07-22', 3, '81.9100', '1119.90', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10258, 'ERNSH', 1, 1, '1996-07-17', '1996-08-14', '1996-07-23', 1, '140.5100', '2018.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10259, 'CENTC', 1, 4, '1996-07-18', '1996-08-15', '1996-07-25', 3, '3.2500', '100.80', 'Centro comercial Meridional', 'R. Rodrigues Sete, 80', 'Fortaleza', 'CE', '05022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10260, 'OTTIK', 1, 4, '1996-07-19', '1996-08-16', '1996-07-29', 1, '55.0900', '1745.45', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10261, 'QUEDE', 1, 4, '1996-07-19', '1996-08-16', '1996-07-30', 2, '3.0500', '448.00', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10262, 'RATTC', 1, 8, '1996-07-22', '1996-08-19', '1996-07-25', 3, '48.2900', '624.60', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10263, 'ERNSH', 1, 9, '1996-07-23', '1996-08-20', '1996-07-31', 3, '146.0600', '2464.05', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10264, 'FOLKO', 1, 6, '1996-07-24', '1996-08-21', '1996-08-23', 3, '3.6700', '724.35', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10265, 'BLONP', 1, 2, '1996-07-25', '1996-08-22', '1996-08-12', 1, '55.2800', '1176.00', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10266, 'WARTH', 1, 3, '1996-07-26', '1996-09-06', '1996-07-31', 3, '25.7300', '364.75', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10267, 'FRANK', 1, 4, '1996-07-29', '1996-08-26', '1996-08-06', 1, '208.5800', '4030.70', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10268, 'GROSR', 1, 8, '1996-07-30', '1996-08-27', '1996-08-02', 3, '66.2900', '1101.20', 'Geralda - Restaurante', 'R. Antonio de Castro, 133', 'Vitria', 'ES', '1081', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10269, 'WHITC', 1, 5, '1996-07-31', '1996-08-14', '1996-08-09', 1, '4.5600', '675.90', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10270, 'WARTH', 1, 1, '1996-08-01', '1996-08-29', '1996-08-02', 1, '136.5400', '1376.00', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10271, 'SPLIR', 1, 6, '1996-08-01', '1996-08-29', '1996-08-30', 2, '4.5400', '48.00', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10272, 'RATTC', 1, 6, '1996-08-02', '1996-08-30', '1996-08-06', 2, '98.0300', '1456.00', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10273, 'QUICK', 1, 3, '1996-08-05', '1996-09-02', '1996-08-12', 3, '76.0700', '2142.20', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10274, 'VINET', 1, 6, '1996-08-06', '1996-09-03', '1996-08-16', 1, '6.0100', '538.60', 'Vinicula Sao Gabriel', 'R. Ciamarte, 95', 'Joo Pessoa', 'PB', '51100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10275, 'MAGAA', 1, 1, '1996-08-07', '1996-09-04', '1996-08-09', 1, '26.9300', '307.10', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10276, 'TORTU', 1, 8, '1996-08-08', '1996-08-22', '1996-08-14', 3, '13.8400', '420.00', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10277, 'MORGK', 1, 2, '1996-08-09', '1996-09-06', '1996-08-13', 3, '125.7700', '1200.80', 'Miramar Comercio Ltda', 'R. Guimaraes  Peixoto,  405', 'Porto Alegre', 'RS', '04179', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10278, 'BERGS', 1, 8, '1996-08-12', '1996-09-09', '1996-08-16', 2, '92.6900', '1488.80', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10279, 'LEHMS', 1, 8, '1996-08-13', '1996-09-10', '1996-08-16', 2, '25.8300', '467.75', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10280, 'BERGS', 1, 2, '1996-08-14', '1996-09-11', '1996-09-12', 1, '8.9800', '613.20', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10281, 'ROMEY', 1, 4, '1996-08-14', '1996-08-28', '1996-08-21', 1, '2.9400', '86.50', 'Romero & Tomaz', 'R. Deputado Mario Monteiro, 52/04', 'Joo Pessoa', 'PB', '28001', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10282, 'ROMEY', 1, 4, '1996-08-15', '1996-09-12', '1996-08-21', 1, '12.6900', '155.40', 'Romero & Tomaz', 'R. Deputado Mario Monteiro, 52/04', 'Joo Pessoa', 'PB', '28001', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10283, 'LILAS', 1, 3, '1996-08-16', '1996-09-13', '1996-08-23', 3, '84.8100', '1414.80', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10284, 'LEHMS', 1, 4, '1996-08-19', '1996-09-16', '1996-08-27', 1, '76.5600', '1451.25', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10285, 'QUICK', 1, 1, '1996-08-20', '1996-09-17', '1996-08-26', 2, '76.8300', '2178.60', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10286, 'QUICK', 1, 8, '1996-08-21', '1996-09-18', '1996-08-30', 3, '229.2400', '3016.00', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10287, 'RICAR', 1, 8, '1996-08-22', '1996-09-19', '1996-08-28', 3, '12.7600', '923.70', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10288, 'REGGC', 1, 4, '1996-08-23', '1996-09-20', '1996-09-03', 1, '7.4500', '88.80', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10289, 'BSBEV', 1, 7, '1996-08-26', '1996-09-23', '1996-08-28', 3, '22.7700', '479.40', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10290, 'COMMI', 1, 8, '1996-08-27', '1996-09-24', '1996-09-03', 1, '79.7000', '2169.00', 'Comrcio Mineiro', 'R. Alfredo Gama, 14', 'Goiana', 'GO', '05432-043', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10291, 'QUEDE', 1, 6, '1996-08-27', '1996-09-24', '1996-09-04', 2, '6.4000', '552.50', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10292, 'TRADH', 1, 1, '1996-08-28', '1996-09-25', '1996-09-02', 2, '1.3500', '1296.00', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10293, 'TORTU', 1, 1, '1996-08-29', '1996-09-26', '1996-09-11', 3, '21.1800', '848.70', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10294, 'RATTC', 1, 4, '1996-08-30', '1996-09-27', '1996-09-05', 2, '147.2600', '1887.60', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10295, 'VINET', 1, 2, '1996-09-02', '1996-09-30', '1996-09-10', 2, '1.1500', '121.60', 'Vinicula Sao Gabriel', 'R. Ciamarte, 95', 'Joo Pessoa', 'PB', '51100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10296, 'LILAS', 1, 6, '1996-09-03', '1996-10-01', '1996-09-11', 1, '0.1200', '1050.60', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10297, 'BLONP', 1, 5, '1996-09-04', '1996-10-16', '1996-09-10', 2, '5.7400', '1420.00', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10298, 'HUNGO', 1, 6, '1996-09-05', '1996-10-03', '1996-09-11', 2, '168.2200', '3126.50', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10299, 'RICAR', 1, 4, '1996-09-06', '1996-10-04', '1996-09-13', 2, '29.7600', '349.50', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10300, 'MAGAA', 1, 2, '1996-09-09', '1996-10-07', '1996-09-18', 2, '17.6800', '608.00', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10301, 'WANDK', 1, 8, '1996-09-09', '1996-10-07', '1996-09-17', 2, '45.0800', '755.00', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10302, 'SUPRD', 1, 4, '1996-09-10', '1996-10-08', '1996-10-09', 2, '6.2700', '2708.80', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10303, 'GODOS', 1, 7, '1996-09-11', '1996-10-09', '1996-09-18', 2, '107.8300', '1241.70', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10304, 'TORTU', 1, 1, '1996-09-12', '1996-10-10', '1996-09-17', 2, '63.7900', '954.40', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10305, 'OLDWO', 1, 8, '1996-09-13', '1996-10-11', '1996-10-09', 3, '257.6200', '4156.70', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10306, 'ROMEY', 1, 1, '1996-09-16', '1996-10-14', '1996-09-23', 3, '7.5600', '498.50', 'Romero & Tomaz', 'R. Deputado Mario Monteiro, 52/04', 'Joo Pessoa', 'PB', '28001', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10307, 'LONEP', 1, 2, '1996-09-17', '1996-10-15', '1996-09-25', 2, '0.5600', '424.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10308, NULL, 1, 7, '1996-09-18', '1996-10-16', '1996-09-24', 3, '1.6100', '88.80', 'Ana Rainha da Culinaria', 'R. Visconde de Taunay, 145', 'Fortaleza', 'CE', '05021', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10309, 'HUNGO', 1, 3, '1996-09-19', '1996-10-17', '1996-10-23', 1, '47.3000', '1762.00', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10310, 'THEBI', 1, 8, '1996-09-20', '1996-10-18', '1996-09-27', 2, '17.5200', '336.00', 'Tonico do Queijo Ltda', 'AV. Norte, 6622', 'Florianopolis', 'SC', '97201', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10311, 'DUMON', 1, 1, '1996-09-20', '1996-10-04', '1996-09-26', 3, '24.6900', '268.80', 'O Mundo Inteiro', 'R. Pedro Allain, 125 Casa.34', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10312, 'WANDK', 1, 2, '1996-09-23', '1996-10-21', '1996-10-03', 2, '40.2600', '1614.80', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10313, 'QUICK', 1, 2, '1996-09-24', '1996-10-22', '1996-10-04', 2, '1.9600', '182.40', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10314, 'RATTC', 1, 1, '1996-09-25', '1996-10-23', '1996-10-04', 2, '74.1600', '2326.70', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10315, 'ISLAT', 1, 4, '1996-09-26', '1996-10-24', '1996-10-03', 2, '41.7600', '516.80', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10316, 'RATTC', 1, 1, '1996-09-27', '1996-10-25', '1996-10-08', 3, '150.1500', '2835.00', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10317, 'LONEP', 1, 6, '1996-09-30', '1996-10-28', '1996-10-10', 1, '12.6900', '288.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10318, 'ISLAT', 1, 8, '1996-10-01', '1996-10-29', '1996-10-04', 2, '4.7300', '240.40', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10319, 'TORTU', 1, 7, '1996-10-02', '1996-10-30', '1996-10-11', 3, '64.5000', '1191.20', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10320, 'WARTH', 1, 5, '1996-10-03', '1996-10-17', '1996-10-18', 3, '34.5700', '516.00', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10321, 'ISLAT', 1, 3, '1996-10-03', '1996-10-31', '1996-10-11', 2, '3.4300', '144.00', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10322, 'PERIC', 1, 7, '1996-10-04', '1996-11-01', '1996-10-23', 3, '0.4000', '112.00', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10323, 'KOENE', 1, 4, '1996-10-07', '1996-11-04', '1996-10-14', 1, '4.8800', '164.40', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10324, 'SAVEA', 1, 9, '1996-10-08', '1996-11-05', '1996-10-10', 1, '214.2700', '6155.30', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10325, 'KOENE', 1, 1, '1996-10-09', '1996-10-23', '1996-10-14', 3, '64.8600', '1497.00', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10326, 'BOLID', 1, 4, '1996-10-10', '1996-11-07', '1996-10-14', 2, '77.9200', '982.00', 'Barto Comidas preparadas', 'R. Senador Milton Campos, 176', 'Joo Pessoa', 'PB', '28023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10327, 'FOLKO', 1, 2, '1996-10-11', '1996-11-08', '1996-10-14', 1, '63.3600', '2261.70', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10328, 'FURIB', 1, 4, '1996-10-14', '1996-11-11', '1996-10-17', 3, '87.0300', '1168.00', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10329, 'SPLIR', 1, 4, '1996-10-15', '1996-11-26', '1996-10-23', 2, '191.6700', '4819.20', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10330, 'LILAS', 1, 3, '1996-10-16', '1996-11-13', '1996-10-28', 1, '12.7500', '1939.70', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10331, 'BONAP', 1, 9, '1996-10-16', '1996-11-27', '1996-10-21', 1, '10.1900', '88.50', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10332, 'MEREP', 1, 3, '1996-10-17', '1996-11-28', '1996-10-21', 2, '52.8400', '2233.00', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10333, 'WARTH', 1, 5, '1996-10-18', '1996-11-15', '1996-10-25', 3, '0.5900', '953.80', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10334, 'VICTE', 1, 8, '1996-10-21', '1996-11-18', '1996-10-28', 2, '8.5600', '144.80', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10335, 'HUNGO', 1, 7, '1996-10-22', '1996-11-19', '1996-10-24', 2, '42.1100', '2544.40', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10336, 'PRINI', 1, 7, '1996-10-23', '1996-11-20', '1996-10-25', 2, '15.5100', '316.70', 'Princesa Isabel Vinhos', 'R. Dr. Antonio de Castro, 160', 'Sao Paulo', 'SP', '1756', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10337, 'FRANK', 1, 4, '1996-10-24', '1996-11-21', '1996-10-29', 3, '108.2600', '2467.00', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10338, 'OLDWO', 1, 4, '1996-10-25', '1996-11-22', '1996-10-29', 3, '84.2100', '934.50', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10339, 'MEREP', 1, 2, '1996-10-28', '1996-11-25', '1996-11-04', 2, '15.6600', '3463.15', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10340, 'BONAP', 1, 1, '1996-10-29', '1996-11-26', '1996-11-08', 3, '166.3100', '2564.25', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10341, 'SIMOB', 1, 7, '1996-10-29', '1996-11-26', '1996-11-05', 3, '26.7800', '411.85', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10342, 'FRANK', 1, 4, '1996-10-30', '1996-11-13', '1996-11-04', 2, '54.8300', '2300.00', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10343, 'LEHMS', 1, 4, '1996-10-31', '1996-11-28', '1996-11-06', 1, '110.3700', '1585.95', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10344, 'WHITC', 1, 4, '1996-11-01', '1996-11-29', '1996-11-05', 2, '23.2900', '2855.75', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10345, 'QUICK', 1, 2, '1996-11-04', '1996-12-02', '1996-11-11', 2, '249.0600', '2924.80', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10346, 'RATTC', 1, 3, '1996-11-05', '1996-12-17', '1996-11-08', 3, '142.0800', '1731.10', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10347, 'FAMIA', 1, 4, '1996-11-06', '1996-12-04', '1996-11-08', 3, '3.1000', '927.70', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10348, 'WANDK', 1, 4, '1996-11-07', '1996-12-05', '1996-11-15', 2, '0.7800', '395.85', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10349, 'SPLIR', 1, 7, '1996-11-08', '1996-12-06', '1996-11-15', 1, '8.6300', '141.60', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10350, 'LAMAI', 1, 6, '1996-11-11', '1996-12-09', '1996-12-03', 2, '64.1900', '713.20', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10351, 'ERNSH', 1, 1, '1996-11-11', '1996-12-09', '1996-11-20', 1, '162.3300', '5677.45', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10352, 'FURIB', 1, 3, '1996-11-12', '1996-11-26', '1996-11-18', 3, '1.3000', '153.85', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10353, 'PICCO', 1, 7, '1996-11-13', '1996-12-11', '1996-11-25', 3, '360.6300', '10741.20', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10354, 'PERIC', 1, 8, '1996-11-14', '1996-12-12', '1996-11-20', 3, '53.8000', '568.80', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10355, 'AROUT', 1, 6, '1996-11-15', '1996-12-13', '1996-11-20', 1, '41.9500', '480.00', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10356, 'WANDK', 1, 6, '1996-11-18', '1996-12-16', '1996-11-27', 2, '36.7100', '1106.40', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10357, 'LILAS', 1, 1, '1996-11-19', '1996-12-17', '1996-12-02', 3, '34.8800', '1359.60', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10358, 'LAMAI', 1, 5, '1996-11-20', '1996-12-18', '1996-11-27', 1, '19.6400', '451.85', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10359, 'SEVES', 1, 5, '1996-11-21', '1996-12-19', '1996-11-26', 3, '288.4300', '3654.25', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10360, 'BLONP', 1, 4, '1996-11-22', '1996-12-20', '1996-12-02', 3, '131.7000', '7390.20', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10361, 'QUICK', 1, 1, '1996-11-22', '1996-12-20', '1996-12-03', 2, '183.1700', '2273.40', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10362, 'BONAP', 1, 3, '1996-11-25', '1996-12-23', '1996-11-28', 1, '96.0400', '1549.60', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10363, 'DRACD', 1, 4, '1996-11-26', '1996-12-24', '1996-12-04', 3, '30.5400', '447.20', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10364, 'EASTC', 1, 1, '1996-11-26', '1997-01-07', '1996-12-04', 1, '71.9700', '950.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10365, 'ANTON', 1, 3, '1996-11-27', '1996-12-25', '1996-12-02', 2, '22.0000', '403.20', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10366, 'GALED', 1, 8, '1996-11-28', '1997-01-09', '1996-12-30', 2, '10.1400', '136.00', 'Galera do Gastronomo', 'R. Major Nereu  Guerra, 131', 'Porto Velho', 'RO', '08022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10367, 'VAFFE', 1, 7, '1996-11-28', '1996-12-26', '1996-12-02', 3, '13.5500', '834.20', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10368, 'ERNSH', 1, 2, '1996-11-29', '1996-12-27', '1996-12-02', 2, '101.9500', '1833.90', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10369, 'SPLIR', 1, 8, '1996-12-02', '1996-12-30', '1996-12-09', 2, '195.6800', '2526.95', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10370, 'CHOPS', 1, 6, '1996-12-03', '1996-12-31', '1996-12-27', 2, '1.1700', '1173.70', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10371, 'LAMAI', 1, 1, '1996-12-03', '1996-12-31', '1996-12-24', 1, '0.4500', '91.00', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10372, 'QUEEN', 1, 5, '1996-12-04', '1997-01-01', '1996-12-09', 2, '890.7800', '12280.20', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10373, 'HUNGO', 1, 4, '1996-12-05', '1997-01-02', '1996-12-11', 3, '124.1200', '1707.60', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10374, 'WOLZA', 1, 1, '1996-12-05', '1997-01-02', '1996-12-09', 3, '3.9400', '459.00', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10375, 'HUNGC', 1, 3, '1996-12-06', '1997-01-03', '1996-12-09', 2, '20.1200', '338.00', 'Hugo Lobo Importacao', 'AV. Otacilo Azevedo, 2397', 'Manaus', 'AM', '97827', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10376, 'MEREP', 1, 1, '1996-12-09', '1997-01-06', '1996-12-13', 2, '20.3900', '419.95', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10377, 'SEVES', 1, 1, '1996-12-09', '1997-01-06', '1996-12-13', 3, '22.2100', '1015.70', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10378, 'FOLKO', 1, 5, '1996-12-10', '1997-01-07', '1996-12-19', 3, '5.4400', '103.20', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10379, 'QUEDE', 1, 2, '1996-12-11', '1997-01-08', '1996-12-13', 1, '45.0300', '958.90', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10380, 'HUNGO', 1, 8, '1996-12-12', '1997-01-09', '1997-01-16', 3, '35.0300', '1419.50', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10381, 'LILAS', 1, 3, '1996-12-12', '1997-01-09', '1996-12-13', 3, '7.9900', '112.00', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10382, 'ERNSH', 1, 4, '1996-12-13', '1997-01-10', '1996-12-16', 1, '94.7700', '2900.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10383, 'AROUT', 1, 8, '1996-12-16', '1997-01-13', '1996-12-18', 3, '34.2400', '899.00', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10384, 'BERGS', 1, 3, '1996-12-16', '1997-01-13', '1996-12-20', 3, '168.6400', '2222.40', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10385, 'SPLIR', 1, 1, '1996-12-17', '1997-01-14', '1996-12-23', 2, '30.9600', '863.40', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10386, 'FAMIA', 1, 9, '1996-12-18', '1997-01-01', '1996-12-25', 3, '13.9900', '166.00', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10387, 'SANTG', 1, 1, '1996-12-18', '1997-01-15', '1996-12-20', 2, '93.6300', '1058.40', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10388, 'SEVES', 1, 2, '1996-12-19', '1997-01-16', '1996-12-20', 1, '34.8600', '1273.60', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10389, 'BOTTM', 1, 4, '1996-12-20', '1997-01-17', '1996-12-24', 2, '47.4200', '1832.80', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10390, 'ERNSH', 1, 6, '1996-12-23', '1997-01-20', '1996-12-26', 1, '126.3800', '2274.90', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10391, 'DRACD', 1, 3, '1996-12-23', '1997-01-20', '1996-12-31', 3, '5.4500', '86.40', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10392, 'PICCO', 1, 2, '1996-12-24', '1997-01-21', '1997-01-01', 3, '122.4600', '1440.00', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10393, 'SAVEA', 1, 1, '1996-12-25', '1997-01-22', '1997-01-03', 3, '126.5600', '3301.60', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10394, 'HUNGC', 1, 1, '1996-12-25', '1997-01-22', '1997-01-03', 3, '30.3400', '442.00', 'Hugo Lobo Importacao', 'AV. Otacilo Azevedo, 2397', 'Manaus', 'AM', '97827', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10395, 'HILAA', 1, 6, '1996-12-26', '1997-01-23', '1997-01-03', 1, '184.4100', '2333.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10396, 'FRANK', 1, 1, '1996-12-27', '1997-01-10', '1997-01-06', 3, '135.3500', '1903.80', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10397, 'PRINI', 1, 5, '1996-12-27', '1997-01-24', '1997-01-02', 1, '60.2600', '842.90', 'Princesa Isabel Vinhos', 'R. Dr. Antonio de Castro, 160', 'Sao Paulo', 'SP', '1756', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10398, 'SAVEA', 1, 2, '1996-12-30', '1997-01-27', '1997-01-09', 3, '89.1600', '2735.90', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10399, 'VAFFE', 1, 8, '1996-12-31', '1997-01-14', '1997-01-08', 3, '27.3600', '1765.60', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10400, 'EASTC', 1, 1, '1997-01-01', '1997-01-29', '1997-01-16', 3, '83.9300', '3063.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10401, 'RATTC', 1, 1, '1997-01-01', '1997-01-29', '1997-01-10', 1, '12.5100', '3868.60', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10402, 'ERNSH', 1, 8, '1997-01-02', '1997-02-13', '1997-01-10', 2, '67.8800', '2713.50', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10403, 'ERNSH', 1, 4, '1997-01-03', '1997-01-31', '1997-01-09', 3, '73.7900', '1005.60', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10404, 'MAGAA', 1, 2, '1997-01-03', '1997-01-31', '1997-01-08', 1, '155.9700', '1674.85', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10405, 'LINOD', 1, 1, '1997-01-06', '1997-02-03', '1997-01-22', 1, '34.8200', '400.00', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10406, 'QUEEN', 1, 7, '1997-01-07', '1997-02-18', '1997-01-13', 1, '108.0400', '2017.80', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10407, 'OTTIK', 1, 2, '1997-01-07', '1997-02-04', '1997-01-30', 2, '91.4800', '1194.00', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10408, 'FOLIG', 1, 8, '1997-01-08', '1997-02-05', '1997-01-14', 1, '11.2600', '1622.40', 'Forte e Alimentado', 'R. Olimpio Tauares , 97', 'Sao Paulo', 'SP', '59000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10409, 'OCEAN', 1, 3, '1997-01-09', '1997-02-06', '1997-01-14', 1, '29.8300', '319.20', 'Ocano Atlntico Ltda.', 'R. Ferreira Lopes, 414', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10410, 'BOTTM', 1, 3, '1997-01-10', '1997-02-07', '1997-01-15', 3, '2.4000', '802.00', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10411, 'BOTTM', 1, 9, '1997-01-10', '1997-02-07', '1997-01-21', 3, '23.6500', '1207.90', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10412, 'WARTH', 1, 8, '1997-01-13', '1997-02-10', '1997-01-15', 2, '3.7700', '371.90', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10413, 'LAMAI', 1, 3, '1997-01-14', '1997-02-11', '1997-01-16', 2, '95.6600', '2123.20', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10414, 'FAMIA', 1, 2, '1997-01-14', '1997-02-11', '1997-01-17', 3, '21.4800', '231.35', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10415, 'HUNGC', 1, 3, '1997-01-15', '1997-02-12', '1997-01-24', 1, '0.2000', '102.40', 'Hugo Lobo Importacao', 'AV. Otacilo Azevedo, 2397', 'Manaus', 'AM', '97827', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10416, 'WARTH', 1, 8, '1997-01-16', '1997-02-13', '1997-01-27', 3, '22.7200', '720.00', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10417, 'SIMOB', 1, 4, '1997-01-16', '1997-02-13', '1997-01-28', 3, '70.2900', '11282.70', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10418, 'QUICK', 1, 4, '1997-01-17', '1997-02-14', '1997-01-24', 1, '17.5500', '1814.80', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10419, 'RICSU', 1, 4, '1997-01-20', '1997-02-17', '1997-01-30', 2, '137.3500', '2207.90', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10420, 'WELLI', 1, 3, '1997-01-21', '1997-02-18', '1997-01-27', 1, '44.1200', '1897.20', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10421, 'QUEDE', 1, 8, '1997-01-21', '1997-03-04', '1997-01-27', 1, '99.2300', '1272.75', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10422, 'FRANS', 1, 2, '1997-01-22', '1997-02-19', '1997-01-31', 1, '3.0200', '49.80', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10423, 'GOURL', 1, 6, '1997-01-23', '1997-02-06', '1997-02-24', 3, '24.5000', '1020.00', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10424, 'MEREP', 1, 7, '1997-01-23', '1997-02-20', '1997-01-27', 2, '370.6100', '11492.60', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10425, 'LAMAI', 1, 6, '1997-01-24', '1997-02-21', '1997-02-14', 2, '7.9300', '479.50', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10426, 'GALED', 1, 4, '1997-01-27', '1997-02-24', '1997-02-06', 1, '18.6900', '338.20', 'Galera do Gastronomo', 'R. Major Nereu  Guerra, 131', 'Porto Velho', 'RO', '08022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10427, 'PICCO', 1, 4, '1997-01-27', '1997-02-24', '1997-03-03', 2, '31.2900', '651.00', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10428, 'REGGC', 1, 7, '1997-01-28', '1997-02-25', '1997-02-04', 1, '11.0900', '192.00', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10429, 'HUNGO', 1, 3, '1997-01-29', '1997-03-12', '1997-02-07', 2, '56.6300', '1748.25', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10430, 'ERNSH', 1, 4, '1997-01-30', '1997-02-13', '1997-02-03', 1, '458.7800', '5795.60', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10431, 'BOTTM', 1, 4, '1997-01-30', '1997-02-13', '1997-02-07', 2, '44.1700', '2522.25', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10432, 'SPLIR', 1, 3, '1997-01-31', '1997-02-14', '1997-02-07', 2, '4.3400', '485.00', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10433, 'PRINI', 1, 3, '1997-02-03', '1997-03-03', '1997-03-04', 3, '73.8300', '851.20', 'Princesa Isabel Vinhos', 'R. Dr. Antonio de Castro, 160', 'Sao Paulo', 'SP', '1756', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10434, 'FOLKO', 1, 3, '1997-02-03', '1997-03-03', '1997-02-13', 2, '17.9200', '359.85', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10435, 'CONSH', 1, 8, '1997-02-04', '1997-03-18', '1997-02-07', 2, '9.2100', '631.60', 'Consolidados Bom Apetite', 'R. Raimundo Freixeira, 163', 'Recife', 'PE', 'WX1 6LT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10436, 'BLONP', 1, 3, '1997-02-05', '1997-03-05', '1997-02-11', 2, '156.6600', '2210.50', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10437, 'WARTH', 1, 8, '1997-02-05', '1997-03-05', '1997-02-12', 1, '19.9700', '393.00', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10438, 'TOMSP', 1, 3, '1997-02-06', '1997-03-06', '1997-02-14', 2, '8.2400', '566.90', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10439, 'MEREP', 1, 6, '1997-02-07', '1997-03-07', '1997-02-10', 3, '4.0700', '1078.00', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10440, 'SAVEA', 1, 4, '1997-02-10', '1997-03-10', '1997-02-28', 2, '86.5300', '5792.50', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10441, 'OLDWO', 1, 3, '1997-02-10', '1997-03-24', '1997-03-14', 2, '73.0200', '1755.00', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10442, 'ERNSH', 1, 3, '1997-02-11', '1997-03-11', '1997-02-18', 2, '47.9400', '1792.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10443, 'REGGC', 1, 8, '1997-02-12', '1997-03-12', '1997-02-14', 1, '13.9500', '537.40', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10444, 'BERGS', 1, 3, '1997-02-12', '1997-03-12', '1997-02-21', 3, '3.5000', '1031.70', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10445, 'BERGS', 1, 3, '1997-02-13', '1997-03-13', '1997-02-20', 1, '9.3000', '174.90', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10446, 'TOMSP', 1, 6, '1997-02-14', '1997-03-14', '1997-02-19', 1, '14.6800', '273.20', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10447, 'RICAR', 1, 4, '1997-02-14', '1997-03-14', '1997-03-07', 2, '68.6600', '914.40', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10448, 'RANCH', 1, 4, '1997-02-17', '1997-03-17', '1997-02-24', 2, '38.8200', '443.40', 'Rancho grande', 'R. Dona Ana Xavier, 60 Lj 05', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10449, 'BLONP', 1, 3, '1997-02-18', '1997-03-18', '1997-02-27', 2, '53.3000', '1838.20', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10450, 'VICTE', 1, 8, '1997-02-19', '1997-03-19', '1997-03-11', 2, '7.2300', '531.00', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10451, 'QUICK', 1, 4, '1997-02-19', '1997-03-05', '1997-03-12', 3, '189.0900', '4277.00', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10452, 'SAVEA', 1, 8, '1997-02-20', '1997-03-20', '1997-02-26', 1, '140.2600', '2095.95', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10453, 'AROUT', 1, 1, '1997-02-21', '1997-03-21', '1997-02-26', 2, '25.3600', '452.80', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10454, 'LAMAI', 1, 4, '1997-02-21', '1997-03-21', '1997-02-25', 3, '2.7400', '413.40', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10455, 'WARTH', 1, 8, '1997-02-24', '1997-04-07', '1997-03-03', 2, '180.4500', '2684.00', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10456, 'KOENE', 1, 8, '1997-02-25', '1997-04-08', '1997-02-28', 2, '8.1200', '655.70', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10457, 'KOENE', 1, 2, '1997-02-25', '1997-03-25', '1997-03-03', 1, '11.5700', '1584.00', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10458, 'SUPRD', 1, 7, '1997-02-26', '1997-03-26', '1997-03-04', 3, '147.0600', '3891.00', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10459, 'VICTE', 1, 4, '1997-02-27', '1997-03-27', '1997-02-28', 2, '25.0900', '1687.90', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10460, 'FOLKO', 1, 8, '1997-02-28', '1997-03-28', '1997-03-03', 1, '16.2700', '234.30', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10461, 'LILAS', 1, 1, '1997-02-28', '1997-03-28', '1997-03-05', 3, '148.6100', '2050.85', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10462, 'CONSH', 1, 2, '1997-03-03', '1997-03-31', '1997-03-18', 1, '6.1700', '156.00', 'Consolidados Bom Apetite', 'R. Raimundo Freixeira, 163', 'Recife', 'PE', 'WX1 6LT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10463, 'SUPRD', 1, 5, '1997-03-04', '1997-04-01', '1997-03-06', 3, '14.7800', '713.30', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10464, 'FURIB', 1, 4, '1997-03-04', '1997-04-01', '1997-03-14', 2, '89.0000', '1847.60', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10465, 'VAFFE', 1, 1, '1997-03-05', '1997-04-02', '1997-03-14', 3, '145.0400', '2718.80', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10466, 'COMMI', 1, 4, '1997-03-06', '1997-04-03', '1997-03-13', 1, '11.9300', '216.00', 'Comrcio Mineiro', 'R. Alfredo Gama, 14', 'Goiana', 'GO', '05432-043', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10467, 'MAGAA', 1, 8, '1997-03-06', '1997-04-03', '1997-03-11', 2, '4.9300', '235.20', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10468, 'KOENE', 1, 3, '1997-03-07', '1997-04-04', '1997-03-12', 3, '44.1200', '717.60', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10469, 'WHITC', 1, 1, '1997-03-10', '1997-04-07', '1997-03-14', 1, '60.1800', '1125.05', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10470, 'BONAP', 1, 4, '1997-03-11', '1997-04-08', '1997-03-14', 2, '64.5600', '1820.80', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10471, 'BSBEV', 1, 2, '1997-03-11', '1997-04-08', '1997-03-18', 3, '45.5900', '1328.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10472, 'SEVES', 1, 8, '1997-03-12', '1997-04-09', '1997-03-19', 1, '4.2000', '1051.15', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10473, 'ISLAT', 1, 1, '1997-03-13', '1997-03-27', '1997-03-21', 3, '16.3700', '230.40', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10474, 'PERIC', 1, 5, '1997-03-13', '1997-04-10', '1997-03-21', 2, '83.4900', '1249.10', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10475, 'SUPRD', 1, 9, '1997-03-14', '1997-04-11', '1997-04-04', 1, '68.5200', '1770.35', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10476, 'HILAA', 1, 8, '1997-03-17', '1997-04-14', '1997-03-24', 3, '4.4100', '182.35', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10477, 'PRINI', 1, 5, '1997-03-17', '1997-04-14', '1997-03-25', 2, '13.0200', '671.50', 'Princesa Isabel Vinhos', 'R. Dr. Antonio de Castro, 160', 'Sao Paulo', 'SP', '1756', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10478, 'VICTE', 1, 2, '1997-03-18', '1997-04-01', '1997-03-26', 3, '4.8100', '495.95', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10479, 'RATTC', 1, 3, '1997-03-19', '1997-04-16', '1997-03-21', 3, '708.9500', '10495.60', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10480, 'FOLIG', 1, 6, '1997-03-20', '1997-04-17', '1997-03-24', 2, '1.3500', '756.00', 'Forte e Alimentado', 'R. Olimpio Tauares , 97', 'Sao Paulo', 'SP', '59000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10481, 'RICAR', 1, 8, '1997-03-20', '1997-04-17', '1997-03-25', 2, '64.3300', '1472.00', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10482, 'LAZYK', 1, 1, '1997-03-21', '1997-04-18', '1997-04-10', 3, '7.4800', '147.00', 'Lazer Lojas Associadas', 'Av. Felicino Dourado, 98', 'Macap', 'AP', '99362', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10483, 'WHITC', 1, 7, '1997-03-24', '1997-04-21', '1997-04-25', 2, '15.2800', '703.90', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10484, 'BSBEV', 1, 3, '1997-03-24', '1997-04-21', '1997-04-01', 3, '6.8800', '386.20', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10485, 'LINOD', 1, 4, '1997-03-25', '1997-04-08', '1997-03-31', 2, '64.4500', '1759.60', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10486, 'HILAA', 1, 1, '1997-03-26', '1997-04-23', '1997-04-02', 2, '30.5300', '1272.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10487, 'QUEEN', 1, 2, '1997-03-26', '1997-04-23', '1997-03-28', 2, '71.0700', '924.85', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10488, 'FRANK', 1, 8, '1997-03-27', '1997-04-24', '1997-04-02', 2, '4.9300', '1559.80', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10489, 'PICCO', 1, 6, '1997-03-28', '1997-04-25', '1997-04-09', 2, '5.2900', '501.95', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10490, 'HILAA', 1, 7, '1997-03-31', '1997-04-28', '1997-04-03', 2, '210.1900', '3163.20', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10491, 'FURIB', 1, 8, '1997-03-31', '1997-04-28', '1997-04-08', 3, '16.9600', '305.00', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10492, 'BOTTM', 1, 3, '1997-04-01', '1997-04-29', '1997-04-11', 1, '62.8900', '895.90', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10493, 'LAMAI', 1, 4, '1997-04-02', '1997-04-30', '1997-04-10', 3, '10.6400', '675.70', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10494, 'COMMI', 1, 4, '1997-04-02', '1997-04-30', '1997-04-09', 2, '65.9900', '912.00', 'Comrcio Mineiro', 'R. Alfredo Gama, 14', 'Goiana', 'GO', '05432-043', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10495, 'LAUGB', 1, 3, '1997-04-03', '1997-05-01', '1997-04-11', 3, '4.6500', '278.00', 'Lourival  Vinhos & CIA', 'R. barao de granito, 54', 'Macap', 'AP', 'V3F 2K1', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10496, 'TRADH', 1, 7, '1997-04-04', '1997-05-02', '1997-04-07', 2, '46.7700', '199.95', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10497, 'LEHMS', 1, 7, '1997-04-04', '1997-05-02', '1997-04-07', 1, '36.2100', '1380.60', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10498, 'HILAA', 1, 8, '1997-04-07', '1997-05-05', '1997-04-11', 2, '29.7500', '575.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10499, 'LILAS', 1, 4, '1997-04-08', '1997-05-06', '1997-04-16', 2, '102.0200', '1412.00', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10500, 'LAMAI', 1, 6, '1997-04-09', '1997-05-07', '1997-04-17', 1, '42.6800', '550.70', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10501, 'BLAUS', 1, 9, '1997-04-09', '1997-05-07', '1997-04-16', 3, '8.8500', '149.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10502, 'PERIC', 1, 2, '1997-04-10', '1997-05-08', '1997-04-29', 1, '69.3200', '816.30', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10503, 'HUNGO', 1, 6, '1997-04-11', '1997-05-09', '1997-04-16', 2, '16.7400', '2048.50', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10504, 'WHITC', 1, 4, '1997-04-11', '1997-05-09', '1997-04-18', 3, '59.1300', '1388.50', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10505, 'MEREP', 1, 3, '1997-04-14', '1997-05-12', '1997-04-21', 3, '7.1300', '147.90', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10506, 'KOENE', 1, 9, '1997-04-15', '1997-05-13', '1997-05-02', 2, '21.1900', '461.80', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10507, 'ANTON', 1, 7, '1997-04-15', '1997-05-13', '1997-04-22', 1, '47.4500', '880.95', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10508, 'OTTIK', 1, 1, '1997-04-16', '1997-05-14', '1997-05-13', 2, '4.9900', '240.00', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10509, 'BLAUS', 1, 4, '1997-04-17', '1997-05-15', '1997-04-29', 1, '0.1500', '136.80', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10510, 'SAVEA', 1, 6, '1997-04-18', '1997-05-16', '1997-04-28', 3, '367.6300', '4735.34', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10511, 'BONAP', 1, 4, '1997-04-18', '1997-05-16', '1997-04-21', 3, '350.6400', '2999.55', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10512, 'FAMIA', 1, 7, '1997-04-21', '1997-05-19', '1997-04-24', 2, '3.5300', '617.40', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10513, 'WANDK', 1, 7, '1997-04-22', '1997-06-03', '1997-04-28', 1, '105.6500', '2426.90', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10514, 'ERNSH', 1, 3, '1997-04-22', '1997-05-20', '1997-05-16', 2, '789.9500', '8623.45', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10515, 'QUICK', 1, 2, '1997-04-23', '1997-05-07', '1997-05-23', 1, '204.4700', '10588.05', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10516, 'HUNGO', 1, 2, '1997-04-24', '1997-05-22', '1997-05-01', 3, '62.7800', '2614.30', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10517, 'NORTS', 1, 3, '1997-04-24', '1997-05-22', '1997-04-29', 3, '32.0700', '352.00', 'Norte/Sul Ltda', 'R. General Meira Barreto, 63', 'Recife', 'PE', 'SW7 1RZ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10518, 'TORTU', 1, 4, '1997-04-25', '1997-05-09', '1997-05-05', 2, '218.1500', '4150.05', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10519, 'CHOPS', 1, 6, '1997-04-28', '1997-05-26', '1997-05-01', 3, '91.7600', '2355.90', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10520, 'SANTG', 1, 7, '1997-04-29', '1997-05-27', '1997-05-01', 1, '13.3700', '200.00', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10521, 'CACTU', 1, 8, '1997-04-29', '1997-05-27', '1997-05-02', 2, '17.2200', '225.50', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10522, 'LEHMS', 1, 4, '1997-04-30', '1997-05-28', '1997-05-06', 1, '45.3300', '2657.20', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10523, 'SEVES', 1, 7, '1997-05-01', '1997-05-29', '1997-05-30', 2, '77.6300', '2715.50', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10524, 'BERGS', 1, 1, '1997-05-01', '1997-05-29', '1997-05-07', 2, '244.7900', '3192.65', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10525, 'BONAP', 1, 1, '1997-05-02', '1997-05-30', '1997-05-23', 2, '11.0600', '845.90', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10526, 'WARTH', 1, 4, '1997-05-05', '1997-06-02', '1997-05-15', 2, '58.5900', '1343.70', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10527, 'QUICK', 1, 7, '1997-05-05', '1997-06-02', '1997-05-07', 1, '41.9000', '1669.80', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10528, 'GREAL', 1, 6, '1997-05-06', '1997-05-20', '1997-05-09', 2, '3.3500', '396.00', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10529, 'MAISD', 1, 5, '1997-05-07', '1997-06-04', '1997-05-09', 2, '66.6900', '946.00', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10530, 'PICCO', 1, 3, '1997-05-08', '1997-06-05', '1997-05-12', 2, '339.2200', '4180.00', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10531, 'OCEAN', 1, 7, '1997-05-08', '1997-06-05', '1997-05-19', 1, '8.1200', '110.00', 'Ocano Atlntico Ltda.', 'R. Ferreira Lopes, 414', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10532, 'EASTC', 1, 7, '1997-05-09', '1997-06-06', '1997-05-12', 3, '74.4600', '796.35', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10533, 'FOLKO', 1, 8, '1997-05-12', '1997-06-09', '1997-05-22', 1, '188.0400', '2295.10', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10534, 'LEHMS', 1, 8, '1997-05-12', '1997-06-09', '1997-05-14', 2, '27.9400', '517.00', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10535, 'ANTON', 1, 4, '1997-05-13', '1997-06-10', '1997-05-21', 1, '15.6400', '2156.10', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10536, 'LEHMS', 1, 3, '1997-05-14', '1997-06-11', '1997-06-06', 2, '58.8800', '2084.50', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10537, 'RICSU', 1, 1, '1997-05-14', '1997-05-28', '1997-05-19', 1, '78.8500', '1823.80', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10538, 'BSBEV', 1, 9, '1997-05-15', '1997-06-12', '1997-05-16', 3, '4.8700', '139.80', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10539, 'BSBEV', 1, 6, '1997-05-16', '1997-06-13', '1997-05-23', 3, '12.3600', '355.50', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10540, 'QUICK', 1, 3, '1997-05-19', '1997-06-16', '1997-06-13', 3, '1007.6400', '10191.70', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10541, 'HANAR', 1, 2, '1997-05-19', '1997-06-16', '1997-05-29', 1, '68.6500', '2162.40', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10542, 'KOENE', 1, 1, '1997-05-20', '1997-06-17', '1997-05-26', 3, '10.9500', '493.70', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10543, 'LILAS', 1, 8, '1997-05-21', '1997-06-18', '1997-05-23', 2, '48.1700', '1769.70', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10544, 'LONEP', 1, 4, '1997-05-21', '1997-06-18', '1997-05-30', 1, '24.9100', '417.20', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10545, 'LAZYK', 1, 8, '1997-05-22', '1997-06-19', '1997-06-26', 2, '11.9200', '210.00', 'Lazer Lojas Associadas', 'Av. Felicino Dourado, 98', 'Macap', 'AP', '99362', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10546, 'VICTE', 1, 1, '1997-05-23', '1997-06-20', '1997-05-27', 3, '194.7200', '2812.00', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10547, 'SEVES', 1, 3, '1997-05-23', '1997-06-20', '1997-06-02', 2, '178.4300', '1907.85', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10548, 'TOMSP', 1, 3, '1997-05-26', '1997-06-23', '1997-06-02', 2, '1.4300', '274.85', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10549, 'QUICK', 1, 5, '1997-05-27', '1997-06-10', '1997-05-30', 1, '171.2400', '4181.05', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10550, 'GODOS', 1, 7, '1997-05-28', '1997-06-25', '1997-06-06', 3, '4.3200', '748.70', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10551, 'FURIB', 1, 4, '1997-05-28', '1997-07-09', '1997-06-06', 3, '72.9500', '1835.70', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10552, 'HILAA', 1, 2, '1997-05-29', '1997-06-26', '1997-06-05', 1, '83.2200', '880.50', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10553, 'WARTH', 1, 2, '1997-05-30', '1997-06-27', '1997-06-03', 2, '149.4900', '1546.30', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10554, 'OTTIK', 1, 4, '1997-05-30', '1997-06-27', '1997-06-05', 3, '120.9700', '1819.30', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10555, 'SAVEA', 1, 6, '1997-06-02', '1997-06-30', '1997-06-04', 3, '252.4900', '3679.50', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10556, 'SIMOB', 1, 2, '1997-06-03', '1997-07-15', '1997-06-13', 1, '9.8000', '835.20', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10557, 'LEHMS', 1, 9, '1997-06-03', '1997-06-17', '1997-06-06', 2, '96.7200', '1152.50', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10558, 'AROUT', 1, 1, '1997-06-04', '1997-07-02', '1997-06-10', 2, '72.9700', '2142.90', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10559, 'BLONP', 1, 6, '1997-06-05', '1997-07-03', '1997-06-13', 1, '8.0500', '547.70', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10560, 'FRANK', 1, 8, '1997-06-06', '1997-07-04', '1997-06-09', 1, '36.6500', '1257.05', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10561, 'FOLKO', 1, 2, '1997-06-06', '1997-07-04', '1997-06-09', 2, '242.2100', '2844.50', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10562, 'REGGC', 1, 1, '1997-06-09', '1997-07-07', '1997-06-12', 1, '22.9500', '542.80', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10563, 'RICAR', 1, 2, '1997-06-10', '1997-07-22', '1997-06-24', 2, '60.4300', '965.00', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10564, 'RATTC', 1, 4, '1997-06-10', '1997-07-08', '1997-06-16', 3, '13.7500', '1298.85', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10565, 'MEREP', 1, 8, '1997-06-11', '1997-07-09', '1997-06-18', 2, '7.1500', '710.80', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10566, 'BLONP', 1, 9, '1997-06-12', '1997-07-10', '1997-06-18', 1, '88.4000', '2039.70', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10567, 'HUNGO', 1, 1, '1997-06-12', '1997-07-10', '1997-06-17', 1, '33.9700', '3108.60', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10568, 'GALED', 1, 3, '1997-06-13', '1997-07-11', '1997-07-09', 3, '6.5400', '155.00', 'Galera do Gastronomo', 'R. Major Nereu  Guerra, 131', 'Porto Velho', 'RO', '08022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10569, 'RATTC', 1, 5, '1997-06-16', '1997-07-14', '1997-07-11', 1, '58.9800', '977.30', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10570, 'MEREP', 1, 3, '1997-06-17', '1997-07-15', '1997-06-19', 3, '188.9900', '2594.90', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10571, 'ERNSH', 1, 8, '1997-06-17', '1997-07-29', '1997-07-04', 3, '26.0600', '647.45', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10572, 'BERGS', 1, 3, '1997-06-18', '1997-07-16', '1997-06-25', 2, '116.4300', '1565.35', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10573, 'ANTON', 1, 7, '1997-06-19', '1997-07-17', '1997-06-20', 3, '84.8400', '2082.00', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10574, 'TRAIH', 1, 4, '1997-06-19', '1997-07-17', '1997-06-30', 2, '37.6000', '764.30', 'Tereza Bebidas e Comidas', 'R. Jose de Holanda, 561', 'Campo Grande', 'MS', '98034', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10575, 'MORGK', 1, 5, '1997-06-20', '1997-07-04', '1997-06-30', 1, '127.3400', '2147.40', 'Miramar Comercio Ltda', 'R. Guimaraes  Peixoto,  405', 'Porto Alegre', 'RS', '04179', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10576, 'TORTU', 1, 3, '1997-06-23', '1997-07-07', '1997-06-30', 3, '18.5600', '838.45', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10577, 'TRAIH', 1, 9, '1997-06-23', '1997-08-04', '1997-06-30', 2, '25.4100', '569.00', 'Tereza Bebidas e Comidas', 'R. Jose de Holanda, 561', 'Campo Grande', 'MS', '98034', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10578, 'BSBEV', 1, 4, '1997-06-24', '1997-07-22', '1997-07-25', 3, '29.6000', '477.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10579, 'LETSS', 1, 1, '1997-06-25', '1997-07-23', '1997-07-04', 2, '13.7300', '317.75', 'Ligao Parada Obrigatoria', 'R. Bacuri, 158', 'Rio Branco', 'AC', '94117', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10580, 'OTTIK', 1, 4, '1997-06-26', '1997-07-24', '1997-07-01', 3, '75.8900', '1066.95', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10581, 'FAMIA', 1, 3, '1997-06-26', '1997-07-24', '1997-07-02', 1, '3.0100', '387.30', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10582, 'BLAUS', 1, 3, '1997-06-27', '1997-07-25', '1997-07-14', 2, '27.7100', '330.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10583, 'WARTH', 1, 2, '1997-06-30', '1997-07-28', '1997-07-04', 2, '7.2800', '2413.60', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10584, 'BLONP', 1, 4, '1997-06-30', '1997-07-28', '1997-07-04', 1, '59.1400', '624.95', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10585, 'WELLI', 1, 7, '1997-07-01', '1997-07-29', '1997-07-10', 1, '13.4100', '142.50', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10586, 'REGGC', 1, 9, '1997-07-02', '1997-07-30', '1997-07-09', 1, '0.4800', '27.85', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10587, 'QUEDE', 1, 1, '1997-07-02', '1997-07-30', '1997-07-09', 1, '62.5200', '807.38', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10588, 'QUICK', 1, 2, '1997-07-03', '1997-07-31', '1997-07-10', 3, '194.6700', '3899.60', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10589, 'GREAL', 1, 8, '1997-07-04', '1997-08-01', '1997-07-14', 2, '4.4200', '72.00', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10590, 'MEREP', 1, 4, '1997-07-07', '1997-08-04', '1997-07-14', 3, '44.7700', '1139.95', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10591, 'VAFFE', 1, 1, '1997-07-07', '1997-07-21', '1997-07-16', 1, '55.9200', '812.50', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10592, 'LEHMS', 1, 3, '1997-07-08', '1997-08-05', '1997-07-16', 1, '32.1000', '543.55', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10593, 'LEHMS', 1, 7, '1997-07-09', '1997-08-06', '1997-08-13', 2, '174.2000', '2492.40', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10594, 'OLDWO', 1, 3, '1997-07-09', '1997-08-06', '1997-07-16', 2, '5.2400', '565.50', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10595, 'ERNSH', 1, 2, '1997-07-10', '1997-08-07', '1997-07-14', 1, '96.7800', '6299.25', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10596, 'WHITC', 1, 8, '1997-07-11', '1997-08-08', '1997-08-12', 1, '16.3400', '1475.50', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10597, 'PICCO', 1, 7, '1997-07-11', '1997-08-08', '1997-07-18', 3, '35.1200', '799.70', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10598, 'RATTC', 1, 1, '1997-07-14', '1997-08-11', '1997-07-18', 3, '44.4200', '2388.50', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10599, 'BSBEV', 1, 6, '1997-07-15', '1997-08-26', '1997-07-21', 3, '29.9800', '493.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10600, 'HUNGC', 1, 4, '1997-07-16', '1997-08-13', '1997-07-21', 1, '45.1300', '479.80', 'Hugo Lobo Importacao', 'AV. Otacilo Azevedo, 2397', 'Manaus', 'AM', '97827', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10601, 'HILAA', 1, 7, '1997-07-16', '1997-08-27', '1997-07-22', 1, '58.3000', '2285.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10602, 'VAFFE', 1, 8, '1997-07-17', '1997-08-14', '1997-07-22', 2, '2.9200', '64.75', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10603, 'SAVEA', 1, 8, '1997-07-18', '1997-08-15', '1997-08-08', 2, '48.7700', '1507.95', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10604, 'FURIB', 1, 1, '1997-07-18', '1997-08-15', '1997-07-29', 1, '7.4600', '256.30', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10605, 'MEREP', 1, 1, '1997-07-21', '1997-08-18', '1997-07-29', 2, '379.1300', '4325.80', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10606, 'TRADH', 1, 4, '1997-07-22', '1997-08-19', '1997-07-31', 3, '79.4000', '1412.40', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10607, 'SAVEA', 1, 5, '1997-07-22', '1997-08-19', '1997-07-25', 1, '200.2400', '6475.40', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10608, 'TOMSP', 1, 4, '1997-07-23', '1997-08-20', '1997-08-01', 2, '27.7900', '1064.00', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10609, 'DUMON', 1, 7, '1997-07-24', '1997-08-21', '1997-07-30', 2, '1.8500', '424.00', 'O Mundo Inteiro', 'R. Pedro Allain, 125 Casa.34', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10610, 'LAMAI', 1, 8, '1997-07-25', '1997-08-22', '1997-08-06', 1, '26.7800', '398.75', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10611, 'WOLZA', 1, 6, '1997-07-25', '1997-08-22', '1997-08-01', 2, '80.6500', '808.00', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10612, 'SAVEA', 1, 1, '1997-07-28', '1997-08-25', '1997-08-01', 2, '544.0800', '6375.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10613, 'HILAA', 1, 4, '1997-07-29', '1997-08-26', '1997-08-01', 2, '8.1100', '357.90', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10614, 'BLAUS', 1, 8, '1997-07-29', '1997-08-26', '1997-08-01', 3, '1.9300', '464.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10615, 'WILMK', 1, 2, '1997-07-30', '1997-08-27', '1997-08-06', 3, '0.7500', '120.00', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10616, 'GREAL', 1, 1, '1997-07-31', '1997-08-28', '1997-08-05', 2, '116.5300', '5031.85', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10617, 'GREAL', 1, 4, '1997-07-31', '1997-08-28', '1997-08-04', 2, '18.5300', '1649.85', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10618, 'MEREP', 1, 1, '1997-08-01', '1997-09-12', '1997-08-08', 1, '154.6800', '2697.50', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10619, 'MEREP', 1, 3, '1997-08-04', '1997-09-01', '1997-08-07', 3, '91.0500', '1260.00', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10620, 'LAUGB', 1, 2, '1997-08-05', '1997-09-02', '1997-08-14', 3, '0.9400', '57.50', 'Lourival  Vinhos & CIA', 'R. barao de granito, 54', 'Macap', 'AP', 'V3F 2K1', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10621, 'ISLAT', 1, 4, '1997-08-05', '1997-09-02', '1997-08-11', 2, '23.7300', '758.50', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10622, 'RICAR', 1, 4, '1997-08-06', '1997-09-03', '1997-08-11', 3, '50.9700', '604.80', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10623, 'FRANK', 1, 8, '1997-08-07', '1997-09-04', '1997-08-12', 2, '97.1800', '1429.45', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10624, 'THECR', 1, 4, '1997-08-07', '1997-09-04', '1997-08-19', 2, '94.8000', '1393.24', 'Tinoco Atacados em Geral', 'R.  Bento de Loyola, 88', 'Salvador', 'BH', '59801', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10625, NULL, 1, 3, '1997-08-08', '1997-09-05', '1997-08-14', 1, '43.9000', '479.75', 'Ana Rainha da Culinaria', 'R. Visconde de Taunay, 145', 'Fortaleza', 'CE', '05021', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10626, 'BERGS', 1, 1, '1997-08-11', '1997-09-08', '1997-08-20', 2, '138.6900', '1503.60', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10627, 'SAVEA', 1, 8, '1997-08-11', '1997-09-22', '1997-08-21', 3, '107.4600', '1264.35', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10628, 'BLONP', 1, 4, '1997-08-12', '1997-09-09', '1997-08-20', 3, '30.3600', '450.00', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10629, 'GODOS', 1, 4, '1997-08-12', '1997-09-09', '1997-08-20', 3, '85.4600', '2775.05', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10630, 'KOENE', 1, 1, '1997-08-13', '1997-09-10', '1997-08-19', 2, '32.3500', '917.95', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10631, 'LAMAI', 1, 8, '1997-08-14', '1997-09-11', '1997-08-15', 1, '0.8700', '61.90', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10632, 'WANDK', 1, 8, '1997-08-14', '1997-09-11', '1997-08-19', 1, '41.3800', '619.90', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10633, 'ERNSH', 1, 7, '1997-08-15', '1997-09-12', '1997-08-18', 3, '477.9000', '6482.45', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10634, 'FOLIG', 1, 4, '1997-08-15', '1997-09-12', '1997-08-21', 3, '487.3800', '4985.50', 'Forte e Alimentado', 'R. Olimpio Tauares , 97', 'Sao Paulo', 'SP', '59000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10635, 'MAGAA', 1, 8, '1997-08-18', '1997-09-15', '1997-08-21', 3, '47.4600', '1380.05', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10636, 'WARTH', 1, 4, '1997-08-19', '1997-09-16', '1997-08-26', 1, '1.1500', '629.50', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10637, 'QUEEN', 1, 6, '1997-08-19', '1997-09-16', '1997-08-26', 1, '201.2900', '2896.15', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10638, 'LINOD', 1, 3, '1997-08-20', '1997-09-17', '1997-09-01', 1, '158.4400', '2720.05', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10639, 'SANTG', 1, 7, '1997-08-20', '1997-09-17', '1997-08-27', 3, '38.6400', '500.00', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10640, 'WANDK', 1, 4, '1997-08-21', '1997-09-18', '1997-08-28', 1, '23.5500', '944.50', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10641, 'HILAA', 1, 4, '1997-08-22', '1997-09-19', '1997-08-26', 2, '179.6100', '2054.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10642, 'SIMOB', 1, 7, '1997-08-22', '1997-09-19', '1997-09-05', 3, '41.8900', '869.60', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10643, 'ALFKI', 1, 6, '1997-08-25', '1997-09-22', '1997-09-02', 1, '29.4600', '1085.25', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10644, 'WELLI', 1, 3, '1997-08-25', '1997-09-22', '1997-09-01', 2, '0.1400', '1421.80', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10645, 'HANAR', 1, 4, '1997-08-26', '1997-09-23', '1997-09-02', 1, '12.4100', '1535.00', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10646, 'HUNGO', 1, 9, '1997-08-27', '1997-10-08', '1997-09-03', 3, '142.3300', '1927.00', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10647, 'QUEDE', 1, 4, '1997-08-27', '1997-09-10', '1997-09-03', 2, '45.5400', '636.00', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10648, 'RICAR', 1, 5, '1997-08-28', '1997-10-09', '1997-09-09', 2, '14.2500', '382.35', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10649, 'MAISD', 1, 5, '1997-08-28', '1997-09-25', '1997-08-29', 3, '6.2000', '1434.00', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10650, 'FAMIA', 1, 5, '1997-08-29', '1997-09-26', '1997-09-03', 3, '176.8100', '1820.15', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10651, 'WANDK', 1, 8, '1997-09-01', '1997-09-29', '1997-09-11', 2, '20.6000', '529.90', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10652, 'GOURL', 1, 4, '1997-09-01', '1997-09-29', '1997-09-08', 2, '7.1400', '331.53', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10653, 'FRANK', 1, 1, '1997-09-02', '1997-09-30', '1997-09-19', 1, '93.2500', '1203.30', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10654, 'BERGS', 1, 5, '1997-09-02', '1997-09-30', '1997-09-11', 1, '55.2600', '668.40', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10655, 'REGGC', 1, 1, '1997-09-03', '1997-10-01', '1997-09-11', 2, '4.4100', '192.80', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10656, 'GREAL', 1, 6, '1997-09-04', '1997-10-02', '1997-09-10', 1, '57.1500', '671.05', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10657, 'SAVEA', 1, 2, '1997-09-04', '1997-10-02', '1997-09-15', 2, '352.6900', '4371.60', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10658, 'QUICK', 1, 4, '1997-09-05', '1997-10-03', '1997-09-08', 1, '364.1500', '4667.85', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10659, 'QUEEN', 1, 7, '1997-09-05', '1997-10-03', '1997-09-10', 2, '105.8100', '1291.45', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10660, 'HUNGC', 1, 8, '1997-09-08', '1997-10-06', '1997-10-15', 1, '111.2900', '1701.00', 'Hugo Lobo Importacao', 'AV. Otacilo Azevedo, 2397', 'Manaus', 'AM', '97827', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10661, 'HUNGO', 1, 7, '1997-09-09', '1997-10-07', '1997-09-15', 3, '17.5500', '702.85', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10662, 'LONEP', 1, 3, '1997-09-09', '1997-10-07', '1997-09-18', 2, '1.2800', '125.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10663, 'BONAP', 1, 2, '1997-09-10', '1997-09-24', '1997-10-03', 2, '113.1500', '2031.85', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10664, 'FURIB', 1, 1, '1997-09-10', '1997-10-08', '1997-09-19', 3, '1.2700', '1515.30', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10665, 'LONEP', 1, 1, '1997-09-11', '1997-10-09', '1997-09-17', 2, '26.3100', '1295.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10666, 'RICSU', 1, 7, '1997-09-12', '1997-10-10', '1997-09-22', 2, '232.4200', '4666.94', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10667, 'ERNSH', 1, 7, '1997-09-12', '1997-10-10', '1997-09-19', 1, '78.0900', '1920.60', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10668, 'WANDK', 1, 1, '1997-09-15', '1997-10-13', '1997-09-23', 2, '47.2200', '694.45', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10669, 'SIMOB', 1, 2, '1997-09-15', '1997-10-13', '1997-09-22', 1, '24.3900', '570.00', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10670, 'FRANK', 1, 4, '1997-09-16', '1997-10-14', '1997-09-18', 1, '203.4800', '2301.75', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10671, 'FRANR', 1, 1, '1997-09-17', '1997-10-15', '1997-09-24', 1, '30.3400', '920.10', 'Frances Restaurante', 'R. Motta Junior, 31', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10672, 'BERGS', 1, 9, '1997-09-17', '1997-10-01', '1997-09-26', 2, '95.7500', '4210.40', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10673, 'WILMK', 1, 2, '1997-09-18', '1997-10-16', '1997-09-19', 1, '22.7600', '412.35', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10674, 'ISLAT', 1, 4, '1997-09-18', '1997-10-16', '1997-09-30', 2, '0.9000', '45.00', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10675, 'FRANK', 1, 5, '1997-09-19', '1997-10-17', '1997-09-23', 2, '31.8500', '1423.00', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10676, 'TORTU', 1, 2, '1997-09-22', '1997-10-20', '1997-09-29', 2, '2.0100', '534.85', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10677, 'ANTON', 1, 1, '1997-09-22', '1997-10-20', '1997-09-26', 3, '4.0300', '956.60', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10678, 'SAVEA', 1, 7, '1997-09-23', '1997-10-21', '1997-10-16', 3, '388.9800', '5256.50', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10679, 'BLONP', 1, 8, '1997-09-23', '1997-10-21', '1997-09-30', 3, '27.9400', '660.00', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10680, 'OLDWO', 1, 1, '1997-09-24', '1997-10-22', '1997-09-26', 1, '26.6100', '1681.75', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10681, 'GREAL', 1, 3, '1997-09-25', '1997-10-23', '1997-09-30', 3, '76.1300', '1326.80', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10682, 'ANTON', 1, 3, '1997-09-25', '1997-10-23', '1997-10-01', 2, '36.1300', '375.50', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10683, 'DUMON', 1, 2, '1997-09-26', '1997-10-24', '1997-10-01', 1, '4.4000', '63.00', 'O Mundo Inteiro', 'R. Pedro Allain, 125 Casa.34', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10684, 'OTTIK', 1, 3, '1997-09-26', '1997-10-24', '1997-09-30', 1, '145.6300', '1768.00', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10685, 'GOURL', 1, 4, '1997-09-29', '1997-10-13', '1997-10-03', 2, '33.7500', '801.10', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10686, 'PICCO', 1, 2, '1997-09-30', '1997-10-28', '1997-10-08', 1, '96.5000', '1638.25', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10687, 'HUNGO', 1, 9, '1997-09-30', '1997-10-28', '1997-10-30', 2, '296.4300', '6201.40', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10688, 'VAFFE', 1, 4, '1997-10-01', '1997-10-15', '1997-10-07', 2, '299.0900', '3489.80', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10689, 'BERGS', 1, 1, '1997-10-01', '1997-10-29', '1997-10-07', 2, '13.4200', '629.75', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10690, 'HANAR', 1, 1, '1997-10-02', '1997-10-30', '1997-10-03', 1, '15.8000', '1149.50', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10691, 'QUICK', 1, 2, '1997-10-03', '1997-11-14', '1997-10-22', 2, '810.0500', '10164.80', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10692, 'ALFKI', 1, 4, '1997-10-03', '1997-10-31', '1997-10-13', 2, '61.0200', '878.00', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10693, 'WHITC', 1, 3, '1997-10-06', '1997-10-20', '1997-10-10', 3, '139.3400', '2333.55', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10694, 'QUICK', 1, 8, '1997-10-06', '1997-11-03', '1997-10-09', 3, '398.3600', '4825.00', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10695, 'WILMK', 1, 7, '1997-10-07', '1997-11-18', '1997-10-14', 1, '16.7200', '642.00', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10696, 'WHITC', 1, 8, '1997-10-08', '1997-11-19', '1997-10-14', 3, '102.5500', '996.00', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10697, 'LINOD', 1, 3, '1997-10-08', '1997-11-05', '1997-10-14', 1, '45.5200', '1072.90', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10698, 'ERNSH', 1, 4, '1997-10-09', '1997-11-06', '1997-10-17', 1, '272.4700', '3600.53', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10699, 'MORGK', 1, 3, '1997-10-09', '1997-11-06', '1997-10-13', 3, '0.5800', '114.00', 'Miramar Comercio Ltda', 'R. Guimaraes  Peixoto,  405', 'Porto Alegre', 'RS', '04179', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10700, 'SAVEA', 1, 3, '1997-10-10', '1997-11-07', '1997-10-16', 1, '65.1000', '2047.20', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10701, 'HUNGO', 1, 6, '1997-10-13', '1997-10-27', '1997-10-15', 3, '220.3100', '3369.55', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10702, 'ALFKI', 1, 4, '1997-10-13', '1997-11-24', '1997-10-21', 1, '23.9400', '330.00', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10703, 'FOLKO', 1, 6, '1997-10-14', '1997-11-11', '1997-10-20', 2, '152.3000', '2545.00', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10704, 'QUEEN', 1, 6, '1997-10-14', '1997-11-11', '1997-11-07', 1, '4.7800', '595.50', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10705, 'HILAA', 1, 9, '1997-10-15', '1997-11-12', '1997-11-18', 2, '3.5200', '378.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10706, 'OLDWO', 1, 8, '1997-10-16', '1997-11-13', '1997-10-21', 3, '135.6300', '1893.00', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10707, 'AROUT', 1, 4, '1997-10-16', '1997-10-30', '1997-10-23', 3, '21.7400', '1703.85', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10708, 'THEBI', 1, 6, '1997-10-17', '1997-11-28', '1997-11-05', 2, '2.9600', '180.40', 'Tonico do Queijo Ltda', 'AV. Norte, 6622', 'Florianopolis', 'SC', '97201', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10709, 'GOURL', 1, 1, '1997-10-17', '1997-11-14', '1997-11-20', 3, '210.8000', '3424.00', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10710, 'FRANS', 1, 1, '1997-10-20', '1997-11-17', '1997-10-23', 1, '4.9800', '93.50', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10711, 'SAVEA', 1, 5, '1997-10-21', '1997-12-02', '1997-10-29', 2, '52.4100', '4451.70', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10712, 'HUNGO', 1, 3, '1997-10-21', '1997-11-18', '1997-10-31', 1, '89.9300', '1238.35', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10713, 'SAVEA', 1, 1, '1997-10-22', '1997-11-19', '1997-10-24', 1, '167.0500', '2827.90', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10714, 'SAVEA', 1, 5, '1997-10-22', '1997-11-19', '1997-10-27', 3, '24.4900', '2939.75', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10715, 'BONAP', 1, 3, '1997-10-23', '1997-11-06', '1997-10-29', 1, '63.2000', '1296.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10716, 'RANCH', 1, 4, '1997-10-24', '1997-11-21', '1997-10-27', 2, '22.5700', '706.00', 'Rancho grande', 'R. Dona Ana Xavier, 60 Lj 05', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10717, 'FRANK', 1, 1, '1997-10-24', '1997-11-21', '1997-10-29', 2, '59.2500', '1331.65', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10718, 'KOENE', 1, 1, '1997-10-27', '1997-11-24', '1997-10-29', 3, '170.8800', '3463.00', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10719, 'LETSS', 1, 8, '1997-10-27', '1997-11-24', '1997-11-05', 2, '51.4400', '1124.92', 'Ligao Parada Obrigatoria', 'R. Bacuri, 158', 'Rio Branco', 'AC', '94117', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10720, 'QUEDE', 1, 8, '1997-10-28', '1997-11-11', '1997-11-05', 2, '9.5300', '550.00', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10721, 'QUICK', 1, 5, '1997-10-29', '1997-11-26', '1997-10-31', 3, '48.9200', '972.45', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10722, 'SAVEA', 1, 8, '1997-10-29', '1997-12-10', '1997-11-04', 1, '74.5800', '1570.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10723, 'WHITC', 1, 3, '1997-10-30', '1997-11-27', '1997-11-25', 1, '21.7200', '468.45', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10724, 'MEREP', 1, 8, '1997-10-30', '1997-12-11', '1997-11-05', 2, '57.7500', '638.50', 'Mercia Paladar', 'Av. Malaco, 503', 'Florianopolis', 'SC', 'H1J 1C3', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10725, 'FAMIA', 1, 4, '1997-10-31', '1997-11-28', '1997-11-05', 3, '10.8300', '287.80', 'Familia Juliano', 'R. Conde de Iraja, 432/801', 'Goiana', 'GO', '05442-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10726, 'EASTC', 1, 4, '1997-11-03', '1997-11-17', '1997-12-05', 1, '16.5600', '655.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10727, 'REGGC', 1, 2, '1997-11-03', '1997-12-01', '1997-12-05', 1, '89.9000', '1709.85', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10728, 'QUEEN', 1, 4, '1997-11-04', '1997-12-02', '1997-11-11', 2, '58.3300', '1296.75', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10729, 'LINOD', 1, 8, '1997-11-04', '1997-12-16', '1997-11-14', 3, '141.0600', '1850.00', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10730, 'BONAP', 1, 5, '1997-11-05', '1997-12-03', '1997-11-14', 1, '20.1200', '509.60', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10731, 'CHOPS', 1, 7, '1997-11-06', '1997-12-04', '1997-11-14', 1, '96.6500', '1989.90', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10732, 'BONAP', 1, 3, '1997-11-06', '1997-12-04', '1997-11-07', 1, '16.9700', '360.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10733, 'BERGS', 1, 1, '1997-11-07', '1997-12-05', '1997-11-10', 3, '110.1100', '1459.00', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10734, 'GOURL', 1, 2, '1997-11-07', '1997-12-05', '1997-11-12', 3, '1.6300', '1498.35', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10735, 'LETSS', 1, 6, '1997-11-10', '1997-12-08', '1997-11-21', 2, '45.9700', '595.80', 'Ligao Parada Obrigatoria', 'R. Bacuri, 158', 'Rio Branco', 'AC', '94117', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10736, 'HUNGO', 1, 9, '1997-11-11', '1997-12-09', '1997-11-21', 2, '44.1000', '997.00', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10737, 'VINET', 1, 2, '1997-11-11', '1997-12-09', '1997-11-18', 2, '7.7900', '139.80', 'Vinicula Sao Gabriel', 'R. Ciamarte, 95', 'Joo Pessoa', 'PB', '51100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10738, 'SPECD', 1, 2, '1997-11-12', '1997-12-10', '1997-11-18', 1, '2.9100', '52.35', 'Sabores do Mundo', 'R. D. Ana Xavier, 60 lj.9/10', 'Curitiba', 'PR', '75016', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10739, 'VINET', 1, 3, '1997-11-12', '1997-12-10', '1997-11-17', 3, '11.0800', '240.00', 'Vinicula Sao Gabriel', 'R. Ciamarte, 95', 'Joo Pessoa', 'PB', '51100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10740, 'WHITC', 1, 4, '1997-11-13', '1997-12-11', '1997-11-25', 2, '81.8800', '1769.20', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10741, 'AROUT', 1, 4, '1997-11-14', '1997-11-28', '1997-11-18', 3, '10.9600', '284.80', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10742, 'BOTTM', 1, 3, '1997-11-14', '1997-12-12', '1997-11-18', 3, '243.7300', '3118.00', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10743, 'AROUT', 1, 1, '1997-11-17', '1997-12-15', '1997-11-21', 2, '23.7200', '335.95', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10744, 'VAFFE', 1, 6, '1997-11-17', '1997-12-15', '1997-11-24', 1, '69.1900', '919.80', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10745, 'QUICK', 1, 9, '1997-11-18', '1997-12-16', '1997-11-27', 1, '3.5200', '4529.80', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10746, 'CHOPS', 1, 1, '1997-11-19', '1997-12-17', '1997-11-21', 3, '31.4300', '2311.70', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10747, 'PICCO', 1, 6, '1997-11-19', '1997-12-17', '1997-11-26', 1, '117.3300', '1912.85', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10748, 'SAVEA', 1, 3, '1997-11-20', '1997-12-18', '1997-11-28', 1, '232.5500', '2196.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10749, 'ISLAT', 1, 4, '1997-11-20', '1997-12-18', '1997-12-19', 2, '61.5300', '1080.00', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10750, 'WARTH', 1, 9, '1997-11-21', '1997-12-19', '1997-11-24', 1, '79.3000', '1870.80', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10751, 'RICSU', 1, 3, '1997-11-24', '1997-12-22', '1997-12-03', 3, '130.7900', '1701.26', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10752, 'NORTS', 1, 2, '1997-11-24', '1997-12-22', '1997-11-28', 3, '1.3900', '252.00', 'Norte/Sul Ltda', 'R. General Meira Barreto, 63', 'Recife', 'PE', 'SW7 1RZ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10753, 'FRANS', 1, 3, '1997-11-25', '1997-12-23', '1997-11-27', 1, '7.7000', '88.00', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10754, 'MAGAA', 1, 6, '1997-11-25', '1997-12-23', '1997-11-27', 3, '2.3800', '55.20', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10755, 'BONAP', 1, 4, '1997-11-26', '1997-12-24', '1997-11-28', 2, '16.7100', '2597.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10756, 'SPLIR', 1, 8, '1997-11-27', '1997-12-25', '1997-12-02', 2, '73.2100', '2486.70', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10757, 'SAVEA', 1, 6, '1997-11-27', '1997-12-25', '1997-12-15', 1, '8.1900', '3082.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10758, 'RICSU', 1, 3, '1997-11-28', '1997-12-26', '1997-12-04', 3, '138.1700', '1644.60', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10759, NULL, 1, 3, '1997-11-28', '1997-12-26', '1997-12-12', 3, '11.9900', '320.00', 'Ana Rainha da Culinaria', 'R. Visconde de Taunay, 145', 'Fortaleza', 'CE', '05021', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10760, 'MAISD', 1, 4, '1997-12-01', '1997-12-29', '1997-12-10', 1, '155.6400', '3303.50', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10761, 'RATTC', 1, 5, '1997-12-02', '1997-12-30', '1997-12-08', 2, '18.6600', '629.25', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10762, 'FOLKO', 1, 3, '1997-12-02', '1997-12-30', '1997-12-09', 1, '328.7400', '4337.00', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10763, 'FOLIG', 1, 3, '1997-12-03', '1997-12-31', '1997-12-08', 3, '37.3500', '616.00', 'Forte e Alimentado', 'R. Olimpio Tauares , 97', 'Sao Paulo', 'SP', '59000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10764, 'ERNSH', 1, 6, '1997-12-03', '1997-12-31', '1997-12-08', 3, '145.4500', '2539.80', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10765, 'QUICK', 1, 3, '1997-12-04', '1998-01-01', '1997-12-09', 3, '42.7400', '1683.90', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10766, 'OTTIK', 1, 4, '1997-12-05', '1998-01-02', '1997-12-09', 1, '157.5500', '2310.00', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10767, 'SUPRD', 1, 4, '1997-12-05', '1998-01-02', '1997-12-15', 3, '1.5900', '28.00', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10768, 'AROUT', 1, 3, '1997-12-08', '1998-01-05', '1997-12-15', 2, '146.3200', '1477.00', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10769, 'VAFFE', 1, 3, '1997-12-08', '1998-01-05', '1997-12-12', 1, '65.0600', '1703.90', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10770, 'HANAR', 1, 8, '1997-12-09', '1998-01-06', '1997-12-17', 3, '5.3200', '314.75', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10771, 'ERNSH', 1, 9, '1997-12-10', '1998-01-07', '1998-01-02', 2, '11.1900', '344.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10772, 'LEHMS', 1, 3, '1997-12-10', '1998-01-07', '1997-12-19', 2, '91.2800', '3603.22', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10773, 'ERNSH', 1, 1, '1997-12-11', '1998-01-08', '1997-12-16', 3, '96.4300', '2215.85', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10774, 'FOLKO', 1, 4, '1997-12-11', '1997-12-25', '1997-12-12', 1, '48.2000', '874.75', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10775, 'THECR', 1, 7, '1997-12-12', '1998-01-09', '1997-12-26', 1, '20.2500', '228.00', 'Tinoco Atacados em Geral', 'R.  Bento de Loyola, 88', 'Salvador', 'BH', '59801', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10776, 'ERNSH', 1, 1, '1997-12-15', '1998-01-12', '1997-12-18', 3, '351.5300', '6984.30', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10777, 'GOURL', 1, 7, '1997-12-15', '1997-12-29', '1998-01-21', 2, '3.0100', '279.80', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10778, 'BERGS', 1, 3, '1997-12-16', '1998-01-13', '1997-12-24', 1, '6.7900', '96.50', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10779, 'MORGK', 1, 3, '1997-12-16', '1998-01-13', '1998-01-14', 2, '58.1300', '1335.00', 'Miramar Comercio Ltda', 'R. Guimaraes  Peixoto,  405', 'Porto Alegre', 'RS', '04179', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10780, 'LILAS', 1, 2, '1997-12-16', '1997-12-30', '1997-12-25', 1, '42.1300', '720.00', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10781, 'WARTH', 1, 2, '1997-12-17', '1998-01-14', '1997-12-19', 3, '73.1600', '1131.95', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10782, 'CACTU', 1, 9, '1997-12-17', '1998-01-14', '1997-12-22', 3, '1.1000', '12.50', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10783, 'HANAR', 1, 4, '1997-12-18', '1998-01-15', '1997-12-19', 2, '124.9800', '1442.50', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10784, 'MAGAA', 1, 4, '1997-12-18', '1998-01-15', '1997-12-22', 3, '70.0900', '1649.70', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10785, 'GROSR', 1, 1, '1997-12-18', '1998-01-15', '1997-12-24', 3, '1.5100', '387.50', 'Geralda - Restaurante', 'R. Antonio de Castro, 133', 'Vitria', 'ES', '1081', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10786, 'QUEEN', 1, 8, '1997-12-19', '1998-01-16', '1997-12-23', 1, '110.8700', '1913.25', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10787, 'LAMAI', 1, 2, '1997-12-19', '1998-01-02', '1997-12-26', 1, '249.9300', '2760.70', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10788, 'QUICK', 1, 1, '1997-12-22', '1998-01-19', '1998-01-19', 2, '42.7000', '769.90', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10789, 'FOLIG', 1, 1, '1997-12-22', '1998-01-19', '1997-12-31', 2, '100.6000', '3687.00', 'Forte e Alimentado', 'R. Olimpio Tauares , 97', 'Sao Paulo', 'SP', '59000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10790, 'GOURL', 1, 6, '1997-12-22', '1998-01-19', '1997-12-26', 1, '28.2300', '849.70', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10791, 'FRANK', 1, 6, '1997-12-23', '1998-01-20', '1998-01-01', 2, '16.8500', '1925.96', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10792, 'WOLZA', 1, 1, '1997-12-23', '1998-01-20', '1997-12-31', 3, '23.7900', '399.85', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10793, 'AROUT', 1, 3, '1997-12-24', '1998-01-21', '1998-01-08', 3, '4.5200', '191.10', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10794, 'QUEDE', 1, 6, '1997-12-24', '1998-01-21', '1998-01-02', 1, '21.4900', '393.05', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10795, 'ERNSH', 1, 8, '1997-12-24', '1998-01-21', '1998-01-20', 2, '126.6600', '2499.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10796, 'HILAA', 1, 3, '1997-12-25', '1998-01-22', '1998-01-14', 1, '26.5200', '2877.48', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10797, 'DRACD', 1, 7, '1997-12-25', '1998-01-22', '1998-01-05', 2, '33.3500', '420.00', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10798, 'ISLAT', 1, 2, '1997-12-26', '1998-01-23', '1998-01-05', 1, '2.3300', '446.60', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10799, 'KOENE', 1, 9, '1997-12-26', '1998-02-06', '1998-01-05', 3, '30.7600', '1584.70', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10800, 'SEVES', 1, 1, '1997-12-26', '1998-01-23', '1998-01-05', 3, '137.4400', '1631.85', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10801, 'BOLID', 1, 4, '1997-12-29', '1998-01-26', '1997-12-31', 2, '97.0900', '4035.30', 'Barto Comidas preparadas', 'R. Senador Milton Campos, 176', 'Joo Pessoa', 'PB', '28023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10802, 'SIMOB', 1, 4, '1997-12-29', '1998-01-26', '1998-01-02', 2, '257.2600', '3922.75', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10803, 'WELLI', 1, 4, '1997-12-30', '1998-01-27', '1998-01-06', 1, '55.2300', '1255.65', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10804, 'SEVES', 1, 6, '1997-12-30', '1998-01-27', '1998-01-07', 2, '27.3300', '2290.25', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10805, 'THEBI', 1, 2, '1997-12-30', '1998-01-27', '1998-01-09', 3, '237.3400', '2775.00', 'Tonico do Queijo Ltda', 'AV. Norte, 6622', 'Florianopolis', 'SC', '97201', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10806, 'VICTE', 1, 3, '1997-12-31', '1998-01-28', '1998-01-05', 2, '22.1100', '571.60', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10807, 'FRANS', 1, 4, '1997-12-31', '1998-01-28', '1998-01-30', 1, '1.3600', '18.40', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10808, 'OLDWO', 1, 2, '1998-01-01', '1998-01-29', '1998-01-09', 3, '45.5300', '1659.70', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10809, 'WELLI', 1, 7, '1998-01-01', '1998-01-29', '1998-01-07', 1, '4.8700', '140.00', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10810, 'LAUGB', 1, 2, '1998-01-01', '1998-01-29', '1998-01-07', 3, '4.3300', '187.00', 'Lourival  Vinhos & CIA', 'R. barao de granito, 54', 'Macap', 'AP', 'V3F 2K1', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10811, 'LINOD', 1, 8, '1998-01-02', '1998-01-30', '1998-01-08', 1, '31.2200', '852.00', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10812, 'REGGC', 1, 5, '1998-01-02', '1998-01-30', '1998-01-12', 1, '59.7800', '1851.80', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10813, 'RICAR', 1, 1, '1998-01-05', '1998-02-02', '1998-01-09', 1, '47.3800', '647.80', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10814, 'VICTE', 1, 3, '1998-01-05', '1998-02-02', '1998-01-14', 3, '130.9400', '2069.55', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10815, 'SAVEA', 1, 2, '1998-01-05', '1998-02-02', '1998-01-14', 3, '14.6200', '40.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10816, 'GREAL', 1, 4, '1998-01-06', '1998-02-03', '1998-02-04', 2, '719.7800', '8890.90', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10817, 'KOENE', 1, 3, '1998-01-06', '1998-01-20', '1998-01-13', 2, '306.0700', '11490.25', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10818, 'MAGAA', 1, 7, '1998-01-07', '1998-02-04', '1998-01-12', 3, '65.4800', '833.00', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10819, 'CACTU', 1, 2, '1998-01-07', '1998-02-04', '1998-01-16', 3, '19.7600', '477.00', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10820, 'RATTC', 1, 3, '1998-01-07', '1998-02-04', '1998-01-13', 2, '37.5200', '1140.00', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10821, 'SPLIR', 1, 1, '1998-01-08', '1998-02-05', '1998-01-15', 1, '36.6800', '678.00', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10822, 'TRAIH', 1, 6, '1998-01-08', '1998-02-05', '1998-01-16', 3, '7.0000', '237.90', 'Tereza Bebidas e Comidas', 'R. Jose de Holanda, 561', 'Campo Grande', 'MS', '98034', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10823, 'LILAS', 1, 5, '1998-01-09', '1998-02-06', '1998-01-13', 2, '163.9700', '3107.20', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10824, 'FOLKO', 1, 8, '1998-01-09', '1998-02-06', '1998-01-30', 1, '1.2300', '250.80', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10825, 'DRACD', 1, 1, '1998-01-09', '1998-02-06', '1998-01-14', 1, '79.2500', '1030.76', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10826, 'BLONP', 1, 6, '1998-01-12', '1998-02-09', '1998-02-06', 1, '7.0900', '730.00', 'Belarmino pais e filhos', 'R. Senador Soares Meireles, 123', 'Rio de Janeiro', 'RJ', '67000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10827, 'BONAP', 1, 1, '1998-01-12', '1998-01-26', '1998-02-06', 2, '63.5400', '843.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10828, 'RANCH', 1, 9, '1998-01-13', '1998-01-27', '1998-02-04', 1, '90.8500', '932.00', 'Rancho grande', 'R. Dona Ana Xavier, 60 Lj 05', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10829, 'ISLAT', 1, 9, '1998-01-13', '1998-02-10', '1998-01-23', 1, '154.7200', '1764.00', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10830, 'TRADH', 1, 4, '1998-01-13', '1998-02-24', '1998-01-21', 2, '81.8300', '1974.00', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10831, 'SANTG', 1, 3, '1998-01-14', '1998-02-11', '1998-01-23', 2, '72.1900', '2684.40', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10832, 'LAMAI', 1, 2, '1998-01-14', '1998-02-11', '1998-01-19', 2, '43.2600', '568.35', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10833, 'OTTIK', 1, 6, '1998-01-15', '1998-02-12', '1998-01-23', 2, '71.4900', '1007.40', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10834, 'TRADH', 1, 1, '1998-01-15', '1998-02-12', '1998-01-19', 3, '29.7800', '1508.02', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10835, 'ALFKI', 1, 1, '1998-01-15', '1998-02-12', '1998-01-21', 3, '69.5300', '850.80', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10836, 'ERNSH', 1, 7, '1998-01-16', '1998-02-13', '1998-01-21', 1, '411.8800', '4705.50', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10837, 'BERGS', 1, 9, '1998-01-16', '1998-02-13', '1998-01-23', 3, '13.3200', '1253.50', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10838, 'LINOD', 1, 3, '1998-01-19', '1998-02-16', '1998-01-23', 3, '59.2800', '2583.75', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10839, 'TRADH', 1, 3, '1998-01-19', '1998-02-16', '1998-01-22', 3, '35.4300', '919.30', 'Tradio Hipermercados', 'Av. Beira Rio, 1059/202', 'Goiana', 'GO', '05634-030', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10840, 'LINOD', 1, 4, '1998-01-19', '1998-03-02', '1998-02-16', 2, '2.7100', '263.60', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10841, 'SUPRD', 1, 5, '1998-01-20', '1998-02-17', '1998-01-29', 2, '424.3000', '4581.00', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10842, 'TORTU', 1, 1, '1998-01-20', '1998-02-17', '1998-01-29', 3, '54.4200', '975.00', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10843, 'VICTE', 1, 4, '1998-01-21', '1998-02-18', '1998-01-26', 2, '9.2600', '211.75', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10844, 'PICCO', 1, 8, '1998-01-21', '1998-02-18', '1998-01-26', 2, '25.2200', '735.00', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10845, 'QUICK', 1, 8, '1998-01-21', '1998-02-04', '1998-01-30', 1, '212.9800', '4058.60', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10846, 'SUPRD', 1, 2, '1998-01-22', '1998-03-05', '1998-01-23', 3, '56.4600', '1112.00', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10847, 'SAVEA', 1, 4, '1998-01-22', '1998-02-05', '1998-02-10', 3, '487.5700', '6163.70', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10848, 'CONSH', 1, 7, '1998-01-23', '1998-02-20', '1998-01-29', 2, '38.2400', '931.50', 'Consolidados Bom Apetite', 'R. Raimundo Freixeira, 163', 'Recife', 'PE', 'WX1 6LT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10849, 'KOENE', 1, 9, '1998-01-23', '1998-02-20', '1998-01-30', 2, '0.5600', '1051.99', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10850, 'VICTE', 1, 1, '1998-01-23', '1998-03-06', '1998-01-30', 1, '49.1900', '739.55', 'Visconde Sabores Mil', 'R. Cons Nabuco 151/502', 'Joo Pessoa', 'PB', '69004', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10851, 'RICAR', 1, 5, '1998-01-26', '1998-02-23', '1998-02-02', 1, '160.5500', '2739.80', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10852, 'RATTC', 1, 8, '1998-01-26', '1998-02-09', '1998-01-30', 1, '174.0500', '2984.00', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10853, 'BLAUS', 1, 9, '1998-01-27', '1998-02-24', '1998-02-03', 2, '53.8300', '625.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10854, 'ERNSH', 1, 3, '1998-01-27', '1998-02-24', '1998-02-05', 2, '100.2200', '3489.70', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10855, 'OLDWO', 1, 3, '1998-01-27', '1998-02-24', '1998-02-04', 1, '170.9700', '2275.10', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10856, 'ANTON', 1, 3, '1998-01-28', '1998-02-25', '1998-02-10', 2, '58.4300', '660.00', 'Antonio Moreno Bebidas', 'R. Vasco da Gama, 424', 'Fortaleza', 'CE', '05023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10857, 'BERGS', 1, 8, '1998-01-28', '1998-02-25', '1998-02-06', 2, '188.8500', '2630.45', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10858, 'LACOR', 1, 2, '1998-01-29', '1998-02-26', '1998-02-03', 1, '52.5100', '649.00', 'Lago Sao Sebastiao', 'R. Largo Casa Amarela, 136', 'So Luis', 'MA', '78000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10859, 'FRANK', 1, 1, '1998-01-29', '1998-02-26', '1998-02-02', 2, '76.1000', '1437.50', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10860, 'FRANR', 1, 3, '1998-01-29', '1998-02-26', '1998-02-04', 3, '19.2600', '519.00', 'Frances Restaurante', 'R. Motta Junior, 31', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10861, 'WHITC', 1, 4, '1998-01-30', '1998-02-27', '1998-02-17', 2, '14.9300', '3523.40', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10862, 'LEHMS', 1, 8, '1998-01-30', '1998-03-13', '1998-02-02', 2, '53.2300', '581.00', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10863, 'HILAA', 1, 4, '1998-02-02', '1998-03-02', '1998-02-17', 2, '30.2600', '518.70', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10864, 'AROUT', 1, 4, '1998-02-02', '1998-03-02', '1998-02-09', 2, '3.0400', '282.00', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10865, 'QUICK', 1, 2, '1998-02-02', '1998-02-16', '1998-02-12', 1, '348.1400', '17249.90', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10866, 'BERGS', 1, 5, '1998-02-03', '1998-03-03', '1998-02-12', 1, '109.1100', '1460.85', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10867, 'LONEP', 1, 6, '1998-02-03', '1998-03-17', '1998-02-11', 1, '1.9300', '98.40', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10868, 'QUEEN', 1, 7, '1998-02-04', '1998-03-04', '1998-02-23', 2, '191.2700', '2004.50', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10869, 'SEVES', 1, 5, '1998-02-04', '1998-03-04', '1998-02-09', 1, '143.2800', '1630.00', 'Sete Oceanos Importao', 'R. das Neves, 390', 'Recife', 'PE', 'OX15 4NB', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10870, 'WOLZA', 1, 5, '1998-02-04', '1998-03-04', '1998-02-13', 3, '12.0400', '160.00', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10871, 'BONAP', 1, 9, '1998-02-05', '1998-03-05', '1998-02-10', 2, '112.2700', '2083.25', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10872, 'GODOS', 1, 5, '1998-02-05', '1998-03-05', '1998-02-09', 2, '175.3200', '2166.60', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10873, 'WILMK', 1, 4, '1998-02-06', '1998-03-06', '1998-02-09', 1, '0.8200', '336.80', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10874, 'GODOS', 1, 5, '1998-02-06', '1998-03-06', '1998-02-11', 2, '19.5800', '310.00', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10875, 'BERGS', 1, 4, '1998-02-06', '1998-03-06', '1998-03-03', 2, '32.3700', '729.40', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10876, 'BONAP', 1, 7, '1998-02-09', '1998-03-09', '1998-02-12', 3, '60.4200', '917.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10877, 'RICAR', 1, 1, '1998-02-09', '1998-03-09', '1998-02-19', 1, '38.0600', '2085.75', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10878, 'QUICK', 1, 4, '1998-02-10', '1998-03-10', '1998-02-12', 1, '46.6900', '1619.95', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10879, 'WILMK', 1, 3, '1998-02-10', '1998-03-10', '1998-02-12', 3, '8.5000', '611.30', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10880, 'FOLKO', 1, 7, '1998-02-10', '1998-03-24', '1998-02-18', 1, '88.0100', '1874.40', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10881, 'CACTU', 1, 4, '1998-02-11', '1998-03-11', '1998-02-18', 1, '2.8400', '150.00', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10882, 'SAVEA', 1, 4, '1998-02-11', '1998-03-11', '1998-02-20', 3, '23.1000', '988.10', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10883, 'LONEP', 1, 8, '1998-02-12', '1998-03-12', '1998-02-20', 3, '0.5300', '36.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10884, 'LETSS', 1, 4, '1998-02-12', '1998-03-12', '1998-02-13', 2, '90.9700', '1450.45', 'Ligao Parada Obrigatoria', 'R. Bacuri, 158', 'Rio Branco', 'AC', '94117', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10885, 'SUPRD', 1, 6, '1998-02-12', '1998-03-12', '1998-02-18', 3, '5.6400', '1209.00', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10886, 'HANAR', 1, 1, '1998-02-13', '1998-03-13', '1998-03-02', 1, '4.9900', '3127.50', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10887, 'GALED', 1, 8, '1998-02-13', '1998-03-13', '1998-02-16', 3, '1.2500', '70.00', 'Galera do Gastronomo', 'R. Major Nereu  Guerra, 131', 'Porto Velho', 'RO', '08022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10888, 'GODOS', 1, 1, '1998-02-16', '1998-03-16', '1998-02-23', 2, '51.8700', '605.00', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10889, 'RATTC', 1, 9, '1998-02-16', '1998-03-16', '1998-02-23', 3, '280.6100', '11380.00', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10890, 'DUMON', 1, 7, '1998-02-16', '1998-03-16', '1998-02-18', 1, '32.7600', '860.10', 'O Mundo Inteiro', 'R. Pedro Allain, 125 Casa.34', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10891, 'LEHMS', 1, 7, '1998-02-17', '1998-03-17', '1998-02-19', 2, '20.3700', '388.30', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10892, 'MAISD', 1, 4, '1998-02-17', '1998-03-17', '1998-02-19', 2, '120.2700', '2199.95', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10893, 'KOENE', 1, 9, '1998-02-18', '1998-03-18', '1998-02-20', 2, '77.7800', '5502.11', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10894, 'SAVEA', 1, 1, '1998-02-18', '1998-03-18', '1998-02-20', 1, '116.1300', '2897.85', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10895, 'ERNSH', 1, 3, '1998-02-18', '1998-03-18', '1998-02-23', 1, '162.7500', '6379.40', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10896, 'MAISD', 1, 7, '1998-02-19', '1998-03-19', '1998-02-27', 3, '32.4500', '750.50', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10897, 'HUNGO', 1, 3, '1998-02-19', '1998-03-19', '1998-02-25', 2, '603.5400', '10835.24', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10898, 'OCEAN', 1, 4, '1998-02-20', '1998-03-20', '1998-03-06', 2, '1.2700', '30.00', 'Ocano Atlntico Ltda.', 'R. Ferreira Lopes, 414', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10899, 'LILAS', 1, 5, '1998-02-20', '1998-03-20', '1998-02-26', 3, '1.2100', '143.85', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10900, 'WELLI', 1, 1, '1998-02-20', '1998-03-20', '1998-03-04', 2, '1.6600', '44.75', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10901, 'HILAA', 1, 4, '1998-02-23', '1998-03-23', '1998-02-26', 1, '62.0900', '934.50', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10902, 'FOLKO', 1, 1, '1998-02-23', '1998-03-23', '1998-03-03', 1, '44.1500', '1015.50', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10903, 'HANAR', 1, 3, '1998-02-24', '1998-03-24', '1998-03-04', 3, '36.7100', '932.05', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10904, 'WHITC', 1, 3, '1998-02-24', '1998-03-24', '1998-02-27', 3, '162.9500', '1924.25', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10905, 'WELLI', 1, 9, '1998-02-24', '1998-03-24', '1998-03-06', 2, '13.7200', '359.95', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10906, 'WOLZA', 1, 4, '1998-02-25', '1998-03-11', '1998-03-03', 3, '26.2900', '427.50', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10907, 'SPECD', 1, 6, '1998-02-25', '1998-03-25', '1998-02-27', 3, '9.1900', '108.50', 'Sabores do Mundo', 'R. D. Ana Xavier, 60 lj.9/10', 'Curitiba', 'PR', '75016', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10908, 'REGGC', 1, 4, '1998-02-26', '1998-03-26', '1998-03-06', 2, '32.9600', '697.90', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10909, 'SANTG', 1, 1, '1998-02-26', '1998-03-26', '1998-03-10', 2, '53.0500', '670.00', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10910, 'WILMK', 1, 1, '1998-02-26', '1998-03-26', '1998-03-04', 3, '38.1100', '452.90', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10911, 'GODOS', 1, 3, '1998-02-26', '1998-03-26', '1998-03-05', 1, '38.1900', '858.00', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10912, 'HUNGO', 1, 2, '1998-02-26', '1998-03-26', '1998-03-18', 2, '580.9100', '8266.90', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10913, 'QUEEN', 1, 4, '1998-02-26', '1998-03-26', '1998-03-04', 1, '33.0500', '958.25', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10914, 'QUEEN', 1, 6, '1998-02-27', '1998-03-27', '1998-03-02', 1, '21.1900', '537.50', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10915, 'TORTU', 1, 2, '1998-02-27', '1998-03-27', '1998-03-02', 2, '3.5100', '539.50', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10916, 'RANCH', 1, 1, '1998-02-27', '1998-03-27', '1998-03-09', 2, '63.7700', '686.70', 'Rancho grande', 'R. Dona Ana Xavier, 60 Lj 05', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10917, 'ROMEY', 1, 4, '1998-03-02', '1998-03-30', '1998-03-11', 2, '8.2900', '365.89', 'Romero & Tomaz', 'R. Deputado Mario Monteiro, 52/04', 'Joo Pessoa', 'PB', '28001', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10918, 'BOTTM', 1, 3, '1998-03-02', '1998-03-30', '1998-03-11', 3, '48.8300', '1929.50', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10919, 'LINOD', 1, 2, '1998-03-02', '1998-03-30', '1998-03-04', 2, '19.8000', '1122.80', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10920, 'AROUT', 1, 4, '1998-03-03', '1998-03-31', '1998-03-09', 2, '29.6100', '390.00', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10921, 'VAFFE', 1, 1, '1998-03-03', '1998-04-14', '1998-03-09', 1, '176.4800', '1936.00', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10922, 'HANAR', 1, 5, '1998-03-03', '1998-03-31', '1998-03-05', 3, '62.7400', '742.50', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10923, 'LAMAI', 1, 7, '1998-03-03', '1998-04-14', '1998-03-13', 3, '68.2600', '935.40', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10924, 'BERGS', 1, 3, '1998-03-04', '1998-04-01', '1998-04-08', 2, '151.5200', '2034.30', 'Bernadete Refeioes', 'R. Surubim, 117', 'Recife', 'PE', 'S-958 22', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10925, 'HANAR', 1, 3, '1998-03-04', '1998-04-01', '1998-03-13', 1, '2.2700', '558.70', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10926, NULL, 1, 4, '1998-03-04', '1998-04-01', '1998-03-11', 3, '39.9200', '514.40', 'Ana Rainha da Culinaria', 'R. Visconde de Taunay, 145', 'Fortaleza', 'CE', '05021', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10927, 'LACOR', 1, 4, '1998-03-05', '1998-04-02', '1998-04-08', 1, '19.7900', '800.00', 'Lago Sao Sebastiao', 'R. Largo Casa Amarela, 136', 'So Luis', 'MA', '78000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10928, 'GALED', 1, 1, '1998-03-05', '1998-04-02', '1998-03-18', 1, '1.3600', '137.50', 'Galera do Gastronomo', 'R. Major Nereu  Guerra, 131', 'Porto Velho', 'RO', '08022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10929, 'FRANK', 1, 6, '1998-03-05', '1998-04-02', '1998-03-12', 1, '33.9300', '1174.75', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10930, 'SUPRD', 1, 4, '1998-03-06', '1998-04-17', '1998-03-18', 3, '15.5500', '2454.60', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10931, 'RICSU', 1, 4, '1998-03-06', '1998-03-20', '1998-03-19', 2, '13.6000', '836.85', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10932, 'BONAP', 1, 8, '1998-03-06', '1998-04-03', '1998-03-24', 1, '134.6400', '1925.20', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10933, 'ISLAT', 1, 6, '1998-03-06', '1998-04-03', '1998-03-16', 3, '54.1500', '920.60', 'Israel Comercio', 'R. Abel de Sa B. Cavalcante, 101', 'Joo Pessoa', 'PB', 'PO31 7PJ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10934, 'LEHMS', 1, 3, '1998-03-09', '1998-04-06', '1998-03-12', 3, '32.0100', '500.00', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10935, 'WELLI', 1, 4, '1998-03-09', '1998-04-06', '1998-03-18', 3, '47.5900', '699.50', 'Wellington Importadora', 'R. Belarmino Carneiro, 53', 'Goiana', 'GO', '08737-363', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10936, 'GREAL', 1, 3, '1998-03-09', '1998-04-06', '1998-03-18', 2, '33.6800', '569.80', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10937, 'CACTU', 1, 7, '1998-03-10', '1998-03-24', '1998-03-13', 3, '31.5100', '644.80', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10938, 'QUICK', 1, 3, '1998-03-10', '1998-04-07', '1998-03-16', 2, '31.8900', '3641.50', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10939, 'MAGAA', 1, 2, '1998-03-10', '1998-04-07', '1998-03-13', 2, '76.3300', '749.70', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10940, 'BONAP', 1, 8, '1998-03-11', '1998-04-08', '1998-03-23', 3, '19.7700', '360.00', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10941, 'SAVEA', 1, 7, '1998-03-11', '1998-04-08', '1998-03-20', 2, '400.8100', '4768.25', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10942, 'REGGC', 1, 9, '1998-03-11', '1998-04-08', '1998-03-18', 3, '17.9500', '560.00', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10943, 'BSBEV', 1, 4, '1998-03-11', '1998-04-08', '1998-03-19', 2, '2.1700', '711.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10944, 'BOTTM', 1, 6, '1998-03-12', '1998-03-26', '1998-03-13', 3, '52.9200', '1138.60', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10945, 'MORGK', 1, 4, '1998-03-12', '1998-04-09', '1998-03-18', 1, '10.2200', '245.00', 'Miramar Comercio Ltda', 'R. Guimaraes  Peixoto,  405', 'Porto Alegre', 'RS', '04179', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10946, 'VAFFE', 1, 1, '1998-03-12', '1998-04-09', '1998-03-19', 2, '27.2000', '1407.50', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10947, 'BSBEV', 1, 3, '1998-03-13', '1998-04-10', '1998-03-16', 2, '3.2600', '220.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10948, 'GODOS', 1, 3, '1998-03-13', '1998-04-10', '1998-03-19', 3, '23.3900', '2362.25', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10949, 'BOTTM', 1, 2, '1998-03-13', '1998-04-10', '1998-03-17', 3, '74.4400', '4422.00', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10950, 'MAGAA', 1, 1, '1998-03-16', '1998-04-13', '1998-03-23', 2, '2.5000', '110.00', 'Magazine Alimentar Ltda', 'R. Heraclito Cavalcante, 165', 'Goiana', 'GO', '24100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10951, 'RICSU', 1, 9, '1998-03-16', '1998-04-27', '1998-04-07', 2, '30.8500', '482.75', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10952, 'ALFKI', 1, 1, '1998-03-16', '1998-04-27', '1998-03-24', 1, '40.4200', '491.15', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10953, 'AROUT', 1, 9, '1998-03-16', '1998-03-30', '1998-03-25', 2, '23.7200', '4674.90', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10954, 'LINOD', 1, 5, '1998-03-17', '1998-04-28', '1998-03-20', 1, '27.9100', '1901.65', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10955, 'FOLKO', 1, 8, '1998-03-17', '1998-04-14', '1998-03-20', 2, '3.2600', '92.80', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10956, 'BLAUS', 1, 6, '1998-03-17', '1998-04-28', '1998-03-20', 2, '44.6500', '677.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10957, 'HILAA', 1, 8, '1998-03-18', '1998-04-15', '1998-03-27', 3, '105.3600', '1762.70', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10958, 'OCEAN', 1, 7, '1998-03-18', '1998-04-15', '1998-03-27', 2, '49.5600', '781.00', 'Ocano Atlntico Ltda.', 'R. Ferreira Lopes, 414', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10959, 'GOURL', 1, 6, '1998-03-18', '1998-04-29', '1998-03-23', 2, '4.9800', '154.85', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10960, 'HILAA', 1, 3, '1998-03-19', '1998-04-02', '1998-04-08', 1, '2.0800', '276.35', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10961, 'QUEEN', 1, 8, '1998-03-19', '1998-04-16', '1998-03-30', 1, '104.4700', '1121.95', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10962, 'QUICK', 1, 8, '1998-03-19', '1998-04-16', '1998-03-23', 2, '275.7900', '3584.00', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10963, 'FURIB', 1, 9, '1998-03-19', '1998-04-16', '1998-03-26', 3, '2.7000', '67.85', 'Feijo Frutos do Mar', 'R. mandacaru, 512, casa, 02', 'Sao Paulo', 'SP', '1675', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10964, 'SPECD', 1, 3, '1998-03-20', '1998-04-17', '1998-03-24', 2, '87.3800', '2052.50', 'Sabores do Mundo', 'R. D. Ana Xavier, 60 lj.9/10', 'Curitiba', 'PR', '75016', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10965, 'OLDWO', 1, 6, '1998-03-20', '1998-04-17', '1998-03-30', 3, '144.3800', '848.00', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10966, 'CHOPS', 1, 4, '1998-03-20', '1998-04-17', '1998-04-08', 1, '27.1900', '1255.30', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10967, 'TOMSP', 1, 2, '1998-03-23', '1998-04-20', '1998-04-02', 2, '62.2200', '910.40', 'Toni Especiarias', 'R. Conselheiro Ribas, 106', 'Florianopolis', 'SC', '44087', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10968, 'ERNSH', 1, 1, '1998-03-23', '1998-04-20', '1998-04-01', 3, '74.6000', '1408.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10969, 'COMMI', 1, 1, '1998-03-23', '1998-04-20', '1998-03-30', 2, '0.2100', '108.00', 'Comrcio Mineiro', 'R. Alfredo Gama, 14', 'Goiana', 'GO', '05432-043', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10970, 'BOLID', 1, 9, '1998-03-24', '1998-04-07', '1998-04-24', 1, '16.1600', '279.80', 'Barto Comidas preparadas', 'R. Senador Milton Campos, 176', 'Joo Pessoa', 'PB', '28023', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10971, 'FRANR', 1, 2, '1998-03-24', '1998-04-21', '1998-04-02', 2, '121.8200', '1733.06', 'Frances Restaurante', 'R. Motta Junior, 31', 'Aracaju', 'SE', '44000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10972, 'LACOR', 1, 4, '1998-03-24', '1998-04-21', '1998-03-26', 2, '0.0200', '251.50', 'Lago Sao Sebastiao', 'R. Largo Casa Amarela, 136', 'So Luis', 'MA', '78000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10973, 'LACOR', 1, 6, '1998-03-24', '1998-04-21', '1998-03-27', 2, '15.1700', '291.55', 'Lago Sao Sebastiao', 'R. Largo Casa Amarela, 136', 'So Luis', 'MA', '78000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10974, 'SPLIR', 1, 3, '1998-03-25', '1998-04-08', '1998-04-03', 3, '12.9600', '439.00', 'Sao Paulo Bebidas', 'R. Maroquinha Ramos, 607', 'Porto Alegre', 'RS', '82520', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10975, 'BOTTM', 1, 1, '1998-03-25', '1998-04-22', '1998-03-27', 3, '32.2700', '717.50', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10976, 'HILAA', 1, 1, '1998-03-25', '1998-05-06', '1998-04-03', 1, '37.9700', '912.00', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10977, 'FOLKO', 1, 8, '1998-03-26', '1998-04-23', '1998-04-10', 3, '208.5000', '2233.00', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10978, 'MAISD', 1, 9, '1998-03-26', '1998-04-23', '1998-04-23', 2, '32.8200', '1500.25', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10979, 'ERNSH', 1, 8, '1998-03-26', '1998-04-23', '1998-03-31', 2, '353.0700', '4813.50', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10980, 'FOLKO', 1, 4, '1998-03-27', '1998-05-08', '1998-04-17', 1, '1.2600', '309.80', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10981, 'HANAR', 1, 1, '1998-03-27', '1998-04-24', '1998-04-02', 2, '193.3700', '15810.00', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10982, 'BOTTM', 1, 2, '1998-03-27', '1998-04-24', '1998-04-08', 1, '14.0100', '1014.00', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10983, 'SAVEA', 1, 2, '1998-03-27', '1998-04-24', '1998-04-06', 2, '657.5400', '796.35', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10984, 'SAVEA', 1, 1, '1998-03-30', '1998-04-27', '1998-04-03', 3, '211.2200', '1809.75', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10985, 'HUNGO', 1, 2, '1998-03-30', '1998-04-27', '1998-04-02', 1, '91.5100', '2247.90', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10986, 'OCEAN', 1, 8, '1998-03-30', '1998-04-27', '1998-04-21', 2, '217.8600', '2220.00', 'Ocano Atlntico Ltda.', 'R. Ferreira Lopes, 414', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10987, 'EASTC', 1, 8, '1998-03-31', '1998-04-28', '1998-04-06', 1, '185.4800', '2772.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10988, 'RATTC', 1, 3, '1998-03-31', '1998-04-28', '1998-04-10', 2, '61.1400', '3771.90', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10989, 'QUEDE', 1, 2, '1998-03-31', '1998-04-28', '1998-04-02', 1, '34.7600', '1353.60', 'Que Delcia', 'AV. Cons.Ribas, 162', 'Joo Pessoa', 'PB', '02389-673', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10990, 'ERNSH', 1, 2, '1998-04-01', '1998-05-13', '1998-04-07', 3, '117.6100', '4930.55', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10991, 'QUICK', 1, 1, '1998-04-01', '1998-04-29', '1998-04-07', 1, '38.5100', '2869.40', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10992, 'THEBI', 1, 1, '1998-04-01', '1998-04-29', '1998-04-03', 3, '4.2700', '69.60', 'Tonico do Queijo Ltda', 'AV. Norte, 6622', 'Florianopolis', 'SC', '97201', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10993, 'FOLKO', 1, 7, '1998-04-01', '1998-04-29', '1998-04-10', 3, '8.8100', '6526.75', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10994, 'VAFFE', 1, 2, '1998-04-02', '1998-04-16', '1998-04-09', 3, '65.5300', '989.95', 'Varejao Sto Antonio', 'R. Cons. Peretti, 106', 'Aracaju', 'SE', '8200', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10995, 'PERIC', 1, 1, '1998-04-02', '1998-04-30', '1998-04-06', 3, '46.0000', '1196.00', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10996, 'QUICK', 1, 4, '1998-04-02', '1998-04-30', '1998-04-10', 2, '1.1200', '560.00', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10997, 'LILAS', 1, 8, '1998-04-03', '1998-05-15', '1998-04-13', 2, '73.9100', '1979.50', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10998, 'WOLZA', 1, 8, '1998-04-03', '1998-04-17', '1998-04-17', 2, '20.3100', '686.00', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (10999, 'OTTIK', 1, 6, '1998-04-03', '1998-05-01', '1998-04-10', 2, '96.3500', '1260.85', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11000, 'RATTC', 1, 2, '1998-04-06', '1998-05-04', '1998-04-14', 3, '55.1200', '1074.50', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11001, 'FOLKO', 1, 2, '1998-04-06', '1998-05-04', '1998-04-14', 2, '197.3000', '2769.00', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11002, 'SAVEA', 1, 4, '1998-04-06', '1998-05-04', '1998-04-16', 1, '141.1600', '1901.70', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11003, 'THECR', 1, 3, '1998-04-06', '1998-05-04', '1998-04-08', 3, '14.9100', '326.00', 'Tinoco Atacados em Geral', 'R.  Bento de Loyola, 88', 'Salvador', 'BH', '59801', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11004, 'MAISD', 1, 3, '1998-04-07', '1998-05-05', '1998-04-20', 1, '44.8400', '295.38', 'Maravilhas do Amazonas', 'R. Heitor Maia, 85', 'So Luis', 'MA', 'B-1180', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11005, 'WILMK', 1, 2, '1998-04-07', '1998-05-05', '1998-04-10', 1, '0.7500', '586.00', 'Wilson Especiarias', 'R. cabo eptacio lucena, 114', 'Campo Grande', 'MS', '21240', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11006, 'GREAL', 1, 3, '1998-04-07', '1998-05-05', '1998-04-15', 2, '25.1900', '391.33', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11007, 'PRINI', 1, 8, '1998-04-08', '1998-05-06', '1998-04-13', 2, '202.2400', '2633.90', 'Princesa Isabel Vinhos', 'R. Dr. Antonio de Castro, 160', 'Sao Paulo', 'SP', '1756', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11008, 'ERNSH', 1, 7, '1998-04-08', '1998-05-06', NULL, 3, '79.4600', '4903.40', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11009, 'GODOS', 1, 2, '1998-04-08', '1998-05-06', '1998-04-10', 1, '59.1100', '701.75', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11010, 'REGGC', 1, 2, '1998-04-09', '1998-05-07', '1998-04-21', 2, '28.7100', '645.00', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11011, 'ALFKI', 1, 3, '1998-04-09', '1998-05-07', '1998-04-13', 1, '1.2100', '959.95', 'Antonios Rei do Sabor', 'R. Xavantes, 40', 'Cuiab', 'MT', '12209', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11012, 'FRANK', 1, 1, '1998-04-09', '1998-04-23', '1998-04-17', 3, '242.9500', '2973.85', 'Frazo Comidas', 'R. Nova Descoberta,84', 'Goiana', 'GO', '80805', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11013, 'ROMEY', 1, 2, '1998-04-09', '1998-05-07', '1998-04-10', 1, '32.9900', '361.00', 'Romero & Tomaz', 'R. Deputado Mario Monteiro, 52/04', 'Joo Pessoa', 'PB', '28001', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11014, 'LINOD', 1, 2, '1998-04-10', '1998-05-08', '1998-04-15', 3, '23.6000', '270.10', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11015, 'SANTG', 1, 2, '1998-04-10', '1998-04-24', '1998-04-20', 2, '4.6200', '622.35', 'Santa Fe Comidas', 'R. de Santa Izabel, 239', 'Salvador', 'BH', '4110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11016, 'AROUT', 1, 9, '1998-04-10', '1998-05-08', '1998-04-13', 2, '33.8000', '491.50', 'Arquimedes Alimentao', 'R. Taquaritinga, 48 B', 'Recife', 'PE', 'WA1 1DP', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11017, 'ERNSH', 1, 9, '1998-04-13', '1998-05-11', '1998-04-20', 2, '754.2600', '6750.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11018, 'LONEP', 1, 4, '1998-04-13', '1998-05-11', '1998-04-16', 2, '11.6500', '1575.00', 'Lamartine Restaurante', 'R. Uriel Paes Barreto,25', 'Florianopolis', 'SC', '97219', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11019, 'RANCH', 1, 6, '1998-04-13', '1998-05-11', NULL, 3, '3.1700', '76.00', 'Rancho grande', 'R. Dona Ana Xavier, 60 Lj 05', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11020, 'OTTIK', 1, 2, '1998-04-14', '1998-05-12', '1998-04-16', 2, '43.3000', '743.85', 'Otilia Alimento em Geral', 'R. Evaristo da Veiga, 106', 'Porto Alegre', 'RS', '50739', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11021, 'QUICK', 1, 3, '1998-04-14', '1998-05-12', '1998-04-21', 1, '297.1800', '6940.99', 'Que Bacana Comercio', 'R. Dona Rosa da Fonseca, 109/02', 'Porto Alegre', 'RS', '01307', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11022, 'HANAR', 1, 9, '1998-04-14', '1998-05-12', '1998-05-04', 2, '6.2700', '1402.00', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11023, 'BSBEV', 1, 1, '1998-04-14', '1998-04-28', '1998-04-24', 2, '123.8300', '1500.00', 'Beto Bebidas', 'R. Santa Isabel, 223 ap.202', 'Recife', 'PE', 'EC2 5NT', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11024, 'EASTC', 1, 4, '1998-04-15', '1998-05-13', '1998-04-20', 1, '74.3600', '1966.81', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11025, 'WARTH', 1, 6, '1998-04-15', '1998-05-13', '1998-04-24', 3, '29.1700', '299.80', 'Wilson Comida Diet', 'R. Carlos Mavignier, 274', 'Curitiba', 'PR', '90110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11026, 'FRANS', 1, 4, '1998-04-15', '1998-05-13', '1998-04-28', 1, '47.0900', '1030.00', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11027, 'BOTTM', 1, 1, '1998-04-16', '1998-05-14', '1998-04-20', 1, '52.5200', '1169.80', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11028, 'KOENE', 1, 2, '1998-04-16', '1998-05-14', '1998-04-22', 1, '29.5900', '2160.00', 'Katia Comidas em Geral', 'R. Luiz Cezario de Melo, 237', 'Joo Pessoa', 'PB', '14776', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11029, 'CHOPS', 1, 4, '1998-04-16', '1998-05-14', '1998-04-27', 1, '47.8400', '1286.80', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11030, 'SAVEA', 1, 7, '1998-04-17', '1998-05-15', '1998-04-27', 2, '830.7500', '16321.15', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11031, 'SAVEA', 1, 6, '1998-04-17', '1998-05-15', '1998-04-24', 2, '227.2200', '2393.50', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11032, 'WHITC', 1, 2, '1998-04-17', '1998-05-15', '1998-04-23', 3, '606.1900', '8902.50', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11033, 'RICSU', 1, 7, '1998-04-17', '1998-05-15', '1998-04-23', 3, '84.7400', '3591.80', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11034, 'OLDWO', 1, 8, '1998-04-20', '1998-06-01', '1998-04-27', 1, '40.3200', '554.30', 'Olinda - Delicatessen', 'R. Bento de Loyola, 161', 'Natal', 'RN', '99508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11035, 'SUPRD', 1, 2, '1998-04-20', '1998-05-18', '1998-04-24', 2, '0.1700', '1754.50', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11036, 'DRACD', 1, 8, '1998-04-20', '1998-05-18', '1998-04-22', 3, '149.4700', '1692.00', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11037, 'GODOS', 1, 7, '1998-04-21', '1998-05-19', '1998-04-27', 1, '3.2000', '60.00', 'Gordo Cozinha Tipica', 'R. Major Afonso Leal, 81/02', 'Terezina', 'PI', '41101', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11038, 'SUPRD', 1, 1, '1998-04-21', '1998-05-19', '1998-04-30', 2, '29.5900', '750.80', 'Super Delicias Ltda', 'R. Costa Lima, 49', 'Belm', 'PA', 'B-6000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11039, 'LINOD', 1, 1, '1998-04-21', '1998-05-19', NULL, 2, '65.0000', '3090.00', 'Lindolfo - Delicatessen', 'AV. Rui Barbosa, 1672', 'Campo Grande', 'MS', '4980', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11040, 'GREAL', 1, 4, '1998-04-22', '1998-05-20', NULL, 3, '18.8400', '200.00', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11041, 'CHOPS', 1, 3, '1998-04-22', '1998-05-20', '1998-04-28', 2, '48.2200', '1886.80', 'Chop-suey Chines', 'R. REDENTOR, 45', 'Fortaleza', 'CE', '3012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11042, 'COMMI', 1, 2, '1998-04-22', '1998-05-06', '1998-05-01', 1, '29.9900', '405.75', 'Comrcio Mineiro', 'R. Alfredo Gama, 14', 'Goiana', 'GO', '05432-043', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11043, 'SPECD', 1, 5, '1998-04-22', '1998-05-20', '1998-04-29', 2, '8.8000', '210.00', 'Sabores do Mundo', 'R. D. Ana Xavier, 60 lj.9/10', 'Curitiba', 'PR', '75016', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11044, 'WOLZA', 1, 4, '1998-04-23', '1998-05-21', '1998-05-01', 1, '8.7200', '591.60', 'Wanderson Culinaria', 'R. Bonito de Santa, 211', 'So Luis', 'MA', '01-012', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11045, 'BOTTM', 1, 6, '1998-04-23', '1998-05-21', NULL, 2, '70.5800', '1309.50', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11046, 'WANDK', 1, 8, '1998-04-23', '1998-05-21', '1998-04-24', 2, '71.6400', '1563.85', 'Wando Comida e Satisfao', 'R. Cecilia Reis, 45', 'Macei', 'AL', '70563', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11047, 'EASTC', 1, 7, '1998-04-24', '1998-05-22', '1998-05-01', 3, '46.6200', '1090.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11048, 'BOTTM', 1, 7, '1998-04-24', '1998-05-22', '1998-04-30', 3, '24.1200', '525.00', 'Barcelos Mercado', 'R. Bela Vista, 51', 'So Luis', 'MA', 'T2F 8M4', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11049, 'GOURL', 1, 3, '1998-04-24', '1998-05-22', '1998-05-04', 1, '8.3400', '341.60', 'Gourmet Lanchonetes', 'R. Melquizedeque de Lima, 105', 'Campo Grande', 'MS', '04876-786', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11050, 'FOLKO', 1, 8, '1998-04-27', '1998-05-25', '1998-05-05', 2, '59.4100', '899.90', 'Festa Popular', 'R. Nova Friburgo, 594', 'Recife', 'PE', 'S-844 67', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11051, 'LAMAI', 1, 7, '1998-04-27', '1998-05-25', NULL, 3, '2.7900', '44.80', 'Lagoa da Asia', 'R. Iguatama, 189', 'Aracaju', 'SE', '31000', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11052, 'HANAR', 1, 3, '1998-04-27', '1998-05-25', '1998-05-01', 1, '67.2600', '1664.60', 'Havai Carnes', 'Av. Dr. Eurico Chaves, 661', 'Joo Pessoa', 'PB', '05454-876', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11053, 'PICCO', 1, 2, '1998-04-27', '1998-05-25', '1998-04-29', 2, '53.0500', '3658.35', 'Pivete Vendas em Geral', 'R. Dr. Carlos Mavignier, 104', 'Belo Horizonte', 'MG', '5020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11054, 'CACTU', 1, 8, '1998-04-28', '1998-05-26', NULL, 1, '0.3300', '305.00', 'Cactus Comidas para levar', 'R. Rosa da Fonseca, 93/304', 'Macap', 'AP', '1010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11055, 'HILAA', 1, 7, '1998-04-28', '1998-05-26', '1998-05-05', 2, '120.9200', '1727.50', 'Hilda - Abastecimentos', 'R. jose Bonifacio, 232', 'Joo Pessoa', 'PB', '5022', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11056, 'EASTC', 1, 8, '1998-04-28', '1998-05-12', '1998-05-01', 2, '278.9600', '3740.00', 'Estacao do Oriente', 'R. Paula Batista, 165', 'Recife', 'PE', 'WX3 6FW', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11057, 'NORTS', 1, 3, '1998-04-29', '1998-05-27', '1998-05-01', 3, '4.1300', '45.00', 'Norte/Sul Ltda', 'R. General Meira Barreto, 63', 'Recife', 'PE', 'SW7 1RZ', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11058, 'BLAUS', 1, 9, '1998-04-29', '1998-05-27', NULL, 3, '31.1400', '858.00', 'Belo Delicatessen', 'R. Sta Maria Goreth, 226', 'Fortaleza', 'CE', '68306', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11059, 'RICAR', 1, 2, '1998-04-29', '1998-06-10', NULL, 2, '85.8000', '1838.00', 'Ricardo Adocicados', 'AV. 17 de Agosto, 892', 'Joo Pessoa', 'PB', '02389-890', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11060, 'FRANS', 1, 2, '1998-04-30', '1998-05-28', '1998-05-04', 2, '10.9800', '266.00', 'Francinete S.p.a', 'R. manoel apolinario, 102', 'Macei', 'AL', '10100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11061, 'GREAL', 1, 4, '1998-04-30', '1998-06-11', NULL, 3, '14.0100', '510.00', 'Grandes Lagos Alimentos', 'AV. pedro allaim, 125 ,casa, 17', 'Goiana', 'GO', '97403', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11062, 'REGGC', 1, 4, '1998-04-30', '1998-05-28', NULL, 2, '29.9300', '507.60', 'Regina Comercio Ltda', 'R. Dom Mauricio, 275', 'Goiana', 'GO', '42100', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11063, 'HUNGO', 1, 3, '1998-04-30', '1998-05-28', '1998-05-06', 2, '81.7300', '1445.30', 'Helena Coruja Noturna', 'R. Antonio Prado, 30', 'Palmas', 'TO', '', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11064, 'SAVEA', 1, 1, '1998-05-01', '1998-05-29', '1998-05-04', 1, '30.0900', '4722.00', 'Salvador Mercado', 'R. Alfredo Gama, 14', 'Macei', 'AL', '83720', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11065, 'LILAS', 1, 8, '1998-05-01', '1998-05-29', NULL, 1, '12.9100', '252.06', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11066, 'WHITC', 1, 7, '1998-05-01', '1998-05-29', '1998-05-04', 2, '44.7200', '928.75', 'Wanderlucia Trevo Mercado', 'AV. Juarez Tavora, 1230', 'Macei', 'AL', '98128', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11067, 'DRACD', 1, 1, '1998-05-04', '1998-05-18', '1998-05-06', 2, '7.9800', '86.85', 'Dracula Delicatessen', 'R. Prof. Alvaro Lima, 50', 'Manaus', 'AM', '52066', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11068, 'QUEEN', 1, 8, '1998-05-04', '1998-06-01', NULL, 2, '81.7500', '2384.35', 'Quero Mais Cozinha', 'R. Conde de Iraja,  520', 'Goiana', 'GO', '05487-020', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11069, 'TORTU', 1, 1, '1998-05-04', '1998-06-01', '1998-05-06', 2, '15.6700', '360.00', 'Tartaruga Restaurante', 'R. Conselheiro Nabuco, 151', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11070, 'LEHMS', 1, 2, '1998-05-05', '1998-06-02', NULL, 1, '136.0000', '1873.05', 'Leticia Comercio Ltda', 'R. Ibia, 97', 'Porto Alegre', 'RS', '60528', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11071, 'LILAS', 1, 1, '1998-05-05', '1998-06-02', NULL, 1, '0.9300', '509.90', 'LILA-Supermercado', 'R. 22 de outubro, 67', 'Curitiba', 'PR', '3508', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11072, 'ERNSH', 1, 4, '1998-05-05', '1998-06-02', NULL, 2, '258.6400', '5218.00', 'Encontro Certo', 'R. Padre Lemos, 644/sala 01', 'Goiana', 'GO', '8010', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11073, 'PERIC', 1, 2, '1998-05-05', '1998-06-02', NULL, 2, '24.9500', '300.00', 'Pericles Comidas classicas', 'R. Dr. Jose Ribeiro Campos, 45', 'Fortaleza', 'CE', '05033', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11074, 'SIMOB', 1, 7, '1998-05-06', '1998-06-03', NULL, 2, '18.4400', '244.25', 'Simao Comidas Ltda', 'R. da Harmonia  480/403', 'Goiana', 'GO', '1734', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11075, 'RICSU', 1, 8, '1998-05-06', '1998-06-03', NULL, 2, '6.1900', '585.55', 'Rivaldo Supermercados S/A', 'R. Des. Fonseca Galvao, 110', 'Recife', 'PE', '1203', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11076, 'BONAP', 1, 4, '1998-05-06', '1998-06-03', NULL, 2, '38.2800', '1056.25', 'Bom Apetite', 'R. Sao Vicente, 340', 'Joo Pessoa', 'PB', '13008', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11077, 'RATTC', 1, 1, '1998-05-06', '1998-06-03', NULL, 2, '8.5300', '1373.91', 'Rato e Gato Comestiveis', 'Av. Ver. Otacilio de Azevedo, 1581', 'Belo Horizonte', 'MG', '87110', 'brasil');
INSERT INTO `adm_pedidos` (`PedidoID`, `ClienteId`, `EmpresaID`, `EmpregadoID`, `DataPedido`, `DataPrevista`, `DataEnvio`, `EnvioVia`, `ValorFrete`, `ValorPedido`, `DestNome`, `DestEndereco`, `DestCidade`, `DestEstado`, `DestCaixaPostal`, `DestPais`) VALUES (11078, 'ALFKI', 1, 1, '2003-05-06', NULL, NULL, 1, '0.0000', '0.00', '', '', '', '', '', '');


DROP TABLE IF EXISTS `adm_produtos`;
CREATE TABLE `adm_produtos` (`ProdutoID` int(11) NOT NULL default '0', `NomeProduto` varchar(40) NOT NULL default '', `FornecedorID` int(11) default NULL, `CodEan` varchar(13) default NULL, `CategoriaID` int(11) default NULL, `QtdPorUnidade` varchar(20) default NULL, `PrecoUnit` decimal(16,4) default NULL, `ValorTotal` decimal(19,2) default NULL, `UnidEmEstoque` smallint(6) default NULL, `UnidEmPedidos` smallint(6) default NULL, `EstoqueMinimo` smallint(6) default NULL, `Descontinuar` smallint(6) default NULL, PRIMARY KEY  (`ProdutoID`)) TYPE=MyISAM;

INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (1, 'Cha de Boldo', 1, '78900349', 1, '20 Sacos', '18.0000', '702.00', 39, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (2, 'Cha de Erva Doce', 1, '78900349', 1, '12 sacos', '19.0000', '323.00', 17, 40, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (3, 'Caldo de Bacon Maggi', 1, '78900349', 2, '12 - 550 ml Garrafa', '10.0000', '130.00', 13, 70, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (4, 'Tempero Curry Arisco', 2, '78900349', 2, '48 - 6 Gramas', '22.0000', '1166.00', 53, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (5, 'Tempero Refil Ajinomoto', 2, '78900349', 2, '36 Caixa', '21.3500', '0.00', 0, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (6, 'Canela em P Kitano', 3, '78900349', 2, '12 - 200 Gramas Pote', '25.0000', '3000.00', 120, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (7, 'Sardinha Coqueiro', 3, '78900349', 7, '12 - saco com 10', '30.0000', '450.00', 15, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (8, 'Noz Moscada Felizardo', 3, '78900349', 2, '12 - saco com 10', '40.0000', '240.00', 6, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (9, 'Almondegas de Frango', 4, '78900349', 6, '18 - 500 g pc', '97.0000', '2813.00', 29, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (10, 'Lagosta de Maceio', 4, '78900349', 8, '1 kg', '31.0000', '961.00', 31, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (11, 'Queijo de Cabra', 5, '78900349', 4, '1 kg pc', '21.0000', '462.00', 22, 30, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (12, 'Queijo de Manteiga do Nordeste', 5, '78900349', 4, '10 - 500 g pc', '38.0000', '3268.00', 86, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (13, 'Ostra de Gaibu', 6, '78900349', 8, '10 und', '6.0000', '144.00', 24, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (14, 'Ervilha Bom Sabor', 6, '78900349', 7, '40 - 100 g pc', '23.2500', '813.75', 35, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (15, 'Molho Ingles', 6, '78900349', 2, '24 - 250 ml frasco', '15.5000', '604.50', 39, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (16, 'Biscoito So Luiz', 7, '78900349', 3, '32 - 500 g caixa', '17.4500', '506.05', 29, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (17, 'Frango Xadres Wenzel', 7, '78900349', 6, '20 - 1 kg Lata', '39.0000', '0.00', 0, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (18, 'Carne de Jacare', 7, '78900349', 8, '16 kg pc', '62.5000', '2625.00', 42, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (19, 'Biscoito de Chocolate Branco', 8, '78900349', 3, '10 caixasd x 12 pea', '9.2000', '230.00', 25, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (20, 'Biscoitos Confianca', 8, '78900349', 3, '30 - 5 pacotes', '81.0000', '3240.00', 40, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (21, 'Biscoitos Doces Tia Mafalda', 8, '78900349', 3, '24 pc. x 4 peas', '10.0000', '30.00', 3, 40, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (22, 'Farelo de Milho Catam', 9, '78900349', 5, '24 - 500 g pc.', '21.0000', '2184.00', 104, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (23, 'Aveia Amazonas', 9, '78900349', 5, '12 - 250 g pc.', '9.0000', '549.00', 61, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (24, 'Guaran Fantastico', 10, '78900349', 1, '12 - 355 ml', '4.5000', '90.00', 20, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (25, 'Pudim de Leite Moa', 11, '78900349', 3, '20 - 450 g es', '14.0000', '1064.00', 76, 0, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (26, 'Bombom Acaramelado', 11, '78900349', 3, '100 - 250 g', '31.2300', '468.45', 15, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (27, 'Doce de Leite da Mamae', 11, '78900349', 3, '100 - 100 g', '43.9000', '2151.10', 49, 0, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (28, 'Ameixas seca do Para', 12, '78900349', 7, '25 - 825 g Caixa', '45.6000', '1185.60', 26, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (29, 'Galinha Caipira do Nordeste', 12, '78900349', 6, '50 saco  x 30 pc.', '13.5500', '0.00', 0, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (30, 'Bacalhau do Norte', 13, '78900349', 8, '10 - 200 g caixa', '25.8900', '258.90', 10, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (31, 'Gorgonzola Especial', 14, '78900349', 4, '12 - 100 g pc', '12.5000', '0.00', 0, 70, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (32, 'Requeijo Boa Sorte', 14, '78900349', 4, '24 - 200 g pc.', '32.0000', '288.00', 9, 40, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (33, 'Mussarela Boa Vida', 15, '78900349', 4, '500 g', '2.5000', '280.00', 112, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (34, 'Bavaria do Recife', 16, '78900349', 1, '24  Garrafas', '14.0000', '1554.00', 111, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (35, 'Antartica do Brasil', 16, '78900349', 1, '24 garrafas', '18.0000', '360.00', 20, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (36, 'Cavala em Postas', 17, '78900349', 8, '24 - 250 g', '19.0000', '2128.00', 112, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (37, 'File de Cioba', 17, '78900349', 8, '12 - 500 g .', '26.0000', '286.00', 11, 50, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (38, 'Licor de Menta', 18, '78900349', 1, '1 garrafa', '263.5000', '4479.50', 17, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (39, 'Contreau Pitimbu', 18, '78900349', 1, '750 ml', '18.0000', '1242.00', 69, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (40, 'Carne de Tubaro', 19, '78900349', 8, '24 - 4', '18.4000', '2263.20', 123, 0, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (41, 'Sopa de Cabeca de Peixe', 19, '78900349', 8, '12 - 150 ml', '9.6500', '820.25', 85, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (42, 'Cereal Nescau Nestle', 20, '78900349', 5, '32 - 1 kg .', '14.0000', '364.00', 26, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (43, 'Cafe So Braz', 20, '78900349', 1, '16 - 500 g', '46.0000', '782.00', 17, 10, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (44, 'Molho Ingles Jimmi', 20, '78900349', 2, '20 - 2 kg', '19.4500', '525.15', 27, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (45, 'Rolinho de Carangueijo', 21, '78900349', 8, '1k pc.', '9.5000', '47.50', 5, 70, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (46, 'Camarao Netuno', 21, '78900349', 8, '4 - 450 g', '12.0000', '1140.00', 95, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (47, 'Sorvete Kibom', 22, '78900349', 3, '10 - 4', '9.5000', '342.00', 36, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (48, 'Chocolade Portugal', 22, '78900349', 3, '10 pkgs.', '12.7500', '191.25', 15, 70, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (49, 'Mamao Acaramelado', 23, '78900349', 3, '24 - 50 g .', '20.0000', '200.00', 10, 60, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (50, 'Paoca do Ceara', 23, '78900349', 3, '12 - 100 g', '16.2500', '1056.25', 65, 0, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (51, 'Atum Ralado Gomes da Costa', 24, '78900349', 7, '50 - 300 g pkgs.', '53.0000', '1060.00', 20, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (52, 'Mistura de Bolo', 24, '78900349', 5, '16 - 2 kg', '7.0000', '266.00', 38, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (53, 'Strogonoff de Carne', 24, '78900349', 6, '48 pc', '32.8000', '0.00', 0, 0, 0, -1);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (54, 'Tortinhas de Carne', 25, '78900349', 6, '16 pc', '7.4500', '156.45', 21, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (55, 'Frango ao Catupiti', 25, '78900349', 6, '24 cx x 2 pc', '24.0000', '2760.00', 115, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (56, 'Sucrilhos de Chocolate', 26, '78900349', 5, '24 - 250 g pkgs.', '38.0000', '798.00', 21, 10, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (57, 'Aveia com Chocolate Quaker', 26, '78900349', 5, '24 - 250 g .', '19.5000', '702.00', 36, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (58, 'Caragueijo Sa', 27, '78900349', 8, '24 peas', '13.2500', '821.50', 62, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (59, 'Requeijo Paraiba', 28, '78900349', 4, '5 kg pkg.', '55.0000', '4345.00', 79, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (60, 'Camembert de Caruaru', 28, '78900349', 4, '15 - 300 g', '34.0000', '646.00', 19, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (61, 'Molho Doce Azedo', 29, '78900349', 2, '24 - 500 ml', '28.5000', '3220.50', 113, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (62, 'Bombom Cristalizado', 29, '78900349', 3, '48 pc', '49.3000', '838.10', 17, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (63, 'Azedinho Alho Brasil', 7, '78900349', 2, '15 - 625 g', '43.9000', '1053.60', 24, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (64, 'Flocos de Arroz Okaki', 12, '78900349', 5, '20 cx x 4 pc', '33.2500', '731.50', 22, 80, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (65, 'Pimenta Vermelha Malagueta', 2, '78900349', 2, '32 - 8 oz bottles', '21.0500', '1599.80', 76, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (66, 'Tempero Suio Rose', 2, '78900349', 2, '24 - 8 Vidro', '17.0000', '68.00', 4, 100, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (67, 'Skol do Brasil', 16, '78900349', 1, '24 - 12 garrafas', '14.0000', '728.00', 52, 0, 10, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (68, 'Biscoito Doce Bom', 8, '78900349', 3, '10 boxes x 8 pc', '12.5000', '75.00', 6, 10, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (69, 'Gorgonzola Ligth', 15, '78900349', 4, '10 kg pkg.', '36.0000', '936.00', 26, 0, 15, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (70, 'Orange Cerveja', 7, '78900349', 1, '24 - 355 ml lata', '15.0000', '225.00', 15, 10, 30, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (71, 'Polemguinho Ligth', 15, '78900349', 4, '10 - 500 g pc.', '21.5000', '559.00', 26, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (72, 'Mussarela ao Molho Branco', 14, '78900349', 4, '24 - 200 g pkgs.', '34.8000', '487.20', 14, 0, 0, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (73, 'Tainha Branca', 17, '78900349', 8, '24 - 150 g', '15.0000', '1515.00', 101, 0, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (74, 'Salsicha Wilson', 4, '78900349', 7, '5 kg pc.', '10.0000', '40.00', 4, 20, 5, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (75, 'Conhaque Sao Bartolomeu', 12, '78900349', 1, '24 - 0.5 l garrafa', '7.7500', '968.75', 125, 0, 25, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (76, 'Licor de Cacau', 23, '78900349', 1, '500 ml', '18.0000', '1026.00', 57, 0, 20, 0);
INSERT INTO `adm_produtos` (`ProdutoID`, `NomeProduto`, `FornecedorID`, `CodEan`, `CategoriaID`, `QtdPorUnidade`, `PrecoUnit`, `ValorTotal`, `UnidEmEstoque`, `UnidEmPedidos`, `EstoqueMinimo`, `Descontinuar`) VALUES (77, 'Molho de Mustarda', 12, '78900349', 2, '12 - 10 200 ml', '13.0000', '416.00', 32, 0, 15, 0);

DROP TABLE IF EXISTS `adm_transportadoras`;
CREATE TABLE `adm_transportadoras` (`TransportadoraID` int(11) NOT NULL default '0', `NomeEmpresa` varchar(40) NOT NULL default '', `Fone` varchar(24) default NULL, PRIMARY KEY  (`TransportadoraID`)) TYPE=MyISAM;

INSERT INTO `adm_transportadoras` (`TransportadoraID`, `NomeEmpresa`, `Fone`) VALUES (1, 'Rapidao Cometa', '(503) 555-9831');
INSERT INTO `adm_transportadoras` (`TransportadoraID`, `NomeEmpresa`, `Fone`) VALUES (2, 'Dom Vital', '(503) 555-3199');
INSERT INTO `adm_transportadoras` (`TransportadoraID`, `NomeEmpresa`, `Fone`) VALUES (3, 'Correio - Sedex', '(503) 555-9931');

DROP TABLE IF EXISTS `adm_cidades`;
CREATE TABLE `adm_cidades` (`cidade` varchar(15) default NULL,`estado` char(2) default NULL) TYPE=MyISAM;
INSERT INTO `adm_cidades` VALUES ('Olinda', 'PE');
INSERT INTO `adm_cidades` VALUES ('Fortaleza', 'CE');
INSERT INTO `adm_cidades` VALUES ('Recife', 'PE');
INSERT INTO `adm_cidades` VALUES ('Paulista', 'PE');
INSERT INTO `adm_cidades` VALUES ('Rio de Janeiro', 'RJ');
INSERT INTO `adm_cidades` VALUES ('Joo Pessoa', 'PB');
INSERT INTO `adm_cidades` VALUES ('So Luis', 'MA');
INSERT INTO `adm_cidades` VALUES ('Macap', 'AP');
INSERT INTO `adm_cidades` VALUES ('Goiana', 'GO');
INSERT INTO `adm_cidades` VALUES ('Manaus', 'AM');
INSERT INTO `adm_cidades` VALUES ('Aracaju', 'SE');
INSERT INTO `adm_cidades` VALUES ('Campina Grande', 'PB');
INSERT INTO `adm_cidades` VALUES ('Sao Paulo', 'SP');
INSERT INTO `adm_cidades` VALUES ('Anaplis', 'GO');
INSERT INTO `adm_cidades` VALUES ('Macei', 'AL');
INSERT INTO `adm_cidades` VALUES ('Porto Velho', 'RO');
INSERT INTO `adm_cidades` VALUES ('Terezina', 'PI');
INSERT INTO `adm_cidades` VALUES ('Campo Grande', 'MS');
INSERT INTO `adm_cidades` VALUES ('Vitria', 'ES');
INSERT INTO `adm_cidades` VALUES ('Palmas', 'TO');
INSERT INTO `adm_cidades` VALUES ('Porto Alegre', 'RS');
INSERT INTO `adm_cidades` VALUES ('Rio Branco', 'AC');
INSERT INTO `adm_cidades` VALUES ('Curitiba', 'PR');
INSERT INTO `adm_cidades` VALUES ('Florianopolis', 'SC');
INSERT INTO `adm_cidades` VALUES ('Natal', 'RN');
INSERT INTO `adm_cidades` VALUES ('Caxias', 'RS');
INSERT INTO `adm_cidades` VALUES ('Aracati', 'CE');
INSERT INTO `adm_cidades` VALUES ('Belo Horizonte', 'MG');
INSERT INTO `adm_cidades` VALUES ('So Carlos', 'SP');
INSERT INTO `adm_cidades` VALUES ('Coxixola', 'PB');
INSERT INTO `adm_cidades` VALUES ('Salvador', 'BA');
INSERT INTO `adm_cidades` VALUES ('Arapiraca', 'AL');
INSERT INTO `adm_cidades` VALUES ('Belm', 'PA');
INSERT INTO `adm_cidades` VALUES ('Londrina', 'PR');
