/* Add TABLE "notif_inbox"                                                   */

CREATE TABLE "notiftable_inbox" (
  "inbox_id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  "notif_id" INTEGER,
  "login" TEXT,
  "notif_dtsent" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "notif_ontop" INTEGER DEFAULT '0',
  "notif_isread" INTEGER DEFAULT '0',
  "notif_dtread" TIMESTAMP DEFAULT NULL,
  "notif_tags" TEXT DEFAULT NULL,
  "notif_important" INTEGER DEFAULT NULL
);

/* Add TABLE "notif_pref"                                                   */

CREATE TABLE "notiftable_pref" (
  "login" TEXT,
  "receive_email" INTEGER DEFAULT '0',
  "receive_sms" INTEGER DEFAULT '0',
  PRIMARY KEY ("login")
);

/* Add TABLE "notif_tags"                                                   */

CREATE TABLE "notiftable_tags" (
  "tag_id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  "tag_title" TEXT NOT NULL,
  "login" TEXT,
  "tag_color" TEXT DEFAULT NULL,
  "tag_active" INTEGER DEFAULT '1'
);

/* Add TABLE "notif_notifications"                                                   */

CREATE TABLE "notiftable_notifications" (
  "notif_id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  "notif_title" TEXT,
  "notif_message" TEXT NOT NULL,
  "notif_dtcreated" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  "notif_ontop" INTEGER DEFAULT '0',
  "notif_dtexpire" TIMESTAMP DEFAULT NULL,
  "notif_categ" TEXT DEFAULT NULL,
  "notif_login_sender" TEXT,
  "notif_type" TEXT DEFAULT NULL,
  "notif_link" TEXT DEFAULT NULL,
  "deleted_at" TIMESTAMP DEFAULT NULL
);

/* Add TABLE "notif_profiles"                                                   */

CREATE TABLE "notiftable_profiles" (
    "profile_id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "profile_name" TEXT NOT NULL,
    "profile_users" TEXT NULL,
    "profile_groups" TEXT NULL,
    "profile_public" INTEGER DEFAULT '0',
    "profile_owner" TEXT NULL
);

/* Add TABLE "notif_user_tags"                                                   */

CREATE TABLE "notiftable_user_tags" (
    "user_tags_id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "login" TEXT,
    "login_sender" TEXT,
    "tags" TEXT DEFAULT NULL
);


