<?php

$arr_data  = $this->GetVar('menu_themes_list');
$handler  = $this->GetVar('handler');


function buildPicker($col) {
    ob_start();
    ?>

    <div class="field colorpicking_field">
        <label for="input_<?php echo $col; ?>"><?php echo nm_get_text_lang("['theme_".$col."']"); ?></label>
        <div class="ui left labeled action input">
            <div class="ui basic label" style="width: 30px;"></div>
            <input id="input_<?php echo $col; ?>" name="input_<?php echo $col; ?>" type="text" placeholder="#000000">
            <button class="ui icon button">
                <i class="eye dropper icon"></i>
            </button>
        </div>
    </div>
    <?php
    $field = ob_get_clean();
    return $field;
}

?>
<style>
    .required-label {
        font-size: 11px;
        font-weight: bold;
        color: #9f3a38;
    }
    .colorpicker {
        z-index: 2000;
        filter: none !important;
    }
    .colorpicker * {
        filter: none !important;
    }
    .del-col {
        width: 20px;
        vertical-align: middle;
        text-align: center;
    }

    .del-col {
        display: flex;
        height: 40px;
        width: 40px;
        justify-content: center;
        align-items: center;
        position: absolute;
        margin: 0;
        padding: 0;
        color: #ed6a6a;
        left: -43px;
        top: 3px;
    }

    .del-col > i {
        /* height: 20px; */
        /* width: 20px; */
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0;
    }

    .action-buttons {
        position: sticky;
        top: 1rem;
        margin-bottom: 2rem;
        padding: 1rem;
        background-color: white;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        z-index: 100;
    }

    .table-container {
        max-height: 70vh;
        overflow-y: auto;
        margin-bottom: 1rem;
    }

    .table-container table {
        width: 100%;
    }

    .table-container thead th {
        position: sticky;
        top: 0;
        background-color: #f9fafb !important;
        z-index: 1;
    }
</style>
<script>
    function getSelectedData() {
        var checkedInput = $('.theme-radio-sel:checked');
        var data = false;

        if (checkedInput[0]) {
            data = JSON.parse(atob(checkedInput.closest('.theme-line').find('.data-values').val()));
        }

        return data;
    }

    function updateButtons() {
        var data = getSelectedData();
        var editBtn = $('#edit-theme-btn');
        var previewBtn = $('#preview-theme-btn');
        var copyBtn = $('#copy-theme-btn');
        var delBtn = $('#del-theme-btn');

        editBtn.addClass('disabled');
        // copyBtn.addClass('disabled');
        previewBtn.addClass('disabled');
        delBtn.addClass('disabled');
        // editBtn.show();
        // copyBtn.hide();

        if (data) {
            // editBtn.hide();
            // copyBtn.hide();

            if (data.scope == 'scriptcase') {
                // copyBtn.show();
                copyBtn.removeClass('disabled');
            } else {
                // editBtn.show();
                editBtn.removeClass('disabled');
                delBtn.removeClass('disabled');
            }

            previewBtn.removeClass('disabled');
        }
    }

    function cancelModal() {
        nmFrmScaseRunFunc('confirmMessage', [
            function() {
                $('#modal-theme').modal('hide');
            },
            {
                title: '<?php echo nm_get_text_lang("['msg_cancel_create_conn']", 'AdminSysAllConectionsCreateWizard'); ?>',
                message: '<?php echo nm_get_text_lang("['error_lose_changes']", 'DbConvert'); ?>'
            }
        ]);

    }

    function saveTheme() {
        if (validateForm()) {
            $('#theme-values-form').submit();
        }
    }

    function deleteThemeItem() {
        //ev.stopPropagation();
        var data = getSelectedData();
        var theme_name = data.name;
        var theme_scope = data.scope;

        nmFrmScaseRunFunc('confirmMessage', [
            function() {
                $('#delete-name').val(theme_name);
                $('#delete-filescope').val(theme_scope);
                $('#delete-form').submit();
            },
            {
                title: '<?php echo nm_get_text_lang("['help_case_menu_del']", 'HelpCaseMenu'); ?>',
                message: '<?php echo nm_get_text_lang("['confirm_del']", 'HelpCaseMenu'); ?>'
            }
        ]);
    }

    function fillFieldsCreate() {
        modalFieldValues();
    }

    function fillFieldsEdit() {
        var data = getSelectedData();
        modalFieldValues(data);
    }

    function fillFieldsCopy() {
        var data = getSelectedData();
        data.name += ' Copy';
        modalFieldValues(data);
        $('#field-theme-orig').val('');
    }

    function validateForm() {
        var error = false;
        var error_msg = '';
        $('#field-theme-name').closest('.field').removeClass('error');
        $('#form-errors').find('.list li').html('');
        $('#form-errors').hide();

        if ($('#field-theme-name').val().trim() == '' ) {
            error_msg = getLangs().theme_name_empty;
            error = true;
        } else if (themes_names.includes($('#field-theme-name').val().trim()) && ($('#field-theme-orig').val().trim() == '' || $('#field-theme-orig').val().trim() != $('#field-theme-name').val().trim()) ) {
            error_msg = getLangs().msg_not_unique_friendly;
            error = true;
        } else if (!/^[a-zA-Z0-9 _-]*$/.test($('#field-theme-name').val())) {
            error_msg = getLangs().theme_name_invalid;
            error = true;
        }

        if (error) {
            $('#field-theme-name').closest('.field').addClass('error');
            $('#form-errors').find('.list li').html(error_msg);
            $('#form-errors').show();
            return false;
        }
        return true;
    }

    function modalFieldValues(fill) {
        $('#field-theme-name').closest('.field').removeClass('error');
        $('#form-errors').find('.list li').html('');
        $('#form-errors').hide();
        if (typeof(fill) === typeof(undefined)) {
            $('#field-theme-name').val('');
            $('#field-theme-orig').val('');
            $('#input_primary_color').val('');
            $('#input_secondary_color').val('');
            $('#input_accent_color').val('');
            $('#input_muted_color').val('');
            $('#input_text_color').val('');
            $('#input_box_shadow').val('');
            $('#input_notification_color').val('');
            $('#filescope-orig').val('');
            $('#filescope').dropdown('set selected', 'public');
        } else {
            $('#field-theme-name').val(fill.name);
            $('#field-theme-orig').val(fill.name);
            $('#input_primary_color').val(fill.p);
            $('#input_secondary_color').val(fill.s);
            $('#input_accent_color').val(fill.a);
            $('#input_muted_color').val(fill.m);
            $('#input_text_color').val(fill.t);
            $('#input_box_shadow').val(fill.b);
            $('#input_notification_color').val(fill.n);
            $('#filescope-orig').val(fill.scope);
            $('#filescope').dropdown('set selected', fill.scope);
        }

        colorPickingSincColor();
    }

    function showPreview() {
        var data = getSelectedData();
        // $('#modal-preview').find('iframe')[0].contentWindow.document.body.innerHTML = '';
        $('#modal-preview').find('iframe').attr('src', '?preview_menu=Y&colors-data=' + btoa(JSON.stringify(data)));
        $('#modal-preview').modal({
            onHide: function() {
                $('#modal-preview').find('iframe').attr('src', 'about:blank');
            },
            onShow: function() {
                $('#preview-theme-btn').blur();
            }
        });
        $('#modal-preview').modal('show');
    }

    function getLangs() {
        var page_langs_arr = {
            new_theme: "<?php echo nm_get_text_lang("['new_theme']"); ?>",
            preview_theme: "<?php echo nm_get_text_lang("['preview_theme']"); ?>",
            edit_theme: "<?php echo nm_get_text_lang("['edit_theme']"); ?>",
            copy_theme: "<?php echo nm_get_text_lang("['copy_theme']"); ?>",
            clear_selection: "<?php echo nm_get_text_lang("['clear_selection']"); ?>",
            newmenuedit_theme_name: "<?php echo nm_get_text_lang("['newmenuedit_theme_name']"); ?>",
            newmenuedit_colors: "<?php echo nm_get_text_lang("['newmenuedit_colors']"); ?>",
            theme_name: "<?php echo nm_get_text_lang("['theme_name']"); ?>",
            theme_color_palette: "<?php echo nm_get_text_lang("['theme_color_palette']"); ?>",
            theme_primary_color: "<?php echo nm_get_text_lang("['theme_primary_color']"); ?>",
            theme_secondary_color: "<?php echo nm_get_text_lang("['theme_secondary_color']"); ?>",
            theme_accent_color: "<?php echo nm_get_text_lang("['theme_accent_color']"); ?>",
            theme_muted_color: "<?php echo nm_get_text_lang("['theme_muted_color']"); ?>",
            theme_text_color: "<?php echo nm_get_text_lang("['theme_text_color']"); ?>",
            theme_box_shadow: "<?php echo nm_get_text_lang("['theme_box_shadow']"); ?>",
            theme_notification_color: "<?php echo nm_get_text_lang("['theme_notification_color']"); ?>",
            theme_color_picker: "<?php echo nm_get_text_lang("['theme_color_picker']"); ?>",
            select_a_color: "<?php echo nm_get_text_lang("['select_a_color']"); ?>",
            color_render_error: "<?php echo nm_get_text_lang("['color_render_error']"); ?>",
            required_field_error: "<?php echo nm_get_text_lang("['required_field_error']"); ?>",
            create_new_theme: "<?php echo nm_get_text_lang("['create_new_theme']"); ?>",
            edit_theme: "<?php echo nm_get_text_lang("['edit_theme']"); ?>",
            msg_not_unique_friendly: "<?php echo nm_get_text_lang("['msg_not_unique_friendly']", 'App'); ?>",
            theme_name_empty: "<?php echo nm_get_text_lang("['theme_name_empty']", 'ThemeMenu'); ?>",
            theme_name_invalid: "<?php echo nm_get_text_lang("['theme_name_invalid']"); ?>",
        };
        return page_langs_arr;
    }
</script>
<main id="main-container" class="ui container">
    <section>
        <!-- botões de ações -->
        <div class="action-buttons">
            <button id="new-theme-btn" class="ui primary button theme-action-btn">
                <i class="plus icon"></i>
                <?php echo nm_get_text_lang("['new_theme']"); ?>
            </button>

            <button id="preview-theme-btn" class="ui disabled button" onclick="showPreview()">
                <i class="eye icon"></i>
                <?php echo nm_get_text_lang("['preview_theme']"); ?>
            </button>

            <button id="edit-theme-btn" class="ui disabled button theme-action-btn">
                <i class="edit icon"></i>
                <?php echo nm_get_text_lang("['edit_theme']"); ?>
            </button>

            <button id="copy-theme-btn" class="ui disabled button theme-action-btn">
                <i class="copy icon"></i>
                <?php echo nm_get_text_lang("['copy_theme']"); ?>
            </button>

            <button id="del-theme-btn" class="ui disabled button" onclick="deleteThemeItem()">
                <i class="trash icon"></i>
                <?php echo nm_get_text_lang("['delete_theme']"); ?>
            </button>
            <a id="remove-radio-selection" href="javascript:void(0)"><?php echo nm_get_text_lang("['clear_selection']"); ?></a>
        </div>
        <!-- tabela de temas -->
        <div class="table-container">
            <table id="theme-table" class="ui padded striped selectable sortable celled definition table">
                <thead>
                <tr>
                    <th class="no-sort"></th>
                    <th class=""><?php echo nm_get_text_lang("['newmenuedit_theme_name']"); ?></th>
                    <th class="no-sort"><?php echo nm_get_text_lang("['newmenuedit_colors']"); ?></th>
                    <th class="sorted descending"><?php echo nm_get_text_lang("['tags_mod']", 'AppSchemaAdvanced'); ?></th>
                </tr>
                </thead>
                <tbody>
                    <?php
                    $theme_names = [];
                    foreach ($arr_data as $k => $theme) {
                        $theme_names[] = $theme['name'];
                    ?>
                    <tr class="theme-line">
                        <td class="collapsing" style="position: relative;">
                            <?php if (false && $theme['scope'] != 'scriptcase') { ?>
                                <a class="del-col" href="javascript:void(0);" onclick="">
                                    <i class="trash icon"></i>
                                </a>
                            <?php } ?>
                            <div class="ui radio checkbox">
                                <input type="radio" name="theme-radio" tabindex="0" class="hidden theme-radio-sel">
                                <input type="hidden" class="data-values" value="<?php echo base64_encode(json_encode($theme)); ?>" >
                            </div>
                        </td>
                        <td><?php echo $theme['name']; ?></td>
                        <td class="collapsing" data-colors="<?php echo $theme['p']; ?>__##NM##__<?php echo $theme['s']; ?>__##NM##__<?php echo $theme['a']; ?>__##NM##__<?php echo $theme['m']; ?>__##NM##__<?php echo $theme['t']; ?>__##NM##__<?php echo $theme['n']; ?>__##NM##__<?php echo $theme['b']; ?>">
                        </td>
                        <td class="collapsing"><?php echo scopeName($theme['scope']); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
                <tfoot>
                <?php /*
                <tr>
                    <td colspan="4">
                        <div id="table-theme-footer">

                            <div class="ui pagination menu">
                                <a class="icon item">
                                    <i class="left chevron icon"></i>
                                </a>
                                <a class="item">1</a>
                                <a class="icon item">
                                    <i class="right chevron icon"></i>
                                </a>
                            </div>
                        </div>
                    </td>
                </tr>
     */ ?>
                </tfoot>
            </table>
        </div>
        <form id="delete-form" action="">
            <input type="hidden" name="delete-name" id="delete-name" />
            <input type="hidden" name="delete-filescope" id="delete-filescope" />
        </form>
    </section>

    <!-- modal de novo tema / edição -->
    <section id="modal-preview" class="ui modal" style="height: 400px; width: 80vw;">
        <iframe src="?preview_menu=Y" id="preview-frame" style="width: 100%;height: 100%;" frameborder="0"></iframe>
    </section>
    <section id="modal-theme" class="ui modal">
        <h1 class="header"></h1>
        <div class="content">
            <form id="theme-values-form" action="" class="ui form">
                <div class="equal width fields">
                    <div class="field">
                        <label for="field-theme-name"><?php echo nm_get_text_lang("['theme_name']"); ?> <span class="required-label">*</span></label>
                        <input type="text" name="field-theme-name" id="field-theme-name">
                        <input type="hidden" name="field-theme-orig" id="field-theme-orig">
                        <span class="ui error message"></span>
                    </div>
                    <div class="field">
                        <label for="field-theme-scope"><?php echo nm_get_text_lang("['tags_mod']", 'AppSchemaAdvanced'); ?> <span class="required-label">*</span></label>
                        <select id="filescope" name="filescope" class="ui dropdown">
                            <?php
                            $modules = $handler->getTemplateList();
                            foreach ($modules as $id => $module) {
                                if ($id != 'scriptcase') {
                                    ?>
                                    <option value="<?php echo $id; ?>"><?php echo $module['title']; ?></option>
                                    <?php
                                }
                            }
                            ?>
                        </select>
                        <input type="hidden" name="filescope-orig" id="filescope-orig">
                    </div>
<!--                    <div class="field">-->
<!--                        <label for="field-theme-author">Autor do tema</label>-->
<!--                        <input type="text" name="field-theme-author" id="field-theme-author">-->
<!--                    </div>-->
                </div>

<!--                <h3 class="ui dividing header">Tipografia</h3>-->
<!--                <div class="field">-->
<!--                    <label for="field-typography">Família tipográfica</label>-->
<!--                    <select name="field-typography" id="field-typography" class="ui dropdown"></select>-->
<!--                </div>-->

                <h3 class="ui dividing header"><?php echo nm_get_text_lang("['theme_color_palette']"); ?></h3>
                <div class="equal width fields">
                    <?php echo buildPicker('primary_color'); ?>
                    <?php echo buildPicker('secondary_color'); ?>
                    <?php echo buildPicker('accent_color'); ?>
                </div>

                <div class="equal width fields">

                    <?php echo buildPicker('muted_color'); ?>
                    <?php echo buildPicker('text_color'); ?>
                    <?php echo buildPicker('notification_color'); ?>
                </div>

                <div class="equal width fields">
                    <?php echo buildPicker('box_shadow'); ?>
                    <div class="field">
                    </div>
                    <div class="field">
                    </div>
                </div>
                <div class="ui error message" id="form-errors">
                    <div class="header">
                        <?php echo nm_get_text_lang("['err_form']"); ?>
                    </div>
                    <ul class="list">
                        <li></li>
                    </ul>
                </div>
                <span class="required-label">* <?php echo nm_get_text_lang("['app_sub_mandatory']", 'App'); ?></span>
            </form>
        </div>
        <div class="actions">
            <button class="ui primary button" onclick="saveTheme();"><?php echo nm_get_text_lang("['save']"); ?></button>
            <button class="ui button" onclick="cancelModal();"><?php echo nm_get_text_lang("['cancel']"); ?></button>
        </div>
        <script>
            var themes_names = <?php echo json_encode($theme_names); ?>;
            function colorPickingSincColor() {
                $('.colorpicking_field').each(function (i,el_p) {
                    var fld_el_dom = $(el_p).find('.ui.basic.label');
                    var fld_el_fld = $(el_p).find('input');
                    $(fld_el_dom).css('background', fld_el_fld.val());
                });
            }
            function readyColorPicking() {
                $('.colorpicking_field').each(function (i,el_name) {
                    var fld_name_cp = $(el_name).find('input').attr('id').replace('input_', '');
                    var el_p = $(el_name).find('input');
                    var fld_el_dom = $(el_name).find('.ui.basic.label');
                    var btn_el_dom = $(el_name).find('button');
                    el_p.on('change.colorpicker_field_change', function () {
                        $(fld_el_dom).css('backgroundColor', el_p.val());
                        $(btn_el_dom).ColorPickerSetColor(el_p.val());
                    });
                    $(btn_el_dom).ColorPicker({
                        color: el_p.val(),
                        onShow: function (colpkr) {
                            $(colpkr).fadeIn(500);
                            return false;
                        },
                        onSubmit: function(hsb, hex, rgb, el) {
                            $(fld_el_dom).css('backgroundColor', '#' + hex);
                            el_p.val('#' + hex);
                            $(el).ColorPickerHide();
                        },
                        onHide: function (colpkr) {
                            $(colpkr).fadeOut(500);
                            return false;
                        },
                    });
                });
            }
            $(document).ready(function() {
                readyColorPicking();
                $('.ui.dropdown').dropdown();
            });
        </script>
    </section>
</main>
