<?php

/**

 * Template scriptcase.

 *

 * Modulo de Seguranca.

 *

 * @package     Template

 * @subpackage  Scriptcase

 * @creation    2009/04/14

 * @copyright   NetMake Solucoes em Informatica

 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>

 *

 * $Id: body_security_module_step_carregar.tpl.php,v 1.2 2012-01-25 13:52:25 vinicius Exp $

 */



/* Protecao contra hacks */

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))

{

    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .

        'invalid access to system file.');

}

$option_profile = $this->GetVar('option_profile');
$without_profile = empty($option_profile);

?>
<style>
.ui.cards > .card .meta * {
    margin-right: 0em
}
</style>
<input type="hidden" name="option_profile" value="">
<input type="hidden" name="profile" value="">

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['create']"); ?></h3>
    </div>

    <div class="right floated four wide column" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
    <div class="ui divider"></div>
    <h5><?php echo nm_get_text_lang("['new_profile_desc']"); ?></h5>
    <div class="ui one buttons">
                <div class="ui positive button" 
                	 onclick="$('input[name=profile]').val('create'); $('#form_notification').submit();">
                	 	<i class="plus icon"></i> 
                	 	<?php echo nm_get_text_lang("['new_profile']"); ?>
                </div>
            </div>
<div class="left floated twelve wide column" style="padding-top:25px;text-align: left;">
    <h3 class="ui header"><?php echo nm_get_text_lang("['list_profile']"); ?></h3>
</div>
<div class="ui divider"></div>
<div class="ui  five cards">
    <?php foreach($option_profile as $tipo => $options): ?>
    <?php foreach($options as $file => $option): ?>
    <div class="card" id="profile_<?php echo $tipo . '__NM__' . strtr($file, ['.'=> '__NM__']); ?>">
        <div class="content">
            <div class="header">
                <span class="span_name"><?php echo $option['profile']; ?></span>
                <div class="ui form hide div_rename">
                    <div class="ui action input small" style="width: 74%;">
                        <input type="text" class='new_name' value="<?php echo $option['profile']; ?>">
                        <button class="ui button tiny" onclick="renameProfile('<?php echo $tipo . '#@NM@#' . $file; ?>', $(this).parent().find('.new_name').val()); return false;"><i class="fa fa-check"></i></button>
                    </div>
                </div>
                <div class="right floated four wide column editButton" style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
                    <div class="ui  compact " onclick="showNewName(this)" style="cursor:pointer"> <i class="fa fa-pencil"></i></div>
                </div>
            </div>
            <div class="ui divider"></div>
            <div class="meta">
                <strong><?php echo nm_get_text_lang("['mod_level']"); ?>:</strong> <?php echo nm_get_text_lang("['mod_" . $tipo . "']"); ?><br/>
                <strong><?php echo nm_get_text_lang("['mod_type']"); ?>:</strong> <?php echo nm_get_text_lang("['". $option['tipo_nivel'] ."']['title']"); ?>
            </div>
            <div class="description">
            </div>
        </div>

        <div class="extra content">
            <div class="ui  ">
                <div class="ui  compact primary button" onclick="useProfile('<?php echo $tipo . '#@NM@#' . $file; ?>');"><?php echo nm_get_text_lang("['use_template']"); ?></div>
                <div class="ui  compact  button" onclick="deleteProfile('<?php echo $tipo . '#@NM@#' . $file; ?>')"> <i class="fa fa-trash"></i></div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php endforeach; ?>
</div>
<div class="ui modal tiny" id="modal-delete-profile">
	<div class="content">
		<span id="modal-delete-span-description">
			<?php echo nm_get_text_lang("['delete_profile']"); ?>
		</span>
	</div>
    <div class="actions">
        <div class="ui cancel button">
        	Cancel
        </div>
        <div class="ui primary approve button">
        	OK
        </div>
    </div>
</div>
<script>
	function useProfile(profile){
		$('input[name=option_profile]').val(profile);
		$('input[name=profile]').val('use'); 
		$('#form_notification').submit();
	}

    function deleteProfile(profile) {
    	$('#modal-delete-profile').modal({
    		onApprove : function(){
    			$.ajax({
                    type: 'POST',
                    url: '<?php echo $nm_config['url_iface']; ?>module_notification.php',
                    cache: false,
                    async: true,
                    data: 'nm_ajax=1&nm_option=deleteProfile&p=' + profile,
                    success: function (retorno) {
                        profile = profile.replace('#@NM@#', '__NM__').replace('.', '__NM__');
                        $('#profile_' + profile).remove();
                    }
                });
    		}
    	});
    	$('#modal-delete-profile').modal('show');
    }

    function renameProfile(profile, new_name){
    	if(!correct_prefix(new_name) || new_name == '')
    	{
    		nm_display_alert('<?php echo nm_get_text_lang("['profile_incorrect']"); ?>');
            return false;
    	}
    	
        $.ajax({
            type: 'POST',
            url: '<?php echo $nm_config['url_iface']; ?>module_notification.php',
            cache: false,
            async: true,
            data: 'nm_ajax=1&nm_option=renameProfile&p='+profile + '&new_name='+new_name,
            success: function (retorno) {
            	if(retorno != 'ok'){
					nm_display_alert(retorno);
            	}else{
                	profile = profile.replace('#@NM@#', '__NM__').replace('.', '__NM__');
                    $('#profile_' + profile ).find('.div_rename').addClass('hide');
                    $('#profile_' + profile ).find('.editButton').removeClass('hide');
                    $('#profile_' + profile ).find('.span_name').removeClass('hide');
                    $('#profile_' + profile ).find('.span_name').html(new_name);
                }
            }
        });
    }

    function showNewName(t){
        $(t).parent().parent().find('.div_rename').removeClass('hide');
        $(t).parent().parent().find('.span_name').addClass('hide');
        $(t).parent().parent().find('.editButton').addClass('hide');
    }
</script>