<?php

/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_tabela.tpl.php,v 1.3 2012-01-25 13:52:25 vinicius Exp $
 */


/* Protecao contra hacks */

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {

    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .

        'invalid access to system file.');

}


$arr_connections = $this->GetVar('arr_connections');
?>

<script>


    function nm_open_prefix(valor) {

        if (valor == 'create') {

            $("#id_tabela_seg_prefix").attr('disabled', false);

            $("#id_tabela_drop_tables").attr('disabled', false);

            $("#id_tr_input_prefix").css('color', '#000');

            $("#id_tr_drop_tables").css('color', '#000');

            $("#id_fix").hide();

            return;

        }

        $("#id_tabela_seg_prefix").attr('disabled', 'disabled');

        $("#id_tabela_drop_tables").attr('disabled', 'disabled');

        $("#id_tabela_drop_tables").attr('checked', false);

        $("#id_tr_input_prefix").css('color', '#CECECE');

        $("#id_tr_drop_tables").css('color', '#CECECE');

    }

</script>
<style>
    label {
        font-size: 14px !important;
    }
</style>

<div class="ui grid">
    <div class="left floated twelve wide column" style="text-align: left;">

        <h3 class="ui header"><?php echo nm_get_text_lang("['table_notification']"); ?></h3>
    </div>

    <div class="right floated four wide column"
         style="display: flex; flex-direction: row; justify-content: flex-end; align-items: center;">
        <?php echo $this->GetVar('block_image_help'); ?>
    </div>
</div>
<div class="ui divider"></div>
<div class="ui segment">
    <div class="ui loader"></div>

    <div class="ui form">
        <div class="fields two column">
            <div class="field required">
                <label><?php echo nm_get_text_lang("['connection']"); ?></label>
                <div class="ui action input">
                    <select class="ui fluid dropdown" name="tabela_conn" onchange="nm_check_connection(this.value);"
                            required>
                        <option value=""></option>
                        <?php
                        foreach ($arr_connections as $k => $conn) {
                            echo "<option value='" . $k . "'>" . $k . "</option>";
                        }
                        ?>
                    </select>
                    <a href="javascript: refreshTables();" id='tabela_conn_refresh'>
                        <div class="ui button">
                            <i class="fa fa-rotate-right"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="field">
                <div class="grouped fields">
                    <label for="tabela_seg"><?php echo nm_get_text_lang("['table_mode']['title']"); ?></label>
                    <div class="field">
                        <div class="ui radio checkbox">
                            <input type="radio" name="tabela_seg" tabindex="0" class="hidden" value="use"
                                   onchange="nm_open_prefix(this.value);">
                            <label><?php echo nm_get_text_lang("['associate_table']"); ?></label>
                        </div>
                    </div>
                    <div class="field">
                        <div class="ui radio checkbox">
                            <input type="radio" name="tabela_seg" tabindex="0" class="hidden" checked value="create"
                                   onchange="nm_open_prefix(this.value);">
                            <label><?php echo nm_get_text_lang("['create_table']"); ?></label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="ui form">
            <div class="fields two column">
                <div class="grouped fields">

                    <div class="field" id="id_tr_input_prefix">
                        <div class="ui">
                            <label for=""
                                   style="font-weight: bold;"><?php echo nm_get_text_lang("['prefix_table']"); ?></label>
                            <input type="text" id='id_tabela_seg_prefix'
                                   name="tabela_seg_prefix" value='notif_'/>
                        </div>
                    </div>
                    <div class="field" id='id_tr_logged'>
                        <div class="ui toggle checkbox">
                            <input type='checkbox' name='tabela_drop_tables' id='id_tabela_drop_tables' value='S'
                                   class="hidden"/>
                            <label for='id_tabela_drop_tables'><?php echo nm_get_text_lang("['drop_tables']"); ?></label>
                        </div>
                    </div>

                </div>
                <div class="field">
                    <div class="grouped fields">
                        <label for="tabela_seg"><?php echo nm_get_text_lang("['usr_grp']['title']"); ?></label>
                        <div class="field">
                            <div class="ui radio checkbox">
                                <input type="radio" name="usr_grp" tabindex="0" class="hidden" value="usr"
                                       onchange="nm_toggle_ug(this.value);">
                                <label><?php echo nm_get_text_lang("['user']"); ?></label>
                            </div>
                        </div>
                        <div class="field">
                            <div class="ui radio checkbox">
                                <input type="radio" name="usr_grp" tabindex="0" class="hidden" checked value="grp"
                                       onchange="nm_toggle_ug(this.value);">
                                <label><?php echo nm_get_text_lang("['group']"); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="ui form">
            <hr/>
        </div>
        <div class="ui orange message">
            <?php echo sprintf(nm_get_text_lang("['mod_security_recommend']"), "javascript:parent.nm_exec_menu('mod_security')"); ?>
        </div>
        <div class="ui form">
            <div class="fields two column">
                <div class="field" id="table_usr">
                    <div class="grouped fields" style="padding-top:6px;">
                        <label for="table_usr"><?php echo nm_get_text_lang("['table_usr']['title']"); ?></label>
                        <div class="ui action ">
                            <select class="ui fluid search dropdown disabled db_table" name="table_usr">
                                <option value=""></option>

                            </select>
                        </div>
                    </div>
                </div>
                <div class="field table_grp">
                    <div class="grouped fields" style="padding-top:6px;">
                        <label for="table_grp"><?php echo nm_get_text_lang("['table_grp']['title']"); ?></label>
                        <div class="ui action">
                            <select class="ui fluid dropdown disabled db_table search" name="table_grp">
                                <option value=""></option>

                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="ui form">
            <div class="fields two column">
                <div class="field" id="table_usr_field_login">
                    <div class="grouped fields" style="padding-top:6px;">
                        <label for="table_usr_field_login"><?php echo nm_get_text_lang("['table_usr_field_login']['title']"); ?></label>
                        <div class="ui action">
                            <select class="ui fluid dropdown disabled db_table search" name="table_usr_field_login">
                                <option value=""></option>

                            </select>
                        </div>
                    </div>
                </div>
                <div class="field table_grp">
                    <div class="grouped fields" style="padding-top:6px;">
                        <label for="table_usr_grp"><?php echo nm_get_text_lang("['table_usr_grp']['title']"); ?></label>
                        <div class="ui action">
                            <select class="ui fluid dropdown disabled db_table search" name="table_usr_grp">
                                <option value=""></option>

                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="ui form">
                <div class="fields two column">
                    <div class="field" id="table_usr_field_name">
                        <div class="grouped fields" style="padding-top:6px;">
                            <label for="table_usr_field_name"><?php echo nm_get_text_lang("['table_usr_field_name']['title']");?></label>
                            <div class="ui action">
                                <select class="ui fluid dropdown disabled db_table search" name="table_usr_field_name" >
                                    <option value=""></option>

                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="field table_grp" id="table_grp_field_group_id">
                        <div class="grouped fields" style="padding-top:6px;">
                            <label for="table_grp_field_group_id"><?php echo nm_get_text_lang("['table_grp_field_group_id']['title']"); ?></label>
                            <div class="ui action">
                                <select class="ui fluid dropdown disabled db_table search" name="table_grp_field_group_id">
                                    <option value=""></option>

                                </select>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ui form">
                <div class="fields two column">
                    <div class="field" id="table_usr_field_email">
                        <div class="grouped fields" style="padding-top:6px;">
                            <label for="table_usr_field_email"><?php echo nm_get_text_lang("['table_usr_field_email']['title']");?></label>
                            <div class="ui action">
                                <select class="ui fluid dropdown disabled db_table search" name="table_usr_field_email" >
                                    <option value=""></option>

                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="field table_grp" id="table_grp_field_description">
                        <div class="grouped fields" style="padding-top:6px;">
                            <label for="table_grp_field_description"><?php echo nm_get_text_lang("['table_grp_field_description']['title']"); ?></label>
                            <div class="ui action">
                                <select class="ui fluid dropdown disabled db_table search" name="table_grp_field_description">
                                    <option value=""></option>

                                </select>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="ui form">
                <div class="fields two column">

                    <div class="field" id="table_usr_field_phone">
                        <div class="grouped fields" style="padding-top:6px;">
                            <label for="table_usr_field_phone"><?php echo nm_get_text_lang("['table_usr_field_phone']['title']"); ?></label>
                            <div class="ui action">
                                <select class="ui fluid dropdown disabled db_table search" name="table_usr_field_phone">
                                    <option value=""></option>

                                </select>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>

        <table id='tab_conn_erro' width="400px" height="250px" border="0"
               style="display:none; border:1px solid red; position:absolute; left:3%; top:74px; z-index:1004"
               class="nmTable">
            <tr>
                <td height="30px" width="30px" valign="top" class="nmErrorMsg" valign="middle">
                    <img src="<?php echo $nm_config['url_img']; ?>cancel.png"/>
                </td>
                <td height="30px" width="400px" class="nmErrorMsg" valign="middle">
                    <b><?php echo nm_get_text_lang("['msg_err_connection']"); ?></b>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="border-top:1px solid red;">
                    <center>
                        <span style="padding:3px;"><?php echo nm_get_text_lang("['sc_msg_no_conn']"); ?>
                        <p style="font-weight:bold;"><?php echo nm_get_text_lang("['sc_msg_fix_conn']"); ?></p></span>
                    </center>
                    <ul style="padding:5px 35px;border:1px solid transparent;border-radius:4px;background-color:#fcf8e3;border-color:#faebcc;color:#8a6d3b;margin-top:-20px;">
                        <li><?php echo nm_get_text_lang("['sc_msg_fix_1']"); ?></li>
                        <li><?php echo nm_get_text_lang("['sc_msg_fix_2']"); ?></li>
                    </ul>
                    <center>
                        <img id='img_erro_con' src="<?php echo $nm_config['url_img']; ?>ajax_load2.gif"
                             style="display:none"/>
                        <span id='bt_erro_con'>
                            <input type="button" value="<?php echo nm_get_text_lang("['lbl_bt_edit_conn']"); ?>"
                                   class="nmButton"
                                   onclick="parent.nmParamCreateAba[0] =$('#id_select_conn').val(); parent.nm_exec_menu('conn_edit');$('#tab_conn_erro').close();"/>&nbsp;&nbsp;&nbsp;
                            <input type="button" value="<?php echo nm_get_text_lang("['button_close']"); ?>"
                                   class="nmButton"
                                   onclick="document.getElementById('tab_conn_erro').style.display = 'none'; "/>
                        </span>
                    </center>
                </td>
            </tr>
        </table>
        <script>
            function getTables(conn) {

                $.ajax({
                    type: 'POST',
                    async: true,
                    url: nm_url_iface + 'module_notification.php',
                    data: 'nm_ajax=1&nm_option=getTables&conn=' + conn + '&search=users',
                    success: function (retorno) {
                        $('select[name=table_usr]').html(retorno);
                        $('select[name=table_usr]').parent().removeClass('loading');
                        loadFieldsTableUsr(conn, $('select[name=table_usr]').val());
                    }
                });
            }

            function getTablesGrp(conn) {
                $.ajax({
                    type: 'POST',
                    async: true,
                    url: nm_url_iface + 'module_notification.php',
                    data: 'nm_ajax=1&nm_option=getTables&conn=' + conn + '&search=groups',
                    success: function (retorno) {
                        $('select[name=table_grp]').html(retorno);
                        $('select[name=table_grp]').parent().removeClass('loading');
                        loadFieldsTableGrp(conn, $('select[name=table_grp]').val());
                    }
                });
            }
            function getTablesUsrGrp(conn) {
                $.ajax({
                    type: 'POST',
                    async: true,
                    url: nm_url_iface + 'module_notification.php',
                    data: 'nm_ajax=1&nm_option=getTables&conn=' + conn + '&search=users_groups',
                    success: function (retorno) {
                        $('select[name=table_usr_grp]').html(retorno);
                        $('select[name=table_usr_grp]').parent().removeClass('loading');

                    }
                });
            }

            function loadFieldsTableUsr(conn, table_usr) {
                if(table_usr == '') return;

                $('select[name=table_usr_field_login]').parent().addClass('loading');
                $('select[name=table_usr_field_name]').parent().addClass('loading');
                $('select[name=table_usr_field_email]').parent().addClass('loading');
                $('select[name=table_usr_field_phone]').parent().addClass('loading');
                $.ajax({
                    type: 'POST',
                    async: true,
                    url: nm_url_iface + 'module_notification.php',
                    data: 'nm_ajax=1&nm_option=getFieldsUsr&conn=' + conn + '&table_usr=' + table_usr,
                    success: function (retorno) {

                        $('select[name=table_usr_field_login]').html(retorno);
                        $('select[name=table_usr_field_email]').html(retorno);
                        $('select[name=table_usr_field_name]').html(retorno);
                        $('select[name=table_usr_field_phone]').html(retorno);

                        //$('select[name=table_usr_field_login]').val($('select[name=table_usr_field_login] > option:nth-child(2)').val());

                        //-------------------

                        setTimeout(function() {
                            $('select[name=table_usr_field_login]').parent().removeClass('loading');
                            $('select[name=table_usr_field_name]').parent().removeClass('loading');
                            $('select[name=table_usr_field_email]').parent().removeClass('loading');
                            $('select[name=table_usr_field_phone]').parent().removeClass('loading');
                            $('select[name=table_usr_field_login]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_usr_field_login] > option:contains("login")').val() ??
                                    $('select[name=table_usr_field_login] > option:contains("LOGIN")').val()
                                );
                            $('select[name=table_usr_field_name]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_usr_field_name] > option:contains("name")').val() ??
                                    $('select[name=table_usr_field_name] > option:contains("NAME")').val()
                                );
                            $('select[name=table_usr_field_email]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_usr_field_email] > option:contains("email")').val() ??
                                    $('select[name=table_usr_field_email] > option:contains("EMAIL")').val()
                                );
                            $('select[name=table_usr_field_phone]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_usr_field_phone] > option:contains("phone")').val() ??
                                    $('select[name=table_usr_field_phone] > option:contains("PHONE")').val()
                                );
                        }, 500);
                        //------------------
                    }
                });
            }

            function loadFieldsTableGrp(conn, table_usr) {
                if(table_usr == '') return;

                $('select[name=table_grp_field_group_id]').parent().addClass('loading');
                $('select[name=table_grp_field_description]').parent().addClass('loading');
                $.ajax({
                    type: 'POST',
                    async: true,
                    url: nm_url_iface + 'module_notification.php',
                    data: 'nm_ajax=1&nm_option=getFieldsUsr&conn=' + conn + '&table_usr=' + table_usr,
                    success: function (retorno) {
                        $('select[name=table_grp_field_group_id]').html(retorno);
                        $('select[name=table_grp_field_description]').html(retorno);

                        //$('select[name=table_usr_field_login]').val($('select[name=table_usr_field_login] > option:nth-child(2)').val());

                        //-------------------

                        setTimeout(function() {

                            $('select[name=table_grp_field_group_id]').parent().removeClass('loading');
                            $('select[name=table_grp_field_description]').parent().removeClass('loading');
                            $('select[name=table_grp_field_group_id]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_grp_field_group_id] > option:contains("group_id")').val() ??
                                    $('select[name=table_grp_field_group_id] > option:contains("GROUP_ID")').val()
                                );
                            $('select[name=table_grp_field_description]').dropdown('refresh')
                                .dropdown('set selected',
                                    $('select[name=table_grp_field_description] > option:contains("description")').val() ??
                                    $('select[name=table_grp_field_description] > option:contains("DESCRIPTION")').val()
                                );
                        }, 500);
                        //------------------
                    }
                });
            }

            $('select[name=table_usr]').on('change', function () {
                loadFieldsTableUsr($('select[name=tabela_conn]').val(), $('select[name=table_usr]').val());

            });
            $('select[name=table_grp]').on('change', function () {
                loadFieldsTableGrp($('select[name=tabela_conn]').val(), $('select[name=table_grp]').val());
            });
        </script>
