<?php

/**
 * Template scriptcase.
 *
 * Modulo de Seguranca.
 *
 * @package     Template
 * @subpackage  Scriptcase
 * @creation    2009/04/14
 * @copyright   NetMake Solucoes em Informatica
 * @author      Juliano Mesquita dos Santos <juliano@netmake.com.br>
 *
 * $Id: body_security_module_step_config.tpl.php,v 1.16 2012-01-27 20:50:46 vinicius Exp $
 */


/* Protecao contra hacks */

if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976)) {

    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .

        'invalid access to system file.');

}

$options_schemas = $this->GetVar('options_schemas');

$options_log = $this->GetVar('options_log');

$options_menu = $this->GetVar('options_menu');

$options_api = $this->GetVar('options_api');
$options_smtp_api = $this->GetVar('options_smtp_api');

?>

<table style="width:900px; height:300px;" class="nmTable" align='center'>

    <tr>

        <td colspan=4 class='nmTitle'
            style='text-align:center;'> <?php echo nm_get_text_lang("['menu']['conf']"); ?>
            <span style="float: right;">
		 	   <?php echo $this->GetVar('block_image_help'); ?>
			</span>
        </td>

    </tr>

    <tr valign='top'>

        <td style='background-color:#FAFACA;' colspan=2 rowspan=2>

            <div id="id_img_module"
                 style='left:36px; top:0px; padding:37px 95px;'><?php echo nm_get_text_lang("['usr']['title']"); ?></div>

            <ul id="abas" style='padding: 0px;width: 103%; left: -3px; position: relative;'>

                <li class='aba_selected aba_clicked' id='general_aba'><a
                            href="#general"><?php echo nm_get_text_lang("['general']"); ?>
                    <?php if ($nm_config['is_97']) { ?>
                    <span class="field-new-sticker" ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                    <?php } ?>
                    </a>
                </li>

                <li id='login_aba'><a href="#login"><?php echo nm_get_text_lang("['login']"); ?>
                        <?php if ($nm_config['is_96']) { ?>
                            <span class="field-new-sticker" ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </a></li>

                <?php if (!($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap' && $_SESSION['nm_session']['module_security']['profile']['tipo_nivel_ldap'] == 'ldap')) { ?>
                    <li id='config_email_aba'><a
                                href="#config_email"><?php echo nm_get_text_lang("['email_sett']"); ?>

                            <?php if (!$nm_config['has_97']) { ?>
                                <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_97']) { ?>
                                <span class="field-new-sticker" ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php }
                            ?></a></li>
                <?php } ?>
                <?php if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] != 'ldap') { ?>

                    <li id='ret_pass_aba'><a href="#ret_pass"><?php echo nm_get_text_lang("['ret_pass']"); ?></a></li>

                    <li id='new_users_aba'><a href="#new_users"><?php echo nm_get_text_lang("['new_usr']"); ?></a></li>
                <?php } ?>


                <li id='config_ldap_aba'><a href="#config_ldap"><?php echo nm_get_text_lang("['ldap_sett']"); ?></a></li>
                <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] == 'S'): ?>
                    <li id='config_social_aba' ><a href="#config_social"><?php echo nm_get_text_lang("['social_network']"); ?></a></li>
                <?php endif; ?>
                <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_logged'] == 'S'): ?>
                    <li id='config_logged_user_aba'><a
                                href="#config_logged_user"><?php echo nm_get_text_lang("['logged_user']"); ?></a></li>
                <?php endif; ?>

                <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] != 'S'): ?>
                    <li id='config_login_template_aba'><a
                                href="#config_login_template"><?php echo nm_get_text_lang("['login_template']"); ?></a></li>
                <?php endif; ?>
                <?php if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] != 'ldap'): ?>
                <li
                    id='config_2fa_aba'><a
                        href="#config_2fa"  ><?php echo nm_get_text_lang("['tab_2fa']"); ?>
                        <?php if (!$nm_config['has_97']) { ?>
                        <small class="upgradeOnlyInfo" onclick="parent.noPermission();"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php }else if ($nm_config['is_97']) { ?>
                            <span class="field-new-sticker" <?php if (!$nm_config['has_97']) { ?>onclick='parent.noPermission();' <?php } ?>  ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </a>
                </li>
                <?php endif; ?>


            </ul>

        </td>

        <td></td>

        <td></td>

    </tr>

    <tr valign="top" id='general'>

        <td colspan=2 style='width:100%; padding:40px;'>

            <table valign="top" align='center'>

                <tr>

                    <td><?php echo nm_get_text_lang("['prefix_app']['title']"); ?></td>

                    <td align='left'>

                        <input type='text' id='id_prefix_app' name='config_general[prefix_app]' value='app_'
                               class='nmInput'>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_prefix_app_img'
                             class='img_help'/>

                    </td>

                    <td class='description'
                        id='id_prefix_app_desc'><?php echo nm_get_text_lang("['prefix_app']['desc']"); ?></td>

                </tr>
                <tr>

                    <td>
                        <?php echo nm_get_text_lang("['session']['title']"); ?>
                        <?php if (!$nm_config['has_93']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else {
                            if ($nm_config['is_93']) { ?>
                                <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php }
                        } ?>
                    </td>

                    <td class="nmLineV3" height="30px">

                        <select name='config_general[session]' onchange='nm_select_session(this);'
                                class='nmInput'>
                            <option value=''><?php echo nm_get_text_lang("['option_session_no']"); ?></option>
                            <option value='R'><?php echo nm_get_text_lang("['option_session_redirect']"); ?></option>
                            <option value='M'><?php echo nm_get_text_lang("['option_session_message']"); ?></option>

                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_active_img'
                             class='img_help'/>

                    </td>

                    <td id='id_active_desc'
                        class='description'><?php echo nm_get_text_lang("['session']['desc']"); ?></td>

                </tr>

                <?php if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] != 'ldap'): ?>
                    <tr>

                        <td><?php echo nm_get_text_lang("['crypt']['title']"); ?></td>

                        <td align='left'>

                            <select name='config_general[criptografia]' onchange='nm_select_crypt(this.value);'
                                    class='nmInput'>

                                <option value=''></option>

                                <option value='md5'>MD5</option>
                                <option value='sha1'>SHA1</option>
                                <option value='sha256'>SHA256</option>
                                <option value='sha512'>SHA512</option>

                            </select>

                            <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_cript_img'
                                 class='img_help'/>

                        </td>

                        <td class='description'
                            id='id_cript_desc'><?php echo nm_get_text_lang("['crypt']['desc']"); ?></td>

                    </tr>
                <?php endif; ?>

                <tr>

                    <td><?php echo nm_get_text_lang("['act_sec']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <input type="radio" class="nm-radio-button" name="config_general[set_seg_app]" id="opt_set_seg_app_yes"
                               checked="checked" value="S"><label for="opt_set_seg_app_yes"
                                                                  class="nmText"><span></span><?php echo nm_get_text_lang("['option_yes']"); ?></label>&nbsp;&nbsp;

                        <input type="radio" class="nm-radio-button" name="config_general[set_seg_app]" id="opt_set_seg_app_no"
                               value="N"><label for="opt_set_seg_app_no"
                                                class="nmText"><span></span><?php echo nm_get_text_lang("['option_no']"); ?></label>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_active_img'
                             class='img_help'/>

                    </td>

                    <td id='id_active_desc'
                        class='description'><?php echo nm_get_text_lang("['act_sec']['desc']"); ?></td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['remember_me']['title']"); ?>
                        <?php if (!$nm_config['has_96']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_96']) { ?>
                            <span class="field-new-sticker" ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </td>

                    <td class="nmLineV3" height="30px">
                        <label class="nmText">
                            <input type="radio" class="nm-radio-button" name="config_general[remember_me]" onclick="$('#id_remember_me_expiry_cookie').removeAttr('disabled');"
                                <?php echo (!$nm_config['has_96'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>
                                value="S"><?php echo nm_get_text_lang("['option_yes']"); ?>
                        </label>&nbsp;&nbsp;
                        <label class="nmText">
                            <input type="radio" class="nm-radio-button" name="config_general[remember_me]" onclick="$('#id_remember_me_expiry_cookie').attr('disabled','disabled');"
                                <?php echo (!$nm_config['has_96'] ? 'checked="checked"' : ''); ?>
                               value="N"><?php echo nm_get_text_lang("['option_no']"); ?>
                        </label>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_remember_me_img'
                             class='img_help'/>

                    </td>


                    <td class='description' id='id_remember_me_desc'>

                        <?php echo nm_get_text_lang("['remember_me']['desc']"); ?>

                    </td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['remember_me_expiry_cookie']['title']"); ?>
                        <?php if (!$nm_config['has_97']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_97']) { ?>
                            <span class="field-new-sticker"><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </td>

                    <td class="nmLineV3" height="30px">
                            <input type="number" class="nm-radio-button" name="config_general[remember_me_expiry_cookie]" id="id_remember_me_expiry_cookie"
                                <?php echo (!$nm_config['has_97'] ? "onchange='parent.noPermission();this.value=\"30\";return false;' " : ''); ?>
                                value="30" /><?php echo nm_get_text_lang("['days']"); ?>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_remember_me_expiry_cookie_img'
                             class='img_help'/>

                    </td>


                    <td class='description' id='id_remember_me_expiry_cookie_desc'>

                        <?php echo nm_get_text_lang("['remember_me_expiry_cookie']['desc']"); ?>

                    </td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['label_position']['title']"); ?>
                        <?php if (!$nm_config['has_96']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_96']) { ?>
                            <span class="field-new-sticker" onclick='parent.noPermission();' ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php } ?>
                    </td>

                    <td class="nmLineV3" height="30px">
                        <select class="nmInput" name="config_general[label_position]" id="id_fld_label_position" <?php echo (!$nm_config['has_96'] ? "parent.noPermission();this.value=2" : ''); ?>
                            <option data-corrido="true" value="1"><?php echo nm_get_text_lang("['block_def_pos_beside']", 'App'); ?></option>
                            <option data-corrido="false" selected='selected' value="2"><?php echo nm_get_text_lang("['block_def_pos_above']", 'App');  ?></option>
                            <option data-corrido="false" value="3"><?php echo nm_get_text_lang("['block_def_pos_below']", 'App'); ?></option>
                            <option data-corrido="false" value="4"><?php echo nm_get_text_lang("['block_def_l_watermark']", 'App'); ?></option>
                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_label_position_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_label_position_desc'>

                        <?php echo nm_get_text_lang("['label_position']['desc']"); ?>

                    </td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['captcha']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <select class="nmInput" name="config_general[use_captcha]" id="id_fld_use_captcha" onchange="nm_change_captcha(this.value)">
                            <option value="N"><?php echo nm_get_text_lang("['option_no']"); ?></option>
                            <option value="S"><?php echo nm_get_text_lang("['option_captcha']"); ?></option>
                            <option value="recaptcha"><?php echo nm_get_text_lang("['option_recaptcha']"); ?></option>
                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_use_captcha_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_use_captcha_desc'>

                        <?php echo nm_get_text_lang("['captcha']['desc']"); ?>

                    </td>

                </tr>

                <tr id="id_recaptcha_site_key">

                    <td><?php echo nm_get_text_lang("['recaptcha_site_key']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <input type="text" name="config_general[recaptcha_site_key]" value="">

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_recaptcha_site_key_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_recaptcha_site_key_desc'>

                        <?php echo nm_get_text_lang("['recaptcha_site_key']['desc']"); ?>

                    </td>

                </tr>

                <tr id="id_recaptcha_secret_key">

                    <td><?php echo nm_get_text_lang("['recaptcha_secret_key']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <input type="text" name="config_general[recaptcha_secret_key]" value="">

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_recaptcha_secret_key_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_recaptcha_secret_key_desc'>

                        <?php echo nm_get_text_lang("['recaptcha_secret_key']['desc']"); ?>

                    </td>

                </tr>


                <tr>

                    <td><?php echo nm_get_text_lang("['folder']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <input type="text" name="config_general[folder_security]" value="Security" size="20"
                               maxlength="64" class="nmInput" id='id_folder_security'>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_folder_img'
                             class='img_help'/>

                    </td>

                    <td class='description'
                        id='id_folder_desc'><?php echo nm_get_text_lang("['folder']['desc']"); ?></td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['theme']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <select name="config_general[theme]" class="nmInput">

                            <?php echo $options_schemas; ?>

                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_theme_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_theme_desc'><?php echo nm_get_text_lang("['theme']['desc']"); ?></td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['log']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <select name="config_general[log]" class="nmInput">

                            <?php echo $options_log; ?>

                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_log_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_log_desc'><?php echo nm_get_text_lang("['log']['desc']"); ?></td>

                </tr>

                <tr>

                    <td><?php echo nm_get_text_lang("['menu']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <select name="config_general[menu]" class="nmInput"
                                onchange="if(this.value=='new_menu'){ $('#id_tr_new_menu').show(); } else { $('#id_tr_new_menu').hide(); } ">

                            <?php echo $options_menu; ?>

                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_menu_img'
                             class='img_help'/>

                    </td>

                    <td class='description' id='id_menu_desc'><?php echo nm_get_text_lang("['menu']['desc']"); ?></td>

                </tr>

                <tr id='id_tr_new_menu' style='display:none;'>

                    <td><?php echo nm_get_text_lang("['tipo_menu']['title']"); ?></td>

                    <td class="nmLineV3" height="30px">

                        <select name="config_general[tipo_menu]" class="nmInput">

                            <option value='menutree'
                                    checked='checked'><?php echo nm_get_text_lang("['option_tipo_menutree']"); ?></option>

                            <option value='menu'><?php echo nm_get_text_lang("['option_tipo_menu']"); ?></option>

                        </select>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_tipo_menu_img'
                             class='img_help'/>

                    </td>

                    <td class='description'
                        id='id_tipo_menu_desc'><?php echo nm_get_text_lang("['tipo_menu']['desc']"); ?></td>

                </tr>

                <tr id='id_tr_sweet_alert' >

                    <td><?php
                        echo nm_get_text_lang("['sweet_alert']['title']");
                        if (!$nm_config['has_94']) { ?>
                        <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_94']) { ?>
                        <span class="field-new-sticker" onclick='parent.noPermission();' ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php }
                    ?></td>


                    <td class="nmLineV3" height="30px">
                        <label class="nmText">
                            <input type="radio" class="nmInput nm-radio-button" name="config_general[sweet_alert]"
                                value="S"
                              <?php echo (!$nm_config['has_94'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>>
                            <?php echo nm_get_text_lang("['option_yes']"); ?>
                        </label>
                        <label class="nmText" >

                            <input type="radio" class="nmInput nm-radio-button" name="config_general[sweet_alert]" <?php echo (!$nm_config['has_94'] ? "checked='checked' onclick='parent.noPermission();' " : ''); ?>

                               value="N">
                            <?php echo nm_get_text_lang("['option_no']"); ?>
                        </label>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_tipo_sweet_img'
                             class='img_help'/>

                    </td>

                    <td class='description'
                        id='id_tipo_sweet_desc'><?php echo nm_get_text_lang("['sweet_alert']['desc']"); ?></td>

                </tr>
                <tr id='id_tr_settings' >

                    <td><?php
                        echo nm_get_text_lang("['settings']['title']");
                        if (!$nm_config['has_97']) { ?>
                        <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                        <?php } else if ($nm_config['is_97']) { ?>
                        <span class="field-new-sticker" onclick='parent.noPermission();' ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                        <?php }
                    ?></td>


                    <td class="nmLineV3" height="30px">
                        <label class="nmText">
                            <input type="radio" class="nmInput nm-radio-button" name="config_general[settings]"
                                value="S"
                              <?php echo (!$nm_config['has_97'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>>
                            <?php echo nm_get_text_lang("['option_yes']"); ?>
                        </label>
                        <label class="nmText" >

                            <input type="radio" class="nmInput nm-radio-button" name="config_general[settings]" <?php echo (!$nm_config['has_97'] ? "checked='checked' onclick='parent.noPermission();' " : ''); ?>

                               value="N">
                            <?php echo nm_get_text_lang("['option_no']"); ?>
                        </label>

                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_settings_img'
                             class='img_help'/>

                    </td>

                    <td class='description'
                        id='id_settings_desc'><?php echo nm_get_text_lang("['settings']['desc']"); ?></td>

                </tr>

            </table>

        </td>

    </tr>

    <tr valign="top" id='login' style='display:none;' align='center'>
        <td colspan="2">
            <table class="nmTable" width="100%">

                <tr>
                    <td style="vertical-align: top;">

                        <fieldset style='border:1px solid #AACAE0; width:100%;    min-height: 164px;    margin: 0px;    padding: 3px;'>

                            <legend><?php echo nm_get_text_lang("['usr']['title']"); ?></legend>

                            <table valign="top" align='center'>
                                <tr>

                                </tr>


                                <tr>

                                    <td style='padding:0 4px;'>

                                       <?php echo nm_get_text_lang("['min_size']"); ?>

                                    </td>

                                    <td>

                                        <input type='text' name='config_login[usu_tam_min]' value='5'
                                               id='id_login_usu_tam_min'
                                               size=1 class='nmInput' onchange='min_max_login();'>

                                    </td>

                                </tr>

                                <tr>

                                    <td style='padding:0 4px;'>

                                        <?php echo nm_get_text_lang("['max_size']"); ?>

                                    </td>

                                    <td>

                                        <input type='text' name='config_login[usu_tam_max]' value='255'
                                               id='id_login_usu_tam_max'
                                               size=1 class='nmInput' onchange='min_max_login();'>

                                    </td>

                                </tr>

                                <tr>

                                    <td style='padding:0 4px;' colspan=2>

                                        <?php echo nm_get_text_lang("['allow_char']"); ?>

                                        <select class='nmInput' name='config_login[usu_todos_carac]'
                                                onchange="if(this.value == 'all'){$('#others_selected_usu').hide(); } else{$('#others_selected_usu').show(); }">

                                            <option value='all'
                                                    selected='selected'><?php echo nm_get_text_lang("['all_chars']"); ?></option>

                                            <option value='selected'><?php echo nm_get_text_lang("['selected_chars']"); ?></option>

                                        </select>

                                        <br/>

                                        <div id='others_selected_usu'>

                                            <div style='float:left;'>

                                                <input type='checkbox' name='config_login[usu_carac_letra]'
                                                       id='id_login_usu_carac_letra' value='S' checked='checked'>

                                                <label
                                                        for="id_login_usu_carac_letra"><?php echo nm_get_text_lang("['allow_letters']"); ?></label>


                                                <br/>

                                                <input type='checkbox' name='config_login[usu_carac_num]'
                                                       id='id_login_usu_carac_num' value='S' checked='checked'>

                                                <label
                                                        for="id_login_usu_carac_num"><?php echo nm_get_text_lang("['allow_numbers']"); ?></label>

                                                <br/>


                                                <input type='checkbox' name='config_login[usu_carac_accent]'
                                                       id='id_login_usu_carac_accent' value='S' checked='checked'>

                                                <label
                                                        for="id_login_usu_carac_accent"><?php echo nm_get_text_lang("['allow_accent']"); ?></label>

                                                <br/>


                                                <input type='checkbox' name='config_login[usu_carac_cedilla]'
                                                       id='id_login_usu_carac_cedilla' value='S' checked='checked'>

                                                <label
                                                        for="id_login_usu_carac_cedilla"><?php echo nm_get_text_lang("['allow_cedilla']"); ?></label>

                                                <br/>

                                            </div>

                                            <input type='checkbox' name='config_login[usu_carac_space]'
                                                   id='id_login_usu_carac_space' value='S' checked='checked'>

                                            <label
                                                    for="id_login_usu_carac_space"><?php echo nm_get_text_lang("['allow_space']"); ?></label>

                                            <br/>


                                            <input type='checkbox' name='config_login[usu_carac_dot]'
                                                   id='id_login_usu_carac_dot'
                                                   value='S' checked='checked'>

                                            <label
                                                    for="id_login_usu_carac_dot"><?php echo nm_get_text_lang("['allow_dot']"); ?></label>

                                            <br/>


                                            <input type='checkbox' name='config_login[usu_carac_comma]'
                                                   id='id_login_usu_carac_comma' value='S' checked='checked'>

                                            <label
                                                    for="id_login_usu_carac_comma"><?php echo nm_get_text_lang("['allow_comma']"); ?></label>

                                            <br/>

                                        </div>

                                    </td>

                                </tr>

                            </table>

                        </fieldset>

                    </td>
                </tr><tr>

                    <td style="vertical-align: top;">

                        <fieldset style='border:1px solid #AACAE0; width:100%;    min-height: 164px;    margin: 0px;    padding: 3px;'>

                            <legend><?php echo nm_get_text_lang("['pass']"); ?></legend>

                            <table align='center'>

                                <tr>

                                    <td style='padding:0 4px;'>

                                        <?php echo nm_get_text_lang("['min_size']"); ?>

                                    </td>

                                    <td>

                                        <input type='text' name='config_login[pass_tam_min]' value='5'
                                               id='id_login_pass_tam_min'
                                               size=1 class='nmInput' onchange='min_max_pswd();'>

                                    </td>

                                </tr>

                                <tr>

                                    <td style='padding:0 4px;'>

                                        <?php echo nm_get_text_lang("['max_size']"); ?>

                                    </td>

                                    <td>

                                        <input type='text' name='config_login[pass_tam_max]' value='32'
                                               id='id_login_pass_tam_max'
                                               size=1 class='nmInput' onchange='min_max_pswd();'>

                                    </td>

                                </tr>

                                <tr>

                                    <td style='padding:0 4px;' colspan=2>

                                        <?php echo nm_get_text_lang("['allow_char']"); ?>

                                        <select name='config_login[pass_todos_carac]'
                                                onchange="if(this.value == 'all'){$('#others_selected_pswd').hide(); } else{$('#others_selected_pswd').show(); }"
                                                class='nmInput'>

                                            <option value='all'
                                                    selected='selected'><?php echo nm_get_text_lang("['all_chars']"); ?></option>

                                            <option value='selected'><?php echo nm_get_text_lang("['selected_chars']"); ?></option>

                                        </select>

                                        <br/>

                                        <div id='others_selected_pswd'>

                                            <div style='float:left;'>

                                                <input type='checkbox' name='config_login[pass_carac_letra]'
                                                       id='id_login_pass_carac_letra' value='S' checked='checked'>

                                                <label
                                                        for="id_login_pass_carac_letra"><?php echo nm_get_text_lang("['allow_letters']"); ?></label>


                                                <br/>

                                                <input type='checkbox' name='config_login[pass_carac_num]'
                                                       id='id_login_pass_carac_num' value='S' checked='checked'>

                                                <label
                                                        for="id_login_pass_carac_num"><?php echo nm_get_text_lang("['allow_numbers']"); ?></label>

                                                <br/>


                                                <input type='checkbox' name='config_login[pass_carac_accent]'
                                                       id='id_login_pass_carac_accent' value='S' checked='checked'>

                                                <label
                                                        for="id_login_pass_carac_accent"><?php echo nm_get_text_lang("['allow_accent']"); ?></label>

                                                <br/>


                                                <input type='checkbox' name='config_login[pass_carac_cedilla]'
                                                       id='id_login_pass_carac_cedilla' value='S' checked='checked'>

                                                <label
                                                        for="id_login_pass_carac_cedilla"><?php echo nm_get_text_lang("['allow_cedilla']"); ?></label>

                                                <br/>

                                            </div>

                                            <input type='checkbox' name='config_login[pass_carac_space]'
                                                   id='id_login_pass_carac_space' value='S' checked='checked'>

                                            <label
                                                    for="id_login_pass_carac_space"><?php echo nm_get_text_lang("['allow_space']"); ?></label>

                                            <br/>


                                            <input type='checkbox' name='config_login[pass_carac_dot]'
                                                   id='id_login_pass_carac_dot'
                                                   value='S' checked='checked'>

                                            <label
                                                    for="id_login_pass_carac_dot"><?php echo nm_get_text_lang("['allow_dot']"); ?></label>

                                            <br/>


                                            <input type='checkbox' name='config_login[pass_carac_comma]'
                                                   id='id_login_pass_carac_comma' value='S' checked='checked'>

                                            <label
                                                    for="id_login_pass_carac_comma"><?php echo nm_get_text_lang("['allow_comma']"); ?></label>

                                            <br/>


                                        </div>

                                    </td>

                                </tr>
                                <tr>

                                    <td style='padding:0 4px;vertical-align: top;padding-top: 7px;'>

                                        <?php echo nm_get_text_lang("['usa_senha_exibir_ocultar']"); ?>
                                        <?php if (!$nm_config['has_96']) { ?>
                                        <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                                        <?php } else if ($nm_config['is_96']) { ?>
                                        <span class="field-new-sticker" onclick='parent.noPermission();' ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                                        <?php } ?>
                                    </td>

                                    <td style="vertical-align: top;padding-top: 5px;">

                                        <label class="nmText">
                                            <input type="radio" class="nmInput nm-radio-button" name="config_login[usa_senha_exibir_ocultar]"
                                                   value="S"
                                                   <?php echo (!$nm_config['has_96'] ? "onclick='parent.noPermission();return false;' " : 'checked="checked"'); ?>>
                                            <?php echo nm_get_text_lang("['option_yes']"); ?>
                                        </label>
                                        <label class="nmText" >

                                            <input type="radio" class="nmInput nm-radio-button" name="config_login[usa_senha_exibir_ocultar]" <?php echo (!$nm_config['has_96'] ? " onclick='parent.noPermission();' checked='checked'" : ''); ?>

                                                   value="N">
                                            <?php echo nm_get_text_lang("['option_no']"); ?>
                                        </label>
                                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_usa_senha_exibir_ocultar_img'
                                             class='img_help'/>
                                    <span class='description'
                                        id='id_usa_senha_exibir_ocultar_desc'><?php echo nm_get_text_lang("['usa_senha_exibir_ocultar']['desc']"); ?></span>

                                    </td>

                                </tr>

                            </table>

                        </fieldset>

                    </td>
                </tr>
            </table>

        </td>


    </tr>
    <?php if ($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] != 'ldap') { ?>

        <tr valign="top" id='ret_pass' style='display:none;' align='center'>

            <td colspan=2 style='width:100%; padding:40px;'>

                <table>

                    <tr>

                        <td>

                            <input type='radio' class="nm-radio-button" name='config_ret_pass[reset_pass]' id='id_ret_pass_send_mail'
                                   value='email_com_senha' checked='checked'/>

                            <label for='id_ret_pass_send_mail'
                                   id="id_ret_pass_send_mail_desc"><span></span><?php echo nm_get_text_lang("['mail_send']"); ?></label>

                        </td>

                    </tr>

                    <tr>

                        <td>

                            <input type='radio' class="nm-radio-button" name='config_ret_pass[reset_pass]' id='id_ret_pass_send_mail_reset'
                                   value='email_com_nova_senha'/>

                            <label
                                    for='id_ret_pass_send_mail_reset'><span></span><?php echo nm_get_text_lang("['mail_reset']"); ?></label>

                        </td>

                    </tr>

                    <tr>

                        <td>

                            <input type='radio' class="nm-radio-button" name='config_ret_pass[reset_pass]' id='id_ret_pass_send_link_mail'
                                   value='email_com_link_senha'/>

                            <label
                                    for='id_ret_pass_send_link_mail'><span></span><?php echo nm_get_text_lang("['mail_new']"); ?></label>

                        </td>

                    </tr>

                </table>

            </td>

        </tr>
        <tr valign="top" id='new_users' style='display:none;' align='center'>

            <td colspan=2 style='width:100%; padding:40px;'>

                <table>

                    <tr>

                        <td>

                            <input type="checkbox" name='config_general[perm_new_user]' value='S' checked='checked'
                                   id='id_perm_new_user' onclick="if(!$(this).is(':checked')){ $('#id_config_general_default_group').attr('disabled','disabled'); } else { $('#id_config_general_default_group').removeAttr('disabled'); }"><label
                                    for="id_perm_new_user"> <?php echo nm_get_text_lang("['allow_reg_usr']"); ?></label>

                        </td>

                    </tr>

                    <tr>

                        <td>

                            <input type="checkbox" name='config_general[actve_by_email]' id='id_actve_by_email'
                                   value='S'><label
                                    for="id_actve_by_email"> <?php echo nm_get_text_lang("['act_by_mail']"); ?></label>

                        </td>

                    </tr>

                    <tr>

                        <td>

                            <input type="checkbox" name='config_general[send_mail_to_admin]' id='id_send_mail_to_admin'
                                   value='S'><label
                                    for="id_send_mail_to_admin"> <?php echo nm_get_text_lang("['mail_admin']"); ?></label>

                        </td>

                    </tr>
                    <?php if($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'grp') : ?>
                    <tr>
                        <td><hr/></td>
                    </tr>

                    <tr>
                        <td>
                            <label><?=nm_get_text_lang("['default_group']")?>
                                <input id='id_config_general_default_group' name="config_general[default_group]" type="text" value="Group Default"/>

                            </label>
                        </td>
                    </tr>
                    <?php endif; ?>
                </table>

            </td>

        </tr>
    <?php } ?>

    <?php if (!($_SESSION['nm_session']['module_security']['profile']['tipo_nivel'] == 'ldap' && $_SESSION['nm_session']['module_security']['profile']['tipo_nivel_ldap'] == 'ldap')) { ?>
        <tr valign="top" id='config_email' style='display:none;' align='center'>

            <td colspan=2 style='width:100%; padding:40px;'>
                <table>
                    <tr>
                        <td><?php echo nm_get_text_lang("['smtp_api']['title']"); ?>
                            <?php if (!$nm_config['has_97']) { ?>
                            <small class="upgradeOnlyInfo"><?php echo nm_get_text_lang("['upgrade_only_feature']", 'App'); ?></small>
                            <?php } else if ($nm_config['is_97']) { ?>
                                <span class="field-new-sticker" ><?php echo nm_get_text_lang("['menu_new_label']", 'Menu'); ?></span>
                            <?php }
                            ?>
                        </td>
                        <td class="nmLineV3" height="30px">
                            <select name="config_general[smtp_api]" id="smtp_api">
                                <option value="custom"><?php echo nm_get_text_lang("['custom']"); ?></option>
                                <?php foreach($options_smtp_api as $mod => $apis): ?>
                                    <optgroup label="<?php echo nm_get_text_lang("['mod_".$mod . "']"); ?>">
                                        <?php foreach($apis as $api => $desc): ?>
                                            <option value="<?php echo $mod . '__NM__'. $api; ?>"><?php echo $desc; ?></option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endforeach; ?>
                            </select>
                            <a href="javascript: nm_reload_apis('email', 'smtp_api', 1);"><img src="<?php echo $nm_config['url_img']; ?>/refresh.gif" style="border-width: 0px; height: 16px; width: 16px; vertical-align: middle" /></a>
                            <a href="javascript: parent.nm_exec_menu('prj_api')"><img src="<?php echo $nm_config['url_img']; ?>/edit.png" style="height: 14px; width: 14px;border-width: 0px; vertical-align: middle;" title="API" /></a>
                            <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_smtp_api_img'
                                 class='img_help'/>
                            <span class='description'
                                  id='id_smtp_api_desc'><?php echo nm_get_text_lang("['smtp_api']['desc']"); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <td class="table_custom_smtp" colspan="2"><hr/></td>
                    </tr>
                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_server"><?php echo nm_get_text_lang("['smtp']['server']"); ?></label>
                        </td>

                        <td><input type="text" name='config_email[smtp_server]' id='id_config_email_smtp_server'
                                   class='nmInput config_email_custom'/></td>

                    </tr>

                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_port"><?php echo nm_get_text_lang("['smtp']['port']"); ?> </label>
                        </td>

                        <td><input type="text" name='config_email[smtp_port]' id='id_config_email_smtp_port'
                                   class='nmInput config_email_custom'/></td>

                    </tr>
                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_security"><?php echo nm_get_text_lang("['smtp']['security']"); ?> </label>
                        </td>

                        <td>
                            <select class='config_email_custom' name='config_email[smtp_security]' id='id_config_email_smtp_security'>
                                <option value="" selected="selected"></option>
                                <option value="S">SSL</option>
                                <option value="T">TLS</option>
                            </select>


                    </tr>

                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_user"><?php echo nm_get_text_lang("['smtp']['usr']"); ?> </label>
                        </td>

                        <td><input type="text" name='config_email[smtp_user]' id='id_config_email_smtp_user'
                                   class='nmInput config_email_custom'/></td>

                    </tr>

                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_pass"><?php echo nm_get_text_lang("['smtp']['pass']"); ?></label>
                        </td>

                        <td style="">
                            <input type="password" name='config_email[smtp_pass]' id='id_config_email_smtp_pass' class='nmInput config_email_custom'/>
                            <i class="fa fa-eye" id="togglePassword" style="position: absolute; margin-top: 5px; margin-left: -30px; cursor: pointer; display: <?php echo (isset($_SERVER['HTTP_USER_AGENT']) && (preg_match('/Edge/i', $_SERVER['HTTP_USER_AGENT']) || preg_match('/Edg/i', $_SERVER['HTTP_USER_AGENT'])))?"none":""; ?>"></i>
                        </td>

                    </tr>

                    <tr class="table_custom_smtp">

                        <td><label
                                    for="id_config_email_smtp_pass"><?php echo nm_get_text_lang("['smtp']['email']"); ?></label>
                        </td>

                        <td><input type="text" name='config_email[smtp_mail]' id='id_config_email_smtp_email'
                                   class='nmInput config_email_custom'/></td>

                    </tr>

                </table>

            </td>

        </tr>
    <?php } ?>


    <tr valign="top" id='config_ldap' style='display:none;' align='center'>

        <td colspan=2 style='width:100%; padding:40px;'>

            <table>

                <tr>

                    <td>

                        <label for='id_ldap_server'><?php echo nm_get_text_lang("['ldap_server']"); ?></label>
                    </td>
                    <td>

                        <input type="text" name='config_general[ldap_server]' value='' id='id_ldap_server'>

                    </td>

                </tr>
                <tr>

                    <td>
                        <label for='id_ldap_dn'><?php echo nm_get_text_lang("['ldap_dn']"); ?></label>
                    <td>
                        <input type="text" name='config_general[ldap_dn]' id='id_ldap_dn' value=''>
                    </td>

                </tr>
                <tr>

                    <td>
                        <label for='id_ldap_port'><?php echo nm_get_text_lang("['ldap_port']"); ?></label>
                    </td>
                    <td>
                        <input type="text" name='config_general[ldap_port]' id='id_ldap_port' value='389'></label>
                    </td>

                </tr>
                <tr>

                    <td>
                        <label for='id_ldap_suffix'><?php echo nm_get_text_lang("['ldap_suffix']"); ?></label>
                    </td>
                    <td>
                        <input type="text" name='config_general[ldap_suffix]' id='id_ldap_suffix' value=''
                               placeholder="@scriptcase.net"></label>
                    </td>

                </tr>

            </table>

        </td>

    </tr>
    <tr valign="top" id='config_logged_user' style='display:none' align='center'>

        <td colspan=2 style='width:100%; padding:40px;'>

            <table>

                <tr>

                    <td>

                        <label
                                for='id_logged_show_user'><?php echo nm_get_text_lang("['logged_show_user']"); ?></label>
                    </td>
                    <td>
                        <input type="radio" class="nmInput nm-radio-button" name="config_general[logged_show_user]"
                               id="opt_set_seg_logged_show_user_Yes" value="S"
                               checked="checked">
                        <label
                                for="opt_set_seg_logged_show_user_Yes"
                                class="nmText"><span></span><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                        <input type="radio" class="nmInput nm-radio-button" name="config_general[logged_show_user]"
                               id="opt_set_seg_logged_show_user_no"
                               value="N"><label
                                for="opt_set_seg_logged_show_user_no"
                                class="nmText"><span></span><?php echo nm_get_text_lang("['option_no']"); ?></label>

                    </td>

                </tr>

                <tr>

                    <td>
                        <label
                                for='id_logged_brute_force'><?php echo nm_get_text_lang("['logged_brute_force']"); ?></label>
                    </td>
                    <td>


                        <input type="radio" class="nmInput nm-radio-button"
                                                      name="config_general[logged_brute_force]"
                                                      id='id_config_general_logged_brute_force_S'
                                                      value="S"
                                                      checked="checked">
                        <label class="nmText" for='id_config_general_logged_brute_force_S'><span></span><?php echo nm_get_text_lang("['option_yes']"); ?></label>
                        <input type="radio" class="nmInput nm-radio-button"
                                                      id='id_config_general_logged_brute_force'
                                                      name="config_general[logged_brute_force]"
                                                      value="N">
                        <label class="nmText" for='id_config_general_logged_brute_force'><span></span><?php echo nm_get_text_lang("['option_no']"); ?></label>


                    </td>

                </tr>
                <tr>

                    <td>
                        <label
                                for='id_logged_brute_force_time'><?php echo nm_get_text_lang("['logged_brute_force_time']"); ?></label>
                    </td>
                    <td>
                        <input type="text" class="nmInput" name="config_general[logged_brute_force_time]"
                               size='1' value="10"
                               onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                               onchange="if(this.value==''){ this.value=10}">

                    </td>

                </tr>
                <tr>

                    <td>
                        <label
                                for='id_logged_brute_force_attempts'><?php echo nm_get_text_lang("['logged_brute_force_attempts']"); ?></label>
                    </td>
                    <td>
                        <input type="text" class="nmInput" name="config_general[logged_brute_force_attempts]"
                               size='1' value="10"
                               onkeyup="if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,'')"
                               onchange="if(this.value==''){ this.value=10}">

                    </td>

                </tr>

            </table>

        </td>

    </tr>

    <tr valign="top" id='config_social' style='display:none' align='center'>

        <td colspan=2 style='width:100%; padding:40px;'>
            <fieldset>
                <legend align="left">
                    <label><input type="checkbox" class="nmInput socialSelect" name="config_general[option_facebook]" onclick="socialConfig(this)" value="facebook">Facebook</label>
                </legend>
                <table>
                    <tr>
                        <td>App ID</td>
                        <td><input type="text" class="nmInput"name="config_general[facebook_app_id]" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td>Secret</td>
                        <td><input type="text" class="nmInput" name="config_general[facebook_secret]" disabled="disabled"></td>
                    </tr>
                </table>
            </fieldset>

            <fieldset>
                <legend  align="left">
                    <label><input type="checkbox" name="config_general[option_twitter]" value="twitter" class="nmInput socialSelect" onclick="socialConfig(this)">Twitter (X)</label>
                </legend>
                <table>
                    <tr>
                        <td>Key</td>
                        <td><input type="text" class="nmInput" disabled="disabled" name="config_general[twitter_key]"></td>
                    </tr>
                    <tr>
                        <td>Secret</td>
                        <td><input type="text" class="nmInput" disabled="disabled" name="config_general[twitter_secret]"></td>
                    </tr>
                </table>
            </fieldset>

<!---->
<!--            <fieldset>-->
<!--                <legend>-->
<!--                    <label><input type="checkbox" name="config_general[option_google]" class="nmInput socialSelect" value="google" onclick="socialConfig(this)">Google</label>-->
<!--                </legend>-->
<!--                <table>-->
<!--                    <tr>-->
<!--                        <td>Application Name</td>-->
<!--                        <td><input type="text" class="nmInput" disabled="disabled" name="config_general[google_app_name]"></td>-->
<!--                    </tr>-->
<!--                    <tr>-->
<!--                        <td>Client ID</td>-->
<!--                        <td><input type="text" class="nmInput" disabled="disabled" name="config_general[google_client_id]"></td>-->
<!--                    </tr>-->
<!--                    <tr>-->
<!--                        <td>Secret</td>-->
<!--                        <td><input type="text" class="nmInput" disabled="disabled" name="config_general[google_secret]"></td>-->
<!--                    </tr>-->
<!--                </table>-->
<!--            </fieldset>-->
        </td>

    </tr>

    <?php if ($_SESSION['nm_session']['module_security']['profile']['tabela_social'] != 'S'): ?>
        <tr valign="top" id='config_login_template' style='display:none' align='center'>

            <td colspan=2 style='width:100%; padding:60px;'>
                <table>
                    <tr>
                        <td align="right"><?php echo nm_get_text_lang("['use_login_template']"); ?></td>
                        <td align="left">
                            <input type="radio" class="nm-radio-button" value='S' name="config_login[use_login_template]" id="id_rd_use_login_template_S"
                                          onclick="$('#id_config_login_template').removeAttr('disabled');"><label for="id_rd_use_login_template_S"><span></span><?php echo nm_get_text_lang("['option_yes']"); ?>
                            </label>
                            <input type="radio" class="nm-radio-button" value='N' checked="checked" name="config_login[use_login_template]" id="id_rd_use_login_template_N"
                                          onclick="$('#id_config_login_template').attr('disabled','disabled');"><label for="id_rd_use_login_template_N"><span></span><?php echo nm_get_text_lang("['option_no']"); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td align="right">
                            Login Template
                        </td>
                        <td align="left">
                            <select name="config_login[template_login]" class="nmInput" id="id_config_login_template"
                                    disabled="disabled">
                                <?php echo nm_get_extenal_libraries_options(); ?>
                            </select>
                            <a href="#" onclick="parent.nm_exec_menu('libraries')" ><?= nm_get_text_lang("['create_library']")?></a>&nbsp;|&nbsp;
                            <a href="#" onclick="reload_libs()" ><?= nm_get_text_lang("['reload_libs']")?></a>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    <?php endif; ?>

    <tr valign="top" id='config_2fa' style='display:none' align='center'>

        <td colspan=2 style='width:100%; padding:60px;'>
            <table>
                <tr>
                    <td><?php echo nm_get_text_lang("['2fa']['title']"); ?></td>
                    <td class="nmLineV3" height="30px">
                        <select name="2fa[option]" id="2fa_option" onchange="nm_reload_apis(this.value,'2fa_api')" <?php if (!$nm_config['has_97']) {?> onclick="parent.noPermission();" disabled="disabled" <?php } ?>>
                            <option value=""></option>
                            <option value="auth"><?php echo nm_get_text_lang("['2fa']['option']"); ?></option>
                            <option value="sms">SMS</option>
                            <option value="email">E-mail</option>
                        </select>
                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_2fa_img'
                             class='img_help'/>
                        <span class='description'
                              id='id_2fa_desc'><?php echo nm_get_text_lang("['2fa']['desc']"); ?></span>


                    </td>
                </tr>

                <tr>
                    <td><?php echo nm_get_text_lang("['2fa_gateway']['title']"); ?></td>
                    <td class="nmLineV3" height="30px">
                        <select name="2fa[api]" id="2fa_api" <?php if (!$nm_config['has_97']) {?> disabled="disabled" onclick="parent.noPermission();" <?php } ?>>
                            <?php foreach($options_api as $mod => $apis): ?>
                            <optgroup label="<?php echo nm_get_text_lang("['mod_".$mod . "']"); ?>">
                            <?php foreach($apis as $api => $desc): ?>
                                <option value="<?php echo $mod . '__NM__'. $api; ?>"><?php echo $desc; ?></option>
                            <?php endforeach; ?>
                            </optgroup>
                            <?php endforeach; ?>
                        </select>
                        <a href="javascript: nm_reload_apis($('#2fa_option').val(), '2fa_api');"><img src="<?php echo $nm_config['url_img']; ?>/refresh.gif" style="border-width: 0px; height: 16px; width: 16px; vertical-align: middle" /></a>
                        <a href="javascript: parent.nm_exec_menu('prj_api')"><img src="<?php echo $nm_config['url_img']; ?>/edit.png" style="height: 14px; width: 14px;border-width: 0px; vertical-align: middle;" title="API" /></a>
                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_2fa_gateway_img'
                             class='img_help'/>
                        <span class='description'
                              id='id_2fa_gateway_desc'><?php echo nm_get_text_lang("['2fa_gateway']['desc']"); ?></span>
                    </td>
                </tr>
                <tr>
                    <td><?php echo nm_get_text_lang("['2fa_expiry_time']['title']"); ?></td>
                    <td class="nmLineV3" height="30px">
                        <input name="2fa[2fa_expiry_time]" id="2fa_expiry_time" <?php if (!$nm_config['has_97']) {?> disabled="disabled" <?php } ?> value="300" />
                        <?php echo nm_get_text_lang("['seconds']"); ?>
                        <img src='<?php echo $nm_config['url_img']; ?>icoHelp.jpg' alt='help' id='id_2fa_expiry_time_img'
                             class='img_help'/>
                        <span class='description'
                              id='id_2fa_expiry_time_desc'><?php echo nm_get_text_lang("['2fa_expiry_time']['desc']"); ?></span>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>

<div id='id_description_help'>

    <div id='title_help'><?php echo nm_get_text_lang("['help']"); ?> <span onclick='nm_close_help()'
                                                                           style='cursor:pointer;float:right;'>X</span>
    </div>

    <span></span></div>

<input type='hidden' id='id_hid_has_app'/>
