/*
Navicat MySQL Data Transfer

Source Server         : MYSQL
Source Server Version : 50505
Source Host           : 127.0.0.1:3306
Source Database       : sc_delivery_tracker

Target Server Type    : MYSQL
Target Server Version : 50699
File Encoding         : 65001

Date: 2019-02-12 15:35:41
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for sc_log
-- ----------------------------
CREATE TABLE `sc_log` (
`id`  int(8) NOT NULL AUTO_INCREMENT ,
`inserted_date`  datetime NULL DEFAULT NULL ,
`username`  varchar(90) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`application`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`creator`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`ip_user`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`action`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`description`  mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=75
;

-- ----------------------------
-- Table structure for sec_users
-- ----------------------------
CREATE TABLE `sec_users` (
`login`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`pswd`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`name`  varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`email`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`active`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`activation_code`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`priv_admin`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`login`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of sec_users
-- ----------------------------
INSERT INTO `sec_users` VALUES ('admin', '21232f297a57a5a743894a0e4a801fc3', 'ADM', 'admin@scriptcase.net', 'Y', null, 'Y');
INSERT INTO `sec_users` VALUES ('bill', 'e8375d7cd983efcbf956da5937050ffc', 'Bill Murray', 'bill@scriptcase.net', 'Y', null, 'N');
INSERT INTO `sec_users` VALUES ('john', '527bd5b5d689e2c32ae974c6229ff785', 'John Kane', 'johnkane@scriptcase.net', 'Y', null, 'N');

-- ----------------------------
-- Table structure for tb_adresses
-- ----------------------------
CREATE TABLE `tb_adresses` (
`adresses_id`  int(11) NOT NULL AUTO_INCREMENT ,
`adresses_name`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`adresses_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`adresses_city`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`adresses_state`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`adresses_country`  varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`adresses_postal_code`  varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`adresses_lat`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`adresses_lng`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`adresses_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=11

;

-- ----------------------------
-- Records of tb_adresses
-- ----------------------------
INSERT INTO `tb_adresses` VALUES ('1', 'Billy Kwong', 'Av. Gov. Agamenon Magalhaes, 153', 'RECIFE', 'PE', 'BR', '52021-170', '-8.036943', '-34.87197');
INSERT INTO `tb_adresses` VALUES ('2', 'Young Henrys', 'R. Carlos Fernandes, 179', 'RECIFE', 'PE', 'BR', '52041-710', '-8.032725', '-34.8873');
INSERT INTO `tb_adresses` VALUES ('3', 'Hunter Gatherer', 'Av. Norte Miguel Arraes de Alencar, 2215', 'RECIFE', 'PE', 'BR', '50030-230', '-8.039245', '-34.890427');
INSERT INTO `tb_adresses` VALUES ('4', 'The Potting Shed', 'Praca das Cinco Pontas, s/n', 'RECIFE', 'PE', 'BR', '50020-500', '-8.071722', '-34.880884');
INSERT INTO `tb_adresses` VALUES ('5', 'Phillip Simons', 'Parque Dona Lindu - Av. Boa Viagem, s/n', 'RECIFE', 'PE', 'BR', '51030-010', '-8.1412311', '-34.904251');
INSERT INTO `tb_adresses` VALUES ('6', 'Will Wallace', 'R. Teresita Bandeira, 563', 'OLINDA', 'PE', 'BR', '53300-030', '', '');
INSERT INTO `tb_adresses` VALUES ('7', 'Chico Science', 'Av. Chico Science, 686', 'OLINDA', 'PE', 'BR', '53090-720', '-7.999549', '-34.849726');
INSERT INTO `tb_adresses` VALUES ('8', 'Carmo', 'Av. Liberdade, 5', 'OLINDA', 'PE', 'BR', '53020-030', '-8.016636', '-34.848388');
INSERT INTO `tb_adresses` VALUES ('9', 'Arts Museum', 'R. Treze de Maio, 185', 'OLINDA', 'PE', 'BR', '53020-170', '-8.016147', '-34.853355');
INSERT INTO `tb_adresses` VALUES ('10', 'Anthropology Museum', 'Av. Dezessete de Agosto, 2187', 'RECIFE', 'PE', 'BR', '52061-540', '-8.0364271', '-34.923606');

-- ----------------------------
-- Table structure for tb_company_info
-- ----------------------------
CREATE TABLE `tb_company_info` (
`company_info_id`  int(11) NOT NULL AUTO_INCREMENT ,
`company_info_descr`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`company_info_address`  text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`company_info_lat`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_info_lng`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_info_api_gmaps_token`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`company_info_api_wa_url`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`company_info_api_wa_token`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`company_info_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=2

;

-- ----------------------------
-- Records of tb_company_info
-- ----------------------------
INSERT INTO `tb_company_info` VALUES ('1', 'Netmake', 'Av. Pres. Kennedy, 1001, Olinda - PE, 53230-120, Brazil', '-8.01793', '-34.865239', 'AIzaSyCVVHpD1Mh69XwWA4-wLL5SLCBgKdV8iTc', '', '');

-- ----------------------------
-- Table structure for tb_deliverers
-- ----------------------------
CREATE TABLE `tb_deliverers` (
`deliverers_id`  int(11) NOT NULL AUTO_INCREMENT ,
`deliverers_name`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`deliverers_active`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`deliverers_email`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`user_login`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`deliverers_level`  int(11) NULL DEFAULT NULL ,
`company_info_id`  int(11) NOT NULL ,
PRIMARY KEY (`deliverers_id`),
FOREIGN KEY (`company_info_id`) REFERENCES `tb_company_info` (`company_info_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`user_login`) REFERENCES `sec_users` (`login`) ON DELETE RESTRICT ON UPDATE RESTRICT,
INDEX `fk_tb_deliverers_tb_company_info1_idx` (`company_info_id`) USING BTREE ,
INDEX `fk_tb_sec_users` (`user_login`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tb_deliverers
-- ----------------------------
INSERT INTO `tb_deliverers` VALUES ('1', 'John Kane', 'Y', 'johnkane@scriptcase.net', 'john', '9', '1');
INSERT INTO `tb_deliverers` VALUES ('4', 'Bill Murray', 'Y', 'bill@scriptcase.net', 'bill', '0', '1');

-- ----------------------------
-- Table structure for tb_markers
-- ----------------------------
CREATE TABLE `tb_markers` (
`markers_id`  int(11) NOT NULL AUTO_INCREMENT ,
`routes_id`  int(11) NULL DEFAULT NULL ,
`markers_status_id`  int(11) NOT NULL ,
`adresses_id`  int(11) NOT NULL ,
`markers_queue`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`markers_id`),
FOREIGN KEY (`markers_status_id`) REFERENCES `tb_markers_status` (`markers_status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`adresses_id`) REFERENCES `tb_adresses` (`adresses_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`routes_id`) REFERENCES `tb_routes` (`routes_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_markers_tb_routes1_idx` (`routes_id`) USING BTREE ,
INDEX `fk_tb_markers_tb_markers_status1_idx` (`markers_status_id`) USING BTREE ,
INDEX `fk_tb_markers_tb_adresses1_idx` (`adresses_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=12

;

-- ----------------------------
-- Records of tb_markers
-- ----------------------------
INSERT INTO `tb_markers` VALUES ('1', '2', '2', '1', '1');
INSERT INTO `tb_markers` VALUES ('2', '2', '2', '2', '2');
INSERT INTO `tb_markers` VALUES ('3', '2', '3', '3', '3');
INSERT INTO `tb_markers` VALUES ('4', '2', '1', '4', '4');
INSERT INTO `tb_markers` VALUES ('5', '2', '1', '5', '5');
INSERT INTO `tb_markers` VALUES ('6', '3', '1', '10', '1');
INSERT INTO `tb_markers` VALUES ('8', '4', '1', '8', '0');
INSERT INTO `tb_markers` VALUES ('9', '4', '1', '7', '0');
INSERT INTO `tb_markers` VALUES ('10', '4', '1', '6', '0');
INSERT INTO `tb_markers` VALUES ('11', '3', '1', '9', '2');

-- ----------------------------
-- Table structure for tb_markers_status
-- ----------------------------
CREATE TABLE `tb_markers_status` (
`markers_status_id`  int(11) NOT NULL AUTO_INCREMENT ,
`markers_status_descr`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`markers_status_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tb_markers_status
-- ----------------------------
INSERT INTO `tb_markers_status` VALUES ('1', 'Pending');
INSERT INTO `tb_markers_status` VALUES ('2', 'Delivered');
INSERT INTO `tb_markers_status` VALUES ('3', 'Failed');
INSERT INTO `tb_markers_status` VALUES ('4', 'Delivering');

-- ----------------------------
-- Table structure for tb_routes
-- ----------------------------
CREATE TABLE `tb_routes` (
`routes_id`  int(11) NOT NULL AUTO_INCREMENT ,
`routes_descr`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`routes_date`  date NOT NULL ,
`deliverers_id`  int(11) NULL DEFAULT NULL ,
`routes_status_id`  int(11) NOT NULL ,
`routes_start_datetime`  datetime NULL DEFAULT NULL ,
`routes_end_datetime`  datetime NULL DEFAULT NULL ,
PRIMARY KEY (`routes_id`),
FOREIGN KEY (`deliverers_id`) REFERENCES `tb_deliverers` (`deliverers_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`routes_status_id`) REFERENCES `tb_routes_status` (`routes_status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
INDEX `fk_tb_routes_tb_deliverers_idx` (`deliverers_id`) USING BTREE ,
INDEX `fk_tb_routes_tb_routes_status1_idx` (`routes_status_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tb_routes
-- ----------------------------
INSERT INTO `tb_routes` VALUES ('2', 'My delivery today', '2019-02-07', '1', '2', '2019-02-07 08:44:50', null);
INSERT INTO `tb_routes` VALUES ('3', 'Museum Delivery', '2019-02-11', '1', '1', null, null);
INSERT INTO `tb_routes` VALUES ('4', 'Route 44', '2019-02-07', '4', '3', '2019-02-07 09:28:57', null);

-- ----------------------------
-- Table structure for tb_routes_coordinates
-- ----------------------------
CREATE TABLE `tb_routes_coordinates` (
`routes_coordinates_id`  int(11) NOT NULL AUTO_INCREMENT ,
`routes_id`  int(11) NOT NULL ,
`routes_coordinates_lat_lng`  text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`routes_coordinates_datetime`  datetime NOT NULL ,
PRIMARY KEY (`routes_coordinates_id`),
FOREIGN KEY (`routes_id`) REFERENCES `tb_routes` (`routes_id`) ON DELETE CASCADE ON UPDATE CASCADE,
INDEX `fk_tb_routes_coordinates_tb_routes1_idx` (`routes_id`) USING BTREE 
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=514

;

-- ----------------------------
-- Records of tb_routes_coordinates
-- ----------------------------
INSERT INTO `tb_routes_coordinates` VALUES ('1', '2', '{lat: -8.0180374, lng: -34.8651537}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('6', '2', '{lat: -8.0172298, lng: -34.8645928}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('7', '2', '{lat: -8.0159173, lng: -34.864067}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('8', '2', '{lat: -8.0154939, lng: -34.8646595}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('9', '2', '{lat: -8.016425, lng: -34.8656551}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('10', '2', '{lat: -8.017108, lng: -34.8662693}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('11', '2', '{lat: -8.0206698, lng: -34.8512647}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('15', '2', '{lat: -8.019383, lng: -34.8500015}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('16', '2', '{lat: -8.0191377, lng: -34.8498093}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('18', '2', '{lat: -8.0167848, lng: -34.8642083}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('29', '2', '{lat: -8.0179565, lng: -34.8651995}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('30', '2', '{lat: -8.0178509, lng: -34.8650595}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('31', '2', '{lat: -8.0180133, lng: -34.8651536}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('32', '2', '{lat: -8.0180739, lng: -34.8651589}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('33', '2', '{lat: -8.0205253, lng: -34.9245865}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('34', '2', '{lat: -8.0213183, lng: -34.9242239}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('35', '2', '{lat: -8.0212035, lng: -34.924155}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('37', '2', '{lat: -8.0212035, lng: -34.924155}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('39', '2', '{lat: -8.0211975, lng: -34.9241475}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('44', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('45', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('46', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('47', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('48', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('50', '2', '{lat: -8.021193, lng: -34.9241467}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('51', '2', '{lat: -8.0213136, lng: -34.9242351}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('52', '2', '{lat: -8.0213009, lng: -34.924235}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('53', '2', '{lat: -8.0213008, lng: -34.9242352}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('54', '2', '{lat: -8.0213006, lng: -34.9242354}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('55', '2', '{lat: -8.0213007, lng: -34.9242353}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('56', '2', '{lat: -8.0213007, lng: -34.9242353}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('57', '2', '{lat: -8.0213008, lng: -34.924235}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('58', '2', '{lat: -8.0213009, lng: -34.9242349}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('59', '2', '{lat: -8.0213029, lng: -34.9242338}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('60', '2', '{lat: -8.0213022, lng: -34.9242343}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('61', '2', '{lat: -8.0213022, lng: -34.9242343}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('62', '2', '{lat: -8.0213022, lng: -34.9242343}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('63', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('64', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('65', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('66', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('67', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('68', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('69', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('70', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('71', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('72', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('73', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('74', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('75', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('76', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('77', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('78', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('79', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('80', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('81', '2', '{lat: -8.0212417, lng: -34.9241613}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('82', '2', '{lat: -8.0212417, lng: -34.9241613}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('83', '2', '{lat: -8.0213071, lng: -34.9242314}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('84', '2', '{lat: -8.0213655, lng: -34.9241718}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('85', '2', '{lat: -8.0213655, lng: -34.9241718}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('86', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('87', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('88', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('89', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('90', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('91', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('92', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('93', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('94', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('95', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('96', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('97', '2', '{lat: -8.0213051, lng: -34.92419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('98', '2', '{lat: -8.0208465, lng: -34.9242645}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('99', '2', '{lat: -8.0203842, lng: -34.9233099}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('100', '2', '{lat: -8.0205777, lng: -34.9230408}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('101', '2', '{lat: -8.0206906, lng: -34.9226054}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('102', '2', '{lat: -8.0206625, lng: -34.922411}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('103', '2', '{lat: -8.0207898, lng: -34.9222356}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('104', '2', '{lat: -8.0207599, lng: -34.9221209}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('105', '2', '{lat: -8.020826, lng: -34.9214511}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('106', '2', '{lat: -8.0208925, lng: -34.9209043}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('107', '2', '{lat: -8.0212243, lng: -34.919138}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('108', '2', '{lat: -8.0211743, lng: -34.9190428}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('109', '2', '{lat: -8.0211328, lng: -34.9177091}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('110', '2', '{lat: -8.0214595, lng: -34.9175476}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('111', '2', '{lat: -8.0217714, lng: -34.9166062}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('112', '2', '{lat: -8.0224521, lng: -34.9142895}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('113', '2', '{lat: -8.0240385, lng: -34.9119556}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('114', '2', '{lat: -8.0241741, lng: -34.9117237}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('115', '2', '{lat: -8.024538, lng: -34.9105452}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('116', '2', '{lat: -8.0246398, lng: -34.9095308}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('117', '2', '{lat: -8.02402, lng: -34.90866}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('118', '2', '{lat: -8.025429, lng: -34.9074374}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('119', '2', '{lat: -8.0262856, lng: -34.9070514}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('120', '2', '{lat: -8.0256259, lng: -34.906834}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('121', '2', '{lat: -8.0266762, lng: -34.9075983}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('122', '2', '{lat: -8.0288458, lng: -34.9075613}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('123', '2', '{lat: -8.0261946, lng: -34.9058949}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('124', '2', '{lat: -8.0263394, lng: -34.9052701}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('125', '2', '{lat: -8.0245115, lng: -34.9057373}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('126', '2', '{lat: -8.0258814, lng: -34.9047874}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('127', '2', '{lat: -8.0263567, lng: -34.9011433}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('128', '2', '{lat: -8.0261961, lng: -34.9008131}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('129', '2', '{lat: -8.0263647, lng: -34.8981143}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('130', '2', '{lat: -8.0263411, lng: -34.8981479}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('131', '2', '{lat: -8.0263802, lng: -34.8983415}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('132', '2', '{lat: -8.0273071, lng: -34.8985242}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('133', '2', '{lat: -8.0270719, lng: -34.8980696}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('134', '2', '{lat: -8.027364, lng: -34.8985193}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('135', '2', '{lat: -8.0273701, lng: -34.8985287}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('136', '2', '{lat: -8.0276816, lng: -34.897209}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('137', '2', '{lat: -8.0272268, lng: -34.896213}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('138', '2', '{lat: -8.0262532, lng: -34.8937844}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('139', '2', '{lat: -8.028167, lng: -34.8941879}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('140', '2', '{lat: -8.0283692, lng: -34.8935328}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('141', '2', '{lat: -8.0271075, lng: -34.8936203}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('142', '2', '{lat: -8.0288145, lng: -34.8940992}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('143', '2', '{lat: -8.0285276, lng: -34.8934545}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('144', '2', '{lat: -8.0271455, lng: -34.8936159}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('145', '2', '{lat: -8.0271091, lng: -34.8936201}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('146', '2', '{lat: -8.0285191, lng: -34.893049}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('147', '2', '{lat: -8.028236, lng: -34.8933811}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('148', '2', '{lat: -8.0264323, lng: -34.8934358}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('149', '2', '{lat: -8.0274818, lng: -34.8924778}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('150', '2', '{lat: -8.0289794, lng: -34.8927939}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('151', '2', '{lat: -8.0288322, lng: -34.8896568}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('152', '2', '{lat: -8.0290009, lng: -34.8896591}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('153', '2', '{lat: -8.0296653, lng: -34.8898258}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('154', '2', '{lat: -8.0296195, lng: -34.8895229}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('155', '2', '{lat: -8.0288094, lng: -34.8893944}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('156', '2', '{lat: -8.0311949, lng: -34.8883013}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('157', '2', '{lat: -8.0311949, lng: -34.8883013}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('158', '2', '{lat: -8.0317334, lng: -34.8871787}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('159', '2', '{lat: -8.0279034, lng: -34.8896668}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('160', '2', '{lat: -8.032128, lng: -34.8874236}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('161', '2', '{lat: -8.0324878, lng: -34.8867242}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('162', '2', '{lat: -8.0332893, lng: -34.8862321}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('163', '2', '{lat: -8.0335181, lng: -34.886093}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('164', '2', '{lat: -8.0336741, lng: -34.8859825}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('165', '2', '{lat: -8.0343589, lng: -34.8863152}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('166', '2', '{lat: -8.0338829, lng: -34.8850238}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('167', '2', '{lat: -8.0336997, lng: -34.8853134}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('168', '2', '{lat: -8.035037, lng: -34.8838941}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('169', '2', '{lat: -8.0356361, lng: -34.8833399}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('170', '2', '{lat: -8.0358073, lng: -34.8836711}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('171', '2', '{lat: -8.0356916, lng: -34.8833859}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('172', '2', '{lat: -8.0357047, lng: -34.8832785}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('173', '2', '{lat: -8.0360006, lng: -34.8835192}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('174', '2', '{lat: -8.0365269, lng: -34.8841136}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('175', '2', '{lat: -8.0365756, lng: -34.8843222}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('176', '2', '{lat: -8.0371047, lng: -34.8839552}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('177', '2', '{lat: -8.0376918, lng: -34.8837365}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('178', '2', '{lat: -8.0378748, lng: -34.8838231}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('179', '2', '{lat: -8.0380927, lng: -34.884336}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('180', '2', '{lat: -8.0386866, lng: -34.8846484}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('181', '2', '{lat: -8.0391526, lng: -34.8854748}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('182', '2', '{lat: -8.0399159, lng: -34.8861115}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('183', '2', '{lat: -8.0393533, lng: -34.8855374}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('184', '2', '{lat: -8.039934, lng: -34.88613}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('185', '2', '{lat: -8.0402111, lng: -34.8871275}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('186', '2', '{lat: -8.0402111, lng: -34.8871275}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('187', '2', '{lat: -8.0403062, lng: -34.8869716}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('188', '2', '{lat: -8.040226, lng: -34.887103}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('189', '2', '{lat: -8.0403205, lng: -34.8867777}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('190', '2', '{lat: -8.040666, lng: -34.8865009}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('191', '2', '{lat: -8.0419903, lng: -34.8851537}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('192', '2', '{lat: -8.0425345, lng: -34.8840555}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('193', '2', '{lat: -8.0438869, lng: -34.8818817}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('194', '2', '{lat: -8.0442801, lng: -34.8811158}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('195', '2', '{lat: -8.0448791, lng: -34.8803735}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('196', '2', '{lat: -8.0451541, lng: -34.8799401}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('197', '2', '{lat: -8.0457383, lng: -34.8793472}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('198', '2', '{lat: -8.0460204, lng: -34.8789419}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('199', '2', '{lat: -8.0466283, lng: -34.8781678}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('200', '2', '{lat: -8.0475881, lng: -34.8775949}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('201', '2', '{lat: -8.04731, lng: -34.8774029}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('202', '2', '{lat: -8.0476193, lng: -34.8775249}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('203', '2', '{lat: -8.049133, lng: -34.8749088}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('204', '2', '{lat: -8.0504693, lng: -34.8750893}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('205', '2', '{lat: -8.0495699, lng: -34.8744991}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('206', '2', '{lat: -8.0511503, lng: -34.8750515}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('207', '2', '{lat: -8.0509413, lng: -34.8746135}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('208', '2', '{lat: -8.0522984, lng: -34.8753794}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('209', '2', '{lat: -8.0519677, lng: -34.8718298}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('210', '2', '{lat: -8.051964, lng: -34.8717894}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('211', '2', '{lat: -8.0541903, lng: -34.8722958}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('212', '2', '{lat: -8.0544133, lng: -34.8720201}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('213', '2', '{lat: -8.0543975, lng: -34.8721973}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('214', '2', '{lat: -8.0545133, lng: -34.8719985}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('215', '2', '{lat: -8.0544367, lng: -34.8719925}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('216', '2', '{lat: -8.0544149, lng: -34.8721464}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('217', '2', '{lat: -8.055571, lng: -34.8722565}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('218', '2', '{lat: -8.0556501, lng: -34.8721047}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('219', '2', '{lat: -8.0550464, lng: -34.8723824}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('220', '2', '{lat: -8.054446, lng: -34.872134}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('221', '2', '{lat: -8.0544029, lng: -34.8722959}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('222', '2', '{lat: -8.0583824, lng: -34.8719129}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('223', '2', '{lat: -8.0585303, lng: -34.8718987}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('224', '2', '{lat: -8.0593056, lng: -34.8722213}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('225', '2', '{lat: -8.0552332, lng: -34.8720285}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('226', '2', '{lat: -8.06103, lng: -34.8733656}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('227', '2', '{lat: -8.0612922, lng: -34.8734513}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('228', '2', '{lat: -8.0611109, lng: -34.8731571}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('229', '2', '{lat: -8.0627228, lng: -34.8737896}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('230', '2', '{lat: -8.0611733, lng: -34.8731756}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('231', '2', '{lat: -8.062113, lng: -34.8735883}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('232', '2', '{lat: -8.0629673, lng: -34.8738047}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('233', '2', '{lat: -8.0626594, lng: -34.8734032}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('234', '2', '{lat: -8.0627732, lng: -34.8734065}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('235', '2', '{lat: -8.0632308, lng: -34.8740808}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('236', '2', '{lat: -8.0632132, lng: -34.8739334}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('237', '2', '{lat: -8.063741, lng: -34.8743872}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('239', '2', '{lat: -8.0630069, lng: -34.8739067}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('240', '2', '{lat: -8.0649495, lng: -34.8739601}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('241', '2', '{lat: -8.0648807, lng: -34.8738067}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('242', '2', '{lat: -8.0658335, lng: -34.8734963}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('243', '2', '{lat: -8.0667172, lng: -34.8737954}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('244', '2', '{lat: -8.0665821, lng: -34.8758897}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('245', '2', '{lat: -8.0672098, lng: -34.8770519}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('246', '2', '{lat: -8.0672098, lng: -34.8770519}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('247', '2', '{lat: -8.063265, lng: -34.8741204}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('248', '2', '{lat: -8.0629657, lng: -34.873898}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('249', '2', '{lat: -8.0629284, lng: -34.8738703}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('250', '2', '{lat: -8.0653556, lng: -34.8764799}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('251', '2', '{lat: -8.0661323, lng: -34.8756956}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('252', '2', '{lat: -8.0658466, lng: -34.8734984}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('253', '2', '{lat: -8.0657104, lng: -34.873473}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('254', '2', '{lat: -8.0658212, lng: -34.8733917}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('255', '2', '{lat: -8.0658307, lng: -34.8733848}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('256', '2', '{lat: -8.0657873, lng: -34.8734932}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('257', '2', '{lat: -8.0660762, lng: -34.8748571}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('258', '2', '{lat: -8.0658476, lng: -34.87348}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('259', '2', '{lat: -8.0657312, lng: -34.8734432}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('260', '2', '{lat: -8.0658236, lng: -34.8733888}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('261', '2', '{lat: -8.0657591, lng: -34.8735076}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('262', '2', '{lat: -8.0658259, lng: -34.873394}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('263', '2', '{lat: -8.0658312, lng: -34.8733849}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('264', '2', '{lat: -8.0654954, lng: -34.8746536}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('265', '2', '{lat: -8.0670107, lng: -34.8758636}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('266', '2', '{lat: -8.0659052, lng: -34.873398}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('267', '2', '{lat: -8.0666036, lng: -34.8762016}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('268', '2', '{lat: -8.0664856, lng: -34.8763315}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('269', '2', '{lat: -8.0658722, lng: -34.876455}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('270', '2', '{lat: -8.0654803, lng: -34.8764847}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('271', '2', '{lat: -8.065526, lng: -34.87647}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('272', '2', '{lat: -8.0642979, lng: -34.8763984}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('273', '2', '{lat: -8.0631717, lng: -34.8739666}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('274', '2', '{lat: -8.0618548, lng: -34.8767378}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('275', '2', '{lat: -8.061789, lng: -34.8769518}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('276', '2', '{lat: -8.0618737, lng: -34.8767968}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('277', '2', '{lat: -8.0602172, lng: -34.8769566}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('278', '2', '{lat: -8.0601367, lng: -34.8781841}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('279', '2', '{lat: -8.0602366, lng: -34.8775783}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('280', '2', '{lat: -8.0595711, lng: -34.8801742}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('281', '2', '{lat: -8.0593795, lng: -34.8801895}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('282', '2', '{lat: -8.0593033, lng: -34.8804143}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('283', '2', '{lat: -8.0565893, lng: -34.8785697}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('284', '2', '{lat: -8.0576551, lng: -34.8791035}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('285', '2', '{lat: -8.0566157, lng: -34.8783936}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('286', '2', '{lat: -8.0565878, lng: -34.8784356}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('287', '2', '{lat: -8.0557869, lng: -34.8776253}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('288', '2', '{lat: -8.0549768, lng: -34.8771674}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('289', '2', '{lat: -8.0546241, lng: -34.8769347}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('290', '2', '{lat: -8.0537455, lng: -34.8763986}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('291', '2', '{lat: -8.0529686, lng: -34.8761756}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('292', '2', '{lat: -8.0510691, lng: -34.8746071}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('293', '2', '{lat: -8.0507733, lng: -34.8744144}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('294', '2', '{lat: -8.0518965, lng: -34.8743858}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('295', '2', '{lat: -8.0510407, lng: -34.8748849}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('296', '2', '{lat: -8.0508973, lng: -34.8745242}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('297', '2', '{lat: -8.050891, lng: -34.8745084}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('298', '2', '{lat: -8.0508902, lng: -34.8745063}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('299', '2', '{lat: -8.0508901, lng: -34.8745061}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('300', '2', '{lat: -8.0508901, lng: -34.8745061}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('302', '2', '{lat: -8.0509829, lng: -34.8745622}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('305', '2', '{lat: -8.050521, lng: -34.8744988}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('306', '2', '{lat: -8.0441171, lng: -34.874766}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('307', '2', '{lat: -8.043355, lng: -34.874252}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('308', '2', '{lat: -8.0428728, lng: -34.8736575}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('309', '2', '{lat: -8.041597, lng: -34.8728017}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('310', '2', '{lat: -8.0398035, lng: -34.871398}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('311', '2', '{lat: -8.0398035, lng: -34.871398}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('312', '2', '{lat: -8.0390177, lng: -34.8708503}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('313', '2', '{lat: -8.0382274, lng: -34.8702896}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('314', '2', '{lat: -8.0373918, lng: -34.8697362}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('315', '2', '{lat: -8.0365115, lng: -34.869134}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('316', '2', '{lat: -8.0356222, lng: -34.8685002}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('317', '2', '{lat: -8.0347393, lng: -34.8678512}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('318', '2', '{lat: -8.03384, lng: -34.8672352}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('319', '2', '{lat: -8.0329414, lng: -34.8666214}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('320', '2', '{lat: -8.0329414, lng: -34.8666214}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('321', '2', '{lat: -8.0282152, lng: -34.8656914}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('322', '2', '{lat: -8.0232679, lng: -34.8622361}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('323', '2', '{lat: -8.0232679, lng: -34.8622361}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('324', '2', '{lat: -8.0221522, lng: -34.8618956}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('326', '2', '{lat: -8.0182894, lng: -34.8614338}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('327', '2', '{lat: -8.0179801, lng: -34.8636872}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('328', '2', '{lat: -8.0178622, lng: -34.864421}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('329', '2', '{lat: -8.0167389, lng: -34.8641463}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('330', '2', '{lat: -8.0167703, lng: -34.864118}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('331', '2', '{lat: -8.0170528, lng: -34.863879}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('332', '2', '{lat: -8.0170401, lng: -34.8638645}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('333', '2', '{lat: -8.0170401, lng: -34.8638645}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('334', '2', '{lat: -8.0170349, lng: -34.8638553}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('335', '2', '{lat: -8.0170349, lng: -34.8638553}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('336', '2', '{lat: -8.0170382, lng: -34.8638561}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('337', '2', '{lat: -8.0170384, lng: -34.8638562}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('340', '2', '{lat: -8.0180264, lng: -34.8651554}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('424', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('425', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('426', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 00:00:00');
INSERT INTO `tb_routes_coordinates` VALUES ('427', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:27');
INSERT INTO `tb_routes_coordinates` VALUES ('428', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:28');
INSERT INTO `tb_routes_coordinates` VALUES ('429', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:35');
INSERT INTO `tb_routes_coordinates` VALUES ('430', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:36');
INSERT INTO `tb_routes_coordinates` VALUES ('431', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:38');
INSERT INTO `tb_routes_coordinates` VALUES ('432', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:42');
INSERT INTO `tb_routes_coordinates` VALUES ('433', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:49');
INSERT INTO `tb_routes_coordinates` VALUES ('434', '2', '{lat: -8.0178667, lng: -34.8650275}', '2019-02-07 09:44:50');
INSERT INTO `tb_routes_coordinates` VALUES ('435', '2', '{lat: -8.018037, lng: -34.8651549}', '2019-02-07 10:35:04');
INSERT INTO `tb_routes_coordinates` VALUES ('436', '2', '{lat: -8.0180278, lng: -34.8651544}', '2019-02-07 10:40:24');
INSERT INTO `tb_routes_coordinates` VALUES ('437', '2', '{lat: -8.0180275, lng: -34.8651549}', '2019-02-07 10:42:39');
INSERT INTO `tb_routes_coordinates` VALUES ('438', '2', '{lat: -8.0180273, lng: -34.8651542}', '2019-02-07 11:37:32');
INSERT INTO `tb_routes_coordinates` VALUES ('439', '2', '{lat: -8.0180362, lng: -34.8651611}', '2019-02-07 11:44:19');
INSERT INTO `tb_routes_coordinates` VALUES ('440', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 14:30:01');
INSERT INTO `tb_routes_coordinates` VALUES ('441', '2', '{lat: -8.0180376, lng: -34.8651553}', '2019-02-07 10:04:57');
INSERT INTO `tb_routes_coordinates` VALUES ('442', '2', '{lat: -8.0180254, lng: -34.8651581}', '2019-02-07 10:06:36');
INSERT INTO `tb_routes_coordinates` VALUES ('443', '2', '{lat: -8.0180251, lng: -34.865157}', '2019-02-07 10:06:42');
INSERT INTO `tb_routes_coordinates` VALUES ('444', '2', '{lat: -8.0180249, lng: -34.8651579}', '2019-02-07 10:06:48');
INSERT INTO `tb_routes_coordinates` VALUES ('445', '2', '{lat: -8.0180257, lng: -34.8651568}', '2019-02-07 10:06:54');
INSERT INTO `tb_routes_coordinates` VALUES ('446', '2', '{lat: -8.0180263, lng: -34.865156}', '2019-02-07 10:07:00');
INSERT INTO `tb_routes_coordinates` VALUES ('447', '2', '{lat: -8.0180265, lng: -34.8651556}', '2019-02-07 10:07:07');
INSERT INTO `tb_routes_coordinates` VALUES ('448', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 10:08:06');
INSERT INTO `tb_routes_coordinates` VALUES ('449', '2', '{lat: -8.0180265, lng: -34.8651556}', '2019-02-07 10:08:08');
INSERT INTO `tb_routes_coordinates` VALUES ('450', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 10:08:15');
INSERT INTO `tb_routes_coordinates` VALUES ('451', '2', '{lat: -8.0180265, lng: -34.8651556}', '2019-02-07 10:08:18');
INSERT INTO `tb_routes_coordinates` VALUES ('452', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 10:08:55');
INSERT INTO `tb_routes_coordinates` VALUES ('453', '2', '{lat: -8.0180265, lng: -34.8651556}', '2019-02-07 10:08:58');
INSERT INTO `tb_routes_coordinates` VALUES ('454', '2', '{lat: -8.0180365, lng: -34.8651557}', '2019-02-07 10:11:40');
INSERT INTO `tb_routes_coordinates` VALUES ('455', '2', '{lat: -8.0180269, lng: -34.8651538}', '2019-02-07 10:16:13');
INSERT INTO `tb_routes_coordinates` VALUES ('456', '2', '{lat: -8.0180281, lng: -34.8651543}', '2019-02-07 10:42:16');
INSERT INTO `tb_routes_coordinates` VALUES ('457', '2', '{lat: -8.0180281, lng: -34.8651542}', '2019-02-07 10:42:22');
INSERT INTO `tb_routes_coordinates` VALUES ('458', '2', '{lat: -8.0180271, lng: -34.8651564}', '2019-02-07 10:42:29');
INSERT INTO `tb_routes_coordinates` VALUES ('459', '2', '{lat: -8.0180268, lng: -34.865155}', '2019-02-07 10:42:35');
INSERT INTO `tb_routes_coordinates` VALUES ('460', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:22:27');
INSERT INTO `tb_routes_coordinates` VALUES ('461', '2', '{lat: -8.018027, lng: -34.8651539}', '2019-02-07 11:23:57');
INSERT INTO `tb_routes_coordinates` VALUES ('462', '2', '{lat: -8.0180367, lng: -34.8651544}', '2019-02-07 11:24:01');
INSERT INTO `tb_routes_coordinates` VALUES ('463', '2', '{lat: -8.0180274, lng: -34.8651563}', '2019-02-07 11:24:07');
INSERT INTO `tb_routes_coordinates` VALUES ('464', '2', '{lat: -8.0180255, lng: -34.865161}', '2019-02-07 11:24:13');
INSERT INTO `tb_routes_coordinates` VALUES ('465', '2', '{lat: -8.0180278, lng: -34.8651561}', '2019-02-07 11:24:19');
INSERT INTO `tb_routes_coordinates` VALUES ('466', '2', '{lat: -8.0180269, lng: -34.8651539}', '2019-02-07 11:24:25');
INSERT INTO `tb_routes_coordinates` VALUES ('467', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:24:32');
INSERT INTO `tb_routes_coordinates` VALUES ('468', '2', '{lat: -8.0180269, lng: -34.8651539}', '2019-02-07 11:24:35');
INSERT INTO `tb_routes_coordinates` VALUES ('469', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:24:39');
INSERT INTO `tb_routes_coordinates` VALUES ('470', '2', '{lat: -8.0180264, lng: -34.8651557}', '2019-02-07 11:24:41');
INSERT INTO `tb_routes_coordinates` VALUES ('471', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:24:54');
INSERT INTO `tb_routes_coordinates` VALUES ('472', '2', '{lat: -8.0180264, lng: -34.8651557}', '2019-02-07 11:24:56');
INSERT INTO `tb_routes_coordinates` VALUES ('473', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:25:18');
INSERT INTO `tb_routes_coordinates` VALUES ('474', '2', '{lat: -8.0180264, lng: -34.8651557}', '2019-02-07 11:27:08');
INSERT INTO `tb_routes_coordinates` VALUES ('475', '2', '{lat: -8.0180268, lng: -34.8651541}', '2019-02-07 11:27:09');
INSERT INTO `tb_routes_coordinates` VALUES ('476', '2', '{lat: -8.0180272, lng: -34.8651548}', '2019-02-07 11:27:16');
INSERT INTO `tb_routes_coordinates` VALUES ('477', '2', '{lat: -8.0180253, lng: -34.8651549}', '2019-02-07 11:27:21');
INSERT INTO `tb_routes_coordinates` VALUES ('478', '2', '{lat: -8.0180259, lng: -34.8651552}', '2019-02-07 11:27:30');
INSERT INTO `tb_routes_coordinates` VALUES ('479', '2', '{lat: -8.0180268, lng: -34.865154}', '2019-02-07 11:27:35');
INSERT INTO `tb_routes_coordinates` VALUES ('480', '2', '{lat: -8.0180275, lng: -34.8651543}', '2019-02-07 11:27:42');
INSERT INTO `tb_routes_coordinates` VALUES ('481', '2', '{lat: -8.0180263, lng: -34.8651547}', '2019-02-07 11:27:58');
INSERT INTO `tb_routes_coordinates` VALUES ('482', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:28:42');
INSERT INTO `tb_routes_coordinates` VALUES ('483', '2', '{lat: -8.0180263, lng: -34.8651547}', '2019-02-07 11:28:43');
INSERT INTO `tb_routes_coordinates` VALUES ('484', '2', '{lat: -8.0165539, lng: -34.8679239}', '2019-02-07 11:29:08');
INSERT INTO `tb_routes_coordinates` VALUES ('485', '2', '{lat: -8.0180002, lng: -34.8651631}', '2019-02-07 11:51:22');
INSERT INTO `tb_routes_coordinates` VALUES ('486', '2', '{lat: -8.0179134, lng: -34.8652195}', '2019-02-07 12:08:43');
INSERT INTO `tb_routes_coordinates` VALUES ('487', '2', '{lat: -8.0179319, lng: -34.8652034}', '2019-02-07 12:08:54');
INSERT INTO `tb_routes_coordinates` VALUES ('488', '2', '{lat: -8.0179857, lng: -34.8651731}', '2019-02-07 12:09:11');
INSERT INTO `tb_routes_coordinates` VALUES ('489', '2', '{lat: -8.0179587, lng: -34.8651811}', '2019-02-07 12:09:18');
INSERT INTO `tb_routes_coordinates` VALUES ('490', '2', '{lat: -8.0179531, lng: -34.865179}', '2019-02-07 12:09:24');
INSERT INTO `tb_routes_coordinates` VALUES ('491', '2', '{lat: -8.0179405, lng: -34.8651889}', '2019-02-07 12:09:30');
INSERT INTO `tb_routes_coordinates` VALUES ('492', '2', '{lat: -8.017948, lng: -34.8651875}', '2019-02-07 12:09:36');
INSERT INTO `tb_routes_coordinates` VALUES ('493', '2', '{lat: -8.0179863, lng: -34.8651679}', '2019-02-07 12:09:48');
INSERT INTO `tb_routes_coordinates` VALUES ('494', '2', '{lat: -8.0179939, lng: -34.8651681}', '2019-02-07 12:09:54');
INSERT INTO `tb_routes_coordinates` VALUES ('495', '2', '{lat: -8.0180219, lng: -34.8651675}', '2019-02-07 12:10:00');
INSERT INTO `tb_routes_coordinates` VALUES ('496', '2', '{lat: -8.0180183, lng: -34.8651665}', '2019-02-07 12:10:06');
INSERT INTO `tb_routes_coordinates` VALUES ('497', '2', '{lat: -8.0180134, lng: -34.8651554}', '2019-02-07 12:10:30');
INSERT INTO `tb_routes_coordinates` VALUES ('498', '2', '{lat: -8.018022, lng: -34.8651556}', '2019-02-07 12:14:51');
INSERT INTO `tb_routes_coordinates` VALUES ('499', '2', '{lat: -8.0180152, lng: -34.8651549}', '2019-02-07 12:14:58');
INSERT INTO `tb_routes_coordinates` VALUES ('500', '2', '{lat: -8.0180201, lng: -34.8651534}', '2019-02-07 12:16:05');
INSERT INTO `tb_routes_coordinates` VALUES ('501', '2', '{lat: -8.0180245, lng: -34.8651532}', '2019-02-07 12:16:11');
INSERT INTO `tb_routes_coordinates` VALUES ('502', '2', '{lat: -8.0180129, lng: -34.8651537}', '2019-02-07 12:16:27');
INSERT INTO `tb_routes_coordinates` VALUES ('503', '2', '{lat: -8.0180214, lng: -34.8651539}', '2019-02-07 12:16:34');
INSERT INTO `tb_routes_coordinates` VALUES ('504', '2', '{lat: -8.0180169, lng: -34.8651542}', '2019-02-07 12:16:40');
INSERT INTO `tb_routes_coordinates` VALUES ('508', '4', '{lat: -8.0192927, lng: -34.8677542}', '2019-02-07 10:19:55');
INSERT INTO `tb_routes_coordinates` VALUES ('509', '4', '{lat: -8.0192927, lng: -34.8677542}', '2019-02-07 10:19:55');
INSERT INTO `tb_routes_coordinates` VALUES ('510', '4', '{lat: -8.0203029, lng: -34.8635217}', '2019-02-07 10:23:02');
INSERT INTO `tb_routes_coordinates` VALUES ('511', '4', '{lat: -8.0203029, lng: -34.8635217}', '2019-02-07 10:23:46');
INSERT INTO `tb_routes_coordinates` VALUES ('512', '4', '{lat: -8.0202461, lng: -34.8593542}', '2019-02-07 10:24:54');
INSERT INTO `tb_routes_coordinates` VALUES ('513', '4', '{lat: -8.0177917, lng: -34.8650072}', '2019-02-07 09:29:06');

-- ----------------------------
-- Table structure for tb_routes_status
-- ----------------------------
CREATE TABLE `tb_routes_status` (
`routes_status_id`  int(11) NOT NULL AUTO_INCREMENT ,
`routes_status_descr`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`routes_status_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=6

;

-- ----------------------------
-- Records of tb_routes_status
-- ----------------------------
INSERT INTO `tb_routes_status` VALUES ('1', 'Pending');
INSERT INTO `tb_routes_status` VALUES ('2', 'In Route');
INSERT INTO `tb_routes_status` VALUES ('3', 'Paused');
INSERT INTO `tb_routes_status` VALUES ('4', 'Delivering');
INSERT INTO `tb_routes_status` VALUES ('5', 'Concluded');

-- ----------------------------
-- Auto increment value for sc_log
-- ----------------------------
ALTER TABLE `sc_log` AUTO_INCREMENT=75;

-- ----------------------------
-- Auto increment value for tb_adresses
-- ----------------------------
ALTER TABLE `tb_adresses` AUTO_INCREMENT=11;

-- ----------------------------
-- Auto increment value for tb_company_info
-- ----------------------------
ALTER TABLE `tb_company_info` AUTO_INCREMENT=2;

-- ----------------------------
-- Auto increment value for tb_deliverers
-- ----------------------------
ALTER TABLE `tb_deliverers` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tb_markers
-- ----------------------------
ALTER TABLE `tb_markers` AUTO_INCREMENT=12;

-- ----------------------------
-- Auto increment value for tb_markers_status
-- ----------------------------
ALTER TABLE `tb_markers_status` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tb_routes
-- ----------------------------
ALTER TABLE `tb_routes` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for tb_routes_coordinates
-- ----------------------------
ALTER TABLE `tb_routes_coordinates` AUTO_INCREMENT=514;

-- ----------------------------
-- Auto increment value for tb_routes_status
-- ----------------------------
ALTER TABLE `tb_routes_status` AUTO_INCREMENT=6;
