function drawMap(strChartType, strChartTitle, strChartSubTitle, minValue, avgValue, MaxValue, jsonData)
{
    FusionCharts.ready(function() {
        var populationMap = new FusionCharts({
            type: 'maps/' + strChartType,
            renderAt: 'chart-container',
            width: '100%',
            height: '100%',
            dataFormat: 'json',
            dataSource: {
                "chart": {
                    "caption": strChartTitle,
                    "subcaption": strChartSubTitle,
                    "theme": "fint",
                    "formatNumberScale": "0",
                    "showLabels": "1",
                    "nullEntityColor": "#C2C2D6",
                    "nullEntityAlpha": "50",
                    "hoverOnNull": "0",
                    "useSNameInLabels": "0",
                    "entityFillColor": "#A8A8A8",
                    "entityFillHoverColor": "#E5E5E9",
					"canvasBorderColor":"#FFFFFF",
					"borderColor":"#808080"
                },
                "colorrange": {
                    "startlabel": "Low",
                    "endlabel": "High",
                    "code": "#e44a00",
                    "minvalue": minValue,
                    "gradient": "1",
                    "color": [{
                        "maxvalue": avgValue,
                        "displayvalue": "Average",
                        "code": "#f8bd19"
                    }, {
                        "maxvalue": MaxValue,
                        "code": "#6baa01"
                    }]
                },
        
                "data": jsonData,
            }
        });	
    	populationMap.render();
    });
}