<?php

function getChartSQL()
{
	//fusionchart key
	//label
	//chart type map
	//the value itself
	if(isset($_GET['map']) && isset($_GET['region']) && isset($_GET['country']))
	{
		$str_sql = "
SELECT
   states.fs_id,
   states.statename,   
   states.statename,
   SUM(orders.priceorder)
FROM
   orders INNER JOIN customers ON orders.customerid = customers.customerid
   INNER JOIN states ON customers.stateid = states.stateid
   INNER JOIN country ON customers.country = country.iso
   INNER JOIN country_region ON country.country_region = country_region.regionid
WHERE
	country_region.short_label = \"". str_replace('"', "\"", $_GET['region']) . "\" AND
    country.fs_id = \"". str_replace('"', "\"", $_GET['country']) . "\"
GROUP BY
   states.stateid,
   states.statename,   
   states.statename
";
	}
	elseif(isset($_GET['map']) && isset($_GET['region']))
	{
		$str_sql = "
SELECT
   country.fs_id,
   country.printable_name,   
   country.fs_map,
   SUM(orders.priceorder)
FROM
   orders INNER JOIN customers ON orders.customerid = customers.customerid
   INNER JOIN states ON customers.stateid = states.stateid
   INNER JOIN country ON customers.country = country.iso
   INNER JOIN country_region ON country.country_region = country_region.regionid
WHERE
    country_region.short_label = \"". str_replace('"', "\"", $_GET['region']) . "\"
GROUP BY
   country.fs_id,
   country.printable_name,   
   country.fs_map
";
	}
	else
	{
		$str_sql = "
SELECT
   country_region.short_label,
   country_region.label,
   country_region.fs_map,
   SUM(orders.priceorder)
FROM
   orders INNER JOIN customers ON orders.customerid = customers.customerid
   INNER JOIN states ON customers.stateid = states.stateid
   INNER JOIN country ON customers.country = country.iso
   INNER JOIN country_region ON country.country_region = country_region.regionid
GROUP BY
   country_region.short_label,
   country_region.label,
   country_region.fs_map
";
	}

	return $str_sql;
}

function getChartMapType()
{
	if(isset($_GET['map']))
	{
		return $_GET['map'];
	}
	else
	{
		return "world";
	}
}

function getChartData($rs)
{
	$arr_data = array();

	$arr_data['min'] = 0;
	$arr_data['max'] = 0;	
	$arr_data['data'] = "";

	foreach($rs as $row)
	{
		$link = "";
		if(isset($_GET['map']) && isset($_GET['region']) && isset($_GET['country']))
		{

		}
		elseif(isset($_GET['map']) && isset($_GET['region']))
		{
			$link = "?map=". $row[2] ."&region=" . $_GET['region'] ."&country=" . $row[0] . "&last_map=" . $_GET['map'];
		}
		else
		{
			$link = "?map=". $row[2] ."&region=" . $row[0];
		}

		if($row[3] > $arr_data['max'])
		{
			$arr_data['max'] = $row[3];
		}

		$arr_data['data'] .= '{
	                    "id": "'. $row[0] .'",
	                    "displayValue": "'. $row[1] .'",
	                    "showLabel": "1",
	                    "value": "'. $row[3] .'",
						"link": "'. $link .'",
	                },';
	}
	return $arr_data;
}

function getHtmlBackButton($strLang)
{
	if(isset($_GET['last_map']) && isset($_GET['region']) && isset($_GET['country']))
	{
		return "<a id='back' href='?map=". $_GET['last_map'] ."&region=". $_GET['region'] ."'>". $strLang ."</a>";
	}
	elseif(isset($_GET['map']) && isset($_GET['region']))
	{
		return "<a id='back' href='?'>". $strLang ."</a>";
	}
	else
	{
		return "";
	}
}