<?php
/**
 * Classe nmPageEditHotkeyTemplates.
 *
 * Endpoint para requisições AJAX com funções genéricas.
 *
 * @package     Classes
 * @subpackage  Page
 * @creation    2018/04/24
 * @copyright   NetMake Solucoes em Informatica
 * @author      Henrique Cézar de Barros <h.barros@netmake.com.br>
 *
 * $Id: nmPageEditHotkeyTemplates.class.php,v 1.0 2018-06-19 15:58:42 henrique Exp $
 */

/* Protecao contra hacks */
if (!defined('SC_LOCKED_VERSION_8976') || ('CARREGADO4536' != SC_LOCKED_VERSION_8976))
{
    die('<br /><span style="font-weight: bold">Fatal error</span>: ' .
        'invalid access to system file.');
}

/* Classes ancestrais */
nm_load_class('page', 'Page');
nm_load_class('interface', 'NewMenuThemes');

/* Definicao da classe */
class nmPageEditMenuThemes extends nmPage
{
    var $handler;

    function __construct()
    {
        $this->handler = new nmNewMenuThemes();
        if ($this->isPreviewCall()) {
            $this->SetArg('skip_default_js', true);
            $this->SetArg('skip_default_acss', true);
            $this->SetArg('skip_default_css', true);
        } else {
            $this->SetBody('nmPage');
            if (isset($_REQUEST['field-theme-name']) && !empty($_REQUEST['field-theme-name'])) {
                $this->prepareAndSave();
            }
            if (isset($_REQUEST['delete-name']) && !empty($_REQUEST['delete-name'])) {
                $this->prepareAndDelete();
            }
        }
        $this->setDocType("XHTML 1.0 Transitional");
        $this->SetBody('nmPage');
        $this->SetMargin(0);
	    $this->LoadLang('Top2');
        $this->SetPage('editmenuthemes');
        $this->CheckLogin();
        $this->SetPageSubtitle('');
        $this->SetScroll('auto');
    }

    function DisplayContent()
    {
	    global $nm_template;

        if ($this->isPreviewCall()) {
            $display = 'body_edit_menu_themes_preview';
            $theme_p = $this->getThemeDataParams();
            $nm_template->SetVar('theme_params', $theme_p);
            $nm_template->SetVar('usar_css', 'N');
        } else {
            $nm_template->SetVar('usar_css', "S");
            $nm_template->SetVar('handler', $this->handler);
            $nm_template->SetVar('menu_themes_list', $this->getMenuThemesList());
            $this->showPageDesenv('edit_menu_themes');
            $dest = nm_verify_doc_url($this->getManual('edit_menu_themes', NM_HELP_MENU_CONFIG));
            $nm_template->SetVar('link_manual', $dest);
            $display = 'body_edit_menu_themes';
            $this->showPageDesenv($display);
        }

	    $nm_template->Display($display);
    }

    function copyData() {
        $dat = $this->handler->getSCData();
        foreach ($dat as $k => $v) {
            $this->saveTheme($v, $this->handler::PUBLIC_SCOPE);
        }
    }
    function sanitizeName($input) {
        $out = preg_replace('/[^0-9a-zA-Z _-]/', '_', trim($input));
        return $out;
    }

    function prepareAndSave() {
        $theme_data = [];
        $old_theme_name = '';
        $scope = '';
        $theme_data_reference = [
            'field-theme-name' => 'name',
            'filescope' => 'scope',
            'input_primary_color' => 'p',
            'input_secondary_color' => 's',
            'input_muted_color' => 'm',
            'input_text_color' => 't',
            'input_accent_color' => 'a',
            'input_notification_color' => 'n',
            'input_box_shadow' => 'b',
        ];

        foreach ($theme_data_reference as $k => $v) {
            $theme_data[$v] = $_REQUEST[$k];
        }
        $theme_data['name'] = $this->sanitizeName($theme_data['name']);
        $old_theme_name = $_REQUEST['field-theme-orig'];
        $old_theme_scope = $_REQUEST['filescope-orig'];
        $scope = $_REQUEST['filescope'];

        if (empty($old_theme_name)) {
            $this->saveTheme($theme_data, $scope);
        } else {
            $this->editTheme($old_theme_name, $theme_data, $old_theme_scope, $scope);
        }
    }

    function prepareAndDelete() {
        $theme_name = $_REQUEST['delete-name'];
        $scope = $_REQUEST['delete-filescope'];

        $this->deleteTheme($theme_name, $scope);
    }

    function saveTheme($theme_data, $scope) {
        if ($scope == $this->handler::SCRIPTCASE_SCOPE) return;
        $scope_themes = $this->handler->getArrayFromScope($scope);

        $scope_themes[$theme_data['name']] = $theme_data;

        $return_data = $this->handler->saveTemplateFileSep($scope_themes, $this->handler->file_name, $scope, false);
        return $return_data;
    }

    function deleteTheme($theme_name, $scope) {
        if ($scope == $this->handler::SCRIPTCASE_SCOPE) return;
        $scope_themes = $this->handler->getArrayFromScope($scope);

        unset($scope_themes[$theme_name]);

        $return_data = $this->handler->saveTemplateFileSep($scope_themes, $this->handler->file_name, $scope, false);
        return $return_data;
    }

    function editTheme($old_theme_name, $theme_data, $old_theme_scope, $scope) {
        if ($scope == $this->handler::SCRIPTCASE_SCOPE) return;
        if ($old_theme_scope == $scope) {
            $scope_themes_old = $this->handler->getArrayFromScope($scope);
            $scope_themes = [];
            foreach ($scope_themes_old as $k => $v) {
                if ($k == $old_theme_name) {
                    $scope_themes[$theme_data['name']] = $theme_data;
                } else {
                    $scope_themes[$k] = $v;
                }
            }
            $return_data = $this->handler->saveTemplateFileSep($scope_themes, $this->handler->file_name, $scope, false);
        } else {
            $scope_themes_old = $this->handler->getArrayFromScope($old_theme_scope);
            $scope_themes_new = $this->handler->getArrayFromScope($scope);

            unset($scope_themes_old[$old_theme_name]);
            $scope_themes_new[$theme_data['name']] = $theme_data;

            $return_data = $this->handler->saveTemplateFileSep($scope_themes_old, $this->handler->file_name, $old_theme_scope, false);
            $return_data = $this->handler->saveTemplateFileSep($scope_themes_new, $this->handler->file_name, $scope, false);
        }
        return $return_data;
    }
    function getThemeDataParams() {
        if (!isset($_REQUEST['colors-data']) || empty($_REQUEST['colors-data'])) return false;
        $arr_conv = $_REQUEST['colors-data'];
        if (isset($arr_conv) && !empty($arr_conv) && $arr_conv = base64_decode($arr_conv)) {
            if ($arr_conv = json_decode($arr_conv, true)) {
                if (is_array($arr_conv)) {
                    return $arr_conv;
                }
            }
        }
        return [
            'name' => 'null',
            'scope' => 'scriptcase',
            'p' => '#0A083A',
            's' => '#3E3B87',
            'a' => '#3E3B87',
            'm' => '#B3B2D4',
            't' => '#DDDEE9',
            'b' => 'rgba(0, 0, 0, 0.5)',
            'n' => '#FF4C51'
        ];
    }

    function isPreviewCall() {
        return (isset($_REQUEST['preview_menu']) && $_REQUEST['preview_menu'] == 'Y');
    }

    function getMenuThemesList() {
        global $nm_config;
        $output = [];
        $arr_push = $this->handler->getArrayFromScope($this->handler::SCRIPTCASE_SCOPE, true);
        $output = array_merge($output, $arr_push);
        $arr_push = $this->handler->getArrayFromScope($this->handler::PROJECT_SCOPE, true);
        $output = array_merge($output, $arr_push);
        $arr_push = $this->handler->getArrayFromScope($this->handler::PUBLIC_SCOPE, true);
        $output = array_merge($output, $arr_push);
//        $cssData = file_get_contents($nm_config['path_devel'].'generator/nmGen/navMenu/common/themes.css');
//        $arr_css_themes = BreakCSS($cssData);
//        $output = [];
//        foreach ( $arr_css_themes['all'] as $k=> $v) {
//            if (strpos($k, 'data-aetheme=') !== false && strpos($k, '@') === false) {
//                $out = preg_replace("/\*\[data\-aetheme\=([A-Za-z0-9\_\-]*)\]/", '$1', $k );
//                $name = ucwords(str_replace('-', ' ', $out));
//                $output[$out] = [
//                    'name' => $name,
//                    'scope' => 'scriptcase',
//                    'p' => $v['--theme-color-primary'],
//                    's' => $v['--theme-color-secondary'],
//                    'a' => $v['--theme-color-accent'],
//                    'm' => $v['--theme-color-muted'],
//                    't' => $v['--theme-color-text'],
//                    'b' => $v['--theme-box-shadow'],
//                    'n' => $v['--theme-alert-color'],
//                ];
//            }
//        }
        return $output;
    }

    function PageJavascript()
    {
	    global $nm_config, $obj_lic;

        $file_list = $this->getMenuThemesList();
        $arr_default = '{}';
        $lang_action = str_replace("'", '\\\'',nm_get_text_lang("['action']", 'editkeybindings'));
        $lang_keyset = str_replace("'", '\\\'',nm_get_text_lang("['keyset']", 'editkeybindings'));
//        $lang_label = str_replace("'", '\\\'',nm_get_text_lang("['label']", 'editkeybindings'));
//        $lang_hint = str_replace("'", '\\\'',nm_get_text_lang("['hint']", 'editkeybindings'));
        $lang_new_keyset = '+';//'+ adicionar nova';
        $lang_remove_keyset = '-';//'- remover';
        $lang_insert_keys = str_replace("'", '\\\'', nm_get_text_lang("['insert_keyset']", 'editkeybindings'));
        $lang_none_selected = str_replace("'", '\\\'', nm_get_text_lang("['none_selected']", 'editkeybindings'));
        $lang_keyset_already_taken = str_replace("'", '\\\'', nm_get_text_lang("['keyset_already_taken']", 'editkeybindings'));
        $lang_action_already_taken = str_replace("'", '\\\'', nm_get_text_lang("['action_already_taken']", 'editkeybindings'));
        $lang_invalid_file_name = str_replace("'", '\\\'', nm_get_text_lang("['help_case_err_file_invalido']", 'HelpCaseLista'));
        $lang_file_name_already_exists = str_replace("'", '\\\'', nm_get_text_lang("['already_exists']", 'HelpCaseLista'));
        $lang_confirm_file_move = str_replace("'", '\\\'', nm_get_text_lang("['confirm_file_move']"));
        $img_path = $nm_config['url_img_toolbar'];
        $has_92 = ($nm_config['has_92']) ? 'true' : 'false';
        $em_desenv = ($nm_config['em_desenv']) ? 'true' : 'false';
    }

    function PageJs()
    {
        if ($this->isPreviewCall()) {
            $this->AddJs('third', 'jquery_plugin/contextmenu/jquery.contextmenu.js');
            $this->AddJs('third', 'Fuse/dist/fuse.min.js');
            $this->AddJs('thirddevel', 'toastr/toastr.js');
        } else {
            $this->AddJs('devel', 'window.js?v=9.1');
            $this->AddJs('third', 'jquery_plugin/malsup-blockui/jquery.blockUI.js');
            $this->AddJs('third', 'semantic-ui/semantic.min.js');
            $this->AddJs('thirddevel', 'sc-module-menu-theme-editor-main/modules/@jaames/iro/dist/iro.js');
            $this->AddJs('thirddevel', 'sc-module-menu-theme-editor-main/modules/tablesort/tablesort.js');
            $this->AddJs('thirddevel', 'sc-module-menu-theme-editor-main/main.js');
            $this->AddJs('third', 'jquery_plugin/colorpicker/js/colorpicker.js');
        }
    }

    function PageStyle() { }

    function PageStyleCss()
    {
        if ($this->isPreviewCall()) {
            $this->AddStyleCss('third', 'jquery_plugin/contextmenu/contextmenu.css');
            $this->AddStyleCss('third', 'font-awesome/6/css/all.min.css');
            $this->AddStyleCss('third', 'lineicons/web-font-files/lineicons.css');
            $this->AddStyleCss('thirddevel', 'toastr/toastr.css');
        } else {
            $this->AddStyleCssAfterScCss('third', 'semantic-ui/semantic.min.css');
            $this->AddStyleCssAfterScCss('third', 'jquery_plugin/colorpicker/css/colorpicker.css');
            $this->AddStyleCss('thirddevel', 'sc-module-menu-theme-editor-main/components/core.css');
            $this->AddStyleCss('thirddevel', 'sc-module-menu-theme-editor-main/components/animations.global.css');
            $this->AddStyleCss('thirddevel', 'sc-module-menu-theme-editor-main/components/colorpicker.css');
            $this->AddStyleCss('thirddevel', 'sc-module-menu-theme-editor-main/menuthemeeditor.css');
        }
    }
}

?>