
<?php
$ret = getNotifRecords($this, $menu_data);
?>

<style>
    .m-bottom-0.body {
        font-size: 0.8rem !important;
        height: 35px;
        margin: 0 0 10px 0;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
        white-space: normal !important;
        word-break: break-all;
        position: relative;
        text-overflow: ellipsis;
        font-weight: normal;
        text-decoration: none;
    }
    .m-bottom-0.body * {
        font-size: 0.8rem !important;
        font-weight: normal !important;
        text-decoration: none !important;
    }
    .m-bottom-0.body img {
        display: none;
    }
    .m-bottom-1.title {
        font-weight: bold;
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
        white-space: normal !important;
        word-break: break-all;
        text-overflow: ellipsis;
    }
    #notification-viewAll i {
        display: none;
    }
    .ae-menubar #notification-content .notification-item .signs {
        display: flex;
        justify-content: flex-end;
        align-items: center;
        column-gap: .5rem;
        font-size: small;
    }

    .ae-menubar #notification-content .notification-item .signs > .fa-thumbtack {
        opacity: .75;
    }

    .ae-menubar #notification-content .notification-item[data-ontop="false"] .signs > .fa-thumbtack {
        display: none;
    }

    .ae-menubar .toolbar #notification-dot {
        background: var(--theme-alert-color);
    }
    .ae-menubar #notification-content .notification-item .read-sign {
        background: var(--theme-alert-color);
    }
    .ae-menubar #notification-content .notification-item .confirm-exclude {
        width: 100%;
        height: 100%;
        top: 0;
        left: 100%;
        background: var(--theme-color-secondary);
        position: absolute;
        transition: all ease 0.3s;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 10px;
        text-align: center;
        gap: 10px;
        cursor: auto;
        visibility: hidden;
    }
    .ae-menubar #notification-content .notification-item .confirm-exclude.open-confirm {
        left: 0%;
        visibility: visible;
    }
    .ae-menubar #notification-content .notification-item .confirm-exclude .confirm-exclude-label {
        font-weight: bold;
    }
    .ae-menubar #notification-content .notification-item .confirm-exclude .confirm-exclude-actions {
        display: flex;
        flex-direction: row;
        justify-content: center;
        align-items: center;
        flex-wrap: wrap;
        column-gap: 10px;
    }
    .ae-menubar #notification-content .notification-item .confirm-exclude .confirm-exclude-actions .button.action-button {
        width: auto;
    }
    .ae-menubar #notification-header .unread-counter {
        background: var(--theme-menubar-nav-menuitem-backgroundColor);
        border-radius: 4px;
        padding: 3px 5px;
        color: var(--theme-color-text);
        font-size: .6em;
        text-transform: capitalize;
    }
    .ae-menubar #notification-header {
        column-gap: 10px;
    }
    .toast .avatar-img {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 10px;
        height: 30px;
        width: 30px;
        border-radius: 100%;
        overflow: hidden;
    }

    .toast-title {
        display: -webkit-box;
        -webkit-line-clamp: 1;
        -webkit-box-orient: vertical;
        overflow: hidden;
        white-space: normal !important;
        word-break: break-all;
        text-overflow: ellipsis;
    }

    .toast-message {
        font-size: 0.9rem !important;
        /*max-height: 40px;*/
        margin: 0 0 10px 0;
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;
        overflow: hidden;
        white-space: normal !important;
        word-break: break-word;
        position: relative;
        text-overflow: ellipsis;
        font-weight: normal;
        text-decoration: none;
    }
    .toast-message * {
        font-size: 0.9rem !important;
        font-weight: normal !important;
        text-decoration: none !important;
    }
    .toast-message img {
        display: none;
    }
    #toast-container > .toast {
        background: var(--theme-color-primary);
        background-image: none !important;
        opacity: 1;
        color: var(--theme-color-text) !important;
        font-family: inherit;
    }

    #toast-container > .toast:hover {
        box-shadow: 2px 2px 3px 0px var(--theme-box-shadow);
    }

    #toast-container > .toast .toast-progress {
        background: var(--theme-color-accent);
        filter: none;
        opacity: .9;
    }

    div#notification-empty > i, div#notification-error > i {
        font-size: 60px;
        opacity: .6;
    }

    div#notification-error, div#notification-empty {
        display: none;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 10px;
        padding: 20px;
        min-height: 170px;
        text-align: center;
    }

    div#notification-content:empty + div#notification-empty {
        display: flex;
    }

    #notification-panel.update_error div#notification-error {
        display: flex;
    }

    #notification-panel.update_error div#notification-content {
        display: none;
    }


</style>
<script>
    const BgColors = [
        '#F44336',
        '#EF5350',
        '#E53935',
        '#D32F2F',
        '#C62828',
        '#B71C1C',
        '#FF5252',
        '#FF1744',
        '#D50000',
        '#F06292',
        '#EC407A',
        '#E91E63',
        '#D81B60',
        '#C2185B',
        '#AD1457',
        '#880E4F',
        '#FF80AB',
        '#FF4081',
        '#F50057',
        '#C51162',
        '#BA68C8',
        '#AB47BC',
        '#9C27B0',
        '#8E24AA',
        '#7B1FA2',
        '#6A1B9A',
        '#4A148C',
        '#E040FB',
        '#D500F9',
        '#AA00FF',
        '#9575CD',
        '#7E57C2',
        '#673AB7',
        '#5E35B1',
        '#512DA8',
        '#4527A0',
        '#311B92',
        '#B388FF',
        '#7C4DFF',
        '#651FFF',
        '#6200EA',
        '#7986CB',
        '#5C6BC0',
        '#3F51B5',
        '#3949AB',
        '#303F9F',
        '#283593',
        '#1A237E',
        '#8C9EFF',
        '#536DFE',
        '#3D5AFE',
        '#304FFE',
        '#64B5F6',
        '#42A5F5',
        '#2196F3',
        '#1E88E5',
        '#1976D2',
        '#1565C0',
        '#0D47A1',
        '#448AFF',
        '#2979FF',
        '#2962FF',
        '#4FC3F7',
        '#29B6F6',
        '#03A9F4',
        '#039BE5',
        '#0288D1',
        '#0277BD',
        '#01579B',
        '#40C4FF',
        '#00B0FF',
        '#0091EA',
        '#26C6DA',
        '#00BCD4',
        '#00ACC1',
        '#0097A7',
        '#00838F',
        '#006064',
        '#18FFFF',
        '#00E5FF',
        '#00B8D4',
        '#26A69A',
        '#009688',
        '#00897B',
        '#00796B',
        '#00695C',
        '#004D40',
        '#1DE9B6',
        '#00BFA5',
        '#66BB6A',
        '#4CAF50',
        '#43A047',
        '#388E3C',
        '#2E7D32',
        '#1B5E20',
        '#00E676',
        '#00C853',
        '#9CCC65',
        '#8BC34A',
        '#7CB342',
        '#689F38',
        '#558B2F',
        '#33691E',
        '#CCFF90',
        '#B2FF59',
        '#76FF03',
        '#64DD17',
        '#DCE775',
        '#D4E157',
        '#CDDC39',
        '#C0CA33',
        '#AFB42B',
        '#9E9D24',
        '#827717',
        '#F4FF81',
        '#EEFF41',
        '#C6FF00',
        '#AEEA00',
        '#FFEB3B',
        '#FDD835',
        '#FBC02D',
        '#F9A825',
        '#F57F17',
        '#FFFF00',
        '#FFEA00',
        '#FFD600',
        '#FFE082',
        '#FFD54F',
        '#FFCA28',
        '#FFC107',
        '#FFB300',
        '#FFA000',
        '#FF8F00',
        '#FF6F00',
        '#FFD740',
        '#FFC400',
        '#FFAB00',
        '#FFA726',
        '#FF9800',
        '#FB8C00',
        '#F57C00',
        '#EF6C00',
        '#E65100',
        '#FFAB40',
        '#FF9100',
        '#FF6D00',
        '#FF8A65',
        '#FF7043',
        '#FF5722',
        '#F4511E',
        '#E64A19',
        '#D84315',
        '#BF360C',
        '#FF6E40',
        '#FF3D00',
        '#DD2C00',
        '#8D6E63',
        '#795548',
        '#6D4C41',
        '#5D4037',
        '#4E342E',
        '#3E2723',
        '#757575',
        '#616161',
        '#424242',
        '#212121',
        '#78909C',
        '#607D8B',
        '#546E7A',
        '#455A64',
        '#37474F',
        '#263238',
        '#000000',
    ];

    const TextColors = [
            "#FFEBEE",
            "#FFCDD2",
            "#EF9A9A",
            "#E57373",
            "#FF8A80",
            "#FCE4EC",
            "#F8BBD0",
            "#F48FB1",
            "#F3E5F5",
            "#E1BEE7",
            "#CE93D8",
            "#EA80FC",
            "#EDE7F6",
            "#D1C4E9",
            "#B39DDB",
            "#E8EAF6",
            "#C5CAE9",
            "#9FA8DA",
            "#E3F2FD",
            "#BBDEFB",
            "#90CAF9",
            "#82B1FF",
            "#E1F5FE",
            "#B3E5FC",
            "#81D4FA",
            "#80D8FF",
            "#E0F7FA",
            "#B2EBF2",
            "#80DEEA",
            "#4DD0E1",
            "#84FFFF",
            "#E0F2F1",
            "#B2DFDB",
            "#80CBC4",
            "#4DB6AC",
            "#A7FFEB",
            "#64FFDA",
            "#E8F5E9",
            "#C8E6C9",
            "#A5D6A7",
            "#81C784",
            "#B9F6CA",
            "#69F0AE",
            "#F1F8E9",
            "#DCEDC8",
            "#C5E1A5",
            "#AED581",
            "#F9FBE7",
            "#F0F4C3",
            "#E6EE9C",
            "#FFFDE7",
            "#FFF9C4",
            "#FFF59D",
            "#FFF176",
            "#FFEE58",
            "#FFFF8D",
            "#FFF8E1",
            "#FFECB3",
            "#FFE57F",
            "#FFF3E0",
            "#FFE0B2",
            "#FFCC80",
            "#FFB74D",
            "#FFD180",
            "#FBE9E7",
            "#FFCCBC",
            "#FFAB91",
            "#FF9E80",
            "#EFEBE9",
            "#D7CCC8",
            "#BCAAA4",
            "#A1887F",
            "#FAFAFA",
            "#F5F5F5",
            "#EEEEEE",
            "#E0E0E0",
            "#BDBDBD",
            "#9E9E9E",
            "#ECEFF1",
            "#CFD8DC",
            "#B0BEC5",
            "#90A4AE"
        ];


    function generateAvatar(in_text) {
        var canvas = document.createElement("canvas");
        var context = canvas.getContext("2d");
        var backgroundColor = stringToColour(in_text, BgColors);
        var foregroundColor = stringToColour(in_text, TextColors);

        canvas.width = 200;
        canvas.height = 200;

        context.fillStyle = backgroundColor;
        context.fillRect(0, 0, canvas.width, canvas.height);

        context.font = "100px Arial";
        context.fillStyle = foregroundColor;
        context.textAlign = "center";
        context.textBaseline = "middle";
        context.fillText(getInitials(in_text), canvas.width / 2, canvas.height / 2 );
        return canvas.toDataURL("image/png");
    }

    function stringToColour(in_str, in_palette) {
        // var str_hash = 0;
        // in_str.split('').forEach(char => {
        //     str_hash = char.charCodeAt(0) + ((str_hash << 5) - str_hash)
        // })
        // var color = '#'
        // for (var i = 0; i < 3; i++) {
        //     var value = (str_hash >> (i * 8)) & 0xff
        //     color += value.toString(16).padStart(2, '0')
        // }

        var h = 0;
        var l = in_str.length;
        var i = 0;

        if ( l > 0 ) {
            while (i < l) {
                h = (h << 5) - h + in_str.charCodeAt(i++) | 0;
            }
        }
        if (h < 0) {
            h = h*-1;
        }
        h = h % (in_palette.length - 1);


        return in_palette[h];

    }

    function getInitials(login) {
        var allNames = login.trim().split(' ');
        var initials = allNames.reduce((acc, curr, index) => {
            if(index === 0 || index === allNames.length - 1){
                acc = `${acc}${curr.charAt(0).toUpperCase()}`;
            }
            return acc;
        }, '');
        return initials;
    }

    function notifCheckNew(new_notif) {
        var current_notif = $('#notification-content');
        var new_notif_el = $.parseHTML(new_notif);
        var alert_notif = [];
        $(new_notif_el).each(function(i, el) {
            if ($(el).is('.notification-item')) {
                var n_id = $(el).attr('data-notif-id');
                var r_id = $(el).attr('id');
                if (!$(current_notif).find('[data-notif-id="'+n_id+'"]').length > 0) {
                    var n_obj = {
                        notif_id: n_id,
                        rand_id: r_id,
                        title: $(el).find('.content .title').text(),
                        message: $(el).find('.content .body').text(),
                        image: $(el).find('.avatar img').attr('src'),
                    }
                    alert_notif.push(n_obj);
                }
            }
        });
        current_notif.html(new_notif);
        alert_notif.forEach(function (ob) {
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-bottom-right aetheme-notif",
                "preventDuplicates": false,
                "showDuration": "50",
                "hideDuration": "300",
                "timeOut": "5000",
                "extendedTimeOut": "5000",
                "showEasing": "linear",
                "hideEasing": "linear",
                "showMethod": "slideDown",
                "hideMethod": "fadeOut",
                "onclick": function() {
                    $('#' + ob.rand_id).click();
                },
                "onShown": function() {
                    var notif_toast = $(this);
                    // notif_toast.css( 'cssText', 'background-image: url('+ $('#' + ob.rand_id).find('.avatar img').attr('src') +') !important; background-size: 30px');
                    notif_toast.css( 'cssText', 'background-image: none !important; position: relative;');
                    notif_toast.append( '<div class="avatar-img"><img src="'+$('#' + ob.rand_id).find('.avatar img').attr('src')+'"></div>');
                },
            }
            toastr["info"](ob.message, ob.title)
            // Swal.fire({
            //     toast: true,
            //     position: 'bottom-end',
            //     iconColor: 'black',
            //     timer: 4000,
            //     title: ob.title,
            //     icon: 'success',
            //     timerProgressBar: true,
            //     showConfirmButton: false,
            // })
        });
        notificationClose();
    }
    function ajaxError(a) {
        var er_msg = false;
        if (a.responseJSON && a.responseJSON.err_msg) {
            er_msg = a.responseJSON.err_msg;
        }
        if (er_msg) {
            notif_update_lock = true;
            Swal.fire({
                title: 'Error',
                html: er_msg,
                confirmButtonText: 'OK',
                onClose: function () {
                    notif_update_lock = false;
                }
            });
        } else {
            $('#notification-panel').addClass('update_error');
        }
    }
    function updateNotif() {
        if (notif_update_lock) return true;
        $.ajax({
            type: "POST",
            url: '',
            data: {
                ajax_notif_request: 'update',
                script_case_init: '1'
            },
            complete: function (a, b) {
                if (a.responseJSON && typeof a.responseJSON.msg === typeof '') {
                    $('#notification-panel').removeClass('update_error');
                    notifCheckNew(a.responseJSON.msg);
                    countNotifications();
                } else {
                    ajaxError(a);
                }
            },
            dataType: 'json'
        });
    }
    function markAllAsReadAjax() {
        $.ajax({
            type: "POST",
            url: '',
            data: {
                ajax_notif_request: 'all_read',
                script_case_init: '1'
            },
            complete: function (a, b) {
                if (a.responseJSON && typeof a.responseJSON.msg === typeof '') {
                    $('.notification-item').attr("data-read", "true");
                    $('.notification-item').attr("data-ontop", "false");
                    countNotifications();
                } else {
                    ajaxError(a);
                }
            },
            dataType: 'json'
        });
    }

    function markAsRead(notif_id) {
        var n_id = $('#' + notif_id).attr("data-notif-id");

        $.ajax({
            type: "POST",
            url: '',
            data: {
                ajax_notif_request: 'read',
                notif_id: n_id,
                script_case_init: '1'
            },
            complete: function (a, b) {
                if (a.responseJSON && typeof a.responseJSON.msg === typeof '') {
                    $('#' + notif_id).attr("data-read", "true");
                    $('#' + notif_id).attr("data-ontop", "false");
                    countNotifications();
                } else {
                    ajaxError(a);
                }
            },
            dataType: 'json'
        });
    }

    function deleteNotif(notif_id) {
        var n_id = $('#' + notif_id).attr("data-notif-id");

        $.ajax({
            type: "POST",
            url: '',
            data: {
                ajax_notif_request: 'delete',
                notif_id: n_id,
                script_case_init: '1'
            },
            complete: function (a, b) {
                if (a.responseJSON && typeof a.responseJSON.msg === typeof '') {
                    countNotifications();
                } else {
                    ajaxError(a);
                }
            },
            dataType: 'json'
        });
    }

    function openNotification(notif_id) {
        markAsRead(notif_id);
        openModal(notif_id);
    }

    function openLink(link_url, notif_id) {
        markAsRead(notif_id);
        window.open(link_url);
    }

    function openApp(app_name, notif_id) {
        var notif_el = $('#' + notif_id);
        var appURL = apl_link_build.replace('###APPNAME###', app_name);
        markAsRead(notif_id);
        if (typeof openInTab == 'function') {
            openInTab(appURL, notif_id + '_tab', notif_el.find('.content .title').html(), '', '', '_self', false);
        } else {
            $('#app-frames').find('iframe').addClass('loading');
            if (loadTimeout) {
                clearTimeout(loadTimeout);
            }
            loadTimeout = setTimeout(function () {
                $('#app-frames iframe').removeClass('loading');
            }, 10000);
            $('.nm_frame_app').attr('src', appURL);
        }
    }

    function openModal(notif_id) {
        var notif_el = $('#' + notif_id);
        Swal.fire({
            imageUrl: notif_el.find('.avatar img').attr('src'),
            imageHeight: 50,
            imageWidth: 50,
            title: notif_el.find('.content .title').html(),
            html: notif_el.find('.content .body').html(),
            confirmButtonText: '<?php echo sanitizeSpecChars($this->Nm_lang['lang_btns_cfrm']); ?>',
            customClass: {
                popup: 'notif-popup'
            }
        });
    }

    var notif_update_interval = setInterval(function() {
        updateNotif();
    }, <?php echo (isset($menu_data['notif_refresh_interval']) && !empty(intval($menu_data['notif_refresh_interval']))) ? intval($menu_data['notif_refresh_interval']) : 10000; ?>)

</script>
<div class="panel" id="notification-panel" role="dialog" aria-hidden="false" data-keep-open="true"
     style="animation-direction: normal !important; position: absolute;">
    <div class="section" id="notification-header">
        <p class="title"><?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_widget_header']); ?></p>
        <div class="flex-separator"></div>
        <div class="unread-counter">
            <?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_unread']); ?> (<span class="d-inline-block" id="notification-number"></span>)
        </div>
        <a id="markAllAsRead-btn" href="javascript:void(0)" aria-label="<?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_widget_mark_all_seen']); ?>" title="<?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_widget_mark_all_seen']); ?>">
            <i class="fa-regular fa-envelope-open"></i>
        </a>
    </div>
    <div class="section p-0" id="notification-content"><?php
        if ($ret) {
            $n_count = 1;
            $n_lim = intval($menu_data['notif_limit']);
            if (!($n_lim >= 1)) {
                $n_lim = 10;
            }
            while (!$ret->EOF && $n_count <= intval($n_lim)) {
                echo buildNotif($ret->fetchRow(), $this);
                $n_count++;
            }
        }
    ?></div>
    <div class="section" id="notification-empty">
        <i class="lni lni-cross-circle"></i>
        <?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_empty']); ?>
    </div>
    <div class="section" id="notification-error">
        <i class="fa-solid fa-link-slash"></i>
        <?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_empty_error']); ?>

    </div>
    <div class="section" id="notification-footer">
        <?php if (isset($menu_data['notif_open_all_app']) && !empty($menu_data['notif_open_all_app'])) { ?>
        <a class="d-inline-block" id="notification-viewAll" href="<?php echo $menu_data['notif_open_all_app']; ?>" tab-name="notif_see_all" title="" tab-title="<?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_widget_header']); ?>" target="nm_frame_app">
            <i class="mb_icon lni lni-alarm" aria-hidden="true">
            </i>
            <?php echo sanitizeSpecChars($this->Nm_lang['lang_notifications_widget_see_all']); ?>
        </a>
        <?php } ?>
    </div>
</div>