# Add table "notif_inbox"                                                   #

CREATE TABLE notiftable_inbox (
    inbox_id AUTOINCREMENT,
    notif_id INTEGER NOT NULL,
    login VARCHAR(255) NOT NULL,
    notif_dtsent datetime NULL,
    notif_ontop INTEGER NULL,
    notif_isread INTEGER NULL,
    notif_dtread datetime NULL,
    notif_tags VARCHAR(255) NULL,
    notif_important INTEGER NULL,
    PRIMARY KEY (inbox_id)
);

# Add table "notif_pref"                                                   #

CREATE TABLE notiftable_pref (
    login VARCHAR(255) NOT NULL,
    receive_email INTEGER NULL ,
    receive_sms INTEGER NULL,
    PRIMARY KEY (login)
);

# Add table "notif_tags"                                                   #

CREATE TABLE notiftable_tags (
    tag_id AUTOINCREMENT,
    tag_title VARCHAR(50) NOT NULL,
    login VARCHAR(255) NOT NULL,
    tag_color VARCHAR(100) NULL,
    tag_active INTEGER NOT NULL,
    PRIMARY KEY (tag_id)
);

# Add table "notif_notifications"                                                   #

CREATE TABLE notiftable_notifications (
   notif_id AUTOINCREMENT,
   notif_title VARCHAR(255) NOT NULL,
   notif_message text NOT NULL,
   notif_dtcreated datetime NOT NULL,
   notif_ontop INTEGER NULL ,
   notif_dtexpire datetime NULL,
   notif_categ VARCHAR(60) NULL,
   notif_login_sender VARCHAR(255) NOT NULL,
   notif_type VARCHAR(60) NULL,
   notif_link VARCHAR(255) NULL,
   deleted_at datetime NULL,
   PRIMARY KEY (notif_id)
);

# Add table "notif_profiles"                                                   #

CREATE TABLE `notiftable_profiles` (
    profile_id AUTOINCREMENT,
    profile_name VARCHAR(255) NOT NULL,
    profile_users text NULL,
    profile_groups text NULL,
    profile_public INTEGER NULL,
    profile_owner VARCHAR(255) NULL,
    PRIMARY KEY (profile_id)
);

# Add table "notif_user_tags"                                                  #

CREATE TABLE notiftable_user_tags (
    user_tags_id AUTOINCREMENT,
    login VARCHAR(255) NOT NULL,
    login_sender VARCHAR(255) NOT NULL,
    tags VARCHAR(255) NULL,
    PRIMARY KEY (user_tags_id)
)