# Add table "notif_inbox"                                                   #

CREATE TABLE notiftable_inbox (
  inbox_id INTEGER NOT NULL AUTO_INCREMENT,
  notif_id INTEGER NOT NULL,
  login VARCHAR(255) NOT NULL,
  notif_dtsent DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  notif_ontop INTEGER NOT NULL DEFAULT '0',
  notif_isread INTEGER NOT NULL DEFAULT '0',
  notif_dtread DATETIME DEFAULT NULL,
  notif_tags VARCHAR(255) DEFAULT NULL,
  notif_important INTEGER DEFAULT NULL,
  PRIMARY KEY (inbox_id)
);

# Add table "notif_pref"                                                 #

CREATE TABLE notiftable_pref (
    login VARCHAR(255) NOT NULL,
    receive_email INTEGER NOT NULL DEFAULT '0',
    receive_sms INTEGER NOT NULL DEFAULT '0',
  PRIMARY KEY (login)
);

# Add table "notif_tags"                                            #

CREATE TABLE notiftable_tags (
  tag_id INTEGER NOT NULL AUTO_INCREMENT,
  tag_title VARCHAR(50) NOT NULL,
  login VARCHAR(255) NOT NULL,
  tag_color VARCHAR(100) DEFAULT NULL,
  tag_active INTEGER NOT NULL DEFAULT '1',
  PRIMARY KEY (tag_id)
)

# Add table "notif_notifications"                                                  #

CREATE TABLE notiftable_notifications (
  notif_id INTEGER NOT NULL AUTO_INCREMENT,
  notif_title VARCHAR(255) NOT NULL,
  notif_message text NOT NULL,
  notif_dtcreated DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  notif_ontop INTEGER NOT NULL DEFAULT '0',
  notif_dtexpire DATETIME DEFAULT NULL,
  notif_categ VARCHAR(60) DEFAULT NULL,
  notif_login_sender VARCHAR(255) NOT NULL,
  notif_type VARCHAR(60) DEFAULT NULL,
  notif_link VARCHAR(255) DEFAULT NULL,
  deleted_at DATETIME DEFAULT NULL,
  PRIMARY KEY (notif_id)
)

# Add table "notif_profiles"                                                  #

CREATE TABLE notiftable_profiles (
    profile_id INTEGER NOT NULL AUTO_INCREMENT,
    profile_name VARCHAR(255) NOT NULL,
    profile_users text NULL,
    profile_groups text NULL,
    profile_public INTEGER NOT NULL DEFAULT '0',
    profile_owner VARCHAR(255) NULL,
    PRIMARY KEY (profile_id)
)

# Add table "notif_user_tags"                                                  #

CREATE TABLE notiftable_user_tags (
    user_tags_id INTEGER NOT NULL AUTO_INCREMENT,
    login VARCHAR(255) NOT NULL,
    login_sender VARCHAR(255) NOT NULL,
    tags VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (user_tags_id)
)

