# Add table "notif_inbox"                                                   #

CREATE TABLE `notiftable_inbox` (
  `inbox_id` int NOT NULL AUTO_INCREMENT,
  `notif_id` int NOT NULL,
  `login` varchar(255) NOT NULL,
  `notif_dtsent` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `notif_ontop` int NOT NULL DEFAULT '0',
  `notif_isread` int NOT NULL DEFAULT '0',
  `notif_dtread` datetime DEFAULT NULL,
  `notif_tags` varchar(255) DEFAULT NULL,
  `notif_important` int DEFAULT NULL,
  PRIMARY KEY (`inbox_id`)
)

# Add table "notif_pref"                                                   #

CREATE TABLE `notiftable_pref` (
  `login` varchar(255) NOT NULL,
  `receive_email` int NOT NULL DEFAULT '0',
  `receive_sms` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`)
)

# Add table "notif_tags"                                                   #

CREATE TABLE `notiftable_tags` (
  `tag_id` int NOT NULL AUTO_INCREMENT,
  `tag_title` varchar(50) NOT NULL,
  `login` varchar(255) NOT NULL,
  `tag_color` varchar(100) DEFAULT NULL,
  `tag_active` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`tag_id`)
)

# Add table "notif_notifications"                                                   #

CREATE TABLE `notiftable_notifications` (
  `notif_id` int NOT NULL AUTO_INCREMENT,
  `notif_title` varchar(255) NOT NULL,
  `notif_message` text NOT NULL,
  `notif_dtcreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `notif_ontop` int NOT NULL DEFAULT '0',
  `notif_dtexpire` datetime DEFAULT NULL,
  `notif_categ` varchar(60) DEFAULT NULL,
  `notif_login_sender` varchar(255) NOT NULL,
  `notif_type` varchar(60) DEFAULT NULL,
  `notif_link` varchar(255) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`notif_id`)
)

# Add table "notif_profiles"                                                   #

CREATE TABLE `notiftable_profiles` (
    `profile_id` int NOT NULL AUTO_INCREMENT,
    `profile_name` varchar(255) NULL,
    `profile_users` text NULL,
    `profile_groups` text NULL,
    `profile_public` int NOT NULL DEFAULT '0',
    `profile_owner`  varchar(255) NULL,
    PRIMARY KEY (`profile_id`)
)

# Add table "notif_user_tags"                                                  #

CREATE TABLE `notiftable_user_tags` (
    `user_tags_id` int NOT NULL AUTO_INCREMENT,
    `login` varchar(255) NOT NULL,
    `login_sender` varchar(255) NOT NULL,
    `tags` varchar(255) DEFAULT NULL,
    PRIMARY KEY (`user_tags_id`)
)