/* Add table "notif_inbox"                                                   */

CREATE TABLE notiftable_inbox (
   inbox_id INTEGER IDENTITY NOT NULL,
   notif_id INTEGER NOT NULL,
   login varchar(255) NOT NULL,
   notif_dtsent DATETIME DEFAULT GETDATE(),
   notif_ontop INTEGER NOT NULL,
   notif_isread INTEGER NOT NULL,
   notif_dtread DATETIME  NULL,
   notif_tags varchar(255)  NULL,
   notif_important INTEGER NULL,
   PRIMARY KEY (inbox_id)
)

/* Add table "notif_pref"                                                   */

CREATE TABLE notiftable_pref (
  login varchar(255) NOT NULL,
  receive_email INTEGER NOT NULL ,
  receive_sms INTEGER NOT NULL,
  PRIMARY KEY (login)
)

/* Add table "notif_tags"                                                   */

CREATE TABLE notiftable_tags (
  tag_id INTEGER IDENTITY NOT NULL,
  tag_title varchar(50) NOT NULL,
  login varchar(255) NOT NULL,
  tag_color varchar(100)  NULL,
  tag_active INTEGER NOT NULL,
  PRIMARY KEY (tag_id)
)

/* Add table "notif_notifications"                                                   */

CREATE TABLE notiftable_notifications (
    notif_id INTEGER IDENTITY NOT NULL,
    notif_title varchar(255) NOT NULL,
    notif_message text NOT NULL,
    notif_dtcreated DATETIME DEFAULT GETDATE(),
    notif_ontop INTEGER NOT NULL,
    notif_dtexpire DATETIME  NULL,
    notif_categ varchar(60) NULL,
    notif_login_sender varchar(255) NOT NULL,
    notif_type varchar(60) NULL,
    notif_link varchar(255) NULL,
    deleted_at DATETIME  NULL,
    PRIMARY KEY (notif_id)
)

/* Add table "notif_profiles"                                                   */

CREATE TABLE notiftable_profiles (
    profile_id INTEGER IDENTITY NOT NULL,
    profile_name varchar(255) NOT NULL,
    profile_users text NULL,
    profile_groups text NULL,
    profile_public INTEGER NOT NULL,
    profile_owner varchar(255) NULL,
    PRIMARY KEY (profile_id)
)

/* Add table "notif_user_tags"                                                   */

CREATE TABLE notiftable_user_tags (
    user_tags_id INTEGER IDENTITY NOT NULL,
    login varchar(255) NOT NULL,
    login_sender varchar(255) NOT NULL,
    tags varchar(255)  NULL,
    PRIMARY KEY (user_tags_id)
)


