// import { SC_ColorPicker } from "./components/colorpicker.class.js";
// import { colorSwatch } from "./menuthemeeditor.js";
// import { validateEditBtn } from "./menuthemeeditor.js";
// import { openThemeModal } from "./menuthemeeditor.js";
// import { selectThemeTableRow } from "./menuthemeeditor.js";





function render(ctx) {
    const page_langs_arr = getLangs();
    if (ctx.nodeType === 1) {
        ctx.innerHTML = `
            <div class="ui basic segment">
                <div data-ui="show" class="ui action left icon input">
                    <i class="icon" data-feedback="color"></i>              
                    <input id="${ctx.dataset.id}" name="${ctx.dataset.id}" type="text" placeholder="` + page_langs_arr.select_a_color + `" data-feedback="hex">                
                    <button id="show-colorpicker" class="ui icon button"><i class="icon eye dropper"></i></button>
                </div>
                <div data-ui="colorpicker" class="wrapper ui segments scale-up-top hide">
                    <div class="header ui top attached secondary segment">                  
                        <div class="ui small header">` + page_langs_arr.color_picker + `</div>
                        <i class="small fitted link black icon close" data-ui="hide"></i>
                    </div>              
                    <div class="ui basic segment">
                        <div data-ui="placeholder"></div>
                    </div>
                    <div class="ui basic segment flex justify-center items-center column-gap-2">
                        <div class="ui tiny right labeled left icon input">
                          <i class="icon" data-feedback="color"></i>                                                
                          <input type="text" id="colorHex" data-feedback="hex" value="">
                          <div class="ui basic label" data-ui="interactivenumber" data-feedback="alpha" ></div>
                        </div>                               
                        ${ Semantic.iconButton('eraser', 'basic small action\:clear')}
                    </div>
                    <div data-ui="colorSwatch" class="colorSwatch ui basic segment"></div>
                </div>          
            </div>  
        `
    } else {
        return false;
    }
}

const addClass = (nodeElement, className) => {
    Array.from(nodeElement).forEach( element => {
        Array.isArray(className) ? element.classList.add(...className) : element.classList.add(className);
    });
};

const removeClass = (nodeElement, className) => {
    nodeElement = Array.isArray(nodeElement) ? nodeElement : Array.from(nodeElement);
    nodeElement.forEach( element => {
        Array.isArray(className) ? element.classList.remove(...className) : element.classList.remove(className);
    });
};

const setProperty = (nodeElement, prop) => {
    if (Array.isArray(nodeElement) && Array.isArray(prop)) {
        nodeElement.forEach(el => {
            prop.forEach((item, index) => {
                el.style.setProperty(prop[index].propName, prop[index].propValue);
            });
        })
    } else {
        prop.forEach((item, index) => {
            nodeElement.style.setProperty(prop[index].propName, prop[index].propValue);
        });
    }
};

const removeProperty = (nodeElement, prop) => {
    if (Array.isArray(nodeElement) && Array.isArray(prop)) {
        nodeElement.forEach(el => {
            prop.forEach((item, index) => {
                el.style.removeProperty(prop[index].propName);
            });
        })
    } else {
        prop.forEach((item, index) => {
            nodeElement.style.removeProperty(prop[index].propName);
        });
    }
};

const setAttribute = (nodeElement, attr) => {
    if (Array.isArray(nodeElement) && Array.isArray(attr)) {
        nodeElement.forEach(el => {
            attr.forEach((item, index) => {
                el.setAttribute(attr[index].attrName, attr[index].attrValue);
            });
        })
    } else {
        attr.forEach((item, index) => {
            nodeElement.setAttribute(attr[index].attrName, attr[index].attrValue);
        });
    }
};

const removeAttribute = (nodeElement, attr) => {
    if (Array.isArray(nodeElement) && Array.isArray(attr)) {
        nodeElement.forEach(el => {
            attr.forEach((item, index) => {
                el.removeAttribute(attr[index].attrName);
            });
        })
    } else {
        attr.forEach((item, index) => {
            nodeElement.removeAttribute(attr[index].attrName);
        });
    }
};

const setValue = (element, value) => {
    if (Array.isArray(element)) {
        element.forEach(el => {
            el.value = value;
        });
    } else {
        element.value = value;
    }
};

const setText = (element, value) => {
    if (Array.isArray(element)) {
        element.forEach(el => {
            el.innerText = value;
        });
    } else {
        element.innerText = value;
    }
};

const isPositive = number => {
    switch (Math.sign(number)) {
        case -1:
            return false;
            break;
        case 1:
            return true;
            break;
    }
};

const clearEvent = (elementNode, event, funcName) => {
    elementNode.removeEventListener(event, funcName);
};

const interactiveNumberField = (minThreshold, maxThreshold, multiplier, fieldSelector) => {
    const root = document.querySelector('body');
    let selector = fieldSelector ? fieldSelector : '[data-ui="interactivenumber"]';
    const fields = document.querySelectorAll(selector);
    let fieldValue = null;


    fields.forEach(field => {
        field.style.setProperty('cursor', 'ew-resize');

        const iterateValue = () => {
            if (field.tagName === 'INPUT' && typeof field.value === 'number') {
                isPositive(event.movementX) ? field.value = field.value += multiplier : field.value = field.value -= multiplier;
                fieldValue < minThreshold ? field.value = minThreshold : false;
                fieldValue > maxThreshold ? field.value = maxThreshold : false;
            } else {
                fieldValue = Number(field.innerText);
                isPositive(event.movementX) ? field.innerText = fieldValue += multiplier : field.innerText = fieldValue -= multiplier;
                fieldValue < minThreshold ? field.innerText = minThreshold : false;
                fieldValue > maxThreshold ? field.innerText = maxThreshold : false;
            }
        }

        const mousedown = () => { mousemove() };

        const mousemove = () => {
            root.style.setProperty('cursor', 'ew-resize');
            iterateValue();
            document.querySelector('.IroSliderGradient').value = fieldValue;
        };

        const mouseup = () => {
            root.style.setProperty('cursor', 'auto')
        };

        document.querySelector(selector).addEventListener('mousedown', () => {
            root.addEventListener('mousemove', mousemove);
            root.addEventListener('mouseup', () => {
                clearEvent(root, 'mousemove', mousemove);
                mouseup();
            });
        });
    });
};

const getBoundCliRect = (elementNode) => {
    return elementNode.getBoundingClientRect();
}

const DateTime = {
    timestamp: function () {
        const date = new Date();
        return date.getTime();
    }
};

const UI = {
    show: function (nodeElement, cssDisplayType) {
        let displayType = cssDisplayType ? cssDisplayType : 'block';
        setProperty(nodeElement, [{propName: 'display', propValue: displayType}]);
        setAttribute(nodeElement, [{attrName: 'visible', attrValue: 'visible'}]);
    },

    hide: function (nodeElement) {
        setProperty(nodeElement, [{propName: 'display', propValue: 'none'}]);
        removeAttribute(nodeElement, [{attrName: 'visible'}]);
    }
};

const Semantic = {
    iconButton: function (iconName, cssClasses) {
        return `
            <button class="ui icon button ${cssClasses ? cssClasses : false}">
                <i class="${iconName} icon"></i>
            </button>
        `;
    },
};

// ****************************************************************************
// *                             Saídas de console                            *
// ****************************************************************************
const Output = {
    renderDataIdError: {
        title: '',//page_langs_arr.required_field_error,
        message: 'data-id'
    },
    colorSwatchWarn: {
        title: 'data-colorswatch',
        message: '',//page_langs_arr.color_render_error
    }
};

// ****************************************************************************
// *                             Core                                         *
// ****************************************************************************
/**
 * @description Quando invocado (após render), adiciona comportamentos, funcionalidades e eventos.
 * @param { object } ctx - ELEMENT_NODE que cria o contexto (custom tag)
 */
function core(ctx) {
    const root = document.querySelector('body');
    const timestamp = DateTime.timestamp();
    let colorsByReference = null;
    let colorSwatch = null;
    const uiColorpicker = ctx.querySelector('[data-ui="colorpicker"]');
    const uiColorpickerPlaceholder = ctx.querySelector(`[data-ui="placeholder"]`);
    const uiColorPickerHide = ctx.querySelectorAll('[data-ui="hide"]');
    const uiClearFeedback = ctx.querySelector('.action\\:clear');
    const uiEyeDropper = ctx.querySelector("#show-colorpicker");
    let fieldColor = ctx.querySelectorAll('[data-feedback="color"]');
    fieldColor = Array.from(fieldColor);
    let fieldHex = ctx.querySelectorAll('[data-feedback="hex"]');
    fieldHex = Array.from(fieldHex);
    let fieldAlpha = ctx.querySelector('[data-feedback="alpha"]');

    /**
     * @attr data-width {number} define a largura do Iro Colorpicker
     * @attr data-color {string} define a cor default do Iro Colorpicker
     * @attr data-margin {number} define a margin-top de cada elemento do Iro Colorpicker
     * @attr data-padding {number} define o padding interno de cada elemento do Iro Colorpicker
     * @attr data-layout {string} ["vertical" || "horizontal"] define o layout do Iro Colorpicker
     * @attr data-colorpicker {string} ["box" || "wheel"] define o tipo do colorpicker
     * @attr data-layouttype {string} ["full" || "compact"] define o layout do Iro Colorpicker
     */
    let settings = {
        width: ctx.dataset.width ? parseInt(ctx.dataset.width) : 196,
        color: ctx.dataset.color ? ctx.dataset.color : "#d9d9d9",
        margin: ctx.dataset.margin ? parseInt(ctx.dataset.margin) : 14,
        padding: ctx.dataset.padding ? parseInt(ctx.dataset.padding) : 2,
        layoutDirection: ctx.dataset.layout === "horizontal" ? ctx.dataset.layout : "vertical",
        layoutFull: [{
            component: iro.ui.Slider,
            options: {
                sliderType: 'hue',
            }
        }, {
            component: ctx.dataset.colorpicker === "wheel" ? iro.ui.Wheel : iro.ui.Box ,
        }, {
            component: iro.ui.Slider,
            options: {
                sliderType: 'saturation',
            }
        }, {
            component: iro.ui.Slider,
            options: {
                sliderType: 'value',
            }
        }, {
            component: iro.ui.Slider,
            options: {
                sliderType: 'alpha',
            }
        }, ],
        layoutCompact: [{
            component: iro.ui.Slider,
            options: {
                sliderType: 'hue'
            }
        }, {
            component: ctx.dataset.colorpicker === "wheel" ? iro.ui.Wheel : iro.ui.Box,
        }]
    };

    /*
       Inicializa o colorPicker
       ========================================================================== */
    const colorPicker = new iro.ColorPicker(uiColorpickerPlaceholder, {
        width: settings.width,
        color: settings.color,
        margin: settings.margin,
        padding: settings.padding,
        layoutDirection: settings.layoutDirection,
        layout: ctx.dataset.layouttype === "compact" ? settings.layoutCompact : settings.layoutFull,
    });

    /*
       Controle de display do colorPicker
       ========================================================================== */
    // Abrir o colorPicker
    (() => {
        ctx.querySelector('[data-ui="show"]').addEventListener('click', () => {
            const activeColorpickers = document.querySelectorAll("[data-ui='colorpicker'][visible]");

            // fecha outros colorpickers
            activeColorpickers.forEach(activeColorpicker => {
                if (activeColorpicker.hasAttribute("visible")) {
                    UI.hide(activeColorpicker);
                }
            });


            UI.show(uiColorpicker, 'flex');

            //posicionamento dinâmico
            setTimeout(function() {
                const x1 = getBoundCliRect(uiColorpicker).right,
                    y1 = getBoundCliRect(uiColorpicker).bottom,
                    vw = document.body.clientWidth,
                    vh = document.body.clientHeight;

                if (x1 > vw) {
                    uiColorpicker.style.left = "auto";
                    uiColorpicker.style.right = `${parseInt(x1 - vw)}px`;
                }

                if (y1 > vh) {
                    uiColorpicker.style.top = "auto";
                    uiColorpicker.style.bottom = "0px";
                    // uiColorpicker.style.bottom = `${parseInt(y1 - vh)}px`;
                }
            }, 150);

        })
    })();

    // Fechar o colorPicker
    (() => {
        uiColorPickerHide.forEach(hide => {
            hide.addEventListener('click', (ev) => {
                UI.hide(uiColorpicker);
            });
        });

        window.addEventListener('keydown', (ev) => {
            ev.stopImmediatePropagation();
            event.keyCode === 27 ? UI.hide(uiColorpicker) : false;
        })
    })();

    /*
       Renderização de UI
       ========================================================================== */
    // Renderiza o colorSwatch
    //-> [data-colorswatch]: 21 cores [hex, rgb, rgba]
    if (ctx.dataset.colorswatch) {
        (() => {
            const colorSwatch = ctx.querySelector('[data-ui="colorSwatch"]');
            const colorsByReference = ctx.dataset.colorswatch;
            let arrColors = colorsByReference.split(' ');
            arrColors.length > 21 ?
                console.warn(Output.colorSwatchWarn.title, Output.colorSwatchWarn.message) :
                false;
            arrColors = arrColors.slice(0, 21);

            const row_1 = document.createElement('div');
            const row_2 = document.createElement('div');
            const row_3 = document.createElement('div');

            addClass([row_1, row_2, row_3], 'row');

            const htmlConstructor = (elementNode, length, startIndex) => {
                for (let i = startIndex; i <= length; i++) {
                    if (arrColors[i]) {
                        elementNode.innerHTML += `
                            <div class="color" data-color="${arrColors[i]}" style="background-color: ${arrColors[i]}"></div>
                        `
                    }
                }
            };

            if (arrColors.length === 1) {
                htmlConstructor(row_1, 0, 0)
            }
            if (arrColors.length > 1 && arrColors.length <= 8) {
                htmlConstructor(row_1, 7, 0)
            }
            if (arrColors.length >= 9 && arrColors.length <= 14) {
                htmlConstructor(row_1, 7, 0);
                htmlConstructor(row_2, 14, 8)
            }
            if (arrColors.length >= 15 && arrColors.length <= 21) {
                htmlConstructor(row_1, 7, 0);
                htmlConstructor(row_2, 14, 8);
                htmlConstructor(row_3, 21, 15)
            }

            if (arrColors.length === 1) {
                setProperty(row_1, [{
                    propName: 'grid-template-columns',
                    propValue: 'auto'
                }])
            } else if (arrColors.length > 1 && arrColors.length <= 7) {
                setProperty(row_1, [{
                    propName: 'grid-template-columns',
                    propValue: `repeat(${arrColors.length}, auto)`
                }])
            } else {
                removeProperty(row_1, [{
                    propName: 'grid-template-columns'
                }])
            }

            colorSwatch.appendChild(row_1);

            arrColors.length > 8 ? colorSwatch.appendChild(row_2) : false;
            arrColors.length >= 15 ? colorSwatch.appendChild(row_3) : false;

            colorSwatch.addEventListener('click', () => {
                setColor(event.target)
            })
        })();
    }

    /*
       Controle de dados
       ========================================================================== */
    const setColor = () => {
        event.target.dataset.color ? colorPicker.color.set(event.target.dataset.color.replace('#', '').trim()) : false;
    }

    const getAlpha = () => {
        return colorPicker.color.alpha;
    }

    const convertAlpha = () => {
        return Math.trunc(getAlpha() * 100);
    }

    const feedback = color => {
        fieldColor.forEach( field => {
            field.classList.contains('gradient-checkerboard') ? removeClass([field], 'gradient-checkerboard') : false;
        })
        setProperty(fieldColor, [{
            propName: 'background-color',
            propValue: colorPicker.color.rgbaString
        }]);
        setValue(fieldHex, colorPicker.color.hex8String);
        setText(fieldAlpha, convertAlpha());
    }

    /*
       Comportamentos
       ========================================================================== */
    // Campo com valor interativo
    interactiveNumberField(0, 100, 1);

    const mousemove = () => {
        colorPicker.color.alpha = parseFloat(Number(fieldAlpha.innerText) / 100);
    }

    // Limpar os campos de feedback
    const clearFeedback = () => {

        fieldColor.forEach( field => {
            colorPicker.color.set(settings.color);
            field.style.setProperty("background-color", settings.color);
        })

        fieldHex.forEach( field => {
            field.value = settings.color;
            field.placeholder = settings.color;
        })

        fieldAlpha.value = '100%'
    }

    /*
        Eventos
        ========================================================================== */
    // Atualiza os campos de feedback após init e change do colorPicker
    colorPicker.on(['color:init', 'color:change'], feedback);

    // Atualiza o Slider:alpha do colorPicker
    fieldAlpha.addEventListener('mousedown', () => {
        root.addEventListener('mousemove', mousemove);
        root.addEventListener('mouseup', () => {
            clearEvent(root, 'mousemove', mousemove);
        })
    })

    // Transfere a cor do fieldHex para o colorPicker
    fieldHex.forEach(field => {
        field.addEventListener('change', () => {
            colorPicker.color.set(field.value);
        })
    })

    // Limpa os valores dos campos de feedback
    uiClearFeedback.addEventListener('click', () => {
        event.preventDefault();
        clearFeedback();
    });

    // remove evento padrão do botão Eye Dropper
    uiEyeDropper.addEventListener("click", function(ev) {
        ev.preventDefault();
    })
}
class SC_ColorPicker extends HTMLElement {

    constructor() {
        super();
    }

    /**
     * connectedCallback------------------------------------------------------------
     * @desc Browser chama este método quando o elemento é adicionado ao documento
     * -----------------------------------------------------------------------------
     * */
    connectedCallback() {
        if (!this.rendered && this.dataset.id) {
            render(this);
            this.rendered = true;
            core(this);
        } else if (!this.dataset.id) {
            console.error(output.renderDataIdError.title, output.renderDataIdError.message);
        }
    }

    /**
     * observedAttributes-----------------------------------------------------------
     * @desc Monitoras os atributos passados no array [attributeChangedCallback]
     * -----------------------------------------------------------------------------
     * */
    static get observedAttributes() {
        return []
    }

    // Browser chama este método quando algum dos atributos observados tem seu valor alterado
    attributeChangedCallback(name, oldValue, newValue) {
        render(this);
    }
}

// Registra o componente para que o Browser o reconheça como uma tag HTML válida
customElements.define('sc-colorpicker', SC_ColorPicker);


























function colorSwatch() {
    const colorsElements = document.querySelectorAll("[data-colors]");

    colorsElements.forEach(colorElement => {
        if (colorElement.dataset.colors) {
            let colors = colorElement.dataset.colors;
            colors = colors.split("__##NM##__");

            for (let i = 0; i < colors.length; i++) {
                createCircle(colorElement, colors[i], i);
            }

        }
    });
}

function validateEditBtn() {
    const editBtn = document.getElementById("edit-theme-btn");
    const editRadios = document.querySelectorAll("[name='theme-radio']");
    const previewBtn = document.getElementById("preview-theme-btn");
    const removeRadioSelectionBtn = document.getElementById("remove-radio-selection");

    removeRadioSelectionBtn.addEventListener("click", function(ev) {
        ev.preventDefault();

        for (let i=0; i < editRadios.length; i++) {
            if (editRadios[i].checked) {
                editRadios[i].checked = false;
                // editBtn.classList.add("disabled");
                // previewBtn.classList.add("disabled");
            }
        }
        updateButtons();
    });
}

function openThemeModal() {
    const themeBtns = document.querySelectorAll(".theme-action-btn");
    const modalHeader = document.querySelector("#modal-theme > .header");
    const page_langs_arr = getLangs();

    themeBtns.forEach(themeBtn => {
        themeBtn.addEventListener("click", function(ev) {
            ev.preventDefault();

            if (ev.currentTarget.getAttribute("id") === "new-theme-btn") {
                fillFieldsCreate();
                modalHeader.innerHTML = "<i class='theme icon'></i>" + page_langs_arr.create_new_theme;
            }
            else if (ev.currentTarget.getAttribute("id") === "edit-theme-btn") {
                fillFieldsEdit();
                modalHeader.innerHTML = "<i class='edit icon'></i>" + page_langs_arr.edit_theme;
            }
            else if (ev.currentTarget.getAttribute("id") === "copy-theme-btn") {
                fillFieldsCopy();
                modalHeader.innerHTML = "<i class='theme icon'></i>" + page_langs_arr.create_new_theme;
            }
            $(ev.currentTarget).blur();
            $("#modal-theme").modal({
                blurring: true,
                closable: false
            });
            $("#modal-theme").modal("show");
        });
    });

}

function selectThemeTableRow() {
    const themeTableRows = document.querySelectorAll("#theme-table > tbody > tr");
    const editBtn = document.getElementById("edit-theme-btn");
    const previewBtn = document.getElementById("preview-theme-btn");

    themeTableRows.forEach(themeTableRow => {
        themeTableRow.addEventListener("click", function(ev) {
            ev.preventDefault();
            const radio = ev.currentTarget.querySelector('.theme-radio-sel');

            if (radio) {
                radio.checked = true;
                // editBtn.classList.remove("disabled");
                // previewBtn.classList.remove("disabled");
            }
            updateButtons();
        });
    });
}

/**
 *
 * @param {DOM element} target elemento no qual o círculo será adicionado
 * @param {string} bgColor cor que será aplicada ao background-color do círculo
 * @param {number} index index do elemento atual
 */
function createCircle(target, bgColor, index) {

    const page_langs_arr = getLangs();
    const circle = document.createElement("span");

    circle.setAttribute('style',  "" +
        "position: relative;" +
        "width: 1.5rem;" +
        "height: 1.5rem;" +
        "margin-right: .5rem;" +
        "border-radius: 50%;" +
        "background: " + bgColor + ";" +
        "box-shadow: 0 2px 4px rgba(0,0,0,.25);" +
        "display: inline-block;"
    );

    circle.classList.add("popup");

    circle.setAttribute("data-content", bgColor.toUpperCase());

    switch (index) {
        case 0:
            circle.setAttribute("data-title", page_langs_arr.theme_primary_color);
            break;
        case 1:
            circle.setAttribute("data-title", page_langs_arr.theme_secondary_color);
            break;
        case 2:
            circle.setAttribute("data-title", page_langs_arr.theme_accent_color);
            break;
        case 3:
            circle.setAttribute("data-title", page_langs_arr.theme_muted_color);
            break;
        case 4:
            circle.setAttribute("data-title", page_langs_arr.theme_text_color);
            break;
        case 5:
            circle.setAttribute("data-title", page_langs_arr.theme_notification_color);
            break;
        case 6:
            circle.setAttribute("data-title", page_langs_arr.theme_box_shadow);
            break;
    }

    target.appendChild(circle);
}
document.addEventListener("DOMContentLoaded", function (ev) {
    // inicializa radio do Semantic UI
    $('.ui.radio.checkbox').checkbox();

    // inicializa seleção de radios por clique em linha da tabela de temas
    selectThemeTableRow();

    // validação do botão editar tema
    validateEditBtn();

    // inicializa tablesort do Semantic UI
    $("table").tablesort();

    // pega cores do data-colors e gera um colorSwatch
    colorSwatch();

    // inicializa popup do Semantic UI
    if ($(".popup")) {        
       $(".popup").popup();  
    }    

    // inicializa modais de novo tema e edição de tema
    openThemeModal();
})

