/*
 * # Fomantic UI - 2.9.0
 * https://github.com/fomantic/Fomantic-UI
 * http://fomantic-ui.com/
 *
 * Copyright 2023 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(N,V,W,z){"use strict";N.isFunction=N.isFunction||function(t){return"function"==typeof t&&"number"!=typeof t.nodeType},V=void 0!==V&&V.Math==Math?V:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),N.fn.popup=function(x){var E,t=N(this),k=N(W),S=N(V),O=N("body"),A=t.selector||"",F="ontouchstart"in W.documentElement?"touchstart":"click",D=(new Date).getTime(),j=[],R=x,M="string"==typeof R,H=[].slice.call(arguments,1);return t.each(function(){var p,s,t,e,o,u=N.isPlainObject(x)?N.extend(!0,{},N.fn.popup.settings,x):N.extend({},N.fn.popup.settings),n=u.selector,c=u.className,d=u.error,f=u.metadata,i=u.namespace,r="."+u.namespace,a="module-"+i,h=N(this),l=[V,W].indexOf(u.context)<0?k.find(u.context):N(u.context),g=[V,W].indexOf(u.scrollContext)<0?k.find(u.scrollContext):N(u.scrollContext),m=[V,W].indexOf(u.boundary)<0?k.find(u.boundary):N(u.boundary),v=u.target?[V,W].indexOf(u.target)<0?k.find(u.target):N(u.target):h,b=0,w=!1,y=!1,P=this,C=h.data(a),T={initialize:function(){T.debug("Initializing",h),T.createID(),T.bind.events(),!T.exists()&&u.preserve&&T.create(),u.observeChanges&&T.observeChanges(),T.instantiate()},instantiate:function(){T.verbose("Storing instance",T),C=T,h.data(a,C)},observeChanges:function(){"MutationObserver"in V&&((t=new MutationObserver(T.event.documentChanged)).observe(W,{childList:!0,subtree:!0}),T.debug("Setting up mutation observer",t))},refresh:function(){u.popup?p=k.find(u.popup).eq(0):u.inline&&(p=v.nextAll(n.popup).eq(0),u.popup=p),u.popup?(p.addClass(c.loading),s=T.get.offsetParent(),p.removeClass(c.loading),u.movePopup&&T.has.popup()&&T.get.offsetParent(p)[0]!==s[0]&&(T.debug("Moving popup to the same offset parent as target"),p.detach().appendTo(s))):s=u.inline?T.get.offsetParent(v):T.has.popup()?T.get.offsetParent(p):O,s.is("html")&&s[0]!==O[0]&&(T.debug("Setting page as offset parent"),s=O),T.get.variation()&&T.set.variation()},reposition:function(){T.refresh(),T.set.position()},destroy:function(){T.debug("Destroying previous module"),t&&t.disconnect(),p&&!u.preserve&&T.removePopup(),clearTimeout(T.hideTimer),clearTimeout(T.showTimer),T.unbind.close(),T.unbind.events(),h.removeData(a)},event:{start:function(t){var e=N.isPlainObject(u.delay)?u.delay.show:u.delay;clearTimeout(T.hideTimer),y&&!u.addTouchEvents||(T.showTimer=setTimeout(T.show,e))},end:function(){var t=N.isPlainObject(u.delay)?u.delay.hide:u.delay;clearTimeout(T.showTimer),T.hideTimer=setTimeout(T.hide,t)},touchstart:function(t){y=!0,u.addTouchEvents&&T.show()},resize:function(){T.is.visible()&&T.set.position()},documentChanged:function(t){[].forEach.call(t,function(t){t.removedNodes&&[].forEach.call(t.removedNodes,function(t){(t==P||0<N(t).find(P).length)&&(T.debug("Element removed from DOM, tearing down events"),T.destroy())})})},hideGracefully:function(t){var e=N(t.target),o=N.contains(W.documentElement,t.target),e=0<e.closest(n.popup).length;t&&!e&&o?(T.debug("Click occurred outside popup hiding popup"),T.hide()):T.debug("Click was inside popup, keeping popup open")}},create:function(){var t=T.get.html(),e=T.get.title(),o=T.get.content();t||o||e?(T.debug("Creating pop-up html"),t=t||u.templates.popup({title:e,content:o}),p=N("<div/>").addClass(c.popup).data(f.activator,h).html(t),u.inline?(T.verbose("Inserting popup element inline",p),p.insertAfter(h)):(T.verbose("Appending popup element to body",p),p.appendTo(l)),T.refresh(),T.set.variation(),u.hoverable&&T.bind.popup(),u.onCreate.call(p,P)):u.popup?(k.find(u.popup).data(f.activator,h),T.verbose("Used popup specified in settings"),T.refresh(),u.hoverable&&T.bind.popup()):0!==v.next(n.popup).length?(T.verbose("Pre-existing popup found"),u.inline=!0,u.popup=v.next(n.popup).data(f.activator,h),T.refresh(),u.hoverable&&T.bind.popup()):T.debug("No content specified skipping display",P)},createID:function(){o=(Math.random().toString(16)+"000000000").slice(2,10),e="."+o,T.verbose("Creating unique id for element",o)},toggle:function(){T.debug("Toggling pop-up"),T.is.hidden()?(T.debug("Popup is hidden, showing pop-up"),T.unbind.close(),T.show()):(T.debug("Popup is visible, hiding pop-up"),T.hide())},show:function(t){t=t||function(){},T.debug("Showing pop-up",u.transition),!T.is.hidden()||T.is.active()&&T.is.dropdown()||(T.exists()||T.create(),!1===u.onShow.call(p,P)?T.debug("onShow callback returned false, cancelling popup animation"):(u.preserve||u.popup||T.refresh(),p&&T.set.position()&&(T.save.conditions(),u.exclusive&&T.hideAll(),T.animate.show(t))))},hide:function(t){t=t||function(){},(T.is.visible()||T.is.animating())&&(!1===u.onHide.call(p,P)?T.debug("onHide callback returned false, cancelling popup animation"):(T.remove.visible(),T.unbind.close(),T.restore.conditions(),T.animate.hide(t)))},hideAll:function(){k.find(n.popup).filter("."+c.popupVisible).each(function(){N(this).data(f.activator).popup("hide")})},exists:function(){return!!p&&(u.inline||u.popup?T.has.popup():1<=p.closest(l).length)},removePopup:function(){T.has.popup()&&!u.popup&&(T.debug("Removing popup",p),p.remove(),p=z,u.onRemove.call(p,P))},save:{conditions:function(){T.cache={title:h.attr("title")},T.cache.title&&h.removeAttr("title"),T.verbose("Saving original attributes",T.cache.title)}},restore:{conditions:function(){return T.cache&&T.cache.title&&(h.attr("title",T.cache.title),T.verbose("Restoring original attributes",T.cache.title)),!0}},supports:{svg:function(){return"undefined"!=typeof SVGGraphicsElement}},animate:{show:function(t){t=N.isFunction(t)?t:function(){},u.transition&&N.fn.transition!==z&&h.transition("is supported")?(T.set.visible(),p.transition({animation:(u.transition.showMethod||u.transition)+" in",queue:!1,debug:u.debug,verbose:u.verbose,silent:u.silent,duration:u.transition.showDuration||u.duration,onComplete:function(){T.bind.close(),t.call(p,P),u.onVisible.call(p,P)}})):T.error(d.noTransition)},hide:function(t){t=N.isFunction(t)?t:function(){},T.debug("Hiding pop-up"),u.transition&&N.fn.transition!==z&&h.transition("is supported")?p.transition({animation:(u.transition.hideMethod||u.transition)+" out",queue:!1,duration:u.transition.hideDuration||u.duration,debug:u.debug,verbose:u.verbose,silent:u.silent,onComplete:function(){T.reset(),t.call(p,P),u.onHidden.call(p,P)}}):T.error(d.noTransition)}},change:{content:function(t){p.html(t)}},get:{html:function(){return h.removeData(f.html),h.data(f.html)||u.html},title:function(){return h.removeData(f.title),h.data(f.title)||u.title},content:function(){return h.removeData(f.content),h.data(f.content)||u.content||h.attr("title")},variation:function(){return h.removeData(f.variation),h.data(f.variation)||u.variation},popup:function(){return p},popupOffset:function(){return p.offset()},calculations:function(){var t=T.get.offsetParent(p),e=v[0],o=m[0]==V,n=v.offset(),i=u.inline||u.popup&&u.movePopup?v.offsetParent().offset():{top:0,left:0},r=o?{top:0,left:0}:m.offset(),a={},o=o?{top:S.scrollTop(),left:S.scrollLeft()}:{top:0,left:0},a={target:{element:v[0],width:v.outerWidth(),height:v.outerHeight(),top:n.top-i.top,left:n.left-i.left,margin:{}},popup:{width:p.outerWidth(),height:p.outerHeight()},parent:{width:s.outerWidth(),height:s.outerHeight()},screen:{top:r.top,left:r.left,scroll:{top:o.top,left:o.left},width:m.width(),height:m.height()}};return t[0]!==s[0]&&(n=t.offset(),a.target.top-=n.top,a.target.left-=n.left,a.parent.width=t.outerWidth(),a.parent.height=t.outerHeight()),u.setFluidWidth&&T.is.fluid()&&(a.container={width:p.parent().outerWidth()},a.popup.width=a.container.width),a.target.margin.top=u.inline?parseInt(V.getComputedStyle(e).getPropertyValue("margin-top"),10):0,a.target.margin.left=u.inline?T.is.rtl()?parseInt(V.getComputedStyle(e).getPropertyValue("margin-right"),10):parseInt(V.getComputedStyle(e).getPropertyValue("margin-left"),10):0,a.boundary={top:(i=a.screen).top+i.scroll.top,bottom:i.top+i.scroll.top+i.height,left:i.left+i.scroll.left,right:i.left+i.scroll.left+i.width},a},id:function(){return o},startEvent:function(){return"hover"==u.on?"mouseenter":"focus"==u.on&&"focus"},scrollEvent:function(){return"scroll"},endEvent:function(){return"hover"==u.on?"mouseleave":"focus"==u.on&&"blur"},distanceFromBoundary:function(t,e){var o={},n=(e=e||T.get.calculations()).popup,e=e.boundary;return t&&(o={top:t.top-e.top,left:t.left-e.left,right:e.right-(t.left+n.width),bottom:e.bottom-(t.top+n.height)},T.verbose("Distance from boundaries determined",t,o)),o},offsetParent:function(t){var e=(t!==z?t:v)[0].parentNode,o=N(e);if(e)for(var n="none"===o.css("transform"),i="static"===o.css("position"),r=o.is("body");e&&!r&&i&&n;)e=e.parentNode,n="none"===(o=N(e)).css("transform"),i="static"===o.css("position"),r=o.is("body");return o&&0<o.length?o:N()},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(t){var e=t.split(" "),o=e[0],e=e[1],n="top"==o||"bottom"==o,i=!1,r=!1,a=!1;return w||(T.verbose("All available positions available"),w=T.get.positions()),T.debug("Recording last position tried",t),w[t]=!0,"opposite"===u.prefer&&(a=(a=[{top:"bottom",bottom:"top",left:"right",right:"left"}[o],e]).join(" "),i=!0===w[a],T.debug("Trying opposite strategy",a)),"adjacent"===u.prefer&&n&&(a=(a=[o,{left:"center",center:"right",right:"left"}[e]]).join(" "),r=!0===w[a],T.debug("Trying adjacent strategy",a)),(r||i)&&(T.debug("Using backup position",a),a={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"}[t]),a}},set:{position:function(t,e){if(0!==v.length&&0!==p.length){var o,n,i,r,a,s,l;if(e=e||T.get.calculations(),t=t||h.data(f.position)||u.position,o=h.data(f.offset)||u.offset,n=u.distanceAway,i=e.target,r=e.popup,a=e.parent,T.should.centerArrow(e)&&(T.verbose("Adjusting offset to center arrow on small target element"),"top left"!=t&&"bottom left"!=t||(o=(o+=i.width/2)-u.arrowPixelsFromEdge),"top right"!=t&&"bottom right"!=t||(o=(o-=i.width/2)+u.arrowPixelsFromEdge)),0===i.width&&0===i.height&&!T.is.svg(i.element))return T.debug("Popup target is hidden, no action taken"),!1;switch(u.inline&&(T.debug("Adding margin to calculation",i.margin),"left center"==t||"right center"==t?(o+=i.margin.top,n+=-i.margin.left):"top left"==t||"top center"==t||"top right"==t?(o+=i.margin.left,n-=i.margin.top):(o+=i.margin.left,n+=i.margin.top)),T.debug("Determining popup position from calculations",t,e),T.is.rtl()&&(t=t.replace(/left|right/g,function(t){return"left"==t?"right":"left"}),T.debug("RTL: Popup position updated",t)),t=b==u.maxSearchDepth&&"string"==typeof u.lastResort?u.lastResort:t){case"top left":s={top:"auto",bottom:a.height-i.top+n,left:i.left+o,right:"auto"};break;case"top center":s={bottom:a.height-i.top+n,left:i.left+i.width/2-r.width/2+o,top:"auto",right:"auto"};break;case"top right":s={bottom:a.height-i.top+n,right:a.width-i.left-i.width-o,top:"auto",left:"auto"};break;case"left center":s={top:i.top+i.height/2-r.height/2+o,right:a.width-i.left+n,left:"auto",bottom:"auto"};break;case"right center":s={top:i.top+i.height/2-r.height/2+o,left:i.left+i.width+n,bottom:"auto",right:"auto"};break;case"bottom left":s={top:i.top+i.height+n,left:i.left+o,bottom:"auto",right:"auto"};break;case"bottom center":s={top:i.top+i.height+n,left:i.left+i.width/2-r.width/2+o,bottom:"auto",right:"auto"};break;case"bottom right":s={top:i.top+i.height+n,right:a.width-i.left-i.width-o,left:"auto",bottom:"auto"}}if(s===z&&T.error(d.invalidPosition,t),T.debug("Calculated popup positioning values",s),p.css(s).removeClass(c.position).addClass(t).addClass(c.loading),l=T.get.popupOffset(),l=T.get.distanceFromBoundary(l,e),!u.forcePosition&&T.is.offstage(l,t)){if(T.debug("Position is outside viewport",t),b<u.maxSearchDepth)return b++,t=T.get.nextPosition(t),T.debug("Trying new position",t),!!p&&T.set.position(t,e);if(!u.lastResort)return T.debug("Popup could not find a position to display",p),T.error(d.cannotPlace,P),T.remove.attempts(),T.remove.loading(),T.reset(),u.onUnplaceable.call(p,P),!1;T.debug("No position found, showing with last position")}return T.debug("Position is on stage",t),T.remove.attempts(),T.remove.loading(),u.setFluidWidth&&T.is.fluid()&&T.set.fluidWidth(e),!0}T.error(d.notFound)},fluidWidth:function(t){t=t||T.get.calculations(),T.debug("Automatically setting element width to parent width",t.parent.width),p.css("width",t.container.width)},variation:function(t){(t=t||T.get.variation())&&T.has.popup()&&(T.verbose("Adding variation to popup",t),p.addClass(t))},visible:function(){h.addClass(c.visible)}},remove:{loading:function(){p.removeClass(c.loading)},variation:function(t){(t=t||T.get.variation())&&(T.verbose("Removing variation",t),p.removeClass(t))},visible:function(){h.removeClass(c.visible)},attempts:function(){T.verbose("Resetting all searched positions"),b=0,w=!1}},bind:{events:function(){T.debug("Binding popup events to module"),"click"==u.on&&h.on(F+r,T.toggle),"hover"==u.on&&h.on("touchstart"+r,T.event.touchstart),T.get.startEvent()&&h.on(T.get.startEvent()+r,T.event.start).on(T.get.endEvent()+r,T.event.end),u.target&&T.debug("Target set to element",v),S.on("resize"+e,T.event.resize)},popup:function(){T.verbose("Allowing hover events on popup to prevent closing"),p&&T.has.popup()&&p.on("mouseenter"+r,T.event.start).on("mouseleave"+r,T.event.end)},close:function(){(!0===u.hideOnScroll||"auto"==u.hideOnScroll&&"click"!=u.on)&&T.bind.closeOnScroll(),T.is.closable()?T.bind.clickaway():"hover"==u.on&&y&&T.bind.touchClose()},closeOnScroll:function(){T.verbose("Binding scroll close event to document"),g.one(T.get.scrollEvent()+e,T.event.hideGracefully)},touchClose:function(){T.verbose("Binding popup touchclose event to document"),k.on("touchstart"+e,function(t){T.verbose("Touched away from popup"),T.event.hideGracefully.call(P,t)})},clickaway:function(){T.verbose("Binding popup close event to document"),k.on(F+e,function(t){T.verbose("Clicked away from popup"),T.event.hideGracefully.call(P,t)})}},unbind:{events:function(){S.off(e),h.off(r)},close:function(){k.off(e),g.off(e)}},has:{popup:function(){return p&&0<p.length}},should:{centerArrow:function(t){return!T.is.basic()&&t.target.width<=2*u.arrowPixelsFromEdge}},is:{closable:function(){return"auto"==u.closable?"hover"!=u.on:u.closable},offstage:function(t,o){var n=[];return N.each(t,function(t,e){e<-u.jitter&&(T.debug("Position exceeds allowable distance from edge",t,e,o),n.push(t))}),0<n.length},svg:function(t){return T.supports.svg()&&t instanceof SVGGraphicsElement},basic:function(){return h.hasClass(c.basic)},active:function(){return h.hasClass(c.active)},animating:function(){return p!==z&&p.hasClass(c.animating)},fluid:function(){return p!==z&&p.hasClass(c.fluid)},visible:function(){return p!==z&&p.hasClass(c.popupVisible)},dropdown:function(){return h.hasClass(c.dropdown)},hidden:function(){return!T.is.visible()},rtl:function(){return"rtl"===h.attr("dir")||"rtl"===h.css("direction")||"rtl"===O.attr("dir")||"rtl"===O.css("direction")||"rtl"===l.attr("dir")||"rtl"===l.css("direction")}},reset:function(){T.remove.visible(),u.preserve?N.fn.transition!==z&&p.transition("remove transition"):T.removePopup()},setting:function(t,e){if(N.isPlainObject(t))N.extend(!0,u,t);else{if(e===z)return u[t];u[t]=e}},internal:function(t,e){if(N.isPlainObject(t))N.extend(!0,T,t);else{if(e===z)return T[t];T[t]=e}},debug:function(){!u.silent&&u.debug&&(u.performance?T.performance.log(arguments):(T.debug=Function.prototype.bind.call(console.info,console,u.name+":"),T.debug.apply(console,arguments)))},verbose:function(){!u.silent&&u.verbose&&u.debug&&(u.performance?T.performance.log(arguments):(T.verbose=Function.prototype.bind.call(console.info,console,u.name+":"),T.verbose.apply(console,arguments)))},error:function(){u.silent||(T.error=Function.prototype.bind.call(console.error,console,u.name+":"),T.error.apply(console,arguments))},performance:{log:function(t){var e,o;u.performance&&(o=(e=(new Date).getTime())-(D||e),D=e,j.push({Name:t[0],Arguments:[].slice.call(t,1)||"",Element:P,"Execution Time":o})),clearTimeout(T.performance.timer),T.performance.timer=setTimeout(T.performance.display,500)},display:function(){var t=u.name+":",o=0;D=!1,clearTimeout(T.performance.timer),N.each(j,function(t,e){o+=e["Execution Time"]}),t+=" "+o+"ms",A&&(t+=" '"+A+"'"),(console.group!==z||console.table!==z)&&0<j.length&&(console.groupCollapsed(t),console.table?console.table(j):N.each(j,function(t,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),j=[]}},invoke:function(n,t,e){var i,r,o,a=C;return t=t||H,e=e||P,"string"==typeof n&&a!==z&&(n=n.split(/[\. ]/),i=n.length-1,N.each(n,function(t,e){var o=t!=i?e+n[t+1].charAt(0).toUpperCase()+n[t+1].slice(1):n;if(N.isPlainObject(a[o])&&t!=i)a=a[o];else{if(a[o]!==z)return r=a[o],!1;{if(!N.isPlainObject(a[e])||t==i)return a[e]!==z&&(r=a[e]),!1;a=a[e]}}})),N.isFunction(r)?o=r.apply(e,t):r!==z&&(o=r),Array.isArray(E)?E.push(o):E!==z?E=[E,o]:o!==z&&(E=o),r}};M?(C===z&&T.initialize(),T.invoke(R)):(C!==z&&C.invoke("destroy"),T.initialize())}),E!==z?E:this},N.fn.popup.settings={name:"Popup",silent:!1,debug:!1,verbose:!1,performance:!0,namespace:"popup",observeChanges:!0,onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onUnplaceable:function(){},onHidden:function(){},on:"hover",boundary:V,addTouchEvents:!0,position:"top left",forcePosition:!1,variation:"",movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!1,hoverable:!1,content:!1,html:!1,title:!1,closable:!0,hideOnScroll:"auto",exclusive:!1,context:"body",scrollContext:V,prefer:"opposite",lastResort:!1,arrowPixelsFromEdge:20,delay:{show:50,hide:70},setFluidWidth:!0,duration:200,transition:"scale",distanceAway:0,jitter:2,offset:0,maxSearchDepth:15,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"Popup does not fit within the boundaries of the viewport",method:"The method you called is not defined.",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",notFound:"The target or popup you specified does not exist on the page"},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",basic:"basic",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible",popupVisible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(t){var e={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};return/[&<>"'`]/.test(t)?(t=t.replace(/&(?![a-z0-9#]{1,12};)/gi,"&amp;")).replace(/[<>"'`]/g,function(t){return e[t]}):t},popup:function(t){var e="",o=N.fn.popup.settings.templates.escape;return typeof t!==z&&(typeof t.title!==z&&t.title&&(t.title=o(t.title),e+='<div class="header">'+t.title+"</div>"),typeof t.content!==z)&&t.content&&(t.content=o(t.content),e+='<div class="content">'+t.content+"</div>"),e}}}}(jQuery,window,document);