--1. Asset / Software Request
	CREATE TABLE `tbl_asset_sw_request` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_department`  varchar(200) DEFAULT NULL, 
	`fld_assetsw`  varchar(100) NOT NULL, 
	`fld_issue`  varchar(100) NOT NULL, 
	`fld_notes`  text DEFAULT NULL,	
	`fld_datereq`  date DEFAULT NULL,
	`fld_datelimit`  date DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_assets` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('1','Laptop');
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('2','Desktop');
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('3','Wireless Keyboard');
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('4','Wireless Mouse');
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('5','Software ABC');
	INSERT INTO tbl_assets (fld_id, fld_descr) VALUES ('6','Software XYZ');
	CREATE TABLE `tbl_issue` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO tbl_issue (fld_id, fld_descr) VALUES ('1','New asset request');
	INSERT INTO tbl_issue (fld_id, fld_descr) VALUES ('2','Replacement for broken/faulty device');
	INSERT INTO tbl_issue (fld_id, fld_descr) VALUES ('3','Replacement for lost device');
	INSERT INTO tbl_issue (fld_id, fld_descr) VALUES ('4','Other reason');

--2. Bug Tracker
	CREATE TABLE `tbl_bugtracker` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_bug_title`  varchar(100) NOT NULL,
	`fld_issue_descr`  text NOT NULL,
	`fld_browser`  varchar(20) DEFAULT NULL, 
	`fld_assigned_to`  int(11) DEFAULT NULL, 
	`fld_type`  int(11) DEFAULT NULL, 
	`fld_priority`  int(11) DEFAULT NULL, 
	`fld_screenshot`  BLOB DEFAULT NULL,
	`fld_status`  int(11) DEFAULT NULL,
	`fld_datetime` datetime DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_technician` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
--3. Car Rental
	CREATE TABLE `tbl_car_rental` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_doctype`  varchar(20) DEFAULT NULL,
	`fld_docnumber`  varchar(20) DEFAULT NULL,
	`fld_birthdate`  date DEFAULT NULL,
	`fld_pickuplocal`  int(11) DEFAULT NULL,
	`fld_pickupdate`  datetime DEFAULT NULL, 
	`fld_dropofflocal`  int(11) DEFAULT NULL,
	`fld_dropoffdate`  datetime DEFAULT NULL,	
	`fld_cartype`  int(2) DEFAULT NULL,	
	`fld_extras`  varchar(200) DEFAULT NULL,  	
	`fld_notes`  text DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ; 
	

--4. Client Details
	CREATE TABLE `tbl_clientdetails` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_gender`  varchar(2) DEFAULT NULL,
	`fld_birthdate`  date NOT NULL,
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_phone2`  varchar(24) DEFAULT NULL,
	`fld_phone3`  varchar(24) DEFAULT NULL,
	`fld_doctype`  varchar(20) DEFAULT NULL,
	`fld_docnumber`  varchar(20) DEFAULT NULL,
	`fld_creditlimit`  numeric(16,2) DEFAULT NULL,
	`fld_cardtype`  varchar(1) DEFAULT NULL,
	`fld_cardnumber`  varchar(20) DEFAULT NULL,
	`fld_notes`  text DEFAULT NULL,
	`fld_company`  varchar(100) DEFAULT NULL,
	`fld_department`  varchar(100) DEFAULT NULL,
	`fld_title`  varchar(100) DEFAULT NULL,
	`fld_workingtime`  varchar(100) DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 


--5. Complaints
	CREATE TABLE `tbl_complaints` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_notes`  text DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ; 


--6. Contact Us
	CREATE TABLE `tbl_contactus` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_notes`  text NOT NULL,	
	PRIMARY KEY (`fld_id`)
	) ; 


--7. Course Evaluation
	
	CREATE TABLE `tbl_course_evaluation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_course`  int(11) NOT NULL, 
	`fld_instructor`  varchar(100) NOT NULL,
	`fld_rateinstrnmethods`  int(1) NOT NULL,
	`fld_rateinstrattitude`  int(1) NOT NULL,	
	`fld_rateusefulness`  int(1) NOT NULL,	
	`fld_notes`  text DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_course` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	`fld_descr`  text NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO tbl_course (fld_id,fld_name,fld_descr) VALUES
	 ('1','Advanced PHP Course','Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.');
	INSERT INTO tbl_course (fld_id,fld_name,fld_descr) VALUES
	  ('2','Fundamentals of Scriptcase','Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.');
	
	

--8. Course Subscription 
	CREATE TABLE `tbl_course_subscription` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_birthdate`  date NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_phone`  varchar(24) NOT NULL,
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,	
	`fld_education`  varchar(100) DEFAULT NULL,
	`fld_course_id`  int(11) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 

--9. Delivery Feedback
	CREATE TABLE `tbl_delivery_feedback` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,	
	`fld_establishment`  int(1) DEFAULT NULL, 
	`fld_deliv_service`  int(1) DEFAULT NULL, 
	`fld_deliv_sys`  int(1) DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ; 	

--10. Donation Form
	CREATE TABLE `tbl_donation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,	
	`fld_howmuch` decimal(16,2) NOT NULL,
	`fld_howtodonate`  int(2) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 

--11. Software Evaluation
	CREATE TABLE `tbl_evaluation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_more1year`  int(1) DEFAULT NULL,	
	`fld_rating`  int(1) DEFAULT NULL, 
	`fld_alternative`  varchar(1) DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 


--12. Product Feedback
	CREATE TABLE `tbl_feedback` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_rating`  int(1) NOT NULL,	
	`fld_notes`  text DEFAULT NULL, 
	`fld_usemytestimonial`  varchar(1) DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 


--13. Free Trial
	CREATE TABLE `tbl_freetrial` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_company`  varchar(100) DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ;


--14. Get our eBook
	CREATE TABLE `tbl_getebook` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_company`  varchar(100) DEFAULT NULL,
	`fld_title`  varchar(100) DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ;


--15. On-site Inquiries 
	CREATE TABLE `tbl_inquiries` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_address1`  varchar(100) NOT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) NOT NULL,
	`fld_state`  varchar(2) NOT NULL,
	`fld_postalcode`  varchar(10) NOT NULL,
	`fld_country`  varchar(2) NOT NULL,	
	`fld_progress`  int(3) NOT NULL, 
	`fld_morematerials`  varchar(1) NOT NULL,	
	`fld_materials`  varchar(100) DEFAULT NULL,	
	`fld_notes`  text NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	

--16. Newsletter
	CREATE TABLE `tbl_newsletter` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,	
	`fld_categories` varchar(100) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 


--17. Party Invitation
	CREATE TABLE `tbl_party_invitation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_joinus`  varchar(1) NOT NULL, 
	`fld_mealpref`  varchar(100) NOT NULL, 
	`fld_guests`  int(2) NOT NULL, 
	`fld_guestsmealpref`  varchar(100) DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	); 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_party` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_title`  varchar(150) NOT NULL,
	`fld_when`  datetime NOT NULL,
	`fld_local`  varchar(150) NOT NULL,
	`fld_message`  text NOT NULL,
	PRIMARY KEY (`fld_id`)
	); 
	
	INSERT INTO `tbl_party` VALUES ('1', 'Chloe Birthday',  '2023-06-01 18:00:00', '415 Sinclair St.', '<p style="text-align: center;"><span class="font" style="font-family: serif,times new roman;"><span class="size" style="font-size: 18px;"> <strong>You are invited! <br />Join us to celebrate this date.</strong></span></span></p>');


--18. Patient Admission
	CREATE TABLE `tbl_patient_admission` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_gender`  varchar(2) DEFAULT NULL,
	`fld_birthdate`  date NOT NULL,
	`fld_weight`  int(3) NOT NULL,
	`fld_height`  int(3) NOT NULL,
	`fld_body_temp`  int(3) NOT NULL,	
	`fld_healthissues`  text DEFAULT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_doctype`  varchar(20) DEFAULT NULL,
	`fld_docnumber`  varchar(20) DEFAULT NULL,	
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 


--19. Patient Tracking
	CREATE TABLE `tbl_patient_tracking` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_id_patient`  int(11) NOT NULL,
	`fld_id_nurse`  int(11) NOT NULL,
	`fld_id_doctor`  int(11) NOT NULL,
	`fld_date`  datetime NOT NULL,
	`fld_complaints`  text DEFAULT NULL,
	`fld_medications`  text DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_nurse` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	INSERT INTO `tbl_nurse` (fld_id, fld_name) VALUES ('1','Charles F. Hill');
	INSERT INTO `tbl_nurse` (fld_id, fld_name) VALUES ('2','David S. Helms');
	INSERT INTO `tbl_nurse` (fld_id, fld_name) VALUES ('3','Amanda B. Bain');
	INSERT INTO `tbl_nurse` (fld_id, fld_name) VALUES ('4','Kimberly G. Gonzalez');
	
	CREATE TABLE `tbl_doctor` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	INSERT INTO `tbl_doctor` (fld_id, fld_name) VALUES ('1','Gina Rodriquez');
	INSERT INTO `tbl_doctor` (fld_id, fld_name) VALUES ('2','Becka Wenona');
	INSERT INTO `tbl_doctor` (fld_id, fld_name) VALUES ('3','Arlen Tristan');
	INSERT INTO `tbl_doctor` (fld_id, fld_name) VALUES ('4','Tommy Rickey');
	
	CREATE TABLE `tbl_patient` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	INSERT INTO `tbl_patient` (fld_id, fld_name) VALUES ('1','Michele J. Sabo');
	INSERT INTO `tbl_patient` (fld_id, fld_name) VALUES ('2','Kendra P. Wallace');
	INSERT INTO `tbl_patient` (fld_id, fld_name) VALUES ('3','Ann D. Lawson');


--20. Resignation Form
	CREATE TABLE `tbl_resignation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_when`  date NOT NULL,
	`fld_rating`  int(1) DEFAULT NULL,
	`fld_notes`  text DEFAULT NULL,
	`fld_signature`  BLOB DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 

--21. Volunteers
	CREATE TABLE `tbl_volunteers` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_phone`  varchar(24) NOT NULL,
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,		
	`fld_howtocontribute`  varchar(1) NOT NULL,
	`fld_items`  text DEFAULT NULL,	
	`fld_weekdays`  varchar(100) DEFAULT NULL, 
	`fld_notes`  text DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 


--22. Employee Satisfacion
	CREATE TABLE `tbl_satisfaction` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_ratesupervisor`  int(1) NOT NULL,
	`fld_ratehr`  int(1) NOT NULL,	
	`fld_rateteam`  int(1) NOT NULL,
	`fld_notes`  text DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 


--23. Testimonial Form
	CREATE TABLE `tbl_testimonials` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_notes`  text NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 


-- Concert/ Show Ticket Booking
	CREATE TABLE `tbl_ticket_booking` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_qty_tickets`  int(3) NOT NULL,	
	`fld_show_id`  int(11) NOT NULL, 
	`fld_show_dttime_id`  int(11) NOT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_shows` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_title`  varchar(250) NOT NULL,
	`fld_descr`  text NOT NULL,
	`fld_banner`  BLOB DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO tbl_shows (fld_id,fld_title,fld_descr,fld_banner) VALUES ('1','Jazz Festival','The Jazz Festival is, above all, an initiative born in 2012 by lovers of good music.',NULL);
	INSERT INTO tbl_shows (fld_id,fld_title,fld_descr,fld_banner) VALUES  ('2','Rock in Rio','THE LARGEST MUSIC AND ENTERTAINMENT FESTIVAL IN THE WORLD.',NULL);
	
	CREATE TABLE `tbl_shows_datetime` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_show_id`  int(11) NOT NULL,
	`fld_datetime` datetime NOT NULL,
	`fld_tickets_qty`  int(11) NOT NULL,
	`fld_tickets_sold`  int(11) NOT NULL,
	PRIMARY KEY (`fld_id`) 
	) ; 
	INSERT INTO tbl_shows_datetime (fld_id,fld_show_id,fld_datetime,fld_tickets_qty,fld_tickets_sold) VALUES ('1',1,'2022-11-30 19:00:00',1000,0);
	INSERT INTO tbl_shows_datetime (fld_id,fld_show_id,fld_datetime,fld_tickets_qty,fld_tickets_sold) VALUES ('2',1,'2022-12-01 19:00:00',1000,0);
	INSERT INTO tbl_shows_datetime (fld_id,fld_show_id,fld_datetime,fld_tickets_qty,fld_tickets_sold) VALUES ('3',2,'2022-12-15 14:00:00',50000,0);
	INSERT INTO tbl_shows_datetime (fld_id,fld_show_id,fld_datetime,fld_tickets_qty,fld_tickets_sold) VALUES ('4',2,'2022-12-16 14:00:00',50000,0);
	INSERT INTO tbl_shows_datetime (fld_id,fld_show_id,fld_datetime,fld_tickets_qty,fld_tickets_sold) VALUES ('5',2,'2022-12-17 14:00:00',50000,0);



-- Vote Election
	CREATE TABLE `tbl_votes` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_id_election`  int(11) NOT NULL, 
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_id_candidate`  int(11) NOT NULL,
	`fld_date`  datetime DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	-- Auxiliar tables
	CREATE TABLE `tbl_election` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	`fld_date_start`  datetime NOT NULL,
	`fld_date_end`  datetime NOT NULL,
	`fld_max_candidates`  int(6) NOT NULL,
	`fld_max_winners`  int(3) NOT NULL,
	PRIMARY KEY (`fld_id`)
	); 
	INSERT INTO tbl_election (fld_id,fld_name,fld_date_start,fld_date_end,fld_max_candidates,fld_max_winners) VALUES
	 ('1','Best Singer Ever','2022-11-01 00:00:00','2027-10-31 00:00:00',5,1);
	CREATE TABLE `tbl_candidate` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_name`  varchar(250) NOT NULL,
	`fld_id_election`  int(11) NOT NULL,
	PRIMARY KEY (`fld_id`)
	); 
	INSERT INTO tbl_candidate (fld_id,fld_name,fld_id_election) VALUES ('1','Frank Sinatra',1);
	INSERT INTO tbl_candidate (fld_id,fld_name,fld_id_election) VALUES ('2','Elvis Presley',1);
	INSERT INTO tbl_candidate (fld_id,fld_name,fld_id_election) VALUES ('3','Amy Winehouse',1);


-- Thanksgiving Buffet
	CREATE TABLE `tbl_thanksgiving` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) DEFAULT NULL,
	`fld_phone`  varchar(24) DEFAULT NULL,
	`fld_guests`  int(2) DEFAULT NULL, 
	`fld_date`  datetime NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 


-- Room Reservation 
	CREATE TABLE `tbl_room_reservation` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_phone`  varchar(24) NOT NULL,
	`fld_doctype`  varchar(20) NOT NULL,
	`fld_docnumber`  varchar(20) NOT NULL,
	`fld_address1`  varchar(100) DEFAULT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,
	`fld_checkindate`  datetime NOT NULL, 
	`fld_checkoutdate`  datetime NOT NULL,	
	`fld_guests`  int(2) NOT NULL,	
	`fld_adults`  int(2) NOT NULL,  	
	`fld_children`  int(2) NOT NULL,	
	`fld_pets`  int(2) NOT NULL,  
	`fld_chaffeur`  int(1) NOT NULL,  
	`fld_airporttrans`  int(1) NOT NULL, 
	`fld_breakfastbed`  int(1) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 

-- Meal Order
	CREATE TABLE `tbl_meal_order` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_sel_menu`  int(11) NOT NULL, 
	`fld_crust`  int(11) DEFAULT NULL, 
	`fld_topping`  int(11) NOT NULL, 
	`fld_sauce`  int(11) DEFAULT NULL, 
	`fld_qty`  int(3) DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_meal_sel_menu` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 	
	INSERT INTO `tbl_meal_sel_menu` VALUES ('1', 'Margherita',  '22.68');
	INSERT INTO `tbl_meal_sel_menu` VALUES ('2', 'Muzzarela',  '20.99');
	INSERT INTO `tbl_meal_sel_menu` VALUES ('3', 'Veggie',  '25.00');
	INSERT INTO `tbl_meal_sel_menu` VALUES ('4', 'Pepperoni',  '25.00');
	
	CREATE TABLE `tbl_meal_crust` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO `tbl_meal_crust` VALUES ('1', 'Thin',  '0.00');
	INSERT INTO `tbl_meal_crust` VALUES ('2', 'Thick',  '0.99');
	INSERT INTO `tbl_meal_crust` VALUES ('3', 'Cheese',  '2.99');
	
	CREATE TABLE `tbl_meal_topping` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO `tbl_meal_topping` VALUES ('1', 'Extra cheese',  '1.99');
	INSERT INTO `tbl_meal_topping` VALUES ('2', 'Pepperoni',  '3.99');
	INSERT INTO `tbl_meal_topping` VALUES ('3', 'Mushrooms',  '2.99');
	
	CREATE TABLE `tbl_meal_sauce` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	INSERT INTO `tbl_meal_sauce` VALUES ('1', 'Tomato sauce',  '1.99');
	INSERT INTO `tbl_meal_sauce` VALUES ('2', 'Mustard',  '3.99');
	INSERT INTO `tbl_meal_sauce` VALUES ('3', 'Hot sauce',  '2.99');
	

-- Service Order
	CREATE TABLE `tbl_service_order` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) NOT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_address1`  varchar(100) NOT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,	
	`fld_homeservices`  varchar(50) NOT NULL, 
	`fld_notes`  text NOT NULL, 
	`fld_datereq`  date DEFAULT NULL,
	`fld_datelimit`  date DEFAULT NULL,
	PRIMARY KEY (`fld_id`)
	) ; 	
	
	-- Auxiliar tables
	CREATE TABLE `tbl_homeservices` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	
	INSERT INTO `tbl_homeservices` VALUES ('1', 'Electrician',  '22.68');
	INSERT INTO `tbl_homeservices` VALUES ('2', 'Pest control',  '20.99');
	INSERT INTO `tbl_homeservices` VALUES ('3', 'Deep cleaning and desinfection',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('4', 'Cleaning and maintenance',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('5', 'Painting',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('6', 'Salon',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('7', 'Carpentry',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('8', 'AC repair',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('9', 'Appliance repair',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('10', 'Plumbing',  '25.00');
	INSERT INTO `tbl_homeservices` VALUES ('11', 'Car repair',  '25.00');



-- Product Order
	CREATE TABLE `tbl_product_order` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_firstname`  varchar(100) NOT NULL,
	`fld_lastname`  varchar(100) DEFAULT NULL,
	`fld_email`  varchar(100) NOT NULL,
	`fld_address1`  varchar(100) NOT NULL,
	`fld_address2`  varchar(100) DEFAULT NULL,
	`fld_city`  varchar(100) DEFAULT NULL,
	`fld_state`  varchar(2) DEFAULT NULL,
	`fld_postalcode`  varchar(10) DEFAULT NULL,
	`fld_country`  varchar(2) DEFAULT NULL,	
	`fld_notes`  text DEFAULT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	
	-- Auxiliar tables
	CREATE TABLE `tbl_products` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_descr`  varchar(100) NOT NULL, 
	`fld_price`  decimal(16,2) NOT NULL,
	`fld_img`  BLOB DEFAULT NULL,	
	PRIMARY KEY (`fld_id`)
	) ; 
	CREATE TABLE `tbl_order_items` (
	`fld_id`  int(11) NOT NULL AUTO_INCREMENT,
	`fld_order_id`  int(11) NOT NULL, 
	`fld_product_id`  int(11) NOT NULL, 
	`fld_size`  varchar(1) NOT NULL, 	
	`fld_qty`  int(3) NOT NULL, 	
	`fld_unit_price`  decimal(16,2) NOT NULL, 	
	`fld_total_price`  decimal(16,2) NOT NULL, 
	PRIMARY KEY (`fld_id`)
	) ; 
	
