SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Sequence structure for tb_benefits_benefit_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_benefits_benefit_id_seq;
CREATE SEQUENCE tb_benefits_benefit_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_benefits_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_benefits_seq;
CREATE SEQUENCE tb_benefits_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_candidates_candidate_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_candidates_candidate_id_seq;
CREATE SEQUENCE tb_candidates_candidate_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_candidates_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_candidates_seq;
CREATE SEQUENCE tb_candidates_seq START WITH 3 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_companies_company_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_companies_company_id_seq;
CREATE SEQUENCE tb_companies_company_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_companies_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_companies_seq;
CREATE SEQUENCE tb_companies_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_contacts_contact_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_contacts_contact_id_seq;
CREATE SEQUENCE tb_contacts_contact_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_contacts_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_contacts_seq;
CREATE SEQUENCE tb_contacts_seq START WITH 8 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_experiences_experience_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_experiences_experience_id_seq;
CREATE SEQUENCE tb_experiences_experience_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_experiences_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_experiences_seq;
CREATE SEQUENCE tb_experiences_seq START WITH 2 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_industries_industry_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_industries_industry_id_seq;
CREATE SEQUENCE tb_industries_industry_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_industries_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_industries_seq;
CREATE SEQUENCE tb_industries_seq START WITH 13 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_job_positions_position_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_job_positions_position_id_seq;
CREATE SEQUENCE tb_job_positions_position_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_job_positions_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_job_positions_seq;
CREATE SEQUENCE tb_job_positions_seq START WITH 22 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_education_education_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_education_education_id_seq;
CREATE SEQUENCE tb_req_education_education_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_education_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_education_seq;
CREATE SEQUENCE tb_req_education_seq START WITH 8 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_status_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_status_seq;
CREATE SEQUENCE tb_req_status_seq START WITH 5 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_status_status_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_status_status_id_seq;
CREATE SEQUENCE tb_req_status_status_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_types_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_types_seq;
CREATE SEQUENCE tb_req_types_seq START WITH 7 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_types_type_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_types_type_id_seq;
CREATE SEQUENCE tb_req_types_type_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_urgencies_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_urgencies_seq;
CREATE SEQUENCE tb_req_urgencies_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_req_urgencies_urgency_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_req_urgencies_urgency_id_seq;
CREATE SEQUENCE tb_req_urgencies_urgency_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_requisitions_requisition_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_requisitions_requisition_id_seq;
CREATE SEQUENCE tb_requisitions_requisition_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_requisitions_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_requisitions_seq;
CREATE SEQUENCE tb_requisitions_seq START WITH 6 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_sc_log_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_sc_log_id_seq;
CREATE SEQUENCE tb_sc_log_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_sc_log_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_sc_log_seq;
CREATE SEQUENCE tb_sc_log_seq START WITH 42 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_sec_groups_group_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_sec_groups_group_id_seq;
CREATE SEQUENCE tb_sec_groups_group_id_seq START WITH 1 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_sec_groups_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_sec_groups_seq;
CREATE SEQUENCE tb_sec_groups_seq START WITH 4 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_submission_status_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_submission_status_seq;
CREATE SEQUENCE tb_submission_status_seq START WITH 6 INCREMENT BY 1;

-- ----------------------------
-- Sequence structure for tb_submission_status_submission_status_id_seq
-- ----------------------------
DROP SEQUENCE IF EXISTS tb_submission_status_submission_status_id_seq;
CREATE SEQUENCE tb_submission_status_submission_status_id_seq START WITH 1 INCREMENT BY 1;


-- ----------------------------
-- Table structure for `tb_benefits`
-- ----------------------------
CREATE TABLE `tb_benefits` (
`benefit_id`  int(11) NOT NULL AUTO_INCREMENT ,
`benefit_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`benefit_note`  varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
PRIMARY KEY (`benefit_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_benefits
-- ----------------------------
BEGIN;
INSERT INTO `tb_benefits` VALUES ('1', 'Disability', null), ('2', 'Vacation Time', null), ('3', 'Medical', null), ('4', 'Dental', null), ('5', 'Vision', null), ('6', 'Life', null), ('7', '401K', null), ('8', '401K Match', null), ('9', 'Flexible Spending', null), ('10', 'Stock Options', null), ('11', 'Education Reimbursement', null), ('12', 'PTO', null);
COMMIT;

-- ----------------------------
-- Table structure for `tb_candidates`
-- ----------------------------
CREATE TABLE `tb_candidates` (
`candidate_id`  int(11) NOT NULL AUTO_INCREMENT ,
`candidate_name`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`candidate_courtesy_title`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_birth_date`  date NULL DEFAULT NULL ,
`candidate_address`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_city`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_state`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_zip`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_email`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_phone`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_resume`  blob NULL ,
`candidate_resume_filename`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`candidate_resume_filesize`  int(11) NULL DEFAULT NULL ,
`candidate_notes`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`tb_sec_users_user_login`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`candidate_id`),
FOREIGN KEY (`tb_sec_users_user_login`) REFERENCES `tb_sec_users` (`user_login`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=3

;

-- ----------------------------
-- Records of tb_candidates
-- ----------------------------
BEGIN;
INSERT INTO `tb_candidates` VALUES ('1', 'Eldrich Thomas', 'Mr', '1984-01-31', '', '', '', '', '', '', '', '', '0', '', 'eldrich'), ('2', 'Mary Jane', 'Ms', '1988-11-11', '', '', '', '', 'mary@scriptcase.net', '', 0x524553554D45, 'resume.txt', '6', '', 'mary');
COMMIT;

-- ----------------------------
-- Table structure for `tb_candidates_submissions`
-- ----------------------------
CREATE TABLE `tb_candidates_submissions` (
`requisition_id`  int(11) NOT NULL ,
`candidate_id`  int(11) NOT NULL ,
`submission_date`  date NULL DEFAULT NULL ,
`submission_status_id`  int(11) NULL DEFAULT NULL ,
`submission_interview_date`  datetime NULL DEFAULT NULL ,
`submission_interview_address`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`submission_rating`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`requisition_id`, `candidate_id`),
FOREIGN KEY (`candidate_id`) REFERENCES `tb_candidates` (`candidate_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`requisition_id`) REFERENCES `tb_requisitions` (`requisition_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`submission_status_id`) REFERENCES `tb_submission_status` (`submission_status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_candidates_submissions
-- ----------------------------
BEGIN;
INSERT INTO `tb_candidates_submissions` VALUES ('1', '1', '2013-10-30', '3', '2013-12-20 00:00:00', 'Kennedy Avenue 1001', '0'), ('1', '2', '2013-11-13', '1', null, null, null), ('3', '2', '2014-02-03', '1', null, null, null);
COMMIT;

-- ----------------------------
-- Table structure for `tb_companies`
-- ----------------------------
CREATE TABLE `tb_companies` (
`company_id`  int(11) NOT NULL AUTO_INCREMENT ,
`company_name`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`company_address`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_country`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_city`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_state`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_zip`  varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_url`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`industry_id`  int(11) NOT NULL ,
PRIMARY KEY (`company_id`),
FOREIGN KEY (`industry_id`) REFERENCES `tb_industries` (`industry_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of tb_companies
-- ----------------------------
BEGIN;
INSERT INTO `tb_companies` VALUES ('1', 'Netmake', 'Kennedy 1001', 'BR', 'Olinda', 'PE', '53230-630', 'www.scriptcase.net', '9'), ('2', 'Sample company', '', 'US', '', '', '', '', '7'), ('3', 'Scriptcase Company', '', 'BR', '', '', '', '', '9');
COMMIT;

-- ----------------------------
-- Table structure for `tb_contacts`
-- ----------------------------
CREATE TABLE `tb_contacts` (
`contact_id`  int(11) NOT NULL AUTO_INCREMENT ,
`contact_name`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`job_position_id`  int(11) NULL DEFAULT NULL ,
`contact_phone`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`contact_email`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`company_id`  int(11) NOT NULL ,
`tb_sec_users_user_login`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`contact_id`),
FOREIGN KEY (`company_id`) REFERENCES `tb_companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`job_position_id`) REFERENCES `tb_job_positions` (`position_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`tb_sec_users_user_login`) REFERENCES `tb_sec_users` (`user_login`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=8

;

-- ----------------------------
-- Records of tb_contacts
-- ----------------------------
BEGIN;
INSERT INTO `tb_contacts` VALUES ('2', 'Phill Morrison', '17', '555', 'info@scriptcase.net', '1', 'phill'), ('3', 'John Mayer', '13', '', 'info@scriptcase.net', '1', 'mayer'), ('5', 'Alice key', '1', '', 'news@scriptcase.net', '1', 'alice'), ('6', 'Andy Leroy', '4', '', '', '2', 'andy'), ('7', 'Paul Walsh', '4', '', '', '3', 'paul');
COMMIT;

-- ----------------------------
-- Table structure for `tb_experiences`
-- ----------------------------
CREATE TABLE `tb_experiences` (
`experience_id`  int(11) NOT NULL AUTO_INCREMENT ,
`experience_start_date`  date NULL DEFAULT NULL ,
`experience_end_date`  date NULL DEFAULT NULL ,
`candidate_id`  int(11) NOT NULL ,
`company_id`  int(11) NULL DEFAULT NULL ,
`tb_job_positions_position_id`  int(11) NULL DEFAULT NULL ,
`experience_summary`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`experience_id`),
FOREIGN KEY (`candidate_id`) REFERENCES `tb_candidates` (`candidate_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`company_id`) REFERENCES `tb_companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`tb_job_positions_position_id`) REFERENCES `tb_job_positions` (`position_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=2

;

-- ----------------------------
-- Records of tb_experiences
-- ----------------------------
BEGIN;
INSERT INTO `tb_experiences` VALUES ('1', '2008-10-01', '2010-10-01', '1', '2', '18', 'Great experience selling the software xxx in the whole USA.');
COMMIT;

-- ----------------------------
-- Table structure for `tb_industries`
-- ----------------------------
CREATE TABLE `tb_industries` (
`industry_id`  int(11) NOT NULL AUTO_INCREMENT ,
`industry_description`  varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`industry_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=13

;

-- ----------------------------
-- Records of tb_industries
-- ----------------------------
BEGIN;
INSERT INTO `tb_industries` VALUES ('1', 'Banking'), ('2', 'Consulting - Financial'), ('3', 'Consulting - IT'), ('4', 'Financial'), ('5', 'Hardware'), ('6', 'Healthcare'), ('7', 'Manufacturing'), ('8', 'Pharma'), ('9', 'Software'), ('10', 'Telcom'), ('11', 'Transportation'), ('12', 'Other');
COMMIT;

-- ----------------------------
-- Table structure for `tb_job_positions`
-- ----------------------------
CREATE TABLE `tb_job_positions` (
`position_id`  int(11) NOT NULL AUTO_INCREMENT ,
`position_description`  varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`position_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=22

;

-- ----------------------------
-- Records of tb_job_positions
-- ----------------------------
BEGIN;
INSERT INTO `tb_job_positions` VALUES ('1', 'Admin Assistant'), ('2', 'Customer Service Manager'), ('3', 'Executive'), ('4', 'HR'), ('5', 'IT - QA'), ('6', 'IT - Software Engineer'), ('7', 'IT - Technical Support'), ('8', 'IT - Systems Analyst'), ('9', 'IT - Web Developper'), ('10', 'IT - Writting'), ('11', 'Marketing Executive'), ('12', 'Sales Manager'), ('13', 'Accountant'), ('14', 'CFO'), ('15', 'CIO'), ('16', 'COO'), ('17', 'CEO'), ('18', 'Sales Representative'), ('19', 'Product Manager'), ('20', 'Systems Administrator'), ('21', 'IT - DBA');
COMMIT;

-- ----------------------------
-- Table structure for `tb_req_education`
-- ----------------------------
CREATE TABLE `tb_req_education` (
`education_id`  int(11) NOT NULL AUTO_INCREMENT ,
`education_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`education_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=8

;

-- ----------------------------
-- Records of tb_req_education
-- ----------------------------
BEGIN;
INSERT INTO `tb_req_education` VALUES ('1', 'Associates'), ('2', 'Bachelors'), ('3', 'Certificate'), ('4', 'HS/GED'), ('5', 'Masters'), ('6', 'None'), ('7', 'PhD');
COMMIT;

-- ----------------------------
-- Table structure for `tb_req_status`
-- ----------------------------
CREATE TABLE `tb_req_status` (
`status_id`  int(11) NOT NULL AUTO_INCREMENT ,
`status_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`status_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=5

;

-- ----------------------------
-- Records of tb_req_status
-- ----------------------------
BEGIN;
INSERT INTO `tb_req_status` VALUES ('1', 'Hiring'), ('2', 'Filled'), ('3', 'Closed'), ('4', 'On-Hold');
COMMIT;

-- ----------------------------
-- Table structure for `tb_req_types`
-- ----------------------------
CREATE TABLE `tb_req_types` (
`type_id`  int(11) NOT NULL AUTO_INCREMENT ,
`typ_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`type_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=7

;

-- ----------------------------
-- Records of tb_req_types
-- ----------------------------
BEGIN;
INSERT INTO `tb_req_types` VALUES ('1', 'Full-time'), ('2', 'Part-time'), ('3', 'Part-time temp'), ('4', 'Full-time temp'), ('5', 'Contract 1099'), ('6', 'Contract W-9');
COMMIT;

-- ----------------------------
-- Table structure for `tb_req_urgencies`
-- ----------------------------
CREATE TABLE `tb_req_urgencies` (
`urgency_id`  int(11) NOT NULL AUTO_INCREMENT ,
`urgency_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`urgency_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of tb_req_urgencies
-- ----------------------------
BEGIN;
INSERT INTO `tb_req_urgencies` VALUES ('1', 'Hot'), ('2', 'Warm'), ('3', 'Cold');
COMMIT;

-- ----------------------------
-- Table structure for `tb_requisitions`
-- ----------------------------
CREATE TABLE `tb_requisitions` (
`requisition_id`  int(11) NOT NULL AUTO_INCREMENT ,
`contact_id`  int(11) NOT NULL ,
`requisition_target_fill_date`  date NULL DEFAULT NULL ,
`status_id`  int(11) NULL DEFAULT NULL ,
`urgency_id`  int(11) NULL DEFAULT NULL ,
`type_id`  int(11) NULL DEFAULT NULL ,
`position_id`  int(11) NULL DEFAULT NULL ,
`requisition_title`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`requisition_description`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`requisition_contract_duration`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`requisition_location`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL ,
`requisition_salary`  decimal(10,2) NULL DEFAULT NULL ,
`requisition_requirements`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`required_education`  int(11) NULL DEFAULT NULL ,
PRIMARY KEY (`requisition_id`),
FOREIGN KEY (`contact_id`) REFERENCES `tb_contacts` (`contact_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`required_education`) REFERENCES `tb_req_education` (`education_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`position_id`) REFERENCES `tb_job_positions` (`position_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`status_id`) REFERENCES `tb_req_status` (`status_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`type_id`) REFERENCES `tb_req_types` (`type_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`urgency_id`) REFERENCES `tb_req_urgencies` (`urgency_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
AUTO_INCREMENT=6

;

-- ----------------------------
-- Records of tb_requisitions
-- ----------------------------
BEGIN;
INSERT INTO `tb_requisitions` VALUES ('1', '5', '2014-01-31', '1', '2', '1', '1', '', '', '', '', '1500.00', '', '5'), ('2', '2', '2014-01-31', '1', '1', '1', '8', '', '', '', '', '0.00', '', '2'), ('3', '2', '2014-02-28', '1', '3', '2', '7', '', '', '', '', '0.00', '', '6'), ('4', '7', '2014-06-01', '1', '3', '1', '1', 'Admin assistant', '', '', '', '1500.00', '', '2'), ('5', '6', '2014-03-01', '1', '1', '4', '7', 'Technical Support', '', '2 years', '', '0.00', '', '6');
COMMIT;

-- ----------------------------
-- Table structure for `tb_requisitions_has_benefits`
-- ----------------------------
CREATE TABLE `tb_requisitions_has_benefits` (
`requisition_id`  int(11) NOT NULL ,
`benefit_id`  int(11) NOT NULL ,
PRIMARY KEY (`requisition_id`, `benefit_id`),
FOREIGN KEY (`benefit_id`) REFERENCES `tb_benefits` (`benefit_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`requisition_id`) REFERENCES `tb_requisitions` (`requisition_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci

;

-- ----------------------------
-- Records of tb_requisitions_has_benefits
-- ----------------------------
BEGIN;
INSERT INTO `tb_requisitions_has_benefits` VALUES ('1', '2'), ('1', '3'), ('1', '4'), ('1', '9'), ('2', '2'), ('2', '3'), ('2', '4'), ('2', '9'), ('3', '2'), ('4', '2'), ('4', '3'), ('4', '6'), ('5', '2'), ('5', '3');
COMMIT;

-- ----------------------------
-- Table structure for `tb_sc_log`
-- ----------------------------
CREATE TABLE `tb_sc_log` (
`id`  int(8) NOT NULL AUTO_INCREMENT ,
`inserted_date`  datetime NULL DEFAULT NULL ,
`username`  varchar(90) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`application`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`creator`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`ip_user`  varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`action`  varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`description`  text CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci
AUTO_INCREMENT=193

;

-- ----------------------------
-- Records of tb_sc_log
-- ----------------------------


-- ----------------------------
-- Table structure for `tb_sec_applications`
-- ----------------------------
CREATE TABLE `tb_sec_applications` (
`applications_id`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`applications_description`  text CHARACTER SET armscii8 COLLATE armscii8_general_ci NULL ,
PRIMARY KEY (`applications_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci

;

-- ----------------------------
-- Records of tb_sec_applications
-- ----------------------------
BEGIN;
INSERT INTO `tb_sec_applications` VALUES ('app_grid_log', 'cons'), ('blank_submit_candidate', 'blank'), ('control_change_psw', 'contr'), ('control_sync_apps', 'contr'), ('form_add_candidate', 'form'), ('form_add_company', 'form'), ('form_add_contact', 'form'), ('form_edit_candidate', 'form'), ('form_look_candidate', 'form'), ('form_look_requisition', 'form'), ('form_tb_benefits', 'form'), ('form_tb_candidates', 'form'), ('form_tb_candidates_submissions', 'form'), ('form_tb_companies', 'form'), ('form_tb_contacts', 'form'), ('form_tb_experiences', 'form'), ('form_tb_industries', 'form'), ('form_tb_job_positions', 'form'), ('form_tb_requisitions', 'form'), ('form_tb_req_education', 'form'), ('form_tb_req_status', 'form'), ('form_tb_req_types', 'form'), ('form_tb_req_urgencies', 'form'), ('form_tb_sec_applications', 'form'), ('form_tb_sec_groups', 'form'), ('form_tb_sec_groups_applications', 'form'), ('form_tb_submission_status', 'form'), ('grid_search_jobs', 'cons'), ('grid_submitted_candidate', 'cons'), ('grid_tb_benefits', 'cons'), ('grid_tb_candidates', 'cons'), ('grid_tb_candidates_submissions', 'cons'), ('grid_tb_companies', 'cons'), ('grid_tb_contacts', 'cons'), ('grid_tb_contacts_detail', 'cons'), ('grid_tb_experiences', 'cons'), ('grid_tb_industries', 'cons'), ('grid_tb_job_positions', 'cons'), ('grid_tb_requisitions', 'cons'), ('grid_tb_requisitions_has_benefits', 'cons'), ('grid_tb_req_education', 'cons'), ('grid_tb_req_status', 'cons'), ('grid_tb_req_types', 'cons'), ('grid_tb_req_urgencies', 'cons'), ('grid_tb_sec_applications', 'cons'), ('grid_tb_sec_groups', 'cons'), ('grid_tb_submission_status', 'cons'), ('login', 'contr'), ('menu', ''), ('search_tb_sec_groups', 'filter');
COMMIT;

-- ----------------------------
-- Table structure for `tb_sec_groups`
-- ----------------------------
CREATE TABLE `tb_sec_groups` (
`group_id`  int(11) NOT NULL AUTO_INCREMENT ,
`group_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`group_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci
AUTO_INCREMENT=4

;

-- ----------------------------
-- Records of tb_sec_groups
-- ----------------------------
BEGIN;
INSERT INTO `tb_sec_groups` VALUES ('1', 'Contacts'), ('2', 'Candidates'), ('3', 'Administrator');
COMMIT;

-- ----------------------------
-- Table structure for `tb_sec_groups_applications`
-- ----------------------------
CREATE TABLE `tb_sec_groups_applications` (
`tb_sec_groups_group_id`  int(11) NOT NULL ,
`tb_sec_applications_id`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`priv_access`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`priv_insert`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`priv_delete`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`priv_update`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`priv_export`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
`priv_print`  varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL ,
PRIMARY KEY (`tb_sec_groups_group_id`, `tb_sec_applications_id`),
FOREIGN KEY (`tb_sec_applications_id`) REFERENCES `tb_sec_applications` (`applications_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
FOREIGN KEY (`tb_sec_groups_group_id`) REFERENCES `tb_sec_groups` (`group_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci

;

-- ----------------------------
-- Records of tb_sec_groups_applications
-- ----------------------------
BEGIN;
INSERT INTO `tb_sec_groups_applications` VALUES ('1', 'control_change_psw', 'Y', '', '', '', '', ''), ('1', 'form_add_candidate', null, null, null, null, null, null), ('1', 'form_add_company', null, null, null, null, null, null), ('1', 'form_add_contact', null, null, null, null, null, null), ('1', 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_look_requisition', null, null, null, null, null, null), ('1', 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', '', ''), ('1', 'grid_submitted_candidate', null, null, null, null, null, null), ('1', 'grid_tb_benefits', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_candidates_submissions', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_companies', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_contacts_detail', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_industries', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_job_positions', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_requisitions', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_req_education', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_req_status', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_req_types', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_req_urgencies', 'Y', '', '', '', 'Y', 'Y'), ('1', 'grid_tb_submission_status', 'Y', '', '', '', 'Y', 'Y'), ('1', 'login', 'Y', '', '', '', '', ''), ('1', 'menu', 'Y', '', '', '', '', ''), ('2', 'blank_submit_candidate', 'Y', '', '', '', '', ''), ('2', 'control_change_psw', 'Y', '', '', '', '', ''), ('2', 'form_add_candidate', null, null, null, null, null, null), ('2', 'form_add_company', null, null, null, null, null, null), ('2', 'form_add_contact', null, null, null, null, null, null), ('2', 'form_edit_candidate', 'Y', 'Y', '', 'Y', '', ''), ('2', 'form_look_requisition', 'Y', '', '', '', '', ''), ('2', 'form_tb_candidates', 'Y', 'Y', '', 'Y', '', ''), ('2', 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', '', ''), ('2', 'grid_search_jobs', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_submitted_candidate', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y'), ('2', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y'), ('2', 'login', 'Y', '', '', '', '', ''), ('2', 'menu', 'Y', '', '', '', '', ''), ('3', 'app_grid_log', 'Y', '', '', '', 'Y', 'Y'), ('3', 'blank_submit_candidate', 'Y', '', '', '', '', ''), ('3', 'control_change_psw', 'Y', '', '', '', '', ''), ('3', 'control_sync_apps', 'Y', '', '', '', '', ''), ('3', 'form_add_candidate', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_add_company', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_add_contact', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_edit_candidate', '', '', '', '', '', ''), ('3', 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_look_requisition', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_candidates', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_sec_applications', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_sec_groups', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_sec_groups_applications', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', '', ''), ('3', 'grid_search_jobs', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_submitted_candidate', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_benefits', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_candidates', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_candidates_submissions', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_companies', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_contacts_detail', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_industries', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_job_positions', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_requisitions', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_req_education', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_req_status', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_req_types', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_req_urgencies', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_sec_applications', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_sec_groups', 'Y', '', '', '', 'Y', 'Y'), ('3', 'grid_tb_submission_status', 'Y', '', '', '', 'Y', 'Y'), ('3', 'login', 'Y', '', '', '', '', ''), ('3', 'menu', 'Y', '', '', '', '', '');
INSERT INTO `tb_sec_groups_applications` VALUES ('3', 'search_tb_sec_groups', 'Y', '', '', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for `tb_sec_users`
-- ----------------------------
CREATE TABLE `tb_sec_users` (
`user_login`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`user_password`  varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
`tb_sec_groups_group_id`  int(11) NOT NULL ,
PRIMARY KEY (`user_login`),
FOREIGN KEY (`tb_sec_groups_group_id`) REFERENCES `tb_sec_groups` (`group_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci

;

-- ----------------------------
-- Records of tb_sec_users
-- ----------------------------
BEGIN;
INSERT INTO `tb_sec_users` VALUES ('admin', 'admin', '3'), ('alice', 'alice', '1'), ('andy', 'andy', '1'), ('eldrich', 'eldrich', '2'), ('mary', 'mary', '2'), ('mayer', 'mayer', '1'), ('paul', 'paul', '1'), ('phill', 'phill', '1');
COMMIT;

-- ----------------------------
-- Table structure for `tb_submission_status`
-- ----------------------------
CREATE TABLE `tb_submission_status` (
`submission_status_id`  int(11) NOT NULL AUTO_INCREMENT ,
`submission_status_description`  varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
PRIMARY KEY (`submission_status_id`)
)
ENGINE=InnoDB
DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci
AUTO_INCREMENT=6

;

-- ----------------------------
-- Records of tb_submission_status
-- ----------------------------
BEGIN;
INSERT INTO `tb_submission_status` VALUES ('1', 'Submitted'), ('2', 'Rejected'), ('3', 'Scheduled'), ('4', 'Cancelled'), ('5', 'Hired');
COMMIT;

-- ----------------------------
-- Auto increment value for `tb_benefits`
-- ----------------------------
ALTER TABLE `tb_benefits` AUTO_INCREMENT=13;

-- ----------------------------
-- Indexes structure for table tb_candidates
-- ----------------------------
CREATE INDEX `fk_tb_candidates_tb_sec_users1_idx` ON `tb_candidates`(`tb_sec_users_user_login`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_candidates`
-- ----------------------------
ALTER TABLE `tb_candidates` AUTO_INCREMENT=3;

-- ----------------------------
-- Indexes structure for table tb_candidates_submissions
-- ----------------------------
CREATE INDEX `fk_requisitions_has_candidates_candidates1_idx` ON `tb_candidates_submissions`(`candidate_id`) USING BTREE ;
CREATE INDEX `fk_requisitions_has_candidates_requisitions1_idx` ON `tb_candidates_submissions`(`requisition_id`) USING BTREE ;
CREATE INDEX `fk_tb_candidates_submissions_tb_submission_status1_idx` ON `tb_candidates_submissions`(`submission_status_id`) USING BTREE ;

-- ----------------------------
-- Indexes structure for table tb_companies
-- ----------------------------
CREATE INDEX `fk_tb_companies_tb_industries1_idx` ON `tb_companies`(`industry_id`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_companies`
-- ----------------------------
ALTER TABLE `tb_companies` AUTO_INCREMENT=4;

-- ----------------------------
-- Indexes structure for table tb_contacts
-- ----------------------------
CREATE INDEX `fk_tb_contacts_tb_companies_idx` ON `tb_contacts`(`company_id`) USING BTREE ;
CREATE INDEX `fk_tb_contacts_tb_job_positions1_idx` ON `tb_contacts`(`job_position_id`) USING BTREE ;
CREATE INDEX `fk_tb_contacts_tb_sec_users1_idx` ON `tb_contacts`(`tb_sec_users_user_login`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_contacts`
-- ----------------------------
ALTER TABLE `tb_contacts` AUTO_INCREMENT=8;

-- ----------------------------
-- Indexes structure for table tb_experiences
-- ----------------------------
CREATE INDEX `fk_tb_experiences_tb_candidates1_idx` ON `tb_experiences`(`candidate_id`) USING BTREE ;
CREATE INDEX `fk_tb_experiences_tb_companies1_idx` ON `tb_experiences`(`company_id`) USING BTREE ;
CREATE INDEX `fk_tb_experiences_tb_job_positions1_idx` ON `tb_experiences`(`tb_job_positions_position_id`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_experiences`
-- ----------------------------
ALTER TABLE `tb_experiences` AUTO_INCREMENT=2;

-- ----------------------------
-- Auto increment value for `tb_industries`
-- ----------------------------
ALTER TABLE `tb_industries` AUTO_INCREMENT=13;

-- ----------------------------
-- Auto increment value for `tb_job_positions`
-- ----------------------------
ALTER TABLE `tb_job_positions` AUTO_INCREMENT=22;

-- ----------------------------
-- Auto increment value for `tb_req_education`
-- ----------------------------
ALTER TABLE `tb_req_education` AUTO_INCREMENT=8;

-- ----------------------------
-- Auto increment value for `tb_req_status`
-- ----------------------------
ALTER TABLE `tb_req_status` AUTO_INCREMENT=5;

-- ----------------------------
-- Auto increment value for `tb_req_types`
-- ----------------------------
ALTER TABLE `tb_req_types` AUTO_INCREMENT=7;

-- ----------------------------
-- Auto increment value for `tb_req_urgencies`
-- ----------------------------
ALTER TABLE `tb_req_urgencies` AUTO_INCREMENT=4;

-- ----------------------------
-- Indexes structure for table tb_requisitions
-- ----------------------------
CREATE INDEX `fk_requisitions_tb_contacts1_idx` ON `tb_requisitions`(`contact_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_tb_req_status1_idx` ON `tb_requisitions`(`status_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_tb_req_urgencies1_idx` ON `tb_requisitions`(`urgency_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_tb_req_types1_idx` ON `tb_requisitions`(`type_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_tb_req_positions1_idx` ON `tb_requisitions`(`position_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_tb_req_education1_idx` ON `tb_requisitions`(`required_education`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_requisitions`
-- ----------------------------
ALTER TABLE `tb_requisitions` AUTO_INCREMENT=6;

-- ----------------------------
-- Indexes structure for table tb_requisitions_has_benefits
-- ----------------------------
CREATE INDEX `fk_tb_requisitions_has_tb_benefits_tb_benefits1_idx` ON `tb_requisitions_has_benefits`(`benefit_id`) USING BTREE ;
CREATE INDEX `fk_tb_requisitions_has_tb_benefits_tb_requisitions1_idx` ON `tb_requisitions_has_benefits`(`requisition_id`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_sc_log`
-- ----------------------------
ALTER TABLE `tb_sc_log` AUTO_INCREMENT=1;

-- ----------------------------
-- Auto increment value for `tb_sec_groups`
-- ----------------------------
ALTER TABLE `tb_sec_groups` AUTO_INCREMENT=4;

-- ----------------------------
-- Indexes structure for table tb_sec_groups_applications
-- ----------------------------
CREATE INDEX `fk_tb_sec_groups_applications_tb_sec_application_idx` ON `tb_sec_groups_applications`(`tb_sec_applications_id`) USING BTREE ;
CREATE INDEX `fk_tb_sec_groups_applications_tb_sec_groups1_idx` ON `tb_sec_groups_applications`(`tb_sec_groups_group_id`) USING BTREE ;

-- ----------------------------
-- Indexes structure for table tb_sec_users
-- ----------------------------
CREATE INDEX `fk_tb_sec_users_tb_sec_groups1_idx` ON `tb_sec_users`(`tb_sec_groups_group_id`) USING BTREE ;

-- ----------------------------
-- Auto increment value for `tb_submission_status`
-- ----------------------------
ALTER TABLE `tb_submission_status` AUTO_INCREMENT=6;
