PRAGMA foreign_keys = OFF;

-- ----------------------------
-- Table structure for "tbl_agencias"
-- ----------------------------
CREATE TABLE "tbl_agencias" (
"agencod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"bancod"  INTEGER,
"agennome"  VARCHAR(30) COLLATE NOCASE,
"agennumeroagencia"  VARCHAR(18) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_agencias
-- ----------------------------
INSERT INTO "tbl_agencias" VALUES (1, 1, 'Moema', 6543),  (2, 2, 'Vereador José Diniz', 765),  (3, 3, 'Av. Piraporinha', 9847);

-- ----------------------------
-- Table structure for "tbl_bancos"
-- ----------------------------
CREATE TABLE "tbl_bancos" (
"bancod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"bannome"  VARCHAR(50) COLLATE NOCASE,
"bannumerobanco"  VARCHAR(10) COLLATE NOCASE,
"banlogo"  VARCHAR(100) COLLATE NOCASE,
"banseparador"  VARCHAR(100) COLLATE NOCASE,
"bancarteira"  VARCHAR(10) COLLATE NOCASE,
"bancarteirades"  VARCHAR(10) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_bancos
-- ----------------------------
INSERT INTO "tbl_bancos" VALUES (1, 'Banco Itaú S. A.', 341, 'logoitau.jpg', 'separador.JPG', '', ''),  (2, 'Caixa Econômica Federal', 104, 'logocaixa.jpg', 'separador.JPG', '', ''),  (3, 'HSBC Bank Brasil S.A. - Banco Múltiplo', 399, 'logohsbc.jpg', 'separador.JPG', '', '');

-- ----------------------------
-- Table structure for "tbl_composicao_plano"
-- ----------------------------
CREATE TABLE "tbl_composicao_plano" (
"plancod"  INTEGER(11) NOT NULL,
"plancoddest"  INTEGER(11) NOT NULL,
PRIMARY KEY ("plancod", "plancoddest")
);

-- ----------------------------
-- Records of tbl_composicao_plano
-- ----------------------------
INSERT INTO "tbl_composicao_plano" VALUES (1, 2),  (1, 6),  (1, 8),  (5, 6),  (5, 7),  (5, 8),  (9, 6);

-- ----------------------------
-- Table structure for "tbl_configuracoes"
-- ----------------------------
CREATE TABLE "tbl_configuracoes" (
"cod_configuracao"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"tempo_sessao"  INTEGER
);

-- ----------------------------
-- Records of tbl_configuracoes
-- ----------------------------
INSERT INTO "tbl_configuracoes" VALUES (1, 10);

-- ----------------------------
-- Table structure for "tbl_contas_correntes"
-- ----------------------------
CREATE TABLE "tbl_contas_correntes" (
"bancod"  INTEGER(11) NOT NULL,
"agencod"  INTEGER(11) NOT NULL,
"contnumero"  VARCHAR(18) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("bancod", "agencod", "contnumero")
);

-- ----------------------------
-- Records of tbl_contas_correntes
-- ----------------------------
INSERT INTO "tbl_contas_correntes" VALUES (1, 1, 57687678),  (2, 2, 32456879),  (2, 2, 65579878),  (2, 2, 76987809),  (3, 3, 15152398),  (3, 3, 69289279),  (3, 3, 86929269);

-- ----------------------------
-- Table structure for "tbl_empresas"
-- ----------------------------
CREATE TABLE "tbl_empresas" (
"empcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"empcidade"  VARCHAR(30) COLLATE NOCASE,
"estadouf"  VARCHAR(2) COLLATE NOCASE,
"emprazaosocial"  VARCHAR(50) COLLATE NOCASE,
"empnatureza"  VARCHAR(1) COLLATE NOCASE,
"empcpfcnpj"  VARCHAR(14) COLLATE NOCASE,
"empendereco"  VARCHAR(50) COLLATE NOCASE,
"empcep"  VARCHAR(9) COLLATE NOCASE,
"empnumero"  VARCHAR(10) COLLATE NOCASE,
"empcomplemento"  VARCHAR(10) COLLATE NOCASE,
"empbairro"  VARCHAR(25) COLLATE NOCASE,
"empddd"  VARCHAR(3) COLLATE NOCASE,
"emptelefone"  VARCHAR(10) COLLATE NOCASE,
"emptipo"  VARCHAR(1) COLLATE NOCASE,
"empemail"  VARCHAR(70) COLLATE NOCASE,
"emplogo"  VARCHAR(100) COLLATE NOCASE NOT NULL,
"empinscestadual"  VARCHAR(30) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_empresas
-- ----------------------------
INSERT INTO "tbl_empresas" VALUES (1, 'São Paulo', 'SP', 'Empresa Pessoa Física', 'F', 12345678909, 'Avenida  Paulista', 01310000, 12345, 'Fundos', 'Bela Vista', 11, 11111111, 'T', 'teste@teste.com.br', 'logo.JPG', 'ISENTO'),  (2, 'São Paulo', 'SP', 'Empresa Pessoa Jurídica', 'J', 12345678909, 'Avenida  dos Bandeirantes', 04553902, 2200, 'Fundos', 'Vila Olímpia', 21, 21212121, 'F', 'teste@teste.com.br', 'logo.JPG', 'ISENTO');

-- ----------------------------
-- Table structure for "tbl_estados"
-- ----------------------------
CREATE TABLE "tbl_estados" (
"estadouf"  VARCHAR(2) COLLATE NOCASE NOT NULL,
"estadonome"  VARCHAR(25) COLLATE NOCASE,
PRIMARY KEY ("estadouf")
);

-- ----------------------------
-- Records of tbl_estados
-- ----------------------------
INSERT INTO "tbl_estados" VALUES ('AC', 'Acre'),  ('AL', 'Alagoas'),  ('AM', 'Amazonas'),  ('AP', 'Amapá'),  ('BA', 'Bahia'),  ('CE', 'Ceará'),  ('ES', 'Espírito Santo'),  ('GO', 'Goiás'),  ('MA', 'Maranhão'),  ('MG', 'Minas Gerais'),  ('MS', 'Mato Grosso Do Sul'),  ('MT', 'Mato Grosso'),  ('PA', 'Pará'),  ('PB', 'Paraíba'),  ('PE', 'Pernambuco'),  ('PI', 'Piauí'),  ('PR', 'Paraná'),  ('RJ', 'Rio De Janeiro'),  ('RN', 'Rio Grande Do Norte'),  ('RO', 'Rondônia'),  ('RS', 'Rio Grande Do Sul'),  ('SC', 'Santa Catarina'),  ('SE', 'Sergipe'),  ('SP', 'São Paulo'),  ('TO', 'Tocantins');

-- ----------------------------
-- Table structure for "tbl_evento"
-- ----------------------------
CREATE TABLE "tbl_evento" (
"evento_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"evento_titulo"  TEXT COLLATE NOCASE,
"evento_datainicio"  DATE,
"evento_horainicio"  TEXT COLLATE NOCASE,
"evento_datafinal"  DATE,
"evento_horafinal"  TEXT COLLATE NOCASE,
"evento_recorrencia"  VARCHAR(10) COLLATE NOCASE,
"evento_periodo"  VARCHAR(10) COLLATE NOCASE,
"evento_fatcod"  VARCHAR(10) COLLATE NOCASE,
"evento_fatserie"  VARCHAR(10) COLLATE NOCASE,
"evento_orgcod"  VARCHAR(10) COLLATE NOCASE,
"evento_pago"  VARCHAR(10) COLLATE NOCASE,
"evento_reccod"  VARCHAR(10) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_evento
-- ----------------------------
INSERT INTO "tbl_evento" VALUES (5, 'Fatura nº:1 / Parcela nº: 1 de 4 / Valor: R$10000,00', '2012-11-28', null, '2012-11-28', null, 'N', 'D', 1, 1, 2, 'S', 13),  (6, 'Fatura nº:1 / Parcela nº: 2 de 4 / Valor: R$10000,00', '2012-12-28', null, '2012-12-28', null, 'N', 'D', 1, 1, 2, 'S', 14),  (7, 'Fatura nº:1 / Parcela nº: 3 de 4 / Valor: R$10000,00', '2013-01-27', null, '2013-01-27', null, 'N', 'D', 1, 1, 2, null, 15),  (8, 'Fatura nº:1 / Parcela nº: 4 de 4 / Valor: R$10000,00', '2013-02-26', null, '2013-02-26', null, 'N', 'D', 1, 1, 2, null, 16),  (9, 'Fatura nº:2 / Parcela nº: 1 de 2 / Valor: R$5000,00', '2012-11-28', null, '2012-11-28', null, 'N', 'D', 2, 1, 4, 'S', 17),  (10, 'Fatura nº:2 / Parcela nº: 2 de 2 / Valor: R$5000,00', '2012-12-28', null, '2012-12-28', null, 'N', 'D', 2, 1, 4, null, 18),  (21, 'Fatura nº:3 / Parcela nº: 1 de 10 / Valor: R$376,50', '2012-11-30', null, '2012-11-30', null, 'N', 'D', 3, 1, 2, 'S', 29),  (22, 'Fatura nº:3 / Parcela nº: 2 de 10 / Valor: R$376,50', '2012-12-30', null, '2012-12-30', null, 'N', 'D', 3, 1, 2, null, 30),  (23, 'Fatura nº:3 / Parcela nº: 3 de 10 / Valor: R$376,50', '2013-01-29', null, '2013-01-29', null, 'N', 'D', 3, 1, 2, null, 31),  (24, 'Fatura nº:3 / Parcela nº: 4 de 10 / Valor: R$376,50', '2013-02-28', null, '2013-02-28', null, 'N', 'D', 3, 1, 2, null, 32),  (25, 'Fatura nº:3 / Parcela nº: 5 de 10 / Valor: R$376,50', '2013-03-30', null, '2013-03-30', null, 'N', 'D', 3, 1, 2, null, 33),  (26, 'Fatura nº:3 / Parcela nº: 6 de 10 / Valor: R$376,50', '2013-04-29', null, '2013-04-29', null, 'N', 'D', 3, 1, 2, null, 34),  (27, 'Fatura nº:3 / Parcela nº: 7 de 10 / Valor: R$376,50', '2013-05-29', null, '2013-05-29', null, 'N', 'D', 3, 1, 2, null, 35),  (28, 'Fatura nº:3 / Parcela nº: 8 de 10 / Valor: R$376,50', '2013-06-28', null, '2013-06-28', null, 'N', 'D', 3, 1, 2, null, 36),  (29, 'Fatura nº:3 / Parcela nº: 9 de 10 / Valor: R$376,50', '2013-07-28', null, '2013-07-28', null, 'N', 'D', 3, 1, 2, 'S', 37),  (30, 'Fatura nº:3 / Parcela nº: 10 de 10 / Valor: R$376,50', '2013-08-27', null, '2013-08-27', null, 'N', 'D', 3, 1, 2, 'N', 38),  (35, 'Fatura nº:4 / Parcela nº: 1 de 4 / Valor: R$603,00', '2013-08-22', null, '2013-08-22', null, 'N', 'D', 4, 1, 2, null, 43),  (36, 'Fatura nº:4 / Parcela nº: 2 de 4 / Valor: R$603,00', '2013-09-21', null, '2013-09-21', null, 'N', 'D', 4, 1, 2, null, 44),  (37, 'Fatura nº:4 / Parcela nº: 3 de 4 / Valor: R$603,00', '2013-10-21', null, '2013-10-21', null, 'N', 'D', 4, 1, 2, null, 45),  (38, 'Fatura nº:4 / Parcela nº: 4 de 4 / Valor: R$603,00', '2013-11-20', null, '2013-11-20', null, 'N', 'D', 4, 1, 2, null, 46);

-- ----------------------------
-- Table structure for "tbl_evento_pag"
-- ----------------------------
CREATE TABLE "tbl_evento_pag" (
"eventopag_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"eventopag_titulo"  TEXT COLLATE NOCASE,
"eventopag_datainicio"  DATE,
"eventopag_horainicio"  TEXT COLLATE NOCASE,
"eventopag_datafinal"  DATE,
"eventopag_horafinal"  TEXT COLLATE NOCASE,
"eventopag_recorrencia"  VARCHAR(10) COLLATE NOCASE,
"eventopag_periodo"  VARCHAR(10) COLLATE NOCASE,
"eventopag_pagcod"  VARCHAR(10) COLLATE NOCASE,
"eventopag_orgcod"  VARCHAR(10) COLLATE NOCASE,
"eventopag_empcod"  VARCHAR(10) COLLATE NOCASE,
"eventopag_pago"  VARCHAR(10) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_evento_pag
-- ----------------------------
INSERT INTO "tbl_evento_pag" VALUES (1, 'Pagamento cód.:1 / Data de Vencimento: 31-10-2012 / Valor: R$2026,00', '2012-10-31', null, '2012-10-31', null, 'N', 'D', 1, 2, 2, 'S'),  (2, 'Pagamento cód.:2 / Data de Lançamento: 31-10-2012 / Data de Vencimento: 12-11-2012 / Valor: R$20042,00', '2012-11-12', null, '2012-11-12', null, 'N', 'D', 2, 2, 2, 'S'),  (3, 'Pagamento cód.:3 / Data de Lançamento: 23-07-2013 / Data de Vencimento: 02-08-2013 / Valor: R$323,34', '2013-08-02', null, '2013-08-02', null, 'N', 'D', 3, 2, 1, null),  (4, 'Pagamento cód.:4 / Data de Lançamento: 23-07-2013 / Data de Vencimento: 06-09-2013 / Valor: R$1234,45', '2013-09-06', null, '2013-09-06', null, 'N', 'D', 4, 1, 2, null);

-- ----------------------------
-- Table structure for "tbl_faturamento"
-- ----------------------------
CREATE TABLE "tbl_faturamento" (
"fatcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"fatserie"  INTEGER NOT NULL,
"plancod"  INTEGER,
"orgcod"  INTEGER NOT NULL,
"empcod"  INTEGER,
"portcod"  INTEGER,
"fatdtlancamento"  DATE,
"fatvalor"  REAL,
"fataliquotaimposto"  REAL,
"fatvalorimposto"  REAL,
"fatnumeroparcelas"  INTEGER,
"boletobanco"  INTEGER,
"boletoagencia"  INTEGER,
"boletoconta"  INTEGER
);

-- ----------------------------
-- Records of tbl_faturamento
-- ----------------------------
INSERT INTO "tbl_faturamento" VALUES (1, 1, 6, 2, 1, 1, '2012-10-29 13:18:04', 40000.0, 1.0, 400.0, 4, null, null, null),  (2, 1, 2, 1, 1, 1, '2012-10-29 13:47:48', 10000.0, 1.0, 100.0, 2, null, null, null),  (3, 1, 10, 2, 1, 1, '2012-10-31 08:30:46', 3765.0, 1.2, 45.18, 10, null, null, null),  (4, 1, 12, 2, 1, 2, '2013-07-23 16:34:33', 2412.0, 0.002, 0.04, 4, null, null, null);

-- ----------------------------
-- Table structure for "tbl_faturamento_x_itens"
-- ----------------------------
CREATE TABLE "tbl_faturamento_x_itens" (
"fatseq"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"fatcod"  INTEGER NOT NULL,
"fatserie"  INTEGER NOT NULL,
"orgcod"  INTEGER NOT NULL,
"fatvalorunitario"  REAL,
"prodcod"  INTEGER,
"fatqtde"  REAL,
"fatvalortotal"  REAL
);

-- ----------------------------
-- Records of tbl_faturamento_x_itens
-- ----------------------------
INSERT INTO "tbl_faturamento_x_itens" VALUES (3, 1, 1, 2, 20.0, 6, 2000.0, 40000.0),  (4, 2, 1, 1, 100.0, 6, 100.0, 10000.0),  (5, 3, 1, 2, 21.0, 3, 65.0, 1365.0),  (6, 3, 1, 2, 200.0, 4, 12.0, 2400.0),  (7, 4, 1, 2, 456.0, 4, 2.0, 912.0),  (8, 4, 1, 2, 500.0, 3, 3.0, 1500.0);

-- ----------------------------
-- Table structure for "tbl_instrucao_boleto"
-- ----------------------------
CREATE TABLE "tbl_instrucao_boleto" (
"msg_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"msg_instrucao"  TEXT COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_instrucao_boleto
-- ----------------------------
INSERT INTO "tbl_instrucao_boleto" VALUES (1, null),  (2, null),  (3, null),  (4, null);

-- ----------------------------
-- Table structure for "tbl_organizacoes"
-- ----------------------------
CREATE TABLE "tbl_organizacoes" (
"orgcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"orgnome"  VARCHAR(50) COLLATE NOCASE,
"orgcpfcnpj"  VARCHAR(30) COLLATE NOCASE,
"orgnatureza"  VARCHAR(80) COLLATE NOCASE,
"orginscestadual"  VARCHAR(30) COLLATE NOCASE,
"orgendereco"  VARCHAR(200) COLLATE NOCASE,
"orgcep"  VARCHAR(10) COLLATE NOCASE,
"orgcidade"  VARCHAR(50) COLLATE NOCASE,
"orgestado"  VARCHAR(4) COLLATE NOCASE,
"orgrazaosocial"  VARCHAR(50) COLLATE NOCASE,
"orglogo"  VARCHAR(50) COLLATE NOCASE,
"orgbairro"  VARCHAR(50) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_organizacoes
-- ----------------------------
INSERT INTO "tbl_organizacoes" VALUES (1, 'Número 1', 07153627000121, 'Prestação de Serviços', 'ISENTO', 'Rua  Antônio José de Almeida', 04720060, 'São Paulo', 'SP', 'Organização Número Hum', 'logo.JPG', 'Granja Julieta'),  (2, 'NETMAKE', 07153627000121, 'Prestação de Serviços', 'ISENTO', 'R. Dr. Oscavo de Paula e Souza, 92', 04720060, 'São Paulo', 'SP', 'NETMAKE', 'sclogo.jpg', 'Campo Belo'),  (3, 'Netmake', null, null, null, null, null, null, null, null, null, null),  (4, 'Canada Veículos', null, null, null, null, null, null, null, null, null, null);

-- ----------------------------
-- Table structure for "tbl_pagamentos"
-- ----------------------------
CREATE TABLE "tbl_pagamentos" (
"pagcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"bancod"  INTEGER,
"orgcod"  INTEGER NOT NULL,
"empcod"  INTEGER,
"agencod"  INTEGER,
"contnumero"  VARCHAR(18) COLLATE NOCASE,
"plancod"  INTEGER,
"pagdtlancamento"  DATE,
"pagdtvencimento"  DATE,
"pagdtpagamento"  DATE,
"pagvalorprincipal"  REAL,
"pagvalorjuros"  REAL,
"pagvalormora"  REAL,
"pagvalortotal"  REAL
);

-- ----------------------------
-- Records of tbl_pagamentos
-- ----------------------------
INSERT INTO "tbl_pagamentos" VALUES (1, 1, 2, 2, 1, 57687678, 5, '2012-10-29 13:17:11', '2012-10-31 09:17:42', '2012-10-29 14:30:07', 2000.0, 24.0, 2.0, 2026.0),  (2, 2, 2, 2, 2, 32456879, 5, '2012-10-31 08:29:37', '2012-11-12 10:30:12', '2012-10-31 09:48:07', 20000.0, 21.0, 21.0, 20042.0),  (3, 1, 2, 1, 1, 57687678, 5, '2013-07-23 16:31:09', '2013-08-02 11:00:01', null, 321.34, 2.0, 0.0, 323.34),  (4, 3, 1, 2, 3, 69289279, 8, '2013-07-23 16:32:32', '2013-09-06 12:32:46', null, 1234.45, 0.0, 0.0, 1234.45);

-- ----------------------------
-- Table structure for "tbl_planos_contas"
-- ----------------------------
CREATE TABLE "tbl_planos_contas" (
"plancod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"plandescricao"  VARCHAR(50) COLLATE NOCASE,
"plantipo"  VARCHAR(1) COLLATE NOCASE,
"plantotalizadora"  VARCHAR(1) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_planos_contas
-- ----------------------------
INSERT INTO "tbl_planos_contas" VALUES (1, 'CLIENTES', 'C', 'S'),  (2, 'Recebíveis', 'C', 'N'),  (5, 'BANCOS', 'D', 'S'),  (6, 'Brasil', 'C', 'N'),  (7, 'Bradesco', 'C', 'N'),  (8, 'NOSSA CAIXA', 'D', 'N'),  (9, 'TESTE', 'D', 'S'),  (10, 'TESTE DE CRÉDITO', 'C', 'N'),  (11, 'BANCO DO BRASIL', 'C', 'N'),  (12, 'BANCO ITAÚ', 'C', 'N'),  (13, 'CAIXA ECONÔMICA', 'C', 'N'),  (14, 'PLANO DE CREDITO', 'C', 'N');

-- ----------------------------
-- Table structure for "tbl_portadores"
-- ----------------------------
CREATE TABLE "tbl_portadores" (
"portcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"portnome"  VARCHAR(20) COLLATE NOCASE,
"portimpressao"  VARCHAR(1) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_portadores
-- ----------------------------
INSERT INTO "tbl_portadores" VALUES (1, 'Boleto Bancário', 'S'),  (2, 'Cartão Crédito', 'N'),  (5, 'Cartão de Débito', 'N');

-- ----------------------------
-- Table structure for "tbl_produtos"
-- ----------------------------
CREATE TABLE "tbl_produtos" (
"prodcod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"proddesc"  VARCHAR(30) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_produtos
-- ----------------------------
INSERT INTO "tbl_produtos" VALUES (1, 'Desenvolvimento de Sites'),  (3, 'Consultoria Delphi'),  (4, 'Consultoria VB'),  (5, 'Suporte Rede'),  (6, 'Consultoria Visual'),  (7, 'Sistema de BI');

-- ----------------------------
-- Table structure for "tbl_recebimento_x_parcelas"
-- ----------------------------
CREATE TABLE "tbl_recebimento_x_parcelas" (
"reccod"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"recparcela"  VARCHAR(4) COLLATE NOCASE,
"fatcod"  VARCHAR(6) COLLATE NOCASE,
"fatserie"  VARCHAR(3) COLLATE NOCASE,
"orgcod"  INTEGER,
"bancod"  INTEGER,
"agencod"  INTEGER,
"contnumero"  VARCHAR(18) COLLATE NOCASE,
"recdtlancamento"  DATE,
"recdtvencimento"  DATE,
"recdtrecebimento"  DATE,
"recvalorprincipal"  REAL,
"recvalorjuros"  REAL,
"recvalormora"  REAL,
"recvalortotal"  REAL
);

-- ----------------------------
-- Records of tbl_recebimento_x_parcelas
-- ----------------------------
INSERT INTO "tbl_recebimento_x_parcelas" VALUES (13, 1, 1, 1, 2, 2, 2, 65579878, '2012-10-29 00:00:00', '2012-11-28 09:13:54', '2012-10-29 14:32:29', 10000.0, 100.0, 12.0, 10112.0),  (14, 2, 1, 1, 2, 1, 1, 57687678, '2012-10-29 00:00:00', '2012-12-28 10:50:24', '2012-10-29 14:33:33', 10000.0, null, null, 10000.0),  (15, 3, 1, 1, 2, null, null, null, '2012-10-29 14:25:14', '2013-01-27 11:55:10', null, 10000.0, null, null, 10000.0),  (16, 4, 1, 1, 2, null, null, null, '2012-10-29 14:25:14', '2013-02-26 13:12:00', null, 10000.0, null, null, 10000.0),  (17, 1, 2, 1, 4, 1, 1, 57687678, '2012-10-29 00:00:00', '2012-11-28 14:28:54', '2012-10-31 09:45:24', 5000.0, null, null, 5000.0),  (18, 2, 2, 1, 4, null, null, null, '2012-10-29 14:48:01', '2012-12-28 15:06:54', null, 5000.0, null, null, 5000.0),  (29, 1, 3, 1, 2, 3, 3, 69289279, '2012-10-31 00:00:00', '2012-11-30 17:32:05', '2012-10-31 09:45:50', 376.5, 12.0, 1.2, 389.7),  (30, 2, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2012-12-30 23:42:47', null, 376.5, null, null, 376.5),  (31, 3, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-01-29 19:07:40', null, 376.5, null, null, 376.5),  (32, 4, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-02-28 20:13:54', null, 376.5, null, null, 376.5),  (33, 5, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-03-30 16:18:47', null, 376.5, null, null, 376.5),  (34, 6, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-04-29 15:31:25', null, 376.5, null, null, 376.5),  (35, 7, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-05-29 11:11:45', null, 376.5, null, null, 376.5),  (36, 8, 3, 1, 2, null, null, null, '2012-10-31 09:31:24', '2013-06-28 17:45:11', null, 376.5, null, null, 376.5),  (37, 9, 3, 1, 2, 2, 2, 32456879, '2012-10-31 00:00:00', '2013-07-28 18:30:00', '2013-07-23 16:03:23', 376.5, null, null, 376.5),  (38, 10, 3, 1, 2, 2, 2, 32456879, '2012-10-31 00:00:00', '2013-08-27 22:44:25', null, 376.5, null, null, 376.5),  (43, 1, 4, 1, 2, 1, 1, 57687678, '2013-07-23 00:00:00', '2013-08-22 14:27:37', null, 603.0, null, null, 603.0),  (44, 2, 4, 1, 2, 2, 2, 65579878, '2013-07-23 00:00:00', '2013-09-21 21:15:37', null, 603.0, null, null, 603.0),  (45, 3, 4, 1, 2, 1, 1, 57687678, '2013-07-23 00:00:00', '2013-10-21 19:18:17', null, 603.0, null, null, 603.0),  (46, 4, 4, 1, 2, 3, 3, 15152398, '2013-07-23 00:00:00', '2013-11-20 15:21:44', null, 603.0, null, null, 603.0);

-- ----------------------------
-- Table structure for "tbl_sec_apps"
-- ----------------------------
CREATE TABLE "tbl_sec_apps" (
"app_name"  VARCHAR(128) COLLATE NOCASE NOT NULL,
"app_type"  VARCHAR(255) COLLATE NOCASE,
"description"  VARCHAR(255) COLLATE NOCASE,
PRIMARY KEY ("app_name")
);

-- ----------------------------
-- Records of tbl_sec_apps
-- ----------------------------
INSERT INTO "tbl_sec_apps" VALUES ('aba_relacoes_bancarias', 'aba', 'Aba de Relações Bancárias'),  ('blank_boleto_php', 'blank', 'Blank Boleto'),  ('calendar_tbl_evento', 'calendar', 'Agenda de Contas a Receber'),  ('calendar_tbl_evento_pag', 'calendar', 'Agenda de Contas a Receber'),  ('ctr_default', 'contr', 'Controle Flash'),  ('form_tbl_agencias', 'form', 'Cadastro de Agências'),  ('form_tbl_bancos', 'form', 'Cadastro de Bancos'),  ('form_tbl_contas_correntes', 'form', 'Cadastro de Contas Correntes'),  ('form_tbl_empresas', 'form', 'Cadastro de Empresas'),  ('form_tbl_estados', 'form', 'Cadastro de Estados'),  ('form_tbl_faturamento_md', 'form', 'Cadastro de Contas a Receber'),  ('form_tbl_faturamento_x_itens_md', 'form', 'Cadastro de Itens de Fatura'),  ('form_tbl_organizacoes', 'form', 'Cadastro de Organizações'),  ('form_tbl_pagamentos', 'form', 'Cadastro de Contas a Pagar'),  ('form_tbl_planos_contas', 'form', 'Cadastro de Planos de Contas'),  ('form_tbl_portadores', 'form', 'Cadastro de Portadores'),  ('form_tbl_produtos', 'form', 'Cadastro de Produtos'),  ('form_tbl_recebimento_x_parcelas', 'form', 'Gerador de Boleto'),  ('grid_boletos_gerados', 'cons', 'Boletos gerados'),  ('grid_contas_pagar', 'cons', 'Contas a Pagar'),  ('grid_contas_pagar_detalhe', 'cons', 'Detalhe de contas a pagar'),  ('grid_contas_receber', 'cons', 'Contas a Receber'),  ('grid_fluxo_caixa', 'cons', 'Fluxo de Caixa'),  ('grid_fluxo_caixa_detalhe', 'cons', 'Detalhe de fluxo de caixa'),  ('grid_tbl_agencias', 'cons', 'Consulta de Agências'),  ('grid_tbl_bancos', 'cons', 'Consulta de Bancos'),  ('grid_tbl_contas_correntes', 'cons', 'Consulta de Contas Correntes'),  ('grid_tbl_empresas', 'cons', 'Consulta de Empresas'),  ('grid_tbl_estados', 'cons', 'Consulta de Estados'),  ('grid_tbl_faturamento', 'cons', 'Consulta de Faturamento'),  ('grid_tbl_faturamento_x_itens', 'cons', 'Itens de Fatura'),  ('grid_tbl_organizacoes', 'cons', 'Consulta de Organizações'),  ('grid_tbl_pagamentos', 'cons', 'Consulta de Contas a Pagar'),  ('grid_tbl_planos_contas', 'cons', 'Consulta de Planos de Contas'),  ('grid_tbl_portadores', 'cons', 'Consulta de Portadores'),  ('grid_tbl_produtos', 'cons', 'Consulta de Produtos'),  ('grid_tbl_recebimento_x_parcelas', 'cons', 'Consulta de Parcelas Recebidas'),  ('grid_tbl_recebimento_x_parcelas_detalhe', 'cons', 'Detalhe de parcelas'),  ('menu', 'menu', 'Menu'),  ('sec_change_pswd', 'contr', 'Mudar a senha'),  ('sec_form_add_users', 'form', 'Adicionar usuários'),  ('sec_form_edit_users', 'form', 'Editar Usuários'),  ('sec_form_sec_apps', 'form', 'Cadastro de Aplicações'),  ('sec_form_sec_groups', 'form', 'Cadastro de Grupos'),  ('sec_form_sec_groups_apps', 'form', 'Gerenciamento de Grupos/Aplicações'),  ('sec_grid_sec_apps', 'cons', 'Consulta de Aplicações'),  ('sec_grid_sec_groups', 'cons', 'Consulta de Grupos'),  ('sec_grid_sec_users', 'cons', 'Consulta de Usuários'),  ('sec_Login', 'contr', 'Login de Usuário'),  ('sec_retrieve_pswd', 'contr', 'Recuperar Senha'),  ('sec_search_sec_groups', 'filter', 'Pesquisa de Grupos'),  ('sec_sync_apps', 'contr', 'Ressincronizar aplicações');

-- ----------------------------
-- Table structure for "tbl_sec_groups"
-- ----------------------------
CREATE TABLE "tbl_sec_groups" (
"group_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"description"  VARCHAR(64) COLLATE NOCASE
);

-- ----------------------------
-- Records of tbl_sec_groups
-- ----------------------------
INSERT INTO "tbl_sec_groups" VALUES (1, 'Administrador');

-- ----------------------------
-- Table structure for "tbl_sec_groups_apps"
-- ----------------------------
CREATE TABLE "tbl_sec_groups_apps" (
"group_id"  INTEGER(11) NOT NULL,
"app_name"  VARCHAR(128) COLLATE NOCASE NOT NULL,
"priv_access"  VARCHAR(1) COLLATE NOCASE,
"priv_insert"  VARCHAR(1) COLLATE NOCASE,
"priv_delete"  VARCHAR(1) COLLATE NOCASE,
"priv_update"  VARCHAR(1) COLLATE NOCASE,
"priv_export"  VARCHAR(1) COLLATE NOCASE,
"priv_print"  VARCHAR(1) COLLATE NOCASE,
PRIMARY KEY ("group_id", "app_name")
);

-- ----------------------------
-- Records of tbl_sec_groups_apps
-- ----------------------------
INSERT INTO "tbl_sec_groups_apps" VALUES (1, 'aba_relacoes_bancarias', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'blank_boleto_php', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'calendar_tbl_evento', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'calendar_tbl_evento_pag', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'ctr_default', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'form_tbl_agencias', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_bancos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_contas_correntes', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_empresas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_estados', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_faturamento_md', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_faturamento_x_itens_md', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_organizacoes', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_pagamentos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_planos_contas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_portadores', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_produtos', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'form_tbl_recebimento_x_parcelas', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'grid_boletos_gerados', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_contas_pagar', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_contas_pagar_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_contas_receber', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_fluxo_caixa', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_fluxo_caixa_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_agencias', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_bancos', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_contas_correntes', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_empresas', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_estados', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_faturamento', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_faturamento_x_itens', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_organizacoes', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_pagamentos', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_planos_contas', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_portadores', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_produtos', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_recebimento_x_parcelas', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'grid_tbl_recebimento_x_parcelas_detalhe', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'menu', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'sec_change_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'sec_form_add_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'sec_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'sec_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'sec_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'sec_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),  (1, 'sec_grid_sec_apps', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'sec_grid_sec_groups', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'sec_grid_sec_users', 'Y', 'N', 'N', 'N', 'Y', 'Y'),  (1, 'sec_Login', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'sec_retrieve_pswd', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'sec_search_sec_groups', 'Y', 'N', 'N', 'N', 'N', 'N'),  (1, 'sec_sync_apps', 'Y', 'N', 'N', 'N', 'N', 'N');

-- ----------------------------
-- Table structure for "tbl_sec_users"
-- ----------------------------
CREATE TABLE "tbl_sec_users" (
"login"  VARCHAR(32) COLLATE NOCASE NOT NULL,
"pswd"  VARCHAR(32) COLLATE NOCASE NOT NULL,
"name"  VARCHAR(64) COLLATE NOCASE,
"email"  VARCHAR(64) COLLATE NOCASE,
"usr_active"  VARCHAR(1) COLLATE NOCASE,
"activation_code"  VARCHAR(32) COLLATE NOCASE,
"priv_admin"  VARCHAR(1) COLLATE NOCASE,
PRIMARY KEY ("login")
);

-- ----------------------------
-- Records of tbl_sec_users
-- ----------------------------
INSERT INTO "tbl_sec_users" VALUES ('ADMIN', '21232f297a57a5a743894a0e4a801fc3', 'Administrador', 'admin@admin.com', 'Y', 'aDP9$wA!RvNMKsi$znAKO9rNDg2BM6qr', 'Y');

-- ----------------------------
-- Table structure for "tbl_sec_users_groups"
-- ----------------------------
CREATE TABLE "tbl_sec_users_groups" (
"login"  VARCHAR(32) COLLATE NOCASE NOT NULL,
"group_id"  INTEGER(11) NOT NULL,
PRIMARY KEY ("login", "group_id")
);

-- ----------------------------
-- Records of tbl_sec_users_groups
-- ----------------------------
INSERT INTO "tbl_sec_users_groups" VALUES ('ADMIN', 1);

-- ----------------------------
-- Table structure for "tbl_usuario_x_organizacoes"
-- ----------------------------
CREATE TABLE "tbl_usuario_x_organizacoes" (
"orgcod"  INTEGER(11) NOT NULL,
"login"  VARCHAR(20) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("orgcod", "login")
);

-- ----------------------------
-- Records of tbl_usuario_x_organizacoes
-- ----------------------------
INSERT INTO "tbl_usuario_x_organizacoes" VALUES (1, 'ADMIN'),  (2, 'ADMIN'),  (3, 'ADMIN'),  (4, 'ADMIN');
