PRAGMA foreign_keys = OFF;


-- ----------------------------
-- Table structure for tb_users
-- ----------------------------
DROP TABLE IF EXISTS "tb_users";
CREATE TABLE "tb_users" (
"user_login"  varchar(30) COLLATE NOCASE NOT NULL,
"email"  varchar(80) COLLATE NOCASE NOT NULL,
"pswd"  varchar(40) COLLATE NOCASE,
"name"  varchar(50) COLLATE NOCASE,
"active"  varchar(1) COLLATE NOCASE,
"activation_code"  varchar(32) COLLATE NOCASE,
"priv_admin"  integer,
PRIMARY KEY ("user_login")
);

-- ----------------------------
-- Records of tb_users
-- ----------------------------
INSERT INTO "tb_users" VALUES ('administrador', 'admin@scriptcase.com.br', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrador Nacional', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('administrator', 'admin@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrador Internacional', 'Y', '', null);
INSERT INTO "tb_users" VALUES ('carl', 'carl@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Carl', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('chris', 'chris@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Chris Laker', 'Y', '', null);
INSERT INTO "tb_users" VALUES ('estudante', 'student@scriptcase.com.br', '81dc9bdb52d04dc20036dbd8313ed055', 'Estudante', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('instructor', 'instructor@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'instructor', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('instrutor', 'instructor@scriptcase.com.br', '81dc9bdb52d04dc20036dbd8313ed055', 'instrutor', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('robert', 'robert@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Robert', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('student', 'student@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'student International', 'Y', null, null);
INSERT INTO "tb_users" VALUES ('tony', 'tony@scriptcase.net', '81dc9bdb52d04dc20036dbd8313ed055', 'Tony Taner', 'Y', null, null);


-- ----------------------------
-- Table structure for instructors
-- ----------------------------
DROP TABLE IF EXISTS "instructors";
CREATE TABLE "instructors" (
"instructor_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"name"  varchar(40) COLLATE NOCASE,
"email_address"  varchar(60) COLLATE NOCASE,
"phone"  varchar(40) COLLATE NOCASE,
"cell_phone"  varchar(60) COLLATE NOCASE,
"fax"  varchar(60) COLLATE NOCASE,
"address"  varchar(60) COLLATE NOCASE,
"date_created"  datetime,
"date_modified"  datetime,
"user_login"  varchar(30) COLLATE NOCASE,
CONSTRAINT "instructors_IDFK_1" FOREIGN KEY ("user_login") REFERENCES "tb_users" ("user_login")
);

-- ----------------------------
-- Records of instructors
-- ----------------------------
INSERT INTO "instructors" VALUES (3, 'Carl Ferdinand', 'carl@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St. Sunnydale, CA', null, '2017-05-22 17:23:43', 'carl');
INSERT INTO "instructors" VALUES (4, 'Chris Laker', 'support@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St.Sunnydale, CA', null, '2011-12-02 15:51:59', 'chris');
INSERT INTO "instructors" VALUES (5, 'Tony Oshoa', 'support@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St.Sunnydale, CA', null, '2011-12-02 15:52:14', 'instrutor');
INSERT INTO "instructors" VALUES (17, 'Steve Austin', 'instructor@scriptcase.net', '(925) 555-1740', '(925) 555-7301', '', '100 Anytown St.Sunnydale, CA', '2011-08-30 09:06:26', '2012-05-11 15:13:16', 'instructor');


-- ----------------------------
-- Table structure for students
-- ----------------------------
DROP TABLE IF EXISTS "students";
CREATE TABLE "students" (
"student_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"first_name"  varchar(30) COLLATE NOCASE,
"last_name"  varchar(30) COLLATE NOCASE,
"full_name"  varchar(150) COLLATE NOCASE,
"email_address"  varchar(100) COLLATE NOCASE,
"company"  varchar(80) COLLATE NOCASE,
"job_title"  varchar(80) COLLATE NOCASE,
"street_address"  varchar(80) COLLATE NOCASE,
"city"  varchar(80) COLLATE NOCASE,
"state"  varchar(80) COLLATE NOCASE,
"zip"  varchar(80) COLLATE NOCASE,
"country"  varchar(80) COLLATE NOCASE,
"fax"  varchar(40) COLLATE NOCASE,
"phone"  varchar(80) COLLATE NOCASE,
"mobile_phone"  varchar(80) COLLATE NOCASE,
"date_created"  datetime,
"date_modified"  datetime,
"user_login"  varchar(30) COLLATE NOCASE,
"certified_name"  varchar(60) COLLATE NOCASE,
CONSTRAINT "students_ibfk_1" FOREIGN KEY ("user_login") REFERENCES "tb_users" ("user_login")
);

-- ----------------------------
-- Records of students
-- ----------------------------
INSERT INTO "students" VALUES (1, 'Robert', 'Adams', 'Robert Adams', 'radams@scriptcase.net', 'Corellian Engineering Corp', 'CEO', '156 Sleepy Autumn Acres', 'Binghamton', 'New York', 77486, 'USA', '(992) 555-1752', '(992) 555-1963', '(992) 555-1766', null, '2011-08-23 09:23:54', 'robert', null);
INSERT INTO "students" VALUES (2, 'Jonathan', 'Alexander', 'Jonathan Alexander', 'jalexander@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '84 Heather Beacon Arbor', 'Boulder', 'Colorado', 88555, 'USA', '(418) 555-9074', '(418) 555-9349', '(418) 555-6114', null, '2011-08-26 11:28:20', null, null);
INSERT INTO "students" VALUES (3, 'Samuel', 'Allen', 'Samuel Allen', 'sallen@scriptcase.net', 'Wayne Enterprises', 'CTO', '74 Little Bluff Bank', 'Koloa', 'Hawaii', 55867, 'USA', '(147) 555-8806', '(147) 555-9205', '(147) 555-7676', null, null, null, null);
INSERT INTO "students" VALUES (4, 'Andrea', 'Anderson', 'Andrea Anderson', 'aanderson@scriptcase.net', 'Central Services', 'ttt', '198 Indian Brook Bend', 'Brooklyn', 'New York', 26568, 'USA', 'ttt', '(381) 555-4902', '(381) 555-3244', null, null, null, null);
INSERT INTO "students" VALUES (5, 'Larry', 'Andrews', 'Larry Andrews', 'landrews@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '145 Lazy Cloud Canyon', 'Omaha', 'Nebraska', 84741, 'USA', '(744) 555-2928', '(744) 555-7666', '(744) 555-0301', null, null, null, null);
INSERT INTO "students" VALUES (6, 'Eric', 'Armstrong', 'Eric Armstrong', 'earmstrong@scriptcase.net', 'Wayne Enterprises', 'CTO', '57 Ridge Creek Corner', 'Atlanta', 'Georgia', 39804, 'USA', '(268) 555-7706', '(268) 555-3300', '(268) 555-5339', null, null, null, null);
INSERT INTO "students" VALUES (7, 'Thomas', 'Arnold', 'Thomas Arnold', 'tarnold@scriptcase.net', 'Wayne Enterprises', 'IT Manager', '60 Wishing Dale Chase', 'Owego', 'New York', 23177, 'USA', '(993) 555-1179', '(993) 555-7934', '(993) 555-2086', null, null, null, null);
INSERT INTO "students" VALUES (8, 'Juan', 'Austin', 'Juan Austin', 'jaustin@scriptcase.net', 'Blue Sun Corp', 'ttt', '93 Colonial Deer Court', 'Scottsdale', 'Arizona', 45316, 'USA', 'ttt', '(383) 555-7563', '(383) 555-3719', null, null, null, null);
INSERT INTO "students" VALUES (9, 'Sandra', 'Bailey', 'Sandra Bailey', 'sbailey@scriptcase.net', 'Blue Sun Corp', 'ttt', '5 Old Falls Cove', 'Cincinatti', 'Ohio', 47303, 'USA', '(422) 555-4946', '(422) 555-9771', '(422) 555-9743', null, null, null, null);
INSERT INTO "students" VALUES (10, 'Frank', 'Baker', 'Frank Baker', 'fbaker@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '43 Quiet Fox Crest', 'Poipu', 'Hawaii', 36514, 'USA', '(886) 555-3873', '(886) 555-9314', '(886) 555-0390', null, null, null, null);
INSERT INTO "students" VALUES (11, 'Martha', 'Barnes', 'Martha Barnes', 'mbarnes@scriptcase.net', 'Blue Sun Corp', 'Director of Marketing', '106 Pleasant Gate Drive', 'Tuscon', 'Arizona', 3968, 'USA', 'ttt', 'ttt', '(991) 555-0976', null, null, null, null);
INSERT INTO "students" VALUES (12, 'Jerry', 'Bell', 'Jerry Bell', 'jbell@scriptcase.net', 'Blue Sun Corp', 'Vice President of Sales', '13 Fawn Hills Edge', 'Toronto', 'Ontario', 'A47 B12', 'Canada', 'ttt', '(367) 555-7729', '(367) 555-6090', null, null, null, null);
INSERT INTO "students" VALUES (13, 'Cynthia', 'Bennett', 'Cynthia Bennett', 'cbennett@scriptcase.net', 'Mainway Toys', 'Vice President of Sales', '25 Bright Island Estates', 'Phoenix', 'Arizona', 10761, 'USA', '(961) 555-4376', '(961) 555-3772', '(961) 555-5812', null, null, null, null);
INSERT INTO "students" VALUES (14, 'Mark', 'Berry', 'Mark Berry', 'mberry@scriptcase.net', 'Blue Sun Corp', 'ttt', '22 Round Jute Farms', 'Washington, DC', 'District of Columbia', 53020, 'USA', '(983) 555-6278', '(983) 555-0710', '(983) 555-0301', null, null, null, null);
INSERT INTO "students" VALUES (15, 'Steve', 'Black', 'Steve Black', 'sblack@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '66 Silent Lagoon Gardens', 'Brooklyn', 'New York', 13132, 'USA', '(159) 555-2244', '(159) 555-5186', '(159) 555-9582', null, null, null, null);
INSERT INTO "students" VALUES (16, 'Roger', 'Boyd', 'Roger Boyd', 'rboyd@scriptcase.net', 'Wayne Enterprises', 'Manager', '53 Crystal Lake Glen', 'Little Desert Island', 'Maine', 3017, 'USA', '(869) 555-4944', '(869) 555-8956', '(869) 555-1101', null, null, null, null);
INSERT INTO "students" VALUES (17, 'Stephen', 'Bradley', 'Stephen Bradley', 'sbradley@scriptcase.net', 'Oceanic Airlines', 'ttt', '26 Cozy Meadow Grove', 'Boulder', 'Colorado', 58562, 'USA', '(484) 555-7582', '(484) 555-9754', '(484) 555-9375', null, null, null, null);
INSERT INTO "students" VALUES (18, 'Kevin', 'Brooks', 'Kevin Brooks', 'kbrooks@scriptcase.net', 'Mainway Toys', 'CEO', '87 Noble Mountain Hollow', 'Phoenix', 'Arizona', 67001, 'USA', '(103) 555-0460', '(103) 555-7215', '(103) 555-7917', null, null, null, null);
INSERT INTO "students" VALUES (19, 'Robin', 'Brown', 'Robin Brown', 'rbrown@scriptcase.net', 'Blue Sun Corp', 'Vice President of Sales', '172 Cotton Nectar Isle', 'New York', 'New York', 79020, 'USA', 'ttt', '(872) 555-6424', '(872) 555-3517', null, null, null, null);
INSERT INTO "students" VALUES (20, 'Margaret', 'Bryant', 'Margaret Bryant', 'mbryant@scriptcase.net', 'Wayne Enterprises', 'Vice President of Sales', '30 Harvest Oak Jetty', 'Lomax', 'New York', 65039, 'USA', '(622) 555-7880', '(622) 555-1495', '(622) 555-6080', null, null, null, null);
INSERT INTO "students" VALUES (21, 'Adam', 'Burns', 'Adam Burns', 'aburns@scriptcase.net', 'Oceanic Airlines', 'IT Manager', '195 Silver Panda Knoll', 'Fielddale', 'Alabama', 88500, 'USA', '(633) 555-2964', '(633) 555-3763', '(633) 555-2436', null, null, null, null);
INSERT INTO "students" VALUES (22, 'Louise', 'Butler', 'Louise Butler', 'lbutler@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '176 Cinder Pioneer Landing', 'Pleasantville', 'Kansas', 46199, 'USA', '(617) 555-2393', '(617) 555-9545', '(617) 555-7288', null, null, null, null);
INSERT INTO "students" VALUES (23, 'Stephanie', 'Campbell', 'Stephanie Campbell', 'scampbell@scriptcase.net', 'Oceanic Airlines', 'ttt', '7 Green Pond Ledge', 'Borride', 'Arizona', 71270, 'USA', 'ttt', '(492) 555-2640', '(492) 555-5372', null, null, null, null);
INSERT INTO "students" VALUES (24, 'Diana', 'Carpenter', 'Diana Carpenter', 'dcarpenter@scriptcase.net', 'Oceanic Airlines', 'ttt', '13 Tawny Prairie Manor', 'Cheyenne', 'Wyoming', 89557, 'USA', '(596) 555-9049', '(596) 555-4329', '(596) 555-8217', null, null, null, null);
INSERT INTO "students" VALUES (25, 'Kathryn', 'Carroll', 'Kathryn Carroll', 'kcarroll@scriptcase.net', 'Mainway Toys', 'Team Lead', '195 Dewy Quail Nook', 'Marquette', 'Arizona', 78686, 'USA', '(616) 555-3101', 'ttt', '(616) 555-8159', null, null, null, null);
INSERT INTO "students" VALUES (26, 'Douglas', 'Carter', 'Douglas Carter', 'dcarter@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '199 Sunny Race Orchard', 'Plato', 'South Dakota', 29878, 'USA', '(117) 555-8643', '(117) 555-8749', '(117) 555-8674', null, null, null, null);
INSERT INTO "students" VALUES (27, 'Shawn', 'Chavez', 'Shawn Chavez', 'schavez@scriptcase.net', 'Oceanic Airlines', 'ttt', '188 Iron Rustic Park', 'Socrates', 'Arizona', 97915, 'USA', 'ttt', '(500) 555-7366', '(500) 555-9746', null, null, null, null);
INSERT INTO "students" VALUES (28, 'Paula', 'Clark', 'Paula Clark', 'pclark@scriptcase.net', 'Wayne Enterprises', 'ttt', '79 Emerald Rise Path', 'Aristotle', 'Kentucky', 30459, 'USA', '(268) 555-8142', '(268) 555-4128', '(268) 555-9332', null, null, null, null);
INSERT INTO "students" VALUES (29, 'Dennis', 'Cole', 'Dennis Cole', 'dcole@scriptcase.net', 'Central Services', 'IT Manager', '137 Golden River Place', 'Ukulele', 'Hawaii', 74364, 'USA', '(260) 555-4778', '(260) 555-2674', '(260) 555-3009', null, null, null, null);
INSERT INTO "students" VALUES (30, 'Anthony', 'Coleman', 'Anthony Coleman', 'acoleman@scriptcase.net', 'Oceanic Airlines', 'ttt', '69 Stony Sky Point', 'Moraga', 'California', 46097, 'USA', '(275) 555-5490', '(275) 555-5860', '(275) 555-5779', null, null, null, null);
INSERT INTO "students" VALUES (31, 'Frances', 'Collins', 'Frances Collins', 'fcollins@scriptcase.net', 'Wayne Enterprises', 'IT Manager', '92 Misty Spring Run', 'Atlanta', 'Georgia', 29382, 'USA', '(535) 555-2107', '(535) 555-2696', '(535) 555-2941', null, null, null, null);
INSERT INTO "students" VALUES (32, 'Kelly', 'Cook', 'Kelly Cook', 'kcook@scriptcase.net', 'Wayne Enterprises', 'ttt', '26 Rocky Timber Trace', 'Vestal', 'New York', 37057, 'USA', '(891) 555-3822', '(891) 555-7329', '(891) 555-2575', null, null, null, null);
INSERT INTO "students" VALUES (33, 'Carlos', 'Cooper', 'Carlos Cooper', 'ccooper@scriptcase.net', 'Blue Sun Corp', 'HR Admin', '158 Broad Treasure Valley', 'Lafayette', 'California', 74387, 'USA', '(621) 555-4711', '(621) 555-9416', '(621) 555-8027', null, null, null, null);
INSERT INTO "students" VALUES (34, 'Gloria', 'Cox', 'Gloria Cox', 'gcox@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '64 Shady View Vista', 'ttt', 'ttt', 'E32 11A', 'UK', '(619) 555-9077', '(619) 555-7248', '(619) 555-7894', null, null, null, null);
INSERT INTO "students" VALUES (35, 'Lois', 'Crawford', 'Lois Crawford', 'lcrawford@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '2 Hidden Willow Way', 'Annapolis', 'Maryland', 61249, 'USA', '(353) 555-9227', '(353) 555-2169', '(353) 555-4968', null, null, null, null);
INSERT INTO "students" VALUES (36, 'Michelle', 'Cruz', 'Michelle Cruz', 'mcruz@scriptcase.net', 'Blue Sun Corp', 'CEO', '168 Velvet Zephyr Woods', 'Dickson', 'Colorado', 6236, 'USA', 'ttt', '(595) 555-9800', '(595) 555-4486', null, null, null, null);
INSERT INTO "students" VALUES (37, 'Cheryl', 'Cunningham', 'Cheryl Cunningham', 'ccunningham@scriptcase.net', 'Blue Sun Corp', 'Managing Director', '34 Wishing View Landing', 'Vail', 'Colorado', 20019, 'USA', '(993) 555-3093', '(993) 555-5073', '(993) 555-1484', null, null, null, null);
INSERT INTO "students" VALUES (38, 'Patricia', 'Daniels', 'Patricia Daniels', 'pdaniels@scriptcase.net', 'Mainway Toys', 'Director of Marketing', '87 Silver Falls Vista', 'Happy Valley', 'Georgia', 54443, 'USA', '(630) 555-8584', '(630) 555-8010', '(630) 555-2962', null, null, null, null);
INSERT INTO "students" VALUES (39, 'Kathy', 'Davis', 'Kathy Davis', 'kdavis@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '165 Tawny Sky Park', 'Sim City', 'North Carolina', 85333, 'USA', '(321) 555-7403', '(321) 555-6199', '(321) 555-9207', null, null, null, null);
INSERT INTO "students" VALUES (40, 'Albert', 'Diaz', 'Albert Diaz', 'adiaz@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '51 Hidden Island Drive', 'Anne Arundel', 'Maryland', 69840, 'USA', '(811) 555-5296', '(811) 555-9253', '(811) 555-0621', null, null, null, null);
INSERT INTO "students" VALUES (41, 'Mildred', 'Dixon', 'Mildred Dixon', 'mdixon@scriptcase.net', 'Wayne Enterprises', 'Manager', '57 Harvest Brook Cove', 'Fish Cove', 'Maryland', 25470, 'USA', '(343) 555-8995', '(343) 555-3530', '(343) 555-4330', null, null, null, null);
INSERT INTO "students" VALUES (42, 'Peter', 'Duncan', 'Peter Duncan', 'pduncan@scriptcase.net', 'Mainway Toys', 'ttt', '78 Cinder Timber Chase', 'Morganville', 'New York', 99110, 'USA', '(857) 555-2636', '(857) 555-6317', '(857) 555-1451', null, null, null, null);
INSERT INTO "students" VALUES (43, 'Jessica', 'Dunn', 'Jessica Dunn', 'jdunn@scriptcase.net', 'Mainway Toys', 'CTO', '58 Cotton Rise Acres', 'Sagebrush', 'Arizona', 69358, 'USA', 'ttt', '(281) 555-1659', '(281) 555-5061', null, null, null, null);
INSERT INTO "students" VALUES (44, 'Joe', 'Edwards', 'Joe Edwards', 'jedwards@scriptcase.net', 'Blue Sun Corp', 'ttt', '140 Fawn Lake Orchard', 'ttt', 'ttt', 'B29 A10', 'Canada', '(357) 555-2764', 'ttt', '(357) 555-1578', null, null, null, null);
INSERT INTO "students" VALUES (45, 'Alan', 'Elliott', 'Alan Elliott', 'aelliott@scriptcase.net', 'Wayne Enterprises', 'ttt', '100 Dewy Pond Corner', 'Honolulu', 'Hawaii', 83685, 'USA', 'ttt', '(356) 555-7900', '(356) 555-0756', null, null, null, null);
INSERT INTO "students" VALUES (47, 'Willie', 'Evans', 'Willie Evans', 'wevans@scriptcase.net', 'Oceanic Airlines', 'ttt', '17 Lazy River Knoll', 'Annapolis', 'Maryland', 10810, 'USA', '(462) 555-1443', '(462) 555-8858', '(462) 555-8060', null, null, null, null);
INSERT INTO "students" VALUES (49, 'Gary', 'Fisher', 'Gary Fisher', 'gfisher@scriptcase.net', 'Oceanic Airlines', 'Director of Marketing', '75 Velvet Jute Court', 'Storrs', 'Connecticut', 23745, 'USA', '(295) 555-7217', '(295) 555-9304', '(295) 555-3540', null, null, null, null);
INSERT INTO "students" VALUES (50, 'Jeremy', 'Flores', 'Jeremy Flores', 'jflores@scriptcase.net', 'Mainway Toys', 'ttt', '193 Golden Deer Trace', 'Honolulu', 'Hawaii', 9043, 'USA', '(111) 555-6300', '(111) 555-7266', '(111) 555-3872', null, null, null, null);
INSERT INTO "students" VALUES (51, 'Janet', 'Ford', 'Janet Ford', 'jford@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '40 Silent Quail Nook', 'Boot Hill', 'Arizona', 15746, 'USA', 'ttt', '(528) 555-6061', '(528) 555-0859', null, null, null, null);
INSERT INTO "students" VALUES (52, 'Emily', 'Foster', 'Emily Foster', 'efoster@scriptcase.net', 'Oceanic Airlines', 'CEO', '70 Old Mountain Glen', 'New Orleans', 'Louisiana', 35555, 'USA', '(605) 555-2668', '(605) 555-4480', '(605) 555-9617', null, null, null, null);
INSERT INTO "students" VALUES (54, 'Ruby', 'Franklin', 'Ruby Franklin', 'rfranklin@scriptcase.net', 'Central Services', 'Manager', '18 Pleasant Fox Hollow', 'Centralia', 'Washington', 22523, 'USA', '(742) 555-7801', '(742) 555-0731', '(742) 555-9613', null, null, null, null);
INSERT INTO "students" VALUES (55, 'Antonio', 'Freeman', 'Antonio Freeman', 'afreeman@scriptcase.net', 'Oceanic Airlines', 'Team Lead', '106 Emerald Pioneer Valley', 'Marquette', 'Maryland', 14284, 'USA', '(328) 555-1739', '(328) 555-3612', '(328) 555-3165', null, null, null, null);
INSERT INTO "students" VALUES (56, 'Sean', 'Garcia', 'Sean Garcia', 'sgarcia@scriptcase.net', 'Wayne Enterprises', 'ttt', '168 Bright Cloud Point', 'ttt', 'ttt', '393B90', 'France', '(644) 555-4852', '(644) 555-5892', '(644) 555-4185', null, null, null, null);
INSERT INTO "students" VALUES (57, 'Paul', 'Gardner', 'Paul Gardner', 'pgardner@scriptcase.net', 'Wayne Enterprises', 'ttt', '189 Colonial Zephyr Manor', 'Portland', 'Oregon', 31207, 'USA', 'ttt', '(642) 555-4066', '(642) 555-1761', null, null, null, null);
INSERT INTO "students" VALUES (58, 'Peggy', 'Gibson', 'Peggy Gibson', 'pgibson@scriptcase.net', 'Blue Sun Corp', 'CTO', '182 Iron Oak Canyon', 'Hanapepe', 'Hawaii', 88518, 'USA', '(288) 555-0295', '(288) 555-2491', '(288) 555-0542', null, null, null, null);
INSERT INTO "students" VALUES (59, 'Christine', 'Gomez', 'Christine Gomez', 'cgomez@scriptcase.net', 'Blue Sun Corp', 'ttt', '43 Shady Panda Ledge', 'Crab Apple Cove', 'Maine', 27711, 'USA', '(555) 555-4429', '(555) 555-1744', '(555) 555-1876', null, null, null, null);
INSERT INTO "students" VALUES (60, 'Phillip', 'Gonzales', 'Phillip Gonzales', 'pgonzales@scriptcase.net', 'Oceanic Airlines', 'ttt', '94 Sunny Autumn Crest', 'ttt', 'ttt', '123B8', 'France', '(852) 555-1351', '(852) 555-5481', '(852) 555-2275', null, null, null, null);
INSERT INTO "students" VALUES (61, 'Irene', 'Gonzalez', 'Irene Gonzalez', 'igonzalez@scriptcase.net', 'Blue Sun Corp', 'ttt', '146 Broad Willow Jetty', 'Phoenix', 'Arizona', 49462, 'USA', '(457) 555-0743', '(457) 555-3347', '(457) 555-3565', null, null, null, null);
INSERT INTO "students" VALUES (62, 'Beverly', 'Gordon', 'Beverly Gordon', 'bgordon@scriptcase.net', 'Blue Sun Corp', 'IT Manager', '66 Indian Spring Arbor', 'St. Louis', 'Missouri', 34878, 'USA', 'ttt', '(587) 555-3750', '(587) 555-3278', null, null, null, null);
INSERT INTO "students" VALUES (63, 'Arthur', 'Graham', 'Arthur Graham', 'agraham@scriptcase.net', 'Mainway Toys', 'IT Manager', '136 Sleepy Beacon Way', 'Gary', 'Indiana', 66439, 'USA', '(688) 555-4543', '(688) 555-2142', '(688) 555-6829', null, null, null, null);
INSERT INTO "students" VALUES (66, 'Roy', 'Green', 'Roy Green', 'rgreen@scriptcase.net', 'Wayne Enterprises', 'HR Admin', '87 Crystal Nectar Isle', 'Breckenridge', 'Colorado', 39923, 'USA', '(179) 555-1112', '(179) 555-6949', '(179) 555-8520', null, null, null, null);
INSERT INTO "students" VALUES (67, 'Maria', 'Greene', 'Maria Greene', 'mgreene@scriptcase.net', 'Mainway Toys', 'ttt', '62 Rocky Hills Bend', 'ttt', 'ttt', '068 E43', 'Canada', '(379) 555-3342', '(379) 555-7502', '(379) 555-9814', null, null, null, null);
INSERT INTO "students" VALUES (68, 'Angela', 'Griffin', 'Angela Griffin', 'agriffin@scriptcase.net', 'Mainway Toys', 'CEO', '56 Little Creek Farms', 'ttt', 'ttt', 'ttt', 'Brazil', '(284) 555-3826', '(284) 555-1026', '(284) 555-2606', null, null, null, null);
INSERT INTO "students" VALUES (69, 'Jimmy', 'Hall', 'Jimmy Hall', 'jhall@scriptcase.net', 'Blue Sun Corp', 'Team Lead', '166 Quiet Lagoon Place', 'Getier', 'South Carolina', 74237, 'ttt', 'ttt', '(818) 555-8026', '(818) 555-5184', null, null, null, null);
INSERT INTO "students" VALUES (70, 'William', 'Hamilton', 'William Hamilton', 'whamilton@scriptcase.net', 'Wayne Enterprises', 'CTO', '116 Cozy Meadow Grove', 'Scottsdale', 'Arizona', 55619, 'ttt', '(511) 555-7704', 'ttt', '(511) 555-4804', null, null, null, null);
INSERT INTO "students" VALUES (71, 'Donna', 'Harper', 'Donna Harper', 'dharper@scriptcase.net', 'Oceanic Airlines', 'Vice President of Sales', '55 Misty Bluff Estates', 'Oakland', 'California', 1092, 'USA', '(788) 555-7944', '(788) 555-2894', '(788) 555-7265', null, null, null, null);
INSERT INTO "students" VALUES (72, 'Theresa', 'Harris', 'Theresa Harris', 'tharris@scriptcase.net', 'Oceanic Airlines', 'Director of Marketing', '15 Green Race Bank', 'Grosse Pointe', 'Michigan', 'B39 181', 'UK', '(185) 555-6466', '(185) 555-5975', '(185) 555-5771', null, null, null, null);
INSERT INTO "students" VALUES (73, 'Brandon', 'Harrison', 'Brandon Harrison', 'bharrison@scriptcase.net', 'Oceanic Airlines', 'CEO', 'ttt', 'Tuscaloosa', 'Alabama', 75973, 'USA', '(630) 555-8785', '(630) 555-9078', '(630) 555-6192', null, null, null, null);
INSERT INTO "students" VALUES (74, 'Jacqueline', 'Hawkins', 'Jacqueline Hawkins', 'jhawkins@scriptcase.net', 'Oceanic Airlines', 'IT Manager', 'ttt', 'Boise', 'Idaho', 38505, 'USA', '(855) 555-5362', '(855) 555-6291', '(855) 555-3220', null, null, null, null);
INSERT INTO "students" VALUES (75, 'Ashley', 'Hayes', 'Ashley Hayes', 'ahayes@scriptcase.net', 'Mainway Toys', 'ttt', 'ttt', 'ttt', 'ttt', 'D871 123', 'Mexico', '(608) 555-7840', '(608) 555-4588', '(608) 555-4646', null, null, null, null);
INSERT INTO "students" VALUES (76, 'Aaron', 'Henderson', 'Aaron Henderson', 'ahenderson@scriptcase.net', 'Blue Sun Corp', 'VP of Product Management', 'ttt', 'Paige', 'Arizona', 20492, 'USA', 'ttt', '(986) 555-3186', '(986) 555-3595', null, null, null, null);
INSERT INTO "students" VALUES (77, 'Rebecca', 'Henry', 'Rebecca Henry', 'rhenry@scriptcase.net', 'Oceanic Airlines', 'CTO', 'ttt', 'Oklahoma City', 'Oklahoma', 85684, 'USA', '(462) 555-9378', '(462) 555-4370', '(462) 555-6044', null, null, null, null);
INSERT INTO "students" VALUES (78, 'Amy', 'Hernandez', 'Amy Hernandez', 'ahernandez@scriptcase.net', 'Wayne Enterprises', 'CTO', 'ttt', 'ttt', 'ttt', 'ttt', 'Brazil', '(422) 555-2018', 'ttt', '(422) 555-4080', null, null, null, null);
INSERT INTO "students" VALUES (79, 'Tina', 'Hicks', 'Tina Hicks', 'thicks@scriptcase.net', 'Central Services', 'ttt', 'ttt', 'Pittsburgh', 'Pennsylvania', 76035, 'USA', '(912) 555-4755', 'ttt', '(912) 555-4600', null, null, null, null);
INSERT INTO "students" VALUES (80, 'Julie', 'Hill', 'Julie Hill', 'jhill@scriptcase.net', 'Oceanic Airlines', 'CEO', 'ttt', 'Atlanta', 'Georgia', 24401, 'USA', '(768) 555-6340', 'ttt', '(768) 555-2498', null, null, null, null);
INSERT INTO "students" VALUES (103, 'student brasil', 'student brasil', 'student brasil student brasil', 'student@scriptcase.com.br', '', '', '', '', '', '', '', '', '', '', '2011-08-26 17:56:24', '2012-05-11 09:58:51', 'estudante', null);
INSERT INTO "students" VALUES (104, 'student', 'International', 'student International', 'student@scriptcase.net', '', '', '', '', '', '', '', '', '', '', '2011-08-26 17:58:05', null, 'student', null);

-- ----------------------------
-- Table structure for course_catalog
-- ----------------------------
DROP TABLE IF EXISTS "course_catalog";
CREATE TABLE "course_catalog" (
"course_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"course_title"  varchar(60) COLLATE NOCASE,
"course_description"  varchar(300) COLLATE NOCASE,
"course_long_description"  text COLLATE NOCASE,
"course_lenght"  varchar(200) COLLATE NOCASE,
"course_track"  varchar(100) COLLATE NOCASE,
"course_price"  decimal(9,2),
"course_level"  integer,
"date_created"  datetime,
"date_modified"  datetime,
"course_lang"  varchar(2) COLLATE NOCASE,
"course_img"  blob,
"is_displayed"  integer(1) DEFAULT 1
);

-- ----------------------------
-- Records of course_catalog
-- ----------------------------
INSERT INTO "course_catalog" VALUES (2, 'CSR: Customer Service Representative', 'Training Customer Service Representative (CSR) is intended for support center professionals who have direct contact with the client and are responsible for the level of care given.', '<p style="text-align: center;"><span style="font-size: small;">asdasdasdasd</span></p>
<p><span style="font-size: small;">Training Customer Service Representative (CSR) is intended for support center professionals who have direct contact with the client and are responsible for the level of care given.</span></p>
<p><span style="font-size: small;">aaaaaaaaaa</span></p>
<p><span style="font-size: small;">asdasdsadas</span></p>
<p><span style="font-size: small;">dsasadsa</span></p>
<p><span style="font-size: small;">dsadsda</span></p>
<p> </p>', 220, 'HR Essentials', 250.0, 3, null, null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
INSERT INTO "course_catalog" VALUES (3, 'SCA: Support Center Analyst', 'The HDI Support Center Analyst (SCA) is an intensive course designed for technical support and customer service that regardless of the level of knowledge are responsible for the so-called solution.', '', 80, 'Finance', 100.0, 2, null, null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
INSERT INTO "course_catalog" VALUES (4, 'DST: Desktop Support Technician', 'This course proves that professional field support, field support and on site have the ability to support customer service, for service management, as well as master the best practices for providing service and support high quality to customers.', '', 40, 'Business Skills', 80.0, 1, null, null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
INSERT INTO "course_catalog" VALUES (5, 'SCTL: Team Leader Support Center', 'This course is designed for team managers, leaders, coordinators or supervisors Support Centers that need to have leadership skills, learn best practices for managing people, processes, tools and resources from the Support Center as well as understand the value added service in the business', '', 16, 'HR Essentials', 80.0, 2, null, null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
INSERT INTO "course_catalog" VALUES (6, 'Support Center Manager', 'The Support Center Manager course covers in detail the best management practices of a tactical and operational support center. ', '', 4, 'HR Essentials', 25.0, 1, null, null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
INSERT INTO "course_catalog" VALUES (7, 'Customer Phone Skills', 'Or- How not to talk to a customer when a customer talks to you.', '', 10, 'Customer Service Skills', 50.0, 1, null, null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
INSERT INTO "course_catalog" VALUES (8, 'Endomarketing to Service Desk', 'Aimed at directors, managers, coordinators and supervisors of technology that has relationship with the users or any aspects of the business, the workshop Endomarketing for Service Desk is intended to present the benefits of communication in relation to the results obtained by IT to effectively by', '', 4, 'HR Essentials', 50.0, 2, null, null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
INSERT INTO "course_catalog" VALUES (9, 'Improve your typing skills', 'Using the most common tecniques to improve your typing skills.
This course can be attended at your computer.', '', 8, 'Improve your typing skills', 50.0, 1, null, null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
INSERT INTO "course_catalog" VALUES (10, 'Public Speaking', 'Public Speaking, learn how.', '', 40, 'Public Speaking', 100.0, 2, null, null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
INSERT INTO "course_catalog" VALUES (11, 'Scriptcase Certified Expert Course', 'The course objective is to teach how to use Scriptcase capabilities efficiently, applying them to a real development project, from the creation to the project delivery.', '<p>The expert course is a 20 hour online with instructor certificated course divided into 10 modules (2h each module), <br />this course was created to users who want to master the key features of the tool and want to evolve in order to have more development flexibility. <br />The EXPERT course show basic and advanced features of all Scriptcase''s applications (forms, grids, charts, Report PDF, <br />menus, controls, calendar, Dashboards and TAB applications) that be created by Scriptcase and also using additional programming languages and <br />development technologies such as: Javascript, PHP, SQL, AJAX, jQuery and HTML5.</p>
<p><strong>Objective:</strong></p>
<p>The appointment system will allow three type of users (admin, staff, and customer) to schedule and manage paid services. <br />Those services will be attended by an available staff under a customer requirement. <br />The system will also send automatic confirmation emails, print invoices, use the google maps API for navigation, <br />enable all types of charts and management reports and use two different types of schedule calendar.</p>
<p>At the end of the 10th module of this course, the user will have developed a complex appointment system with elaborate and <br />useful features that will elevate their projects to a new level.</p>', '20 hours', 'Expert', 199.5, 3, null, null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


-- ----------------------------
-- Table structure for course_lessons
-- ----------------------------
DROP TABLE IF EXISTS "course_lessons";
CREATE TABLE "course_lessons" (
"lesson_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"lesson_title"  varchar(100) COLLATE NOCASE NOT NULL,
"lesson_text"  text COLLATE NOCASE NOT NULL,
"lesson_video"  varchar(250) COLLATE NOCASE NOT NULL,
"lesson_length"  integer NOT NULL,
"course_id"  integer NOT NULL,
"course_module"  integer NOT NULL,
"lesson_order"  integer NOT NULL,
"lesson_released"  integer NOT NULL DEFAULT 0,
CONSTRAINT "course_lessons_ibfk_1" FOREIGN KEY ("course_id") REFERENCES "course_catalog" ("course_id")
);

-- ----------------------------
-- Records of course_lessons
-- ----------------------------
INSERT INTO "course_lessons" VALUES (1, 'Lesson 1', '<div class="divBorderedGrid">
<h3>What is Scriptcase?</h3>
<p class="text-grid">It''s the best and most efficient web development tool focused on SQL databases (MySQL, Access, Oracle, SQL Server...). A powerful PHP generator to develop systems in a safe and fast way, increasing productivity and reducing costs.</p>
</div>
<div>
<h3>What does it do?</h3>
<p class="text-grid">It helps you to develop web applications in a fast and intuitive way, such as: management reports (Business Intelligence - BI), customizable HTML5 charts, registration forms, users authentication, menus, dashboards and others apps.</p>
</div>
<div>
<h3>How does it work?</h3>
<p class="text-grid">Can be installed in a local network or on the Internet to be accessed by any browser. It allows that multiple developers work on the same project connected to an SQL database. The generated applications are independent from Scriptcase.</p>
</div>', 'https://player.vimeo.com/video/151658834', 15, 2, 1, 0, 1);
INSERT INTO "course_lessons" VALUES (2, 'Lesson 2', '<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque volutpat porta ex et aliquam. Fusce ornare diam sed enim maximus, ac pretium tortor tempus. Fusce dignissim tellus velit, non euismod mi tempor nec. Duis molestie mi risus, vel pharetra purus elementum ac. In in purus eu orci fermentum posuere. Nunc vitae faucibus urna. Nullam at interdum dolor.</span></p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 45, 2, 1, 0, 1);
INSERT INTO "course_lessons" VALUES (3, 'Lesson 3', '<p><span>Mauris mattis quis felis sed venenatis. Maecenas eget lacus hendrerit, tincidunt eros in, auctor elit. Aliquam eleifend volutpat justo. Curabitur hendrerit nulla mi, interdum sodales purus vestibulum at. Proin sem nunc, condimentum nec diam in, fringilla hendrerit arcu. Vestibulum tincidunt, metus ac faucibus placerat, nisi metus pretium mauris, non feugiat orci justo vitae arcu. Morbi enim sapien, facilisis cursus pharetra sit amet, varius eu ipsum. Suspendisse eleifend massa vel neque rutrum finibus. Ut ullamcorper, lorem nec fermentum viverra, arcu erat interdum nunc, et facilisis lectus ex at dolor. Aliquam erat volutpat.</span></p>', '<iframe width="800" height="600" src="https://www.youtube.com/embed/B_6qDlJaFj4?list=PLDMYt0EmYW5xjM9QlY6CaPJJtO89BjYDy" frameborder="0" allowfullscreen></iframe>', 120, 2, 1, 0, 1);
INSERT INTO "course_lessons" VALUES (4, 'Lesson 4', '<p><span>Cras feugiat mauris nunc, ac hendrerit tellus molestie vel. Vestibulum dictum auctor orci, sed maximus tellus rutrum a. Donec non feugiat nunc. Phasellus aliquam leo ac augue varius varius. Proin bibendum lorem at lorem maximus, eu porta tortor volutpat. In vel tortor nisi. Duis bibendum tincidunt orci at ornare. Praesent id lectus pharetra, gravida nisi sed, rutrum est. Nam vehicula consequat neque ut molestie. Praesent eu ligula erat.</span></p>', '<iframe width="800" height="600" src="https://www.youtube.com/embed/B_6qDlJaFj4?list=PLDMYt0EmYW5xjM9QlY6CaPJJtO89BjYDy" frameborder="0" allowfullscreen></iframe>', 25, 2, 2, 0, 1);
INSERT INTO "course_lessons" VALUES (5, 'Lesson 5', '<p><span>Quisque ornare et libero quis pretium. Curabitur orci augue, molestie sit amet rhoncus et, posuere vitae risus. Quisque laoreet erat ac rhoncus ullamcorper. Integer venenatis felis rutrum accumsan aliquam. Phasellus ut imperdiet orci. Phasellus nec nulla varius, commodo lacus eget, tempus urna. Suspendisse suscipit mauris a pharetra auctor. Etiam ac dictum nulla. Suspendisse feugiat ornare mi, sed pharetra eros maximus vestibulum.</span></p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 30, 2, 3, 0, 1);
INSERT INTO "course_lessons" VALUES (6, 'Class 01: Introduction', '<div>In this class we will show a brief introduction about what is Scriptcase, what it does, how it works and its advantages. What the tool needs to run and the difference between development and production environment. </div>
<div> </div>
<div>After the introduction we will give an overview about the Scritpcase''s environment and we will also create our project.</div>
<div> </div>
<div>We will create a form and discuss it''s basics features. In the end we will showcase the data dictionary feature and will give the introduction of the menu application.</div>
<p> </p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 0, 11, 1, 0, 1);
INSERT INTO "course_lessons" VALUES (7, 'Class 02: Grid resources and Master-details Form', '<p><span>In this class we will create and discuss the first grid application, learn how link works and use the master detail feature to make two forms working together at the same screen.</span></p>', 'https://player.vimeo.com/video/151658834', 0, 11, 1, 1, 1);
INSERT INTO "course_lessons" VALUES (8, 'Class 03: Admin Applications', '<div>In this class we will create the admin side applications, this applications include:</div>
<div>- Admin''s appointments report</div>
<div>- Form to create, schedule and calculate the appointment services cost automatically.</div>', '<iframe src="https://player.vimeo.com/video/151658834" width="500" height="281" frameborder="0"  webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true"></iframe>', 0, 11, 1, 2, 1);
INSERT INTO "course_lessons" VALUES (9, 'Q & A 1', '', 'https://player.vimeo.com/video/151658834', 2, 11, 1, 4, 1);
INSERT INTO "course_lessons" VALUES (10, 'Class 04: Customer Applications', '<p><span>The customer will select in a list what services he needs to schedule, the request will be generated by the RUN button and redirect the customer to a form to select the date and time of the appointment, after he selects, he will be redirected to the report with all his appointments.  </span></p>', 'https://player.vimeo.com/video/151658834', 0, 11, 1, 3, 1);
INSERT INTO "course_lessons" VALUES (11, 'Class 05: Staff Applications', '<p><span>The staff will have two options to follow up his own appointments, using a report application with filters and group by or a calendar showing his appointments. To proceed with an appointment the Staff is able to check a google maps app with the customer’s address.  </span></p>', 'https://player.vimeo.com/video/151658834', 0, 11, 2, 0, 1);
INSERT INTO "course_lessons" VALUES (12, 'Class 06: Buttons and Links', '<div>In this class we will create a user defined report with a custom HTML template in order to show a billing summary for the customer.</div>
<div> </div>
<div>We are also creating some apps that will complete the system usage in general, apps to: Show the appointments history, details and rate.</div>
<div> </div>
<div>We can''t forget about a report that will be used by the admin, staff and customer to perform all types of actions on a specific appointment.</div>', 'https://player.vimeo.com/video/151658834', 2, 11, 2, 1, 1);
INSERT INTO "course_lessons" VALUES (13, 'Class 07: Tab, Dashboard and Calendar', '<p><span>On this class we are going to create a set of applications used to exhibit other applications, we are also going to create a dashboard to show 4 apps at the same time, this app will be used as home to the admin.</span></p>', 'https://player.vimeo.com/video/151658834', 2, 11, 2, 2, 1);
INSERT INTO "course_lessons" VALUES (14, 'Q & A 2', '', 'https://player.vimeo.com/video/151658834', 2, 11, 3, 1, 1);
INSERT INTO "course_lessons" VALUES (15, 'Class 8: Calendar and Security', '<div>We will create a calendar application using our own coding in a blank application using the ‘my calendar’ API from Scriptcase and we will use the form_appointments to helps us to maintain the data in the application </div>
<div> </div>
<div>The Scriptcase’s security module Will handle all the access control to your system, not only the access but what apps and what actions the end user may do with the app. </div>', 'https://player.vimeo.com/video/151658834', 2, 11, 3, 0, 1);
INSERT INTO "course_lessons" VALUES (16, 'Extra Class - Login Screen', '', 'https://player.vimeo.com/video/151658834', 0, 11, 3, 10, 0);
INSERT INTO "course_lessons" VALUES (17, 'ABC', '<p>Ut eu nulla vel eros porttitor imperdiet. Mauris porta lacus nulla, ut molestie neque cursus vel. Fusce pulvinar sollicitudin tortor, vitae faucibus leo dignissim ac. Sed efficitur, nisi in venenatis iaculis, velit arcu posuere ante, a pellentesque risus nisl non tortor. Quisque in tincidunt augue. Praesent lacinia felis id nibh tincidunt condimentum. Morbi iaculis dapibus diam, id fringilla leo vulputate at. Sed laoreet tempus malesuada.</p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 0, 3, 1, 0, 1);
INSERT INTO "course_lessons" VALUES (18, 'Lesson 6', '<p><span>Quisque enim ante, euismod vel quam eget, rhoncus fermentum tellus. Nullam interdum, nisi eget tincidunt dictum, erat eros pretium nunc, sed posuere ipsum purus eu tortor. Duis elementum justo ut magna dapibus, ac commodo metus volutpat. Quisque at lorem urna. Proin fermentum condimentum quam, sed posuere dui feugiat a. Aenean mollis placerat nunc eu porttitor. Nunc iaculis enim sem. Nam pellentesque suscipit ullamcorper. Quisque semper quis ex eu fringilla. Nulla vehicula lobortis massa, ac porttitor nulla mattis sit amet. Fusce malesuada nisl quis tortor fermentum, eget tincidunt justo semper. Phasellus in lorem vestibulum, aliquet arcu eget, mattis felis. Sed justo nunc, finibus nec efficitur quis, consectetur ut ante. Aliquam eu nisl libero. Aliquam erat volutpat. Integer vel leo sed magna hendrerit tempor eleifend sed diam.</span></p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 0, 2, 1, 1, 0);
INSERT INTO "course_lessons" VALUES (19, 'Lesson 7', '<p><span>Ut eu nulla vel eros porttitor imperdiet. Mauris porta lacus nulla, ut molestie neque cursus vel. Fusce pulvinar sollicitudin tortor, vitae faucibus leo dignissim ac. Sed efficitur, nisi in venenatis iaculis, velit arcu posuere ante, a pellentesque risus nisl non tortor. Quisque in tincidunt augue. Praesent lacinia felis id nibh tincidunt condimentum. Morbi iaculis dapibus diam, id fringilla leo vulputate at. Sed laoreet tempus malesuada.</span></p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 0, 2, 2, 2, 0);
INSERT INTO "course_lessons" VALUES (20, 'Lesson 8', '<p><span>In consectetur purus eget nulla faucibus ultricies. Integer volutpat mi nec blandit iaculis. Donec pretium, purus quis suscipit laoreet, velit libero pharetra elit, ut porta sem odio at odio. Curabitur pretium, nibh id dapibus aliquet, nisl urna placerat nulla, vitae lobortis mi magna sit amet quam. Maecenas at dui quis mauris malesuada vulputate. Pellentesque ut ipsum risus. Curabitur quis tristique purus. Proin vehicula dictum erat sit amet porta. Ut sit amet hendrerit sapien.</span></p>', 'https://www.youtube.com/embed/63DpNWWfWsE', 0, 2, 3, 3, 0);
INSERT INTO "course_lessons" VALUES (21, 'Lesson 9', '<p><span>Nam lectus elit, maximus id enim sit amet, fringilla pulvinar risus. Sed pellentesque vel augue vitae lacinia. Fusce non porttitor enim. Mauris eget mollis lacus. Sed mollis tortor ac arcu fringilla, in pulvinar diam venenatis. Fusce et arcu velit. Phasellus quis consectetur erat, pulvinar venenatis metus. Suspendisse sodales justo non libero sollicitudin dapibus. Fusce sit amet libero in diam hendrerit cursus. Donec consectetur facilisis varius. Nullam urna quam, iaculis eu placerat ac, porttitor dictum risus. Vivamus bibendum elementum massa, sit amet eleifend odio congue eu. Praesent accumsan sapien eget semper laoreet. Vestibulum eu metus nunc. Nullam sit amet sodales odio, quis porttitor diam. Nunc semper ac tortor quis lacinia.</span></p>', '<iframe src="https://player.vimeo.com/video/151658834" width="500" height="281" frameborder="0"  webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true"></iframe>', 0, 2, 4, 4, 0);
INSERT INTO "course_lessons" VALUES (22, 'Lesson 10', '<p><span>Phasellus euismod nunc sed tincidunt pharetra. Aenean ut venenatis dolor, quis faucibus elit. Fusce sit amet auctor mauris. Donec a rhoncus neque, sit amet viverra leo. Vestibulum at turpis placerat, tincidunt nisl nec, tincidunt est. Nam pretium eros et justo ornare, rutrum bibendum massa finibus. Donec non turpis vestibulum, facilisis tellus vel, dictum nisl. Donec vel leo auctor, dictum magna in, dictum leo. Cras quis lorem sit amet arcu porta sollicitudin et non neque. Vestibulum vehicula sapien risus, id varius mauris cursus sed. Morbi eu velit consequat purus fringilla sodales. Phasellus sit amet nisl dictum, euismod tellus at, convallis massa. In eget vestibulum nibh. Aenean volutpat est eget interdum lobortis. Duis vitae porta sem.</span></p>', '<iframe src="https://player.vimeo.com/video/151658834" width="500" height="281" frameborder="0"  webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true"></iframe>', 0, 2, 5, 5, 0);

-- ----------------------------
-- Table structure for classes
-- ----------------------------
DROP TABLE IF EXISTS "classes";
CREATE TABLE "classes" (
"class_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"course_id"  integer NOT NULL,
"instructor_id"  integer NOT NULL,
"class_size"  integer,
"class_status"  integer,
"confirmed_reservations"  integer,
"start_date"  date DEFAULT NULL,
"start_time"  time DEFAULT NULL,
"end_date"  date DEFAULT NULL,
"end_time"  time DEFAULT NULL,
"pending_reservations"  integer DEFAULT NULL,
"class_information"  varchar(200) COLLATE NOCASE,
"date_created"  datetime DEFAULT NULL,
"date_modified"  datetime DEFAULT NULL,
CONSTRAINT "classes_ibfk_1" FOREIGN KEY ("instructor_id") REFERENCES "instructors" ("instructor_id"),
CONSTRAINT "classes_ibfk_2" FOREIGN KEY ("course_id") REFERENCES "course_catalog" ("course_id")
);

-- ----------------------------
-- Records of classes
-- ----------------------------
INSERT INTO "classes" VALUES (1, 4, 4, 10, 1, 0, '2017-01-02', '10:00:00', '2017-01-31', '12:00:00', 1, 'Yearly Insider Trading: 10-01-2010, 10:00 am-Newton Conference Room', null, null);
INSERT INTO "classes" VALUES (2, 2, 5, 15, 1, 2, '2017-01-04', '10:00:00', '2017-01-08', '12:00:00', 3, 'SOX Compliance: 10-05-2010, 9:00 am-Peter Lacrosse Field', null, null);
INSERT INTO "classes" VALUES (3, 3, 4, 13, 1, 1, '2017-01-15', '14:00:00', '2017-02-15', '16:00:00', 0, 'Building a Perfect Presentation: 10-11-2010, 9:00 am-Amys Hotel and Casino', null, null);
INSERT INTO "classes" VALUES (4, 2, 17, 15, 1, 3, '2017-05-04', '10:00:00', '2017-05-08', '12:00:00', 0, 'Acronyms, the Organization and You: 10-07-2010, 10:00 am-Bills Windsurf Shop', null, '2017-06-12 14:57:13');
INSERT INTO "classes" VALUES (5, 3, 3, 100, 1, 0, '2017-02-04', '10:00:00', '2017-02-08', '12:00:00', 1, 'Sexual Harrassment - Just Say No:', null, null);
INSERT INTO "classes" VALUES (6, 6, 17, 20, 1, 0, '2017-04-18', '10:00:00', '2017-04-22', '12:00:00', 1, 'Sexual Harrassment - Just Say No: 12-04-2010, 9:00 am-Eric Stadium', null, null);
INSERT INTO "classes" VALUES (7, 3, 4, 15, 1, 0, '2017-03-18', '14:00:00', '2017-04-18', '16:00:00', 0, 'Just an insetion test!!', null, null);
INSERT INTO "classes" VALUES (8, 4, 5, 20, 1, 0, '2017-05-25', '10:00:00', '2017-05-29', '12:00:00', 1, 'This is our first class in how to create a perfect presentation, dont miss it.', null, null);
INSERT INTO "classes" VALUES (9, 5, 17, 30, 1, 0, '2017-05-25', '10:00:00', '2017-05-29', '12:00:00', 0, 'Just an insertion test!', null, null);
INSERT INTO "classes" VALUES (10, 7, 17, 25, 1, 0, '2017-05-25', '14:00:00', '2017-05-29', '16:00:00', 0, 'Just some lessons about phone skills, don''t miss it.', null, null);
INSERT INTO "classes" VALUES (11, 6, 4, 20, 1, 0, '2017-05-25', '10:00:00', '2017-06-29', '12:00:00', 0, 'Some sport lessons for young children.', null, null);
INSERT INTO "classes" VALUES (12, 8, 17, 15, 1, 0, '2017-06-01', '10:00:00', '2017-06-30', '12:00:00', 0, 'How to use MySQL', null, '2017-06-12 14:56:31');
INSERT INTO "classes" VALUES (13, 3, 5, 15, 1, 0, '2017-07-01', '10:00:00', '2017-07-30', '12:00:00', 0, 'Advanced PHP', null, null);
INSERT INTO "classes" VALUES (14, 3, 4, 50, 1, 0, '2017-08-01', '10:00:00', '2017-08-05', '12:00:00', 0, 'Project Management with PMBOK', null, '2017-06-07 08:45:55');
INSERT INTO "classes" VALUES (15, 8, 3, 30, 1, 0, '2017-08-10', '12:00:00', '2017-08-30', '16:00:00', 0, 'Helping you to inprove your helpdesk skills', null, '2017-06-07 08:46:11');
INSERT INTO "classes" VALUES (16, 9, 17, 60, 1, 0, '2017-09-01', '12:00:00', '2017-09-15', '14:00:00', 0, 'Don''t be late!', null, null);
INSERT INTO "classes" VALUES (17, 2, 17, 10, 1, 0, '2017-10-04', '09:00:00', '2017-10-16', '12:00:00', 0, '', null, '2017-06-12 14:52:41');
INSERT INTO "classes" VALUES (18, 2, 3, 10, 1, 0, '2017-03-20', '09:00:00', '2017-04-19', '12:00:00', 0, '', null, null);
INSERT INTO "classes" VALUES (19, 11, 17, 50, 1, 0, '2017-07-01', '10:00:00', '2017-12-30', '12:00:00', 0, '', null, null);
INSERT INTO "classes" VALUES (20, 2, 4, 100, 1, 0, '2017-11-01', '11:11:00', '2017-12-22', '11:11:00', 0, '', null, null);
INSERT INTO "classes" VALUES (21, 5, 3, 100, 1, 0, '2017-01-15', '14:00:00', '2017-02-15', '16:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (22, 7, 3, 20, 1, 0, '2017-06-01', '10:00:00', '2017-06-30', '12:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (23, 9, 5, 100, 1, 0, '2017-01-15', '10:00:00', '2017-03-15', '12:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (24, 10, 3, 100, 1, 0, '2017-04-15', '10:00:00', '2017-07-15', '12:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (25, 11, 5, 100, 1, 0, '2017-01-01', '10:00:00', '2017-06-30', '12:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (26, 10, 4, 30, 1, 0, '2017-01-15', '10:00:00', '2017-03-15', '12:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (27, 11, 3, 100, 1, 0, '2017-01-01', '14:00:00', '2017-06-30', '16:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (28, 11, 4, 50, 1, 0, '2017-07-01', '14:00:00', '2017-12-30', '16:00:00', 0, null, null, null);
INSERT INTO "classes" VALUES (29, 4, 5, 20, 1, 0, '2017-06-25', '10:00:00', '2017-06-29', '12:00:00', 1, null, null, null);


-- ----------------------------
-- Table structure for classes_lessons
-- ----------------------------
DROP TABLE IF EXISTS "classes_lessons";
CREATE TABLE "classes_lessons" (
"class_id"  integer NOT NULL,
"lesson_id"  integer NOT NULL,
PRIMARY KEY ("class_id", "lesson_id"),
CONSTRAINT "classes_lessons_ibfk_1" FOREIGN KEY ("class_id") REFERENCES "classes" ("class_id"),
CONSTRAINT "classes_lessons_ibfk_2" FOREIGN KEY ("lesson_id") REFERENCES "course_lessons" ("lesson_id")
);

-- ----------------------------
-- Records of classes_lessons
-- ----------------------------
INSERT INTO "classes_lessons" VALUES (2, 3);
INSERT INTO "classes_lessons" VALUES (2, 4);
INSERT INTO "classes_lessons" VALUES (3, 17);
INSERT INTO "classes_lessons" VALUES (4, 1);
INSERT INTO "classes_lessons" VALUES (4, 2);
INSERT INTO "classes_lessons" VALUES (4, 3);
INSERT INTO "classes_lessons" VALUES (4, 4);
INSERT INTO "classes_lessons" VALUES (4, 5);
INSERT INTO "classes_lessons" VALUES (5, 17);
INSERT INTO "classes_lessons" VALUES (7, 17);
INSERT INTO "classes_lessons" VALUES (13, 17);
INSERT INTO "classes_lessons" VALUES (14, 17);
INSERT INTO "classes_lessons" VALUES (17, 1);
INSERT INTO "classes_lessons" VALUES (17, 2);
INSERT INTO "classes_lessons" VALUES (17, 3);
INSERT INTO "classes_lessons" VALUES (17, 4);
INSERT INTO "classes_lessons" VALUES (17, 5);
INSERT INTO "classes_lessons" VALUES (18, 1);
INSERT INTO "classes_lessons" VALUES (18, 2);
INSERT INTO "classes_lessons" VALUES (18, 3);
INSERT INTO "classes_lessons" VALUES (19, 6);
INSERT INTO "classes_lessons" VALUES (19, 7);
INSERT INTO "classes_lessons" VALUES (19, 8);
INSERT INTO "classes_lessons" VALUES (19, 9);
INSERT INTO "classes_lessons" VALUES (19, 10);
INSERT INTO "classes_lessons" VALUES (19, 11);
INSERT INTO "classes_lessons" VALUES (19, 12);
INSERT INTO "classes_lessons" VALUES (19, 13);

-- ----------------------------
-- Table structure for classes_threads
-- ----------------------------
DROP TABLE IF EXISTS "classes_threads";
CREATE TABLE "classes_threads" (
"thread_id"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
"thread_title"  varchar(100) COLLATE NOCASE NOT NULL,
"thread_text"  text COLLATE NOCASE NOT NULL,
"class_id"  integer NOT NULL,
"user_login"  varchar(30) COLLATE NOCASE,
"thread_above"  integer,
"thread_public"  tinyint(1) NOT NULL DEFAULT 0,
"thread_datetime"  datetime NOT NULL,
CONSTRAINT "classes_threads_ibfk_1" FOREIGN KEY ("class_id") REFERENCES "classes" ("class_id"),
CONSTRAINT "classes_threads_ibfk_2" FOREIGN KEY ("thread_above") REFERENCES "classes_threads" ("thread_id"),
CONSTRAINT "classes_threads_ibfk_3" FOREIGN KEY ("user_login") REFERENCES "tb_users" ("user_login")
);




-- ----------------------------
-- Records of classes_threads
-- ----------------------------
INSERT INTO "classes_threads" VALUES (2, 'I need help', '<p>I have a question: What is lorem Ipsum?</p>', 17, 'estudante', null, 1, '2016-12-22 10:55:48');
INSERT INTO "classes_threads" VALUES (3, 'When will release the next lesson?', '<p>When will release the next lesson?</p>', 17, 'estudante', null, 1, '2016-12-22 11:00:27');
INSERT INTO "classes_threads" VALUES (4, 'Password', '<p>I lost my password. What can I do?</p>', 17, 'estudante', null, 0, '2016-12-22 11:00:42');
INSERT INTO "classes_threads" VALUES (5, 'What you need to know', '<p>Lorem Ipsum is Sed vel turpis magna.</p>', 17, 'estudante', 2, 1, '2016-12-22 11:04:10');
INSERT INTO "classes_threads" VALUES (6, 'Ok', '<p>It is good to know. Thank you.</p>', 17, 'estudante', 2, 1, '2016-12-22 11:05:04');
INSERT INTO "classes_threads" VALUES (7, 'Answer 3', '<p>It is good to know. Thank you.</p>', 17, 'estudante', 3, 1, '2016-12-22 11:05:33');
INSERT INTO "classes_threads" VALUES (8, 'A new Thread', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In porta, dui in dictum porta, metus metus porta velit, id laoreet tortor augue quis lorem. Quisque iaculis purus at tellus dictum lobortis. Curabitur mauris velit, iaculis in est sit amet, imperdiet maximus dui. Curabitur ornare ex ex, nec tempus justo porttitor sed. Maecenas tincidunt orci vel lacus blandit luctus. Etiam efficitur mollis laoreet. Maecenas iaculis nibh a tempus pretium.</p>', 17, 'student', null, 1, '2016-12-23 14:04:05');
INSERT INTO "classes_threads" VALUES (10, 'answer 3 thread 2', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In porta, dui in dictum porta, metus metus porta velit, id laoreet tortor augue quis lorem. Quisque iaculis purus at tellus dictum lobortis. Curabitur mauris velit, iaculis in est sit amet, imperdiet maximus dui. Curabitur ornare ex ex, nec tempus justo porttitor sed. Maecenas tincidunt orci vel lacus blandit luctus. Etiam efficitur mollis laoreet. Maecenas iaculis nibh a tempus pretium.</p>', 17, 'student', 2, 1, '2016-12-28 11:26:08');
INSERT INTO "classes_threads" VALUES (11, 'classe 17 contacts', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In porta, dui in dictum porta, metus metus porta velit, id laoreet tortor augue quis lorem. Quisque iaculis purus at tellus dictum lobortis. Curabitur mauris velit, iaculis in est sit amet, imperdiet maximus dui. Curabitur ornare ex ex, nec tempus justo porttitor sed. Maecenas tincidunt orci vel lacus blandit luctus. Etiam efficitur mollis laoreet. Maecenas iaculis nibh a tempus pretium.</p>', 17, 'student', null, 1, '2016-12-28 11:38:26');
INSERT INTO "classes_threads" VALUES (12, 'classe 17', '<p>Sed vel turpis magna. Curabitur ut ornare nulla, eu pretium velit. Vivamus vel mauris orci. In hendrerit ultrices turpis, eu venenatis leo scelerisque eget. Quisque nec nulla volutpat, vulputate nulla vitae, convallis risus. Aenean viverra, orci et tempor congue, erat orci sagittis augue, id fringilla felis diam blandit mauris. Ut ac sem facilisis, pulvinar enim quis, ultricies diam. Aenean in arcu molestie, ornare nunc et, laoreet lectus. Quisque vel diam nisi. Sed augue lectus, laoreet id lectus sit amet, ornare sodales nunc. Ut vestibulum arcu velit, in porta massa lobortis at. Vestibulum orci felis, ultrices quis lacus eget, feugiat dictum magna. Nullam cursus, lectus non posuere vehicula, ante nisl egestas odio, vitae mattis nisi quam eget lectus.</p>', 17, 'student', 11, 1, '2016-12-28 11:40:36');
INSERT INTO "classes_threads" VALUES (13, 'answer', '<p>Fusce facilisis, lorem vel hendrerit vestibulum, nisl velit dignissim arcu, a tincidunt metus leo in velit. Integer eget turpis nibh. Suspendisse a dolor eu neque euismod consequat id et eros. Vivamus fringilla tempor volutpat. Integer bibendum a turpis quis efficitur. Cras est est, vehicula sed dui eget, ultrices lacinia sapien. Phasellus sagittis sapien vitae fringilla mattis. Suspendisse posuere lacinia sapien, vel congue sem iaculis quis. Phasellus fermentum dui dui, quis interdum libero bibendum eu. Sed dapibus urna et diam euismod, blandit vehicula justo accumsan.</p>', 17, 'student', 11, 1, '2016-12-28 11:54:11');
INSERT INTO "classes_threads" VALUES (14, 'What is the best lesson?', '<p>What is the best lesson of this course?</p><p>I loved the lesson 5</p>', 5, 'robert', null, 1, '2016-12-28 13:39:46');
INSERT INTO "classes_threads" VALUES (15, 4, '<p>The 4 is better.</p>', 5, 'student', 14, 1, '2016-12-28 13:40:21');
INSERT INTO "classes_threads" VALUES (17, 'My contact', '<p>Donec non felis id est aliquam malesuada id quis neque. Vivamus eleifend mollis congue. Sed neque turpis, feugiat ut auctor et, ultricies quis erat. Phasellus mollis feugiat tincidunt. Pellentesque laoreet mi a volutpat faucibus. In hac habitasse platea dictumst. Donec quis risus nec libero pharetra elementum. Nunc consequat tempus quam eget malesuada. Nunc tempor urna in leo laoreet, sit amet tincidunt quam vehicula. Sed faucibus justo nec faucibus scelerisque.</p>', 17, 'estudante', 11, 1, '2016-12-28 16:02:44');
INSERT INTO "classes_threads" VALUES (19, 'agree', '<p>I agree with Student</p>', 5, 'estudante', 14, 1, '2016-12-30 08:53:25');
INSERT INTO "classes_threads" VALUES (21, 'Private topic', '<p>What do you think about...?</p>', 5, 'student', null, 0, '2016-12-30 10:13:15');
INSERT INTO "classes_threads" VALUES (22, 'Error in lesson 2', '<p>The document 4 is missing.</p>', 5, 'student', null, 0, '2016-12-30 10:14:55');
INSERT INTO "classes_threads" VALUES (23, 'answer private', '<p>Ok I will try.</p>', 5, 'student', 21, 0, '2016-12-30 10:17:33');
INSERT INTO "classes_threads" VALUES (30, 'Documents', '<p>I couldn''t download the document 5 and 7.</p>', 2, 'estudante', null, 1, '2017-01-07 09:23:27');
INSERT INTO "classes_threads" VALUES (31, 'About that?', '<p>What can I do about that error?</p>', 2, 'estudante', null, 0, '2017-01-07 09:24:47');
INSERT INTO "classes_threads" VALUES (32, 'Lesson 3', '<p>The lesson 3 was great!</p>', 2, 'estudante', null, 1, '2017-01-07 09:26:00');
INSERT INTO "classes_threads" VALUES (33, 'Anyone', '<p>Anyone else?</p>', 2, 'estudante', 30, 1, '2017-01-07 09:28:20');
INSERT INTO "classes_threads" VALUES (34, 'Answer', '<p>Please, follow the steps.</p>', 2, 'administrator', 31, 0, '2017-01-25 11:41:39');
INSERT INTO "classes_threads" VALUES (35, 'ok', '<p>answering this ask...</p>', 17, 'administrator', 4, 0, '2017-01-27 11:12:49');
INSERT INTO "classes_threads" VALUES (37, 'Off', '<p>What can I do about that error?</p>', 18, 'estudante', null, 0, '2017-03-07 16:54:24');
INSERT INTO "classes_threads" VALUES (38, 'A new topic', '<p>Donec non felis id est aliquam malesuada id quis neque. Vivamus eleifend mollis congue. Sed neque turpis, feugiat ut auctor et, ultricies quis erat. Phasellus mollis feugiat tincidunt. Pellentesque laoreet mi a volutpat faucibus. In hac habitasse platea dictumst. Donec quis risus nec libero pharetra elementum. Nunc consequat tempus quam eget malesuada. Nunc tempor urna in leo laoreet, sit amet tincidunt quam vehicula. Sed faucibus justo nec faucibus scelerisque.</p>', 18, 'estudante', null, 1, '2017-03-08 08:38:57');
INSERT INTO "classes_threads" VALUES (43, 'Help', '<p>What do you think about...?</p>', 19, 'student', null, 0, '2017-09-19 15:45:18');
INSERT INTO "classes_threads" VALUES (44, 'Ok', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In porta, dui in dictum porta, metus metus porta velit, id laoreet tortor augue quis lorem. Quisque iaculis purus at tellus dictum lobortis. Curabitur mauris velit, iaculis in est sit amet, imperdiet maximus dui. Curabitur ornare ex ex, nec tempus justo porttitor sed. Maecenas tincidunt orci vel lacus blandit luctus. Etiam efficitur mollis laoreet. Maecenas iaculis nibh a tempus pretium.</p>', 19, 'administrator', 43, 0, '2017-09-21 10:21:16');
INSERT INTO "classes_threads" VALUES (45, 'Ok', 'Thank you', 19, 'student', 43, 0, '2017-09-21 10:23:05');
INSERT INTO "classes_threads" VALUES (47, 'Lesson 5', '<p>Sed vel turpis magna. Curabitur ut ornare nulla, eu pretium velit. Vivamus vel mauris orci. In hendrerit ultrices turpis, eu venenatis leo scelerisque eget. Quisque nec nulla volutpat, vulputate nulla vitae, convallis risus. Aenean viverra, orci et tempor congue, erat orci sagittis augue, id fringilla felis diam blandit mauris. Ut ac sem facilisis, pulvinar enim quis, ultricies diam. Aenean in arcu molestie, ornare nunc et, laoreet lectus. Quisque vel diam nisi. Sed augue lectus, laoreet id lectus sit amet, ornare sodales nunc. Ut vestibulum arcu velit, in porta massa lobortis at. Vestibulum orci felis, ultrices quis lacus eget, feugiat dictum magna. Nullam cursus, lectus non posuere vehicula, ante nisl egestas odio, vitae mattis nisi quam eget lectus.</p>', 19, 'estudante', null, 1, '2017-11-21 14:44:21');
INSERT INTO "classes_threads" VALUES (51, 'Doubt', '<p>Fusce facilisis, lorem vel hendrerit vestibulum, nisl velit dignissim arcu, a tincidunt metus leo in velit. Integer eget turpis nibh. Suspendisse a dolor eu neque euismod consequat id et eros. Vivamus fringilla tempor volutpat. Integer bibendum a turpis quis efficitur. Cras est est, vehicula sed dui eget, ultrices lacinia sapien. Phasellus sagittis sapien vitae fringilla mattis. Suspendisse posuere lacinia sapien, vel congue sem iaculis quis. Phasellus fermentum dui dui, quis interdum libero bibendum eu. Sed dapibus urna et diam euismod, blandit vehicula justo accumsan.</p>', 19, 'student', null, 1, '2017-11-21 14:50:49');

-- ----------------------------
-- Table structure for course_materials
-- ----------------------------
DROP TABLE IF EXISTS "course_materials";
CREATE TABLE "course_materials" (
"record_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"title"  varchar(80) COLLATE NOCASE,
"description"  varchar(80) COLLATE NOCASE,
"file_attachment"  varchar(80) COLLATE NOCASE,
"file_bin"  blob NOT NULL,
"url"  varchar(80) COLLATE NOCASE,
"lesson_id"  integer,
"date_created"  datetime,
"date_modified"  datetime
);

-- ----------------------------
-- Records of course_materials
-- ----------------------------

-- ----------------------------
-- Table structure for inbox
-- ----------------------------
DROP TABLE IF EXISTS "inbox";
CREATE TABLE "inbox" (
"inbox_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"inbox_title"  varchar(100) COLLATE NOCASE NOT NULL,
"inbox_text"  text COLLATE NOCASE NOT NULL,
"inbox_datetime"  datetime NOT NULL,
"inbox_stick"  tinyint(1) NOT NULL DEFAULT 1
);

-- ----------------------------
-- Records of inbox
-- ----------------------------
INSERT INTO "inbox" VALUES (1, 'Welcome', '<p>Welcome to Scriptcase</p>', '2017-02-11 10:55:14', 0);
INSERT INTO "inbox" VALUES (2, 'Access Password', '<p>Video Password: <strong>thepass</strong></p>', '2017-02-11 10:57:10', 0);
INSERT INTO "inbox" VALUES (3, 'Info n1', '<p>This is an important INFO about your course!</p>', '2016-02-11 10:57:46', 0);
INSERT INTO "inbox" VALUES (4, 'Congratulations', '<p>You have done all the course very well.</p>', '2017-02-11 11:06:26', 0);
INSERT INTO "inbox" VALUES (5, 'Info', '<p>One more important info.</p>', '2017-02-11 11:06:46', 0);
INSERT INTO "inbox" VALUES (7, 'New Lesson released on Scriptcase Certified Expert Course', '<b>New Lesson released on Scriptcase Certified Expert Course</b><br /><br />Q & A 1<br />', '2017-04-14 08:14:51', 1);
INSERT INTO "inbox" VALUES (8, 'New Lesson released on CSR: Customer Service Representative', '<b>New Lesson released on CSR: Customer Service Representative</b><br /><br />ABC<br />DEF<br />GHI<br />', '2017-04-14 08:17:10', 1);
INSERT INTO "inbox" VALUES (9, 'New Lesson released on Scriptcase Certified Expert Course', '<b>New Lesson released on Scriptcase Certified Expert Course</b><br /><br />Class 05: Staff Applications<br />Class 06: Buttons and Links<br />', '2017-04-14 08:54:23', 1);
INSERT INTO "inbox" VALUES (10, 'Scriptcase Certified Expert Course', '<b>New Lesson released onScriptcase Certified Expert Course</b><br /><br />Class 07: Tab, Dashboard and Calendar<br />', '2017-04-20 09:27:59', 1);
INSERT INTO "inbox" VALUES (13, 'SCA: Support Center Analyst', '<b>A new lesson is available on the course SCA: Support Center Analyst</b><br /><br />ABC<br />', '2017-04-30 09:31:36', 1);
INSERT INTO "inbox" VALUES (14, 'SCA: Support Center Analyst', '<b>A new lesson is available on the course SCA: Support Center Analyst</b><br /><br />ABC<br />', '2017-04-30 09:31:53', 1);
INSERT INTO "inbox" VALUES (15, 'SCA: Support Center Analyst', '<b>A new lesson is available on the course SCA: Support Center Analyst</b><br /><br />ABC<br />', '2017-04-30 10:16:55', 1);
INSERT INTO "inbox" VALUES (16, 'SCA: Support Center Analyst', '<p><strong>A new lesson is available on the course SCA: Support Center Analyst</strong><br /><br />Lesson X</p>', '2017-04-30 10:17:12', 0);
INSERT INTO "inbox" VALUES (19, 'CSR: Customer Service Representative', '<b>A new lesson is available on the course CSR: Customer Service Representative</b><br /><br />Lesson 1<br />Lesson 2<br />Lesson 3<br />Lesson 4<br />Lesson 5<br />', '2017-05-26 10:29:52', 1);
INSERT INTO "inbox" VALUES (21, 'CSR: Customer Service Representative', '<b>A new lesson is available on the course CSR: Customer Service Representative</b><br /><br />Lesson 1<br />Lesson 2<br />Lesson 3<br />Lesson 4<br />Lesson 5<br />', '2017-06-12 14:52:29', 1);

-- ----------------------------
-- Table structure for inbox_x_student
-- ----------------------------
DROP TABLE IF EXISTS "inbox_x_student";
CREATE TABLE "inbox_x_student" (
"inbox_id"  integer NOT NULL,
"student_id"  integer NOT NULL,
"is_read"  integer DEFAULT 0,
PRIMARY KEY ("inbox_id", "student_id"),
CONSTRAINT "inbox_x_student_ibfk_1" FOREIGN KEY ("inbox_id") REFERENCES "inbox" ("inbox_id"),
CONSTRAINT "inbox_x_student_ibfk_2" FOREIGN KEY ("student_id") REFERENCES "students" ("student_id")
);

-- ----------------------------
-- Records of inbox_x_student
-- ----------------------------
INSERT INTO "inbox_x_student" VALUES (1, 4, 0);
INSERT INTO "inbox_x_student" VALUES (1, 7, 0);
INSERT INTO "inbox_x_student" VALUES (1, 21, 0);
INSERT INTO "inbox_x_student" VALUES (1, 45, 0);
INSERT INTO "inbox_x_student" VALUES (1, 47, 0);
INSERT INTO "inbox_x_student" VALUES (1, 72, 0);
INSERT INTO "inbox_x_student" VALUES (1, 76, 0);
INSERT INTO "inbox_x_student" VALUES (1, 79, 0);
INSERT INTO "inbox_x_student" VALUES (1, 103, 0);
INSERT INTO "inbox_x_student" VALUES (1, 104, 1);
INSERT INTO "inbox_x_student" VALUES (2, 17, 0);
INSERT INTO "inbox_x_student" VALUES (2, 47, 0);
INSERT INTO "inbox_x_student" VALUES (2, 54, 0);
INSERT INTO "inbox_x_student" VALUES (2, 104, 1);
INSERT INTO "inbox_x_student" VALUES (3, 3, 0);
INSERT INTO "inbox_x_student" VALUES (3, 103, 0);
INSERT INTO "inbox_x_student" VALUES (3, 104, 1);
INSERT INTO "inbox_x_student" VALUES (4, 103, 0);
INSERT INTO "inbox_x_student" VALUES (4, 104, 1);
INSERT INTO "inbox_x_student" VALUES (5, 3, 0);
INSERT INTO "inbox_x_student" VALUES (5, 7, 0);
INSERT INTO "inbox_x_student" VALUES (5, 9, 0);
INSERT INTO "inbox_x_student" VALUES (5, 15, 0);
INSERT INTO "inbox_x_student" VALUES (5, 16, 0);
INSERT INTO "inbox_x_student" VALUES (5, 17, 0);
INSERT INTO "inbox_x_student" VALUES (5, 23, 0);
INSERT INTO "inbox_x_student" VALUES (5, 27, 0);
INSERT INTO "inbox_x_student" VALUES (5, 47, 0);
INSERT INTO "inbox_x_student" VALUES (5, 54, 0);
INSERT INTO "inbox_x_student" VALUES (5, 56, 0);
INSERT INTO "inbox_x_student" VALUES (5, 66, 0);
INSERT INTO "inbox_x_student" VALUES (5, 70, 0);
INSERT INTO "inbox_x_student" VALUES (5, 72, 0);
INSERT INTO "inbox_x_student" VALUES (5, 79, 0);
INSERT INTO "inbox_x_student" VALUES (5, 103, 0);
INSERT INTO "inbox_x_student" VALUES (5, 104, 1);
INSERT INTO "inbox_x_student" VALUES (7, 103, 1);
INSERT INTO "inbox_x_student" VALUES (7, 104, 1);
INSERT INTO "inbox_x_student" VALUES (8, 7, 0);
INSERT INTO "inbox_x_student" VALUES (8, 8, 0);
INSERT INTO "inbox_x_student" VALUES (8, 16, 0);
INSERT INTO "inbox_x_student" VALUES (8, 103, 0);
INSERT INTO "inbox_x_student" VALUES (8, 104, 0);
INSERT INTO "inbox_x_student" VALUES (9, 103, 0);
INSERT INTO "inbox_x_student" VALUES (9, 104, 0);
INSERT INTO "inbox_x_student" VALUES (10, 103, 0);
INSERT INTO "inbox_x_student" VALUES (10, 104, 0);
INSERT INTO "inbox_x_student" VALUES (14, 2, 0);
INSERT INTO "inbox_x_student" VALUES (16, 4, 0);
INSERT INTO "inbox_x_student" VALUES (16, 7, 0);
INSERT INTO "inbox_x_student" VALUES (16, 21, 0);
INSERT INTO "inbox_x_student" VALUES (16, 40, 0);
INSERT INTO "inbox_x_student" VALUES (16, 45, 0);
INSERT INTO "inbox_x_student" VALUES (16, 72, 0);
INSERT INTO "inbox_x_student" VALUES (16, 76, 0);
INSERT INTO "inbox_x_student" VALUES (16, 78, 0);
INSERT INTO "inbox_x_student" VALUES (16, 79, 0);
INSERT INTO "inbox_x_student" VALUES (16, 103, 0);
INSERT INTO "inbox_x_student" VALUES (16, 104, 0);

-- ----------------------------
-- Table structure for reservation
-- ----------------------------
DROP TABLE IF EXISTS "reservation";
CREATE TABLE "reservation" (
"reservation_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"class_id"  integer,
"student_id"  integer,
"status"  integer DEFAULT 1,
"comments"  varchar(60) COLLATE NOCASE,
"date_created"  datetime,
"date_modified"  datetime,
CONSTRAINT "reservation_IDFK_1" FOREIGN KEY ("class_id") REFERENCES "classes" ("class_id"),
CONSTRAINT "reservation_IDFK_2" FOREIGN KEY ("student_id") REFERENCES "students" ("student_id")
);

-- ----------------------------
-- Records of reservation
-- ----------------------------
INSERT INTO "reservation" VALUES (82, 8, 2, 1, null, null, null);
INSERT INTO "reservation" VALUES (87, 11, 2, 1, null, null, null);
INSERT INTO "reservation" VALUES (96, 6, 103, 1, null, null, null);
INSERT INTO "reservation" VALUES (247, 2, 3, 1, null, null, null);
INSERT INTO "reservation" VALUES (248, 2, 103, 1, null, null, null);
INSERT INTO "reservation" VALUES (404, 19, 103, 1, null, null, null);
INSERT INTO "reservation" VALUES (405, 19, 104, 1, null, null, null);
INSERT INTO "reservation" VALUES (408, 13, 2, 1, null, null, null);
INSERT INTO "reservation" VALUES (413, 3, 3, 1, null, null, null);
INSERT INTO "reservation" VALUES (414, 18, 76, 1, null, null, null);
INSERT INTO "reservation" VALUES (415, 18, 21, 1, null, null, null);
INSERT INTO "reservation" VALUES (416, 18, 45, 1, null, null, null);
INSERT INTO "reservation" VALUES (417, 18, 40, 1, null, null, null);
INSERT INTO "reservation" VALUES (418, 18, 78, 1, null, null, null);
INSERT INTO "reservation" VALUES (419, 18, 4, 1, null, null, null);
INSERT INTO "reservation" VALUES (420, 18, 103, 1, null, null, null);
INSERT INTO "reservation" VALUES (421, 18, 104, 1, null, null, null);
INSERT INTO "reservation" VALUES (422, 18, 72, 1, null, null, null);
INSERT INTO "reservation" VALUES (423, 18, 7, 1, null, null, null);
INSERT INTO "reservation" VALUES (424, 18, 79, 1, null, null, null);
INSERT INTO "reservation" VALUES (425, 20, 16, 1, null, null, null);
INSERT INTO "reservation" VALUES (426, 20, 66, 1, null, null, null);
INSERT INTO "reservation" VALUES (427, 20, 54, 1, null, null, null);
INSERT INTO "reservation" VALUES (428, 20, 3, 1, null, null, null);
INSERT INTO "reservation" VALUES (429, 20, 9, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (430, 20, 56, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (431, 20, 27, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (432, 20, 23, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (433, 20, 17, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (434, 20, 15, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (435, 20, 103, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (436, 20, 104, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (437, 20, 72, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (438, 20, 7, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (439, 20, 79, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (440, 20, 70, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (441, 20, 47, 1, null, '2017-05-23 10:59:52', null);
INSERT INTO "reservation" VALUES (442, 14, 76, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (443, 14, 21, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (444, 14, 45, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (445, 14, 40, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (446, 14, 78, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (447, 14, 4, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (448, 14, 68, 1, null, '2017-06-07 08:45:55', null);
INSERT INTO "reservation" VALUES (449, 15, 56, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (450, 15, 27, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (451, 15, 23, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (452, 15, 17, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (453, 15, 15, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (454, 15, 103, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (455, 15, 104, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (456, 15, 72, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (457, 15, 7, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (458, 15, 79, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (459, 15, 70, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (460, 15, 47, 1, null, '2017-06-07 08:46:11', null);
INSERT INTO "reservation" VALUES (469, 17, 103, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (470, 17, 104, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (471, 17, 72, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (472, 17, 7, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (473, 17, 79, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (474, 17, 70, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (475, 17, 47, 1, null, '2017-06-12 14:52:41', null);
INSERT INTO "reservation" VALUES (480, 12, 1, 1, null, '2017-06-12 14:56:31', null);
INSERT INTO "reservation" VALUES (481, 12, 19, 1, null, '2017-06-12 14:56:31', null);
INSERT INTO "reservation" VALUES (482, 12, 16, 1, null, '2017-06-12 14:56:31', null);
INSERT INTO "reservation" VALUES (483, 12, 66, 1, null, '2017-06-12 14:56:31', null);
INSERT INTO "reservation" VALUES (484, 12, 104, 1, null, '2017-06-12 14:56:31', null);
INSERT INTO "reservation" VALUES (503, 4, 76, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (504, 4, 21, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (505, 4, 45, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (506, 4, 40, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (507, 4, 78, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (508, 4, 4, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (509, 4, 68, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (510, 4, 30, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (511, 4, 55, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (512, 4, 63, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (513, 4, 75, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (514, 4, 62, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (515, 4, 73, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (516, 4, 33, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (517, 4, 37, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (518, 4, 59, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (519, 4, 13, 1, null, '2017-06-12 14:57:13', null);
INSERT INTO "reservation" VALUES (520, 4, 29, 1, null, '2017-06-12 14:57:13', null);

-- ----------------------------
-- Table structure for status
-- ----------------------------
DROP TABLE IF EXISTS "status";
CREATE TABLE "status" (
"status_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"status_desc"  varchar(120) COLLATE NOCASE
);

-- ----------------------------
-- Records of status
-- ----------------------------
INSERT INTO "status" VALUES (1, 'Opened');
INSERT INTO "status" VALUES (2, 'Expired');

-- ----------------------------
-- Table structure for student_lessons
-- ----------------------------
DROP TABLE IF EXISTS "student_lessons";
CREATE TABLE "student_lessons" (
"student_id"  integer NOT NULL,
"class_id"  integer NOT NULL,
"lesson_id"  integer NOT NULL,
PRIMARY KEY ("student_id", "class_id", "lesson_id"),
CONSTRAINT "student_lessons_IDFK_1" FOREIGN KEY ("student_id") REFERENCES "students" ("student_id"),
CONSTRAINT "student_lessons_IDFK_2" FOREIGN KEY ("class_id") REFERENCES "classes" ("class_id"),
CONSTRAINT "student_lessons_IDFK_3" FOREIGN KEY ("lesson_id") REFERENCES "course_lessons" ("lesson_id")
);

-- ----------------------------
-- Records of student_lessons
-- ----------------------------
INSERT INTO "student_lessons" VALUES (103, 19, 6);
INSERT INTO "student_lessons" VALUES (103, 19, 11);
INSERT INTO "student_lessons" VALUES (104, 5, 17);
INSERT INTO "student_lessons" VALUES (104, 18, 1);
INSERT INTO "student_lessons" VALUES (104, 18, 2);
INSERT INTO "student_lessons" VALUES (104, 18, 3);
INSERT INTO "student_lessons" VALUES (104, 19, 6);
INSERT INTO "student_lessons" VALUES (104, 19, 7);
INSERT INTO "student_lessons" VALUES (104, 19, 8);
INSERT INTO "student_lessons" VALUES (104, 19, 9);
INSERT INTO "student_lessons" VALUES (104, 19, 10);
INSERT INTO "student_lessons" VALUES (104, 19, 11);
INSERT INTO "student_lessons" VALUES (104, 19, 12);
INSERT INTO "student_lessons" VALUES (104, 19, 13);

-- ----------------------------
-- Table structure for student_notes
-- ----------------------------
DROP TABLE IF EXISTS "student_notes";
CREATE TABLE "student_notes" (
"notes_id"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"notes_text"  text COLLATE NOCASE NOT NULL,
"course_id"  integer NOT NULL,
"lesson_id"  integer NOT NULL,
"student_id"  integer NOT NULL,
"notes_datetime"  datetime NOT NULL,
CONSTRAINT "student_notes_ibfk_1" FOREIGN KEY ("course_id") REFERENCES "course_catalog" ("course_id"),
CONSTRAINT "student_notes_ibfk_2" FOREIGN KEY ("lesson_id") REFERENCES "course_lessons" ("lesson_id"),
CONSTRAINT "student_notes_ibfk_3" FOREIGN KEY ("student_id") REFERENCES "students" ("student_id")
);

-- ----------------------------
-- Records of student_notes
-- ----------------------------
INSERT INTO "student_notes" VALUES (6, 'aaasa', 2, 2, 104, '2016-12-17 11:59:52');
INSERT INTO "student_notes" VALUES (7, 'aass', 2, 3, 104, '2016-12-17 12:01:06');
INSERT INTO "student_notes" VALUES (14, 1235, 2, 2, 103, '2017-02-04 11:47:46');
INSERT INTO "student_notes" VALUES (16, 'test', 2, 1, 104, '2017-02-11 09:19:39');
INSERT INTO "student_notes" VALUES (17, 'aaaaa', 2, 1, 103, '2017-02-17 09:25:36');
INSERT INTO "student_notes" VALUES (18, 'aaaaa', 2, 3, 103, '2017-02-17 09:42:35');
INSERT INTO "student_notes" VALUES (19, 'snfuinfidnbdgbfgfdgfd', 2, 5, 103, '2017-02-17 09:50:07');

-- ----------------------------
-- Table structure for tb_applications
-- ----------------------------
DROP TABLE IF EXISTS "tb_applications";
CREATE TABLE "tb_applications" (
"name"  varchar(150) COLLATE NOCASE NOT NULL,
"description"  varchar(170) COLLATE NOCASE,
"app_type"  varchar(20) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("name")
);

-- ----------------------------
-- Records of tb_applications
-- ----------------------------
INSERT INTO "tb_applications" VALUES ('app_change_pswd', 'Security Application', 'contr');
INSERT INTO "tb_applications" VALUES ('app_form_add_users', 'Security Application', 'form');
INSERT INTO "tb_applications" VALUES ('app_form_edit_users', 'Security Application', 'form');
INSERT INTO "tb_applications" VALUES ('app_form_sec_apps', 'Security Application', 'form');
INSERT INTO "tb_applications" VALUES ('app_form_sec_groups', 'Security Application', 'form');
INSERT INTO "tb_applications" VALUES ('app_form_sec_groups_apps', 'Security Application', 'form');
INSERT INTO "tb_applications" VALUES ('app_grid_sec_apps', 'Security Application', 'cons');
INSERT INTO "tb_applications" VALUES ('app_grid_sec_groups', 'Security Application', 'cons');
INSERT INTO "tb_applications" VALUES ('app_grid_sec_users', 'Security Application', 'cons');
INSERT INTO "tb_applications" VALUES ('app_Login', 'Security Application', 'contr');
INSERT INTO "tb_applications" VALUES ('app_retrieve_pswd', 'Security Application', 'contr');
INSERT INTO "tb_applications" VALUES ('app_search_sec_groups', 'Security Application', 'filter');
INSERT INTO "tb_applications" VALUES ('app_sync_apps', 'Security Application', 'contr');
INSERT INTO "tb_applications" VALUES ('blank', 'blank', '');
INSERT INTO "tb_applications" VALUES ('blank_teste_email', 'blank_teste_email', '');
INSERT INTO "tb_applications" VALUES ('calendar_classes', 'calendar_classes', '');
INSERT INTO "tb_applications" VALUES ('container', 'container', '');
INSERT INTO "tb_applications" VALUES ('container_admin', null, 'container');
INSERT INTO "tb_applications" VALUES ('container_instructor', 'container_instructor', '');
INSERT INTO "tb_applications" VALUES ('control_change_password', 'control_change_password', '');
INSERT INTO "tb_applications" VALUES ('control_login', 'control_login', '');
INSERT INTO "tb_applications" VALUES ('control_synchronize', 'control_synchronize', '');
INSERT INTO "tb_applications" VALUES ('form_add_instructors', 'form_add_instructors', '');
INSERT INTO "tb_applications" VALUES ('form_add_students', 'form_add_students', 'form');
INSERT INTO "tb_applications" VALUES ('form_classes', null, 'form');
INSERT INTO "tb_applications" VALUES ('form_classes_threads', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_classes_topic', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_confirm_classes_label', 'form_confirm_classes_label', 'form');
INSERT INTO "tb_applications" VALUES ('form_confirm_classes_label_detail', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_conf_email', 'form_conf_email', 'form');
INSERT INTO "tb_applications" VALUES ('form_course_catalog', 'form_course_catalog', 'form');
INSERT INTO "tb_applications" VALUES ('form_course_lessons', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_course_materials', 'form_course_materials', 'form');
INSERT INTO "tb_applications" VALUES ('form_edit_instructor', 'form_edit_instructor', 'form');
INSERT INTO "tb_applications" VALUES ('form_edit_students', null, 'form');
INSERT INTO "tb_applications" VALUES ('form_inbox', null, 'form');
INSERT INTO "tb_applications" VALUES ('form_instructors', 'form_instructors', 'form');
INSERT INTO "tb_applications" VALUES ('form_instructor_confirm_classes_label', 'form_instructor_confirm_classes_label', 'form');
INSERT INTO "tb_applications" VALUES ('form_register_class', 'form_register_class', 'form');
INSERT INTO "tb_applications" VALUES ('form_reservation', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_reservation_label', 'form_reservation_label', 'form');
INSERT INTO "tb_applications" VALUES ('form_status', null, 'form');
INSERT INTO "tb_applications" VALUES ('form_students', 'form_students', 'form');
INSERT INTO "tb_applications" VALUES ('form_student_notes', '', 'form');
INSERT INTO "tb_applications" VALUES ('form_tb_applications', 'form_tb_applications', 'form');
INSERT INTO "tb_applications" VALUES ('form_tb_groups', 'form_tb_groups', 'form');
INSERT INTO "tb_applications" VALUES ('form_tb_users', 'form_tb_users', 'form');
INSERT INTO "tb_applications" VALUES ('form_unregister_reservation', 'form_unregister_reservation', 'form');
INSERT INTO "tb_applications" VALUES ('form_update_students', 'form_update_students', 'form');
INSERT INTO "tb_applications" VALUES ('form_venues', 'form_venues', 'form');
INSERT INTO "tb_applications" VALUES ('grid_admin_classes', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_asks_last_posts', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_asks_last_posts_admin', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_asks_last_posts_instructor', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_classes_asks', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_classes_asks_thread', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_classes_forum', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_classes_forum_thread', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_classes_list', 'grid_classes_list', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_catalog', 'grid_course_catalog', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_catalog_self', 'grid_course_catalog_self', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_class_view', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_lessons', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_lessons_ementa', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_materials', 'grid_course_materials', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_course_view', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_forum_last_posts', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_inbox', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_instructors', 'grid_instructors', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_instructors_details', 'grid_instructors_details', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_instructor_classes', 'grid_instructor_classes', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_outline', '', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_reservation', 'grid_reservation', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_reservation_list', 'grid_reservation_list', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_reservation_list_instructor', 'grid_reservation_list_instructor', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_reservation_student_detail', 'grid_reservation_student_detail', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_students', 'grid_students', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_classes', 'grid_student_classes', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_classes_detail', 'grid_student_classes_detail', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_classes_details', 'grid_student_classes_details', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_classes_detail_BKP', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_classes_list', 'grid_student_classes_list', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_course_catalog', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_my_courses', null, 'cons');
INSERT INTO "tb_applications" VALUES ('grid_student_reservation_pending', 'grid_student_reservation_pending', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_tb_applications', 'grid_tb_applications', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_tb_groups', 'grid_tb_groups', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_tb_users', 'grid_tb_users', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_venues', 'grid_venues', 'cons');
INSERT INTO "tb_applications" VALUES ('grid_venues_details', 'grid_venues_details', 'cons');
INSERT INTO "tb_applications" VALUES ('insert_users', null, 'blank');
INSERT INTO "tb_applications" VALUES ('login', 'login', '');
INSERT INTO "tb_applications" VALUES ('login_BKP', null, 'contr');
INSERT INTO "tb_applications" VALUES ('mail', null, 'blank');
INSERT INTO "tb_applications" VALUES ('menu', 'menu', '');
INSERT INTO "tb_applications" VALUES ('tabs_last_comunic', null, '');
INSERT INTO "tb_applications" VALUES ('tabs_student_courses', null, '');
INSERT INTO "tb_applications" VALUES ('treemenu_outline', null, '');
INSERT INTO "tb_applications" VALUES ('vimeo', null, 'blank');
INSERT INTO "tb_applications" VALUES ('form_inbox_x_student_1', null, '');
INSERT INTO "tb_applications" VALUES ('form_inbox_x_student', null, 'form');
INSERT INTO "tb_applications" VALUES ('login_03', null, '');

-- ----------------------------
-- Table structure for tb_email
-- ----------------------------
DROP TABLE IF EXISTS "tb_email";
CREATE TABLE "tb_email" (
"mail_id"  integer NOT NULL,
"smtp"  varchar(60) COLLATE NOCASE,
"user_name"  varchar(60) COLLATE NOCASE,
"pswd"  varchar(60) COLLATE NOCASE,
"from_mail"  varchar(60) COLLATE NOCASE,
"fld_use"  integer,
PRIMARY KEY ("mail_id")
)

;

-- ----------------------------
-- Records of tb_email
-- ----------------------------
INSERT INTO "tb_email" VALUES (1, 'smtp.gmail.com', 'yuri@netmake.com.br', 'c2FvcGF1bG8xMjM=', 'yuri@netmake.com.br', 0);

-- ----------------------------
-- Table structure for tb_groups
-- ----------------------------
DROP TABLE IF EXISTS "tb_groups";
CREATE TABLE "tb_groups" (
"code"  integer PRIMARY KEY AUTOINCREMENT NOT NULL,
"description"  varchar(50) COLLATE NOCASE
);

-- ----------------------------
-- Records of tb_groups
-- ----------------------------
INSERT INTO "tb_groups" VALUES (1, 'Administrator');
INSERT INTO "tb_groups" VALUES (9, 'Student');
INSERT INTO "tb_groups" VALUES (10, 'Instructor');

-- ----------------------------
-- Table structure for tb_groups_x_apps
-- ----------------------------
DROP TABLE IF EXISTS "tb_groups_x_apps";
CREATE TABLE "tb_groups_x_apps" (
"cod_group"  integer NOT NULL DEFAULT 0,
"cod_application"  varchar(150) COLLATE NOCASE NOT NULL,
"priv_access"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
"priv_insert"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
"priv_delete"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
"priv_update"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
"priv_export"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
"priv_print"  varchar(1) COLLATE NOCASE DEFAULT 'Y',
PRIMARY KEY ("cod_group", "cod_application"),
CONSTRAINT "tb_groups_x_apps_ibfk_1" FOREIGN KEY ("cod_group") REFERENCES "tb_groups" ("code"),
CONSTRAINT "tb_groups_x_apps_ibfk_2" FOREIGN KEY ("cod_application") REFERENCES "tb_applications" ("name")
);

-- ----------------------------
-- Records of tb_groups_x_apps
-- ----------------------------
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_change_pswd', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_form_add_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_form_edit_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_form_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_form_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_form_sec_groups_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_grid_sec_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_grid_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_grid_sec_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_Login', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_retrieve_pswd', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_search_sec_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'app_sync_apps', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'blank', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'blank_teste_email', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'calendar_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'container', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'container_admin', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'container_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'control_change_password', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'control_login', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'control_synchronize', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_add_instructors', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_add_students', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_classes_threads', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_classes_topic', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_confirm_classes_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_confirm_classes_label_detail', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_conf_email', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_course_catalog', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_course_lessons', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_course_materials', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_edit_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_edit_students', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_inbox', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_instructors', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_instructor_confirm_classes_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_register_class', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_reservation', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_reservation_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_status', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_students', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_student_notes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_tb_applications', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_tb_groups', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_tb_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_unregister_reservation', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_update_students', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_venues', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_admin_classes', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_asks_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_asks_last_posts_admin', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_asks_last_posts_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_classes_asks', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_classes_asks_thread', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_classes_forum', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_classes_forum_thread', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_classes_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_catalog', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_catalog_self', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_class_view', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_lessons', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_lessons_ementa', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_materials', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_course_view', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_forum_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_inbox', '', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_instructors', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_instructors_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_instructor_classes', '', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_outline', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_reservation', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_reservation_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_reservation_list_instructor', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_reservation_student_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_students', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_classes', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_classes_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_classes_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_classes_detail_BKP', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_classes_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_course_catalog', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_my_courses', '', 'Y', 'Y', 'Y', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_student_reservation_pending', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_tb_applications', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_tb_groups', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_tb_users', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_venues', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'grid_venues_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'insert_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'login', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'login_BKP', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'mail', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'menu', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'tabs_last_comunic', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'tabs_student_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'treemenu_outline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'vimeo', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'blank', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'container', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'container_admin', '', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'control_change_password', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'control_login', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_classes', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_classes_threads', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_classes_topic', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_confirm_classes_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_edit_students', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_status', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_student_notes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_unregister_reservation', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_update_students', 'Y', '', '', 'Y', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_asks_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_asks_last_posts_admin', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_asks_last_posts_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_classes_asks', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_classes_asks_thread', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_classes_forum', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_classes_forum_thread', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_classes_list', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_course_catalog', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_course_class_view', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_course_lessons', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_course_lessons_ementa', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_course_view', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_forum_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_inbox', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_outline', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_reservation_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_reservation_student_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_classes', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_classes_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_classes_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_classes_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_course_catalog', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_my_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'grid_student_reservation_pending', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'insert_users', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'mail', '', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'menu', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'tabs_last_comunic', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'tabs_student_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'treemenu_outline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'vimeo', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'blank', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'container', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'container_admin', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'container_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'control_change_password', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'control_login', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_classes', 'Y', '', '', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_classes_threads', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_confirm_classes_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_confirm_classes_label_detail', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_course_catalog', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_edit_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_edit_students', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_inbox', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_instructor_confirm_classes_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_register_class', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_reservation_label', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_status', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_unregister_reservation', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_venues', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_admin_classes', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_asks_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_asks_last_posts_admin', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_asks_last_posts_instructor', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_classes_asks', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_classes_asks_thread', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_classes_list', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_course_catalog', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_course_catalog_self', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_forum_last_posts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_inbox', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_instructors_details', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_instructor_classes', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_reservation_list', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_reservation_list_instructor', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_classes', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_classes_details', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_classes_detail_BKP', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_classes_list', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_course_catalog', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_student_my_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_venues', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'grid_venues_details', '', '', '', '', '', '');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'insert_users', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'login_BKP', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'mail', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'menu', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'tabs_last_comunic', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'tabs_student_courses', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'treemenu_outline', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'vimeo', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_inbox_x_student_1', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_inbox_x_student_1', '', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_inbox_x_student_1', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'form_inbox_x_student', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'form_inbox_x_student', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'form_inbox_x_student', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (1, 'login_03', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (9, 'login_03', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
INSERT INTO "tb_groups_x_apps" VALUES (10, 'login_03', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y');
























-- ----------------------------
-- Table structure for tb_user_applications
-- ----------------------------
DROP TABLE IF EXISTS "tb_user_applications";
CREATE TABLE "tb_user_applications" (
"fk_user_login"  varchar(30) COLLATE NOCASENOT NULL,
"fk_interface_name"  varchar(150) COLLATE NOCASE NOT NULL,
PRIMARY KEY ("fk_user_login", "fk_interface_name"),
CONSTRAINT "tb_user_applications_ibfk_1" FOREIGN KEY ("fk_interface_name") REFERENCES "tb_applications" ("name")
);

-- ----------------------------
-- Records of tb_user_applications
-- ----------------------------

-- ----------------------------
-- Table structure for tb_users_x_groups
-- ----------------------------
DROP TABLE IF EXISTS "tb_users_x_groups";
CREATE TABLE "tb_users_x_groups" (
"user_login"  varchar(30) COLLATE NOCASE NOT NULL,
"cod_group"  integer NOT NULL DEFAULT 0,
PRIMARY KEY ("user_login", "cod_group"),
CONSTRAINT "tb_users_x_groups_ibfk_1" FOREIGN KEY ("cod_group") REFERENCES "tb_groups" ("code")
);

-- ----------------------------
-- Records of tb_users_x_groups
-- ----------------------------
INSERT INTO "tb_users_x_groups" VALUES ('administrador', 1);
INSERT INTO "tb_users_x_groups" VALUES ('administrator', 1);
INSERT INTO "tb_users_x_groups" VALUES ('cakphd', 9);
INSERT INTO "tb_users_x_groups" VALUES ('carlos', 10);
INSERT INTO "tb_users_x_groups" VALUES ('estudante', 9);
INSERT INTO "tb_users_x_groups" VALUES ('instructor', 10);
INSERT INTO "tb_users_x_groups" VALUES ('instrutor', 10);
INSERT INTO "tb_users_x_groups" VALUES ('jack', 10);
INSERT INTO "tb_users_x_groups" VALUES ('mirlbac1', 9);
INSERT INTO "tb_users_x_groups" VALUES ('student', 9);
INSERT INTO "tb_users_x_groups" VALUES ('teste', 9);
INSERT INTO "tb_users_x_groups" VALUES ('testexx', 9);
INSERT INTO "tb_users_x_groups" VALUES ('vitorjamil', 9);
INSERT INTO "tb_users_x_groups" VALUES ('vjamil', 9);